/*
 * Decompiled with CFR 0.152.
 */
package com.daxie.xops.properties.xms.xgs;

import com.daxie.basis.vector.Vector;
import com.daxie.log.LogFile;
import com.daxie.tool.ByteFunctions;
import com.daxie.tool.FileFunctions;
import com.daxie.xops.properties.entity.weapon.WeaponBinSpecifierAndEnumConverter;
import com.daxie.xops.properties.entity.weapon.WeaponData;
import com.daxie.xops.properties.entity.weapon.WeaponModelFilenamesStock;
import com.daxie.xops.properties.entity.weapon.WeaponModelType;
import com.daxie.xops.properties.entity.weapon.WeaponScopeMode;
import com.daxie.xops.properties.entity.weapon.WeaponShootingStance;
import com.daxie.xops.properties.entity.weapon.WeaponTextureFilenamesStock;
import com.daxie.xops.properties.entity.weapon.WeaponTextureType;
import java.io.IOException;
import java.util.List;

class XGSParser {
    private WeaponData[] weapon_data_array = null;

    public XGSParser(String xgs_filename) throws IOException {
        List bin = FileFunctions.GetFileAllBin((String)xgs_filename);
        if (bin.size() != 1732) {
            LogFile.WriteWarn((String)("[XGSParser-<init>] Invalid file size. filename:" + xgs_filename), (boolean)true);
            return;
        }
        byte[] b = new byte[2];
        int count = 14;
        for (int i = 0; i < 23; ++i) {
            b[0] = (Byte)bin.get(count);
            b[1] = (Byte)bin.get(count + 1);
            short itemp = ByteFunctions.byte_to_short_le((byte[])b);
            this.weapon_data_array[i].SetAttackPower(itemp);
            b[0] = (Byte)bin.get(count += 2);
            b[1] = (Byte)bin.get(count + 1);
            itemp = ByteFunctions.byte_to_short_le((byte[])b);
            this.weapon_data_array[i].SetPenetration(itemp);
            b[0] = (Byte)bin.get(count += 2);
            b[1] = (Byte)bin.get(count + 1);
            itemp = ByteFunctions.byte_to_short_le((byte[])b);
            this.weapon_data_array[i].SetFiringInterval(itemp);
            b[0] = (Byte)bin.get(count += 2);
            b[1] = (Byte)bin.get(count + 1);
            itemp = ByteFunctions.byte_to_short_le((byte[])b);
            this.weapon_data_array[i].SetBulletSpeed(itemp);
            b[0] = (Byte)bin.get(count += 2);
            b[1] = (Byte)bin.get(count + 1);
            itemp = ByteFunctions.byte_to_short_le((byte[])b);
            this.weapon_data_array[i].SetNumberOfBullets(itemp);
            b[0] = (Byte)bin.get(count += 2);
            b[1] = (Byte)bin.get(count + 1);
            itemp = ByteFunctions.byte_to_short_le((byte[])b);
            this.weapon_data_array[i].SetReloadingTime(itemp);
            b[0] = (Byte)bin.get(count += 2);
            b[1] = (Byte)bin.get(count + 1);
            itemp = ByteFunctions.byte_to_short_le((byte[])b);
            this.weapon_data_array[i].SetRecoil(itemp);
            b[0] = (Byte)bin.get(count += 2);
            b[1] = (Byte)bin.get(count + 1);
            itemp = ByteFunctions.byte_to_short_le((byte[])b);
            this.weapon_data_array[i].SetErrorRangeMin(itemp);
            b[0] = (Byte)bin.get(count += 2);
            b[1] = (Byte)bin.get(count + 1);
            itemp = ByteFunctions.byte_to_short_le((byte[])b);
            this.weapon_data_array[i].SetErrorRangeMax(itemp);
            Vector vtemp = new Vector();
            b[0] = (Byte)bin.get(count += 2);
            b[1] = (Byte)bin.get(count + 1);
            itemp = ByteFunctions.byte_to_short_le((byte[])b);
            vtemp.SetX((float)itemp);
            b[0] = (Byte)bin.get(count += 2);
            b[1] = (Byte)bin.get(count + 1);
            itemp = ByteFunctions.byte_to_short_le((byte[])b);
            vtemp.SetY((float)itemp);
            b[0] = (Byte)bin.get(count += 2);
            b[1] = (Byte)bin.get(count + 1);
            itemp = ByteFunctions.byte_to_short_le((byte[])b);
            vtemp.SetZ((float)itemp);
            this.weapon_data_array[i].SetPosition(vtemp);
            vtemp = new Vector();
            b[0] = (Byte)bin.get(count += 2);
            b[1] = (Byte)bin.get(count + 1);
            itemp = ByteFunctions.byte_to_short_le((byte[])b);
            vtemp.SetX((float)itemp);
            b[0] = (Byte)bin.get(count += 2);
            b[1] = (Byte)bin.get(count + 1);
            itemp = ByteFunctions.byte_to_short_le((byte[])b);
            vtemp.SetY((float)itemp);
            b[0] = (Byte)bin.get(count += 2);
            b[1] = (Byte)bin.get(count + 1);
            itemp = ByteFunctions.byte_to_short_le((byte[])b);
            vtemp.SetZ((float)itemp);
            this.weapon_data_array[i].SetFlashPosition(vtemp);
            vtemp = new Vector();
            b[0] = (Byte)bin.get(count += 2);
            b[1] = (Byte)bin.get(count + 1);
            itemp = ByteFunctions.byte_to_short_le((byte[])b);
            vtemp.SetX((float)itemp);
            b[0] = (Byte)bin.get(count += 2);
            b[1] = (Byte)bin.get(count + 1);
            itemp = ByteFunctions.byte_to_short_le((byte[])b);
            vtemp.SetY((float)itemp);
            b[0] = (Byte)bin.get(count += 2);
            b[1] = (Byte)bin.get(count + 1);
            itemp = ByteFunctions.byte_to_short_le((byte[])b);
            vtemp.SetZ((float)itemp);
            this.weapon_data_array[i].SetCartridgePosition(vtemp);
            b[0] = (Byte)bin.get(count += 2);
            b[1] = (Byte)bin.get(count + 1);
            itemp = ByteFunctions.byte_to_short_le((byte[])b);
            WeaponShootingStance shooting_stance = WeaponBinSpecifierAndEnumConverter.GetWeaponShootingStanceFromBinSpecifier(itemp);
            this.weapon_data_array[i].SetShootingStance(shooting_stance);
            b[0] = (Byte)bin.get(count += 2);
            b[1] = (Byte)bin.get(count + 1);
            itemp = ByteFunctions.byte_to_short_le((byte[])b);
            if (itemp == 0) {
                this.weapon_data_array[i].SetRapidFireEnabledFlag(true);
            } else {
                this.weapon_data_array[i].SetRapidFireEnabledFlag(false);
            }
            b[0] = (Byte)bin.get(count += 2);
            b[1] = (Byte)bin.get(count + 1);
            itemp = ByteFunctions.byte_to_short_le((byte[])b);
            WeaponScopeMode scope_mode = WeaponBinSpecifierAndEnumConverter.GetWeaponScopeModeFromBinSpecifier(itemp);
            this.weapon_data_array[i].SetScopeMode(scope_mode);
            b[0] = (Byte)bin.get(count += 2);
            b[1] = (Byte)bin.get(count + 1);
            itemp = ByteFunctions.byte_to_short_le((byte[])b);
            WeaponTextureType texture_type = WeaponBinSpecifierAndEnumConverter.GetWeaponTextureTypeFromBinSpecifier(itemp);
            String texture_filename = WeaponTextureFilenamesStock.GetTextureFilename(texture_type);
            this.weapon_data_array[i].SetTextureFilename(texture_filename);
            b[0] = (Byte)bin.get(count += 2);
            b[1] = (Byte)bin.get(count + 1);
            itemp = ByteFunctions.byte_to_short_le((byte[])b);
            WeaponModelType model_type = WeaponBinSpecifierAndEnumConverter.GetWeaponModelTypeFromBinSpecifier(itemp);
            String model_filename = WeaponModelFilenamesStock.GetModelFilename(model_type);
            this.weapon_data_array[i].SetModelFilename(model_filename);
            b[0] = (Byte)bin.get(count += 2);
            b[1] = (Byte)bin.get(count + 1);
            itemp = ByteFunctions.byte_to_short_le((byte[])b);
            this.weapon_data_array[i].SetScale((float)itemp * 0.1f);
            vtemp = new Vector();
            b[0] = (Byte)bin.get(count += 2);
            b[1] = (Byte)bin.get(count + 1);
            itemp = ByteFunctions.byte_to_short_le((byte[])b);
            vtemp.SetX((float)itemp);
            b[0] = (Byte)bin.get(count += 2);
            b[1] = (Byte)bin.get(count + 1);
            itemp = ByteFunctions.byte_to_short_le((byte[])b);
            vtemp.SetY((float)itemp);
            vtemp.SetZ(0.0f);
            this.weapon_data_array[i].SetCartridgeVelocity(vtemp);
            b[0] = (Byte)bin.get(count += 2);
            b[1] = (Byte)bin.get(count + 1);
            itemp = ByteFunctions.byte_to_short_le((byte[])b);
            this.weapon_data_array[i].SetSoundID(itemp);
            b[0] = (Byte)bin.get(count += 2);
            b[1] = (Byte)bin.get(count + 1);
            itemp = ByteFunctions.byte_to_short_le((byte[])b);
            this.weapon_data_array[i].SetSoundVolume(itemp);
            b[0] = (Byte)bin.get(count += 2);
            b[1] = (Byte)bin.get(count + 1);
            itemp = ByteFunctions.byte_to_short_le((byte[])b);
            if (itemp == 0) {
                this.weapon_data_array[i].SetSuppressorEnabledFlag(false);
            } else {
                this.weapon_data_array[i].SetSuppressorEnabledFlag(true);
            }
            count += 2;
            if (i == 4) {
                this.weapon_data_array[i].SetChangeableWeapon(16);
            } else if (i == 16) {
                this.weapon_data_array[i].SetChangeableWeapon(4);
            }
            if (i != 19) continue;
            this.weapon_data_array[i].SetNumberOfProjectiles(6);
        }
        count = 1348;
        for (int i = 0; i < 23; ++i) {
            byte[] name_buffer = new byte[16];
            for (int j = 0; j < 15; ++j) {
                name_buffer[j] = (Byte)bin.get(count + j);
            }
            name_buffer[15] = 0;
            count += 16;
            String strtemp = new String(name_buffer);
            int first_null_pos = 15;
            for (int j = 0; j < 16; ++j) {
                if (strtemp.charAt(j) != '\u0000') continue;
                first_null_pos = j;
                break;
            }
            strtemp = strtemp.substring(0, first_null_pos);
            this.weapon_data_array[22 - i].SetName(strtemp);
        }
    }

    public WeaponData[] GetWeaponDataArray() {
        WeaponData[] ret = new WeaponData[this.weapon_data_array.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = new WeaponData(this.weapon_data_array[i]);
        }
        return ret;
    }
}

