/*
 * Decompiled with CFR 0.152.
 */
package com.daxie.xops.properties.exe;

import com.daxie.log.LogFile;
import com.daxie.tool.ByteFunctions;
import com.daxie.xops.properties.entity.character.CharacterAILevel;
import com.daxie.xops.properties.entity.character.CharacterBinSpecifierAndEnumConverter;
import com.daxie.xops.properties.entity.character.CharacterData;
import com.daxie.xops.properties.entity.character.CharacterModelType;
import com.daxie.xops.properties.entity.character.CharacterTextureType;
import com.daxie.xops.properties.entity.character.CharacterType;
import java.util.List;

class XOPSExeCharacterDataWriter {
    private CharacterData[] character_data_array;

    public XOPSExeCharacterDataWriter(CharacterData[] character_data_array) {
        this.character_data_array = character_data_array;
    }

    public void Write(List<Byte> bin, int character_data_start_pos) {
        if (this.character_data_array == null) {
            LogFile.WriteWarn((String)"[XOPSExeCharacterDataWriter-Write] Data is null.", (boolean)true);
            return;
        }
        if (this.character_data_array.length != 43) {
            LogFile.WriteWarn((String)("[XOPSExeCharacterDataWriter-Write] Invalid number of data. data_num:" + this.character_data_array.length), (boolean)true);
            return;
        }
        int pos = character_data_start_pos;
        for (int i = 0; i < 43; ++i) {
            CharacterTextureType texture_type = this.character_data_array[i].GetTextureType();
            int itemp = CharacterBinSpecifierAndEnumConverter.GetBinSpecifierFromCharacterTextureType(texture_type);
            byte[] b = ByteFunctions.short_to_byte_le((short)((short)itemp));
            bin.set(pos, b[0]);
            bin.set(pos + 1, b[1]);
            CharacterModelType model_type = this.character_data_array[i].GetModelType();
            itemp = CharacterBinSpecifierAndEnumConverter.GetBinSpecifierFromCharacterModelType(model_type);
            b = ByteFunctions.short_to_byte_le((short)((short)itemp));
            bin.set(pos += 2, b[0]);
            bin.set(pos + 1, b[1]);
            itemp = this.character_data_array[i].GetHP();
            b = ByteFunctions.ushort_to_byte_le((int)((short)itemp));
            bin.set(pos += 2, b[0]);
            bin.set(pos + 1, b[1]);
            CharacterAILevel ai_level = this.character_data_array[i].GetAILevel();
            itemp = CharacterBinSpecifierAndEnumConverter.GetBinSpecifierFromCharacterAILevel(ai_level);
            b = ByteFunctions.short_to_byte_le((short)((short)itemp));
            bin.set(pos += 2, b[0]);
            bin.set(pos + 1, b[1]);
            itemp = this.character_data_array[i].GetWeaponID(0);
            b = ByteFunctions.short_to_byte_le((short)((short)itemp));
            bin.set(pos += 2, b[0]);
            bin.set(pos + 1, b[1]);
            itemp = this.character_data_array[i].GetWeaponID(1);
            b = ByteFunctions.short_to_byte_le((short)((short)itemp));
            bin.set(pos += 2, b[0]);
            bin.set(pos + 1, b[1]);
            CharacterType type = this.character_data_array[i].GetType();
            itemp = CharacterBinSpecifierAndEnumConverter.GetBinSpecifierFromCharacterType(type);
            b = ByteFunctions.short_to_byte_le((short)((short)itemp));
            bin.set(pos += 2, b[0]);
            bin.set(pos + 1, b[1]);
            pos += 2;
        }
    }
}

