/*
 * Decompiled with CFR 0.152.
 */
package com.github.dabasan.joglfaddon.pointlight;

import com.github.dabasan.basis.coloru8.ColorU8;
import com.github.dabasan.basis.coloru8.ColorU8Functions;
import com.github.dabasan.basis.vector.Vector;
import com.github.dabasan.basis.vector.VectorFunctions;
import com.github.dabasan.joglf.gl.shader.ShaderProgram;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

class PointLight {
    private boolean enabled = true;
    private Vector position = VectorFunctions.VGet((float)0.0f, (float)50.0f, (float)0.0f);
    private float k0 = 0.0f;
    private float k1 = 0.01f;
    private float k2 = 1.0E-4f;
    private ColorU8 diffuse_color = ColorU8Functions.GetColorU8((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    private float diffuse_power = 1.0f;
    private float color_clamp_min = 0.0f;
    private float color_clamp_max = 1.0f;
    private List<ShaderProgram> programs = new ArrayList<ShaderProgram>();
    private Function<Boolean, Integer> bti = b -> {
        if (!b.booleanValue()) {
            return 0;
        }
        return 1;
    };

    public boolean IsEnabled() {
        return this.enabled;
    }

    public Vector GetPosition() {
        return new Vector(this.position);
    }

    public float GetK0() {
        return this.k0;
    }

    public float GetK1() {
        return this.k1;
    }

    public float GetK2() {
        return this.k2;
    }

    public ColorU8 GetDiffuseColor() {
        return new ColorU8(this.diffuse_color);
    }

    public float GetDiffusePower() {
        return this.diffuse_power;
    }

    public float GetColorClampMin() {
        return this.color_clamp_min;
    }

    public float GetColorClampMax() {
        return this.color_clamp_max;
    }

    public void Enable(boolean enabled) {
        this.enabled = enabled;
    }

    public void SetPosition(Vector position) {
        this.position = position;
    }

    public void SetK(float k0, float k1, float k2) {
        this.k0 = k0;
        this.k1 = k1;
        this.k2 = k2;
    }

    public void SetDiffuseColor(ColorU8 diffuse_color) {
        this.diffuse_color = diffuse_color;
    }

    public void SetDiffusePower(float diffuse_power) {
        this.diffuse_power = diffuse_power;
    }

    public void SetColorClamp(float min, float max) {
        this.color_clamp_min = min;
        this.color_clamp_max = max;
    }

    public void AddProgram(ShaderProgram program) {
        this.programs.add(program);
    }

    public void RemoveProgram(ShaderProgram program) {
        this.programs.remove(program);
    }

    public void RemoveAllPrograms() {
        this.programs.clear();
    }

    public void Update(int index) {
        String element_name = "lights[" + index + "]";
        for (ShaderProgram program : this.programs) {
            program.Enable();
            program.SetUniform(element_name + ".enabled", this.bti.apply(this.enabled).intValue());
            program.SetUniform(element_name + ".position", this.position);
            program.SetUniform(element_name + ".k0", this.k0);
            program.SetUniform(element_name + ".k1", this.k1);
            program.SetUniform(element_name + ".k2", this.k2);
            program.SetUniform(element_name + ".diffuse_color", this.diffuse_color);
            program.SetUniform(element_name + ".diffuse_power", this.diffuse_power);
            program.SetUniform(element_name + ".color_clamp_min", this.color_clamp_min);
            program.SetUniform(element_name + ".color_clamp_max", this.color_clamp_max);
            program.Disable();
        }
    }
}

