/*
 * Decompiled with CFR 0.152.
 */
package org.cyclades.xml.parser.api;

import java.io.File;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.cyclades.xml.parser.XMLParserException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public abstract class XMLGeneratedObject {
    private Element rootElement;
    private Document document;

    public XMLGeneratedObject(String xmlString) throws XMLParserException {
        String eLabel = "XMLGeneratedObject.XMLGeneratedObject: ";
        if (xmlString == null) {
            return;
        }
        try {
            this.parseFromString(xmlString);
        }
        catch (Exception e) {
            throw new XMLParserException("XMLGeneratedObject.XMLGeneratedObject: " + e);
        }
    }

    public void parseFromString(String xmlString) throws XMLParserException {
        String eLabel = "XMLGeneratedObject.parseFromString: ";
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            this.document = db.parse(new InputSource(new StringReader(xmlString)));
            this.rootElement = this.document.getDocumentElement();
        }
        catch (Exception e) {
            throw new XMLParserException("XMLGeneratedObject.parseFromString: " + e);
        }
    }

    public void parseFromFile(File file) throws XMLParserException {
        String eLabel = "XMLGeneratedObject.parseFromFile: ";
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            this.document = db.parse(file);
            this.rootElement = this.document.getDocumentElement();
        }
        catch (Exception e) {
            throw new XMLParserException("XMLGeneratedObject.parseFromFile: " + e);
        }
    }

    public abstract void populate() throws XMLParserException;

    public Element getRootElement() {
        return this.rootElement;
    }

    public Document getDocument() {
        return this.document;
    }

    public void cleanUp() {
        this.rootElement = null;
        this.document = null;
    }

    public static String getTextValue(Element ele, String tagName) throws XMLParserException {
        String eLabel = "XMLGeneratedObject.getTextValue: ";
        try {
            String textVal = null;
            NodeList nl = ele.getElementsByTagName(tagName);
            if (nl != null && nl.getLength() > 0) {
                Element el = (Element)nl.item(0);
                textVal = el.getFirstChild().getNodeValue();
            }
            return textVal;
        }
        catch (Exception e) {
            throw new XMLParserException("XMLGeneratedObject.getTextValue: " + e);
        }
    }

    public static int getIntValue(Element ele, String tagName) throws XMLParserException {
        String eLabel = "XMLGeneratedObject.getIntValue: ";
        try {
            return Integer.parseInt(XMLGeneratedObject.getTextValue(ele, tagName));
        }
        catch (Exception e) {
            throw new XMLParserException("XMLGeneratedObject.getIntValue: " + e);
        }
    }

    public static String getAttributeTextValue(Element ele, String tagName, String attName) throws XMLParserException {
        String eLabel = "XMLGeneratedObject.getAttributeTextValue: ";
        try {
            String textVal = null;
            NodeList nl = ele.getElementsByTagName(tagName);
            if (nl != null && nl.getLength() > 0) {
                Element el = (Element)nl.item(0);
                textVal = el.getAttribute(attName);
            }
            return textVal;
        }
        catch (Exception e) {
            throw new XMLParserException("XMLGeneratedObject.getAttributeTextValue: " + e);
        }
    }

    public static int getAttributeIntValue(Element ele, String tagName, String attName) throws XMLParserException {
        String eLabel = "XMLGeneratedObject.getAttributeIntValue: ";
        try {
            return Integer.parseInt(XMLGeneratedObject.getAttributeTextValue(ele, tagName, attName));
        }
        catch (Exception e) {
            throw new XMLParserException("XMLGeneratedObject.getAttributeIntValue: " + e);
        }
    }

    public String toXMLString() throws Exception {
        return this.toXMLString(false);
    }

    public String toXMLString(boolean omitXMLDeclaration) throws Exception {
        if (this.document == null) {
            return null;
        }
        return XMLGeneratedObject.toXMLString(new DOMSource(this.document), omitXMLDeclaration);
    }

    public static String toXMLString(DOMSource domSource, boolean omitXMLDeclaration) throws Exception {
        String eLabel = "XMLGeneratedObject.toXMLString(DOMSource): ";
        try {
            StringWriter stringWriter = new StringWriter();
            XMLGeneratedObject.writeToStreamResult(domSource, new StreamResult(stringWriter), omitXMLDeclaration);
            stringWriter.flush();
            return stringWriter.toString();
        }
        catch (Exception e) {
            throw new Exception("XMLGeneratedObject.toXMLString(DOMSource): " + e);
        }
    }

    public static void writeToStreamResult(DOMSource domSource, StreamResult streamResult, boolean omitXMLDeclaration) throws Exception {
        String eLabel = "XMLGeneratedObject.writeToStreamResult: ";
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            if (omitXMLDeclaration) {
                transformer.setOutputProperty("omit-xml-declaration", "yes");
            }
            transformer.transform(domSource, streamResult);
        }
        catch (Exception e) {
            throw new Exception("XMLGeneratedObject.writeToStreamResult: " + e);
        }
    }
}

