/*
 * Decompiled with CFR 0.152.
 */
package org.cyclades.engine.validator;

import java.util.List;
import org.cyclades.engine.validator.ParameterListValidator;
import org.cyclades.engine.validator.ValidationFaultElement;

public class ParameterMatches
extends ParameterListValidator {
    String value;
    boolean showValuesBool = true;

    public ParameterMatches(String key, String value) {
        super(key);
        this.value = value;
    }

    public ParameterMatches(String key, String value, boolean terminal) {
        super(key, terminal);
        this.value = value;
    }

    public ParameterMatches showValues(boolean showValuesBool) {
        this.showValuesBool = showValuesBool;
        return this;
    }

    @Override
    public ValidationFaultElement validate(List<String> values) throws Exception {
        if (values == null || values.size() < 1) {
            StringBuilder sb = new StringBuilder("Parameter does not exist: ").append(this.getKey());
            return new ValidationFaultElement(sb.toString());
        }
        if (!values.get(0).equals(this.value)) {
            StringBuilder sb = new StringBuilder("Parameter input value does not match designated value: name:[").append(this.getKey()).append("]");
            if (this.showValuesBool) {
                sb.append(" designated:[").append(this.value).append("] ").append("actual:[").append(values.get(0)).append("]");
            }
            return new ValidationFaultElement(sb.toString());
        }
        return null;
    }
}

