/*
 * Decompiled with CFR 0.152.
 */
package org.cyclades.engine.validator;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.cyclades.engine.NyxletSession;
import org.cyclades.engine.validator.FieldValidator;
import org.cyclades.engine.validator.ValidationFaultElement;

public class FieldValidators {
    private List<FieldValidator> fieldValidators = new ArrayList<FieldValidator>();

    public FieldValidators add(FieldValidator fieldValidator) {
        this.fieldValidators.add(fieldValidator);
        return this;
    }

    public List<ValidationFaultElement> validate(NyxletSession nyxletSession, Map<String, List<String>> parameters) {
        return this.validate(nyxletSession, parameters, false);
    }

    public List<ValidationFaultElement> validate(NyxletSession nyxletSession, Map<String, List<String>> parameters, boolean ignoreTerminals) {
        ArrayList<ValidationFaultElement> validationFaultElements = new ArrayList<ValidationFaultElement>();
        ValidationFaultElement vfe = null;
        for (FieldValidator fv : this.fieldValidators) {
            try {
                vfe = fv.validate(nyxletSession, parameters);
            }
            catch (Exception e) {
                vfe = new ValidationFaultElement(e);
            }
            if (vfe == null) continue;
            validationFaultElements.add(vfe);
            if (!fv.isTerminal() || ignoreTerminals) continue;
            break;
        }
        return validationFaultElements;
    }

    public int size() {
        return this.fieldValidators.size();
    }
}

