/*
 * Decompiled with CFR 0.152.
 */
package org.cyclades.engine.stroma.xstroma;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cyclades.engine.MetaTypeEnum;
import org.cyclades.engine.ResponseCodeEnum;
import org.cyclades.engine.api.Nyxlet;
import org.cyclades.engine.nyxlet.NyxletRepository;
import org.cyclades.engine.stroma.STROMAResponse;
import org.cyclades.engine.stroma.xstroma.STROMARequest;
import org.cyclades.engine.stroma.xstroma.XSTROMABrokerRequest;
import org.cyclades.engine.stroma.xstroma.XSTROMABrokerResponse;
import org.cyclades.io.PeekException;
import org.cyclades.io.PeekingOutputStream;

public class VirtualizedSTROMARequest {
    private final String brokerName;
    private final Map<String, List<String>> xstromaParams;
    private final MetaTypeEnum metaTypeEnum;
    private final STROMARequest stromaRequest;

    public VirtualizedSTROMARequest(Map<String, List<String>> xstromaParams, MetaTypeEnum metaTypeEnum, String serviceName, Map<String, List<String>> params, String data) throws Exception {
        this("servicebroker", xstromaParams, metaTypeEnum, serviceName, params, data);
    }

    public VirtualizedSTROMARequest(String brokerName, Map<String, List<String>> xstromaParams, MetaTypeEnum metaTypeEnum, String serviceName, Map<String, List<String>> params, String data) throws Exception {
        String eLabel = "VirtualizedSTROMARequest.VirtualizedSTROMARequest: ";
        try {
            this.brokerName = brokerName;
            this.xstromaParams = xstromaParams;
            this.metaTypeEnum = metaTypeEnum;
            this.stromaRequest = new STROMARequest(serviceName, params, data);
        }
        catch (Exception e) {
            throw new Exception("VirtualizedSTROMARequest.VirtualizedSTROMARequest: " + e);
        }
    }

    public STROMAResponse execute() throws Exception {
        String eLabel = "VirtualizedSTROMARequest.execute: ";
        try {
            String target;
            Nyxlet nyxlet = NyxletRepository.getStaticInstance().getNyxlet(this.brokerName);
            if (nyxlet == null) {
                throw new Exception("Service not found: " + this.brokerName);
            }
            String[] targets = nyxlet.getEngineContext().getNyxletTargets(this.stromaRequest.getServiceName());
            STROMAResponse stromaResponse = null;
            if (targets == null || targets.length == 0) {
                return this.executeXSTROMARequest(nyxlet, null);
            }
            for (int i = 0; i < targets.length && (stromaResponse = this.executeXSTROMARequest(nyxlet, target = targets[i])).getErrorCode() == ResponseCodeEnum.SERVICE_NOT_FOUND.getCode(); ++i) {
            }
            return stromaResponse;
        }
        catch (Exception e) {
            throw new Exception("VirtualizedSTROMARequest.execute: " + e);
        }
    }

    private STROMAResponse executeXSTROMARequest(Nyxlet brokerNyxlet, String target) throws Exception {
        String eLabel = "VirtualizedSTROMARequest.executeXSTROMARequest: ";
        try {
            HashMap<String, List<String>> stromaRequestParameters = new HashMap<String, List<String>>();
            stromaRequestParameters.putAll(this.xstromaParams);
            if (target != null) {
                stromaRequestParameters.put("target", new ArrayList<String>(Arrays.asList(target)));
            }
            XSTROMABrokerRequest xstromaRequest = new XSTROMABrokerRequest(this.brokerName, this.metaTypeEnum, stromaRequestParameters);
            xstromaRequest.addSTROMARequest(this.stromaRequest);
            XSTROMABrokerResponse response = xstromaRequest.execute(brokerNyxlet);
            if (response.getErrorCode() != 0) {
                throw new Exception("Service Broker error: " + response.getErrorCode() + " " + response.getErrorMessage());
            }
            List<STROMAResponse> stromaResponseList = response.getResponses();
            if (stromaResponseList.size() != 1) {
                throw new Exception("There should allways be exactly one service STROMAResponse");
            }
            return stromaResponseList.get(0);
        }
        catch (Exception e) {
            throw new Exception("VirtualizedSTROMARequest.executeXSTROMARequest: " + e);
        }
    }

    public void execute(OutputStream out) throws Exception {
        String eLabel = "VirtualizedSTROMARequest.execute(OutputStream): ";
        try {
            Nyxlet nyxlet = NyxletRepository.getStaticInstance().getNyxlet(this.brokerName);
            if (nyxlet == null) {
                throw new Exception("Service not found: " + this.brokerName);
            }
            String[] targets = nyxlet.getEngineContext().getNyxletTargets(this.stromaRequest.getServiceName());
            if (targets == null || targets.length == 0) {
                this.executeXSTROMARequest(nyxlet, null, out);
            } else {
                String target;
                for (int i = 0; i < targets.length && !this.executeXSTROMARequest(nyxlet, target = targets[i], out); ++i) {
                }
            }
        }
        catch (Exception e) {
            throw new Exception("VirtualizedSTROMARequest.execute(OutputStream): " + e);
        }
    }

    private boolean executeXSTROMARequest(Nyxlet brokerNyxlet, String target, OutputStream out) throws Exception {
        String eLabel = "VirtualizedSTROMARequest.executeXSTROMARequest(Nyxlet, String, OutputStream): ";
        try {
            block5: {
                HashMap<String, List<String>> stromaRequestParameters = new HashMap<String, List<String>>();
                stromaRequestParameters.putAll(this.xstromaParams);
                if (target != null) {
                    stromaRequestParameters.put("target", new ArrayList<String>(Arrays.asList(target)));
                }
                XSTROMABrokerRequest xstromaRequest = new XSTROMABrokerRequest(this.brokerName, this.metaTypeEnum, stromaRequestParameters);
                xstromaRequest.addSTROMARequest(this.stromaRequest);
                try {
                    xstromaRequest.execute(brokerNyxlet, this.getSTROMAPeekingOutputStream(out, this.metaTypeEnum.equals((Object)MetaTypeEnum.JSON) ? (char)',' : '>'));
                }
                catch (PeekException pe) {
                    if (pe.getCode() != ResponseCodeEnum.SERVICE_NOT_FOUND.getCode()) break block5;
                    return false;
                }
            }
            return true;
        }
        catch (Exception e) {
            throw new Exception("VirtualizedSTROMARequest.executeXSTROMARequest(Nyxlet, String, OutputStream): " + e);
        }
    }

    private PeekingOutputStream getSTROMAPeekingOutputStream(OutputStream os, char delimiter) {
        return new PeekingOutputStream(os, delimiter){

            @Override
            public void peek(byte[] data) throws PeekException {
                String dataString = new String(data);
                short status = Short.parseShort(dataString.substring(dataString.length() - 3, dataString.length() - 2));
                if (status != 0) {
                    throw new PeekException("Non-zero STROMA error-code returned", status);
                }
            }
        };
    }
}

