/*
 * Decompiled with CFR 0.152.
 */
package org.cyclades.engine.stroma;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cyclades.engine.MetaTypeEnum;
import org.cyclades.engine.NyxletSession;
import org.cyclades.engine.exception.CycladesException;
import org.cyclades.engine.stroma.STROMAResponse;
import org.cyclades.engine.stroma.STROMAServiceRequest;
import org.cyclades.engine.stroma.xstroma.VirtualizedSTROMARequest;

public class STROMARequestHelper {
    public static Object virtualRequest(Map<String, List<String>> xstromaParameters, Map<String, List<String>> stromaParameters, MetaTypeEnum metaType, String serviceName, String data) throws Exception {
        STROMAResponse stromaResponse = new VirtualizedSTROMARequest(xstromaParameters, metaType, serviceName, stromaParameters, data).execute();
        if (stromaResponse.getErrorCode() != 0) {
            throw new Exception(stromaResponse.getServiceName() + " " + stromaResponse.getAction() + " " + stromaResponse.getErrorCode() + " " + stromaResponse.getErrorMessage());
        }
        return stromaResponse.getData();
    }

    public static Object request(Map<String, List<String>> stromaParameters, MetaTypeEnum metaType, String serviceName, String data) throws Exception {
        STROMAResponse stromaResponse = new STROMAServiceRequest(serviceName, metaType, stromaParameters, data).execute();
        if (stromaResponse.getErrorCode() != 0) {
            throw new Exception(stromaResponse.getServiceName() + " " + stromaResponse.getAction() + " " + stromaResponse.getErrorCode() + " " + stromaResponse.getErrorMessage());
        }
        return stromaResponse.getData();
    }

    public static Object requestGetMapChannel(Map<String, List<String>> stromaParameters, String serviceName, String mapChannelKey) throws Exception {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        NyxletSession ns = new NyxletSession(stromaParameters, null, os);
        ns.setChainsForward(true);
        STROMAServiceRequest.execute(serviceName, ns);
        STROMAResponse sr = STROMAResponse.fromBytes(ns.getMetaTypeEnum(), os.toByteArray());
        if (sr.getErrorCode() != 0) {
            throw new CycladesException(sr.getErrorMessage(), (short)sr.getErrorCode());
        }
        return ns.getMapChannelObject(mapChannelKey);
    }

    public static Object requestSetAndGetMapChannel(Map<String, List<String>> stromaParameters, String serviceName, String mapChannelKey, Object mapChannelObject, String returMapChannelKey) throws Exception {
        HashMap<Object, Object> mapChannel = new HashMap<Object, Object>();
        mapChannel.put(mapChannelKey, mapChannelObject);
        return STROMARequestHelper.requestSetAndGetMapChannel(stromaParameters, serviceName, mapChannel).get(returMapChannelKey);
    }

    public static Map<Object, Object> requestSetAndGetMapChannel(Map<String, List<String>> stromaParameters, String serviceName, Map<Object, Object> mapChannel) throws Exception {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        NyxletSession ns = new NyxletSession(stromaParameters, null, os);
        ns.setMapChannel(mapChannel);
        ns.setChainsForward(true);
        STROMAServiceRequest.execute(serviceName, ns);
        STROMAResponse sr = STROMAResponse.fromBytes(ns.getMetaTypeEnum(), os.toByteArray());
        if (sr.getErrorCode() != 0) {
            throw new CycladesException(sr.getErrorMessage(), (short)sr.getErrorCode());
        }
        return ns.getMapChannel();
    }

    public static void requestSetMapChannel(Map<String, List<String>> stromaParameters, String serviceName, String mapChannelKey, Object mapChannelObject, OutputStream os) throws Exception {
        NyxletSession ns = new NyxletSession(stromaParameters, null, os);
        ns.putMapChannelObject(mapChannelKey, mapChannelObject);
        STROMAServiceRequest.execute(serviceName, ns);
    }

    public static void requestSetMapChannel(Map<String, List<String>> stromaParameters, String serviceName, Map<Object, Object> mapChannel, OutputStream os) throws Exception {
        NyxletSession ns = new NyxletSession(stromaParameters, null, os);
        ns.setMapChannel(mapChannel);
        STROMAServiceRequest.execute(serviceName, ns);
    }

    public static String requestStreamedResponse(Map<String, List<String>> stromaParameters, MetaTypeEnum metaType, String serviceName, String data) throws Exception {
        String eLabel = "STROMARequestHelper.requestStreamedResponse: ";
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            STROMARequestHelper.requestStreamedResponse(stromaParameters, metaType, serviceName, data, baos);
            if (baos.size() < 1) {
                throw new Exception("No data returned in service response stream");
            }
            return String.valueOf(baos);
        }
        catch (Exception e) {
            throw new Exception("STROMARequestHelper.requestStreamedResponse: " + e);
        }
    }

    public static void requestStreamedResponse(Map<String, List<String>> stromaParameters, MetaTypeEnum metaType, String serviceName, String data, OutputStream os) throws Exception {
        new STROMAServiceRequest(serviceName, metaType, stromaParameters, data).execute(os);
    }
}

