/*
 * Decompiled with CFR 0.152.
 */
package org.cyclades.engine.nyxlet.templates.xstroma.target;

import java.util.ArrayList;
import java.util.List;
import org.cyclades.engine.nyxlet.templates.xstroma.ServiceBrokerNyxletImpl;
import org.cyclades.engine.nyxlet.templates.xstroma.message.api.MessageConsumer;
import org.cyclades.engine.nyxlet.templates.xstroma.message.api.MessageProcessor;
import org.cyclades.engine.nyxlet.templates.xstroma.message.impl.RawMessageProcessor;
import org.cyclades.engine.nyxlet.templates.xstroma.message.impl.ResponseProcessor;
import org.cyclades.engine.util.MapHelper;
import org.json.JSONObject;

public class ConsumerTarget {
    private final String theClass;
    private MessageConsumer messageConsumer;
    private static final String CLASS = "class";
    private static final String TARGET_INITIALIZATION_DATA = "target_init_data";
    private static final String RAW_MESSAGE_PROCESSOR_DATA = "raw_message_processor";
    private static final String RESPONSE_PROCESSOR_DATA = "response_processor";

    public ConsumerTarget(String theClass, JSONObject initializationData, JSONObject messageProcessorData, JSONObject responseProcessorData, ServiceBrokerNyxletImpl service) throws Exception {
        String eLabel = "ConsumerTarget.ConsumerTarget: ";
        try {
            this.theClass = theClass;
            this.messageConsumer = (MessageConsumer)service.getClass().getClassLoader().loadClass(theClass).newInstance();
            this.messageConsumer.init(MapHelper.mapFromMetaObject(initializationData), messageProcessorData == null ? null : new RawMessageProcessor(messageProcessorData), responseProcessorData == null ? null : new ResponseProcessor(responseProcessorData), service);
        }
        catch (Exception e) {
            throw new Exception("ConsumerTarget.ConsumerTarget: " + e);
        }
    }

    public ConsumerTarget(String theClass, JSONObject initializationData, MessageProcessor messageProcessor) throws Exception {
        String eLabel = "ConsumerTarget.ConsumerTarget: ";
        try {
            this.theClass = theClass;
            this.messageConsumer = (MessageConsumer)this.getClass().getClassLoader().loadClass(theClass).newInstance();
            this.messageConsumer.init(MapHelper.mapFromMetaObject(initializationData), messageProcessor, null, null);
        }
        catch (Exception e) {
            throw new Exception("ConsumerTarget.ConsumerTarget: " + e);
        }
    }

    public static List<ConsumerTarget> loadTargets(List<JSONObject> consumerJSONObjectTargets, ServiceBrokerNyxletImpl service) throws Exception {
        String eLabel = "ConsumerTarget.loadTargets: ";
        ArrayList<ConsumerTarget> targetList = null;
        try {
            targetList = new ArrayList<ConsumerTarget>();
            for (JSONObject target : consumerJSONObjectTargets) {
                targetList.add(new ConsumerTarget(target.getString(CLASS), target.getJSONObject(TARGET_INITIALIZATION_DATA), target.has(RAW_MESSAGE_PROCESSOR_DATA) ? target.getJSONObject(RAW_MESSAGE_PROCESSOR_DATA) : null, target.has(RESPONSE_PROCESSOR_DATA) ? target.getJSONObject(RESPONSE_PROCESSOR_DATA) : null, service));
            }
            return targetList;
        }
        catch (Exception e) {
            if (targetList != null) {
                for (ConsumerTarget consumerTarget : targetList) {
                    try {
                        consumerTarget.destroy();
                    }
                    catch (Exception ex) {}
                }
            }
            throw new Exception("ConsumerTarget.loadTargets: " + e);
        }
    }

    public void destroy() throws Exception {
        String eLabel = "ConsumerTarget.destroy: ";
        try {
            this.messageConsumer.destroy();
        }
        catch (Exception e) {
            throw new Exception("ConsumerTarget.destroy: " + e);
        }
    }

    public String toString() {
        return this.theClass;
    }

    public boolean isHealthy() throws Exception {
        return this.messageConsumer.isHealthy();
    }
}

