/*
 * Decompiled with CFR 0.152.
 */
package org.cyclades.engine.nyxlet.templates.xstroma.message.impl;

import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cyclades.engine.MetaTypeEnum;
import org.cyclades.engine.NyxletSession;
import org.cyclades.engine.nyxlet.templates.xstroma.message.api.StreamingMessageProducer;
import org.cyclades.engine.stroma.STROMAResponseWriter;
import org.cyclades.engine.stroma.xstroma.XSTROMAResponseWriter;
import org.cyclades.io.ResourceRequestUtils;

public class HTTPRepeatingMessageProducer
implements StreamingMessageProducer {
    private String queryParameters;
    public static final String CONNECTION_TIMEOUT = "connection-timeout";
    public static final String READ_TIMEOUT = "read-timeout";
    public static final String URI_PARAMETER = "uri";
    private static final Map<String, String> headerProperties = new HashMap<String, String>();

    @Override
    public void init(Map<String, String> initializationMap) throws Exception {
        this.queryParameters = "?" + "x-stroma-message";
    }

    @Override
    public void sendMessage(String message, Map<String, List<String>> attributeMap, OutputStream os) throws Exception {
        String eLabel = "HTTPRepeatingMessageProducer.sendMessage: ";
        NyxletSession ns = new NyxletSession(attributeMap, null, os);
        XSTROMAResponseWriter writer = new XSTROMAResponseWriter("servicebroker", ns);
        try {
            if (!attributeMap.containsKey(URI_PARAMETER)) {
                throw new Exception("Requires parameter parameter: uri");
            }
            int connectionTimeout = attributeMap.containsKey(CONNECTION_TIMEOUT) ? Integer.parseInt(attributeMap.get(CONNECTION_TIMEOUT).get(0)) : 0;
            int readTimeout = attributeMap.containsKey(READ_TIMEOUT) ? Integer.parseInt(attributeMap.get(READ_TIMEOUT).get(0)) : 0;
            OutputStream writeTo = writer.getOutputStream();
            int i = 0;
            for (String uri : attributeMap.get(URI_PARAMETER)) {
                if (i++ > 0 && ns.getResponseMetaTypeEnum().equals((Object)MetaTypeEnum.JSON)) {
                    writeTo.write(",".getBytes());
                }
                writer.addResponseParameter(URI_PARAMETER, uri);
                try {
                    String responseString = new String(ResourceRequestUtils.getData(uri + this.queryParameters, message.getBytes(), headerProperties, 1024, connectionTimeout, readTimeout));
                    writeTo.write(responseString.getBytes());
                    if (!responseString.contains("orchestration-fault")) continue;
                    writer.addResponseParameter("error", uri);
                }
                catch (Exception e) {
                    new STROMAResponseWriter("servicebroker", ns).writeErrorResponse(1, e.toString());
                    writer.addResponseParameter("error", uri + " " + e.toString());
                    if (!attributeMap.containsKey("enable-orchestration-fault")) continue;
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception("HTTPRepeatingMessageProducer.sendMessage: " + e);
        }
        finally {
            writer.done();
        }
    }

    @Override
    public String sendMessage(String message, Map<String, List<String>> attributeMap) throws Exception {
        throw new UnsupportedOperationException("Please use the sendMessage implementation from StreamingMessageProducer");
    }

    @Override
    public void destroy() throws Exception {
    }

    @Override
    public boolean isHealthy() throws Exception {
        return true;
    }

    static {
        headerProperties.put("STROMA", "true");
    }
}

