/*
 * Decompiled with CFR 0.152.
 */
package org.cyclades.collectiveutils.list;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class BinarySortedListFacade<T extends Comparable<T>>
implements Iterable<T> {
    private List<T> list;

    public BinarySortedListFacade() {
        this.list = new ArrayList<T>();
    }

    public BinarySortedListFacade(List<T> list) throws NullPointerException {
        String eLabel = "BinarySortedListFacade.BinarySortListFacade: ";
        if (list == null) {
            throw new NullPointerException("BinarySortedListFacade.BinarySortListFacade: List parameter cannot be null");
        }
        this.list = list;
        if (list.size() > 1) {
            BinarySortedListFacade.binarySort(list);
        }
    }

    public void add(T item) {
        BinarySortedListFacade.binaryInsertionSort(item, this.list);
    }

    @Override
    public Iterator<T> iterator() {
        return this.list.iterator();
    }

    public static <T extends Comparable<? super T>> void binarySort(List<T> list) {
        String eLabel = "BinarySortedListFacade.binarySort: ";
        if (list == null) {
            throw new NullPointerException("BinarySortedListFacade.binarySort: List parameter must not be null");
        }
        for (int i = 0; i < list.size(); ++i) {
            Comparable value = (Comparable)list.get(i);
            int left = 0;
            int right = i;
            while (left <= right) {
                int mid = (left + right) / 2;
                if (value.compareTo(list.get(mid)) >= 0) {
                    left = mid + 1;
                    continue;
                }
                right = mid - 1;
            }
            if (i <= left) continue;
            list.add(left, list.remove(i));
        }
    }

    public static <T extends Comparable<? super T>> void binaryInsertionSort(T item, List<T> list) {
        String eLabel = "BinarySortedListFacade.binaryInsertionSort: ";
        if (item == null) {
            throw new NullPointerException("BinarySortedListFacade.binaryInsertionSort: <T>item parameter must not be null");
        }
        if (list == null) {
            throw new NullPointerException("BinarySortedListFacade.binaryInsertionSort: List parameter must not be null");
        }
        int left = 0;
        int right = list.size() - 1;
        while (left <= right) {
            int mid = (left + right) / 2;
            if (item.compareTo(list.get(mid)) >= 0) {
                left = mid + 1;
                continue;
            }
            right = mid - 1;
        }
        list.add(left, item);
    }

    public String toString() {
        return this.list.toString();
    }
}

