/*
 * Decompiled with CFR 0.152.
 */
package org.cyclades.client;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cyclades.engine.stroma.xstroma.STROMARequest;
import org.cyclades.engine.stroma.xstroma.XSTROMABrokerRequest;
import org.cyclades.io.ResourceRequestUtils;
import org.cyclades.io.StreamUtils;

public class Http {
    private static final Map<String, String> headerProperties = new HashMap<String, String>();

    public static byte[] execute(String url, XSTROMABrokerRequest xstromaRequest) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Http.execute(url, xstromaRequest, (OutputStream)baos);
        return baos.toByteArray();
    }

    public static void execute(String url, XSTROMABrokerRequest xstromaRequest, OutputStream out) throws Exception {
        Http.execute(url, xstromaRequest, false, out, 0, 0);
    }

    public static byte[] execute(String url, XSTROMABrokerRequest xstromaRequest, boolean xstromaMessage) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Http.execute(url, xstromaRequest, xstromaMessage, baos);
        return baos.toByteArray();
    }

    public static void execute(String url, XSTROMABrokerRequest xstromaRequest, boolean xstromaMessage, OutputStream out) throws Exception {
        Http.execute(url, xstromaRequest, xstromaMessage, out, 0, 0);
    }

    public static byte[] execute(String url, XSTROMABrokerRequest xstromaRequest, boolean xstromaMessage, int connectionTimeout, int readTimeout) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Http.execute(url, xstromaRequest, xstromaMessage, baos, connectionTimeout, readTimeout);
        return baos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(String url, XSTROMABrokerRequest xstromaRequest, boolean xstromaMessage, OutputStream out, int connectionTimeout, int readTimeout) throws Exception {
        String xstromaString;
        StringBuilder requestURL = new StringBuilder(url);
        if (xstromaMessage) {
            requestURL.append("?").append("x-stroma-message");
            xstromaString = xstromaRequest.toXSTROMAMessage();
        } else {
            requestURL.append(Http.createParameterizedXSTOMAUrl(xstromaRequest));
            xstromaString = xstromaRequest.generateData();
        }
        InputStream is = null;
        try {
            is = ResourceRequestUtils.getInputStreamHTTP(requestURL.toString(), "POST", new ByteArrayInputStream(xstromaString.getBytes()), headerProperties, connectionTimeout, readTimeout);
            StreamUtils.write(is, out);
        }
        finally {
            try {
                is.close();
            }
            catch (Exception e) {}
        }
    }

    public static String toString(XSTROMABrokerRequest xstromaRequest, boolean xstromaMessage) throws Exception {
        if (xstromaMessage) {
            return xstromaRequest.toXSTROMAMessage();
        }
        return xstromaRequest.generateData();
    }

    private static String createParameterizedXSTOMAUrl(XSTROMABrokerRequest xstromaRequest) throws URISyntaxException {
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append("data-type=").append(xstromaRequest.getMetaTypeEnum().name());
        Map<String, List<String>> parameters = xstromaRequest.getParameters();
        for (Map.Entry<String, List<String>> parametersEntry : parameters.entrySet()) {
            String key = parametersEntry.getKey();
            List<String> values = parametersEntry.getValue();
            for (String value : values) {
                urlBuilder.append("&").append(key).append("=").append(value);
            }
        }
        return new URI(null, null, null, urlBuilder.toString(), null).toString();
    }

    public static byte[] execute(String url, STROMARequest stromaRequest) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Http.execute(url, stromaRequest, (OutputStream)baos);
        return baos.toByteArray();
    }

    public static void execute(String url, STROMARequest stromaRequest, OutputStream out) throws Exception {
        Http.execute(url, stromaRequest, out, 0, 0);
    }

    public static byte[] execute(String url, STROMARequest stromaRequest, int connectionTimeout, int readTimeout) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Http.execute(url, stromaRequest, baos, connectionTimeout, readTimeout);
        return baos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(String url, STROMARequest stromaRequest, OutputStream out, int connectionTimeout, int readTimeout) throws Exception {
        StringBuilder requestURL = new StringBuilder(url);
        String stromaDataString = stromaRequest.generateData();
        InputStream is = null;
        try {
            is = ResourceRequestUtils.getInputStreamHTTP(requestURL.toString(), "POST", new ByteArrayInputStream(stromaDataString.getBytes()), headerProperties, connectionTimeout, readTimeout);
            StreamUtils.write(is, out);
        }
        finally {
            try {
                is.close();
            }
            catch (Exception e) {}
        }
    }

    static {
        headerProperties.put("STROMA", "true");
    }
}

