package com.github.curiousoddman.rgxgen.model;

/* **************************************************************************
   Copyright 2019 Vladislavs Varslavans

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
/* **************************************************************************/

public class UnicodeCategoryConstants {
    public static final SymbolRange BASIC_LATIN_ASCII_PUNCTUATION_AND_SYMBOLS_TO_ASCII_PUNCTUATION_AND_SYMBOLS = SymbolRange.range(' ', '');  // 0x20 - 0x7f
    public static final SymbolRange BASIC_LATIN_ASCII_PUNCTUATION_AND_SYMBOLS_SUBSET_1 = SymbolRange.range('!', '#');  // 0x21 - 0x23
    public static final SymbolRange BASIC_LATIN_ASCII_PUNCTUATION_AND_SYMBOLS_SUBSET_2 = SymbolRange.range('%', '\'');  // 0x25 - 0x27
    public static final SymbolRange BASIC_LATIN_ASCII_PUNCTUATION_AND_SYMBOLS_SUBSET_3 = SymbolRange.range('%', '*');  // 0x25 - 0x2a
    public static final SymbolRange BASIC_LATIN_ASCII_PUNCTUATION = SymbolRange.range(',', '/');  // 0x2c - 0x2f
    public static final SymbolRange BASIC_LATIN_ASCII_PUNCTUATION_SUBSET = SymbolRange.range('.', '/');  // 0x2e - 0x2f
    public static final SymbolRange BASIC_LATIN_ASCII_DIGITS = SymbolRange.range('0', '9');  // 0x30 - 0x39
    public static final SymbolRange BASIC_LATIN_ASCII_PUNCTUATION_1 = SymbolRange.range(':', ';');  // 0x3a - 0x3b
    public static final SymbolRange BASIC_LATIN_ASCII_MATHEMATICAL_OPERATORS = SymbolRange.range('<', '>');  // 0x3c - 0x3e
    public static final SymbolRange BASIC_LATIN_ASCII_PUNCTUATION_2 = SymbolRange.range('?', '@');  // 0x3f - 0x40
    public static final SymbolRange BASIC_LATIN_UPPERCASE_LATIN_ALPHABET = SymbolRange.range('A', 'Z');  // 0x41 - 0x5a
    public static final SymbolRange BASIC_LATIN_ASCII_PUNCTUATION_AND_SYMBOLS_SUBSET = SymbolRange.range('[', ']');  // 0x5b - 0x5d
    public static final SymbolRange BASIC_LATIN_LOWERCASE_LATIN_ALPHABET = SymbolRange.range('a', 'z');  // 0x61 - 0x7a
    public static final SymbolRange BASIC_LATIN_TO_LATIN_1_SUPPLEMENT = SymbolRange.range('', '');  // 0x7f - 0x9f
    public static final SymbolRange LATIN_1_SUPPLEMENT_LATIN_1_PUNCTUATION_AND_SYMBOLS_SUBSET = SymbolRange.range('¢', '¥');  // 0xa2 - 0xa5
    public static final SymbolRange LATIN_1_SUPPLEMENT_LATIN_1_PUNCTUATION_AND_SYMBOLS_SUBSET_1 = SymbolRange.range('¢', '¦');  // 0xa2 - 0xa6
    public static final SymbolRange LATIN_1_SUPPLEMENT_LATIN_1_PUNCTUATION_AND_SYMBOLS_SUBSET_2 = SymbolRange.range('¨', '©');  // 0xa8 - 0xa9
    public static final SymbolRange LATIN_1_SUPPLEMENT_LATIN_1_PUNCTUATION_AND_SYMBOLS_SUBSET_3 = SymbolRange.range('®', '±');  // 0xae - 0xb1
    public static final SymbolRange LATIN_1_SUPPLEMENT_LATIN_1_PUNCTUATION_AND_SYMBOLS_SUBSET_4 = SymbolRange.range('²', '³');  // 0xb2 - 0xb3
    public static final SymbolRange LATIN_1_SUPPLEMENT_LATIN_1_PUNCTUATION_AND_SYMBOLS_SUBSET_5 = SymbolRange.range('¶', '·');  // 0xb6 - 0xb7
    public static final SymbolRange LATIN_1_SUPPLEMENT_VULGAR_FRACTIONS = SymbolRange.range('¼', '¾');  // 0xbc - 0xbe
    public static final SymbolRange LATIN_1_SUPPLEMENT_LETTERS = SymbolRange.range('À', 'Ö');  // 0xc0 - 0xd6
    public static final SymbolRange LATIN_1_SUPPLEMENT_UPPERCASE_LETTERS = SymbolRange.range('Ø', 'Þ');  // 0xd8 - 0xde
    public static final SymbolRange LATIN_1_SUPPLEMENT_UPPERCASE_LETTERS_TO_LOWERCASE_LETTERS = SymbolRange.range('Ø', 'ö');  // 0xd8 - 0xf6
    public static final SymbolRange LATIN_1_SUPPLEMENT_LOWERCASE_LETTERS = SymbolRange.range('ß', 'ö');  // 0xdf - 0xf6
    public static final SymbolRange LATIN_1_SUPPLEMENT_TO_SPACING_MODIFIER_LETTERS = SymbolRange.range('ø', 'ˁ');  // 0xf8 - 0x2c1
    public static final SymbolRange LATIN_1_SUPPLEMENT_LETTERS_1 = SymbolRange.range('ø', 'ÿ');  // 0xf8 - 0xff
    public static final SymbolRange LATIN_EXTENDED_A_EUROPEAN_LATIN_SUBSET = SymbolRange.range('ķ', 'ĸ');  // 0x137 - 0x138
    public static final SymbolRange LATIN_EXTENDED_A_EUROPEAN_LATIN_TO_EUROPEAN_LATIN = SymbolRange.range('ň', 'ŉ');  // 0x148 - 0x149
    public static final SymbolRange LATIN_EXTENDED_A_EUROPEAN_LATIN_SUBSET_1 = SymbolRange.range('Ÿ', 'Ź');  // 0x178 - 0x179
    public static final SymbolRange LATIN_EXTENDED_A_EUROPEAN_LATIN_TO_EUROPEAN_LATIN_1 = SymbolRange.range('ž', 'ƀ');  // 0x17e - 0x180
    public static final SymbolRange LATIN_EXTENDED_B_NON_EUROPEAN_AND_HISTORIC_LATIN_SUBSET = SymbolRange.range('Ɓ', 'Ƃ');  // 0x181 - 0x182
    public static final SymbolRange LATIN_EXTENDED_B_NON_EUROPEAN_AND_HISTORIC_LATIN_SUBSET_1 = SymbolRange.range('Ɔ', 'Ƈ');  // 0x186 - 0x187
    public static final SymbolRange LATIN_EXTENDED_B_NON_EUROPEAN_AND_HISTORIC_LATIN_SUBSET_2 = SymbolRange.range('Ɖ', 'Ƌ');  // 0x189 - 0x18b
    public static final SymbolRange LATIN_EXTENDED_B_NON_EUROPEAN_AND_HISTORIC_LATIN_SUBSET_3 = SymbolRange.range('ƌ', 'ƍ');  // 0x18c - 0x18d
    public static final SymbolRange LATIN_EXTENDED_B_NON_EUROPEAN_AND_HISTORIC_LATIN_SUBSET_4 = SymbolRange.range('Ǝ', 'Ƒ');  // 0x18e - 0x191
    public static final SymbolRange LATIN_EXTENDED_B_NON_EUROPEAN_AND_HISTORIC_LATIN_SUBSET_5 = SymbolRange.range('Ɠ', 'Ɣ');  // 0x193 - 0x194
    public static final SymbolRange LATIN_EXTENDED_B_NON_EUROPEAN_AND_HISTORIC_LATIN_SUBSET_6 = SymbolRange.range('Ɩ', 'Ƙ');  // 0x196 - 0x198
    public static final SymbolRange LATIN_EXTENDED_B_NON_EUROPEAN_AND_HISTORIC_LATIN_SUBSET_7 = SymbolRange.range('ƙ', 'ƛ');  // 0x199 - 0x19b
    public static final SymbolRange LATIN_EXTENDED_B_NON_EUROPEAN_AND_HISTORIC_LATIN_SUBSET_8 = SymbolRange.range('Ɯ', 'Ɲ');  // 0x19c - 0x19d
    public static final SymbolRange LATIN_EXTENDED_B_NON_EUROPEAN_AND_HISTORIC_LATIN_SUBSET_9 = SymbolRange.range('Ɵ', 'Ơ');  // 0x19f - 0x1a0
    public static final SymbolRange LATIN_EXTENDED_B_NON_EUROPEAN_AND_HISTORIC_LATIN_SUBSET_10 = SymbolRange.range('Ʀ', 'Ƨ');  // 0x1a6 - 0x1a7
    public static final SymbolRange LATIN_EXTENDED_B_NON_EUROPEAN_AND_HISTORIC_LATIN_SUBSET_11 = SymbolRange.range('ƪ', 'ƫ');  // 0x1aa - 0x1ab
    public static final SymbolRange LATIN_EXTENDED_B_NON_EUROPEAN_AND_HISTORIC_LATIN_SUBSET_12 = SymbolRange.range('Ʈ', 'Ư');  // 0x1ae - 0x1af
    public static final SymbolRange LATIN_EXTENDED_B_NON_EUROPEAN_AND_HISTORIC_LATIN_SUBSET_13 = SymbolRange.range('Ʊ', 'Ƴ');  // 0x1b1 - 0x1b3
    public static final SymbolRange LATIN_EXTENDED_B_NON_EUROPEAN_AND_HISTORIC_LATIN_SUBSET_14 = SymbolRange.range('Ʒ', 'Ƹ');  // 0x1b7 - 0x1b8
    public static final SymbolRange LATIN_EXTENDED_B_NON_EUROPEAN_AND_HISTORIC_LATIN_SUBSET_15 = SymbolRange.range('ƹ', 'ƺ');  // 0x1b9 - 0x1ba
    public static final SymbolRange LATIN_EXTENDED_B_NON_EUROPEAN_AND_HISTORIC_LATIN_SUBSET_16 = SymbolRange.range('ƽ', 'ƿ');  // 0x1bd - 0x1bf
    public static final SymbolRange LATIN_EXTENDED_B_AFRICAN_LETTERS_FOR_CLICKS = SymbolRange.range('ǀ', 'ǃ');  // 0x1c0 - 0x1c3
    public static final SymbolRange LATIN_EXTENDED_B_PINYIN_DIACRITIC_VOWEL_COMBINATIONS_TO_PINYIN_DIACRITIC_VOWEL_COMBINATIONS = SymbolRange.range('ǜ', 'ǝ');  // 0x1dc - 0x1dd
    public static final SymbolRange LATIN_EXTENDED_B_PHONETIC_AND_HISTORIC_LETTERS_SUBSET = SymbolRange.range('ǯ', 'ǰ');  // 0x1ef - 0x1f0
    public static final SymbolRange LATIN_EXTENDED_B_PHONETIC_AND_HISTORIC_LETTERS_SUBSET_1 = SymbolRange.range('Ƕ', 'Ǹ');  // 0x1f6 - 0x1f8
    public static final SymbolRange LATIN_EXTENDED_B_ADDITIONS_FOR_LIVONIAN_TO_ADDITIONS_FOR_AFRICANIST_LINGUISTICS = SymbolRange.range('ȳ', 'ȹ');  // 0x233 - 0x239
    public static final SymbolRange LATIN_EXTENDED_B_ADDITIONS_FOR_SENCOTEN_SUBSET = SymbolRange.range('Ⱥ', 'Ȼ');  // 0x23a - 0x23b
    public static final SymbolRange LATIN_EXTENDED_B_ADDITIONS_FOR_SENCOTEN_SUBSET_1 = SymbolRange.range('Ƚ', 'Ⱦ');  // 0x23d - 0x23e
    public static final SymbolRange LATIN_EXTENDED_B_ADDITIONS_FOR_AFRICANIST_LINGUISTICS_1 = SymbolRange.range('ȿ', 'ɀ');  // 0x23f - 0x240
    public static final SymbolRange LATIN_EXTENDED_B_MISCELLANEOUS_ADDITIONS_SUBSET = SymbolRange.range('Ƀ', 'Ɇ');  // 0x243 - 0x246
    public static final SymbolRange LATIN_EXTENDED_B_TO_IPA_EXTENSIONS = SymbolRange.range('ɏ', 'ʓ');  // 0x24f - 0x293
    public static final SymbolRange IPA_EXTENSIONS_IPA_EXTENSIONS_TO_ADDITIONS_FOR_SINOLOGY = SymbolRange.range('ɐ', 'ʯ');  // 0x250 - 0x2af
    public static final SymbolRange IPA_EXTENSIONS_IPA_EXTENSIONS_TO_ADDITIONS_FOR_SINOLOGY_1 = SymbolRange.range('ʕ', 'ʯ');  // 0x295 - 0x2af
    public static final SymbolRange SPACING_MODIFIER_LETTERS_LATIN_SUPERSCRIPT_MODIFIER_LETTERS_TO_MISCELLANEOUS_PHONETIC_MODIFIERS = SymbolRange.range('ʰ', 'ˁ');  // 0x2b0 - 0x2c1
    public static final SymbolRange SPACING_MODIFIER_LETTERS_LATIN_SUPERSCRIPT_MODIFIER_LETTERS_TO_UPA_MODIFIERS = SymbolRange.range('ʰ', '˿');  // 0x2b0 - 0x2ff
    public static final SymbolRange SPACING_MODIFIER_LETTERS_MISCELLANEOUS_PHONETIC_MODIFIERS_SUBSET = SymbolRange.range('˂', '˅');  // 0x2c2 - 0x2c5
    public static final SymbolRange SPACING_MODIFIER_LETTERS_MISCELLANEOUS_PHONETIC_MODIFIERS_SUBSET_1 = SymbolRange.range('ˆ', 'ˑ');  // 0x2c6 - 0x2d1
    public static final SymbolRange SPACING_MODIFIER_LETTERS_MISCELLANEOUS_PHONETIC_MODIFIERS_TO_ADDITIONS_BASED_ON_1989_IPA = SymbolRange.range('˒', '˟');  // 0x2d2 - 0x2df
    public static final SymbolRange SPACING_MODIFIER_LETTERS_ADDITIONS_BASED_ON_1989_IPA_SUBSET = SymbolRange.range('ˠ', 'ˤ');  // 0x2e0 - 0x2e4
    public static final SymbolRange SPACING_MODIFIER_LETTERS_TONE_LETTERS_TO_EXTENDED_BOPOMOFO_TONE_MARKS = SymbolRange.range('˥', '˫');  // 0x2e5 - 0x2eb
    public static final SymbolRange SPACING_MODIFIER_LETTERS_UPA_MODIFIERS = SymbolRange.range('˯', '˿');  // 0x2ef - 0x2ff
    public static final SymbolRange COMBINING_DIACRITICAL_MARKS_ORDINARY_DIACRITICS_TO_MEDIEVAL_SUPERSCRIPT_LETTER_DIACRITICS = SymbolRange.range('̀', 'ͯ');  // 0x300 - 0x36f
    public static final SymbolRange GREEK_AND_COPTIC_ARCHAIC_LETTERS_TO_ARCHAIC_LETTERS = SymbolRange.range('Ͱ', 'ʹ');  // 0x370 - 0x374
    public static final SymbolRange GREEK_AND_COPTIC_ARCHAIC_LETTERS_SUBSET = SymbolRange.range('Ͷ', 'ͷ');  // 0x376 - 0x377
    public static final SymbolRange GREEK_AND_COPTIC_IOTA_SUBSCRIPT_TO_LOWERCASE_OF_EDITORIAL_SYMBOLS = SymbolRange.range('ͺ', 'ͽ');  // 0x37a - 0x37d
    public static final SymbolRange GREEK_AND_COPTIC_LOWERCASE_OF_EDITORIAL_SYMBOLS = SymbolRange.range('ͻ', 'ͽ');  // 0x37b - 0x37d
    public static final SymbolRange GREEK_AND_COPTIC_SPACING_ACCENT_MARKS = SymbolRange.range('΄', '΅');  // 0x384 - 0x385
    public static final SymbolRange GREEK_AND_COPTIC_LETTERS_SUBSET = SymbolRange.range('Έ', 'Ί');  // 0x388 - 0x38a
    public static final SymbolRange GREEK_AND_COPTIC_LETTERS_SUBSET_1 = SymbolRange.range('Ύ', 'Ώ');  // 0x38e - 0x38f
    public static final SymbolRange GREEK_AND_COPTIC_LETTERS_SUBSET_2 = SymbolRange.range('Ύ', 'Ρ');  // 0x38e - 0x3a1
    public static final SymbolRange GREEK_AND_COPTIC_LETTERS_SUBSET_3 = SymbolRange.range('Α', 'Ρ');  // 0x391 - 0x3a1
    public static final SymbolRange GREEK_AND_COPTIC_LETTERS_SUBSET_4 = SymbolRange.range('Σ', 'Ϋ');  // 0x3a3 - 0x3ab
    public static final SymbolRange GREEK_AND_COPTIC_LETTERS_TO_VARIANT_LETTERFORMS_AND_SYMBOLS = SymbolRange.range('Σ', 'ϵ');  // 0x3a3 - 0x3f5
    public static final SymbolRange GREEK_AND_COPTIC_LETTERS_SUBSET_5 = SymbolRange.range('ά', 'ώ');  // 0x3ac - 0x3ce
    public static final SymbolRange GREEK_AND_COPTIC_VARIANT_LETTERFORMS_SUBSET = SymbolRange.range('ϐ', 'ϑ');  // 0x3d0 - 0x3d1
    public static final SymbolRange GREEK_AND_COPTIC_VARIANT_LETTERFORMS_SUBSET_1 = SymbolRange.range('ϒ', 'ϔ');  // 0x3d2 - 0x3d4
    public static final SymbolRange GREEK_AND_COPTIC_VARIANT_LETTERFORMS_SUBSET_2 = SymbolRange.range('ϕ', 'ϗ');  // 0x3d5 - 0x3d7
    public static final SymbolRange GREEK_AND_COPTIC_COPTIC_LETTERS_DERIVED_FROM_DEMOTIC_TO_VARIANT_LETTERFORMS = SymbolRange.range('ϯ', 'ϳ');  // 0x3ef - 0x3f3
    public static final SymbolRange GREEK_AND_COPTIC_TO_CYRILLIC = SymbolRange.range('Ϸ', 'ҁ');  // 0x3f7 - 0x481
    public static final SymbolRange GREEK_AND_COPTIC_VARIANT_LETTERFORM_TO_VARIANT_LETTERFORM = SymbolRange.range('Ϲ', 'Ϻ');  // 0x3f9 - 0x3fa
    public static final SymbolRange GREEK_AND_COPTIC_ARCHAIC_LETTERS_TO_ARCHAIC_LETTERS_1 = SymbolRange.range('ϻ', 'ϼ');  // 0x3fb - 0x3fc
    public static final SymbolRange GREEK_AND_COPTIC_TO_CYRILLIC_1 = SymbolRange.range('Ͻ', 'Я');  // 0x3fd - 0x42f
    public static final SymbolRange CYRILLIC_CYRILLIC_EXTENSIONS_TO_ADDITIONS_FOR_NIVKH = SymbolRange.range('Ѐ', 'ӿ');  // 0x400 - 0x4ff
    public static final SymbolRange CYRILLIC_BASIC_RUSSIAN_ALPHABET_TO_CYRILLIC_EXTENSIONS = SymbolRange.range('а', 'џ');  // 0x430 - 0x45f
    public static final SymbolRange CYRILLIC_HISTORIC_MISCELLANEOUS_SUBSET = SymbolRange.range('҃', '҇');  // 0x483 - 0x487
    public static final SymbolRange CYRILLIC_HISTORIC_MISCELLANEOUS_SUBSET_1 = SymbolRange.range('҃', '҉');  // 0x483 - 0x489
    public static final SymbolRange CYRILLIC_HISTORIC_MISCELLANEOUS_SUBSET_2 = SymbolRange.range('҈', '҉');  // 0x488 - 0x489
    public static final SymbolRange CYRILLIC_TO_CYRILLIC_SUPPLEMENT = SymbolRange.range('Ҋ', 'ԯ');  // 0x48a - 0x52f
    public static final SymbolRange CYRILLIC_EXTENDED_CYRILLIC_SUBSET = SymbolRange.range('Ӏ', 'Ӂ');  // 0x4c0 - 0x4c1
    public static final SymbolRange CYRILLIC_EXTENDED_CYRILLIC_SUBSET_1 = SymbolRange.range('ӎ', 'ӏ');  // 0x4ce - 0x4cf
    public static final SymbolRange CYRILLIC_SUPPLEMENT_KOMI_LETTERS_TO_KHANTY_LETTERS = SymbolRange.range('Ԁ', 'ԯ');  // 0x500 - 0x52f
    public static final SymbolRange CYRILLIC_SUPPLEMENT_ARMENIAN_TO_RELIGIOUS_SYMBOLS = SymbolRange.range('԰', '֏');  // 0x530 - 0x58f
    public static final SymbolRange CYRILLIC_SUPPLEMENT_UPPERCASE_LETTERS_SUBSET = SymbolRange.range('Ա', 'Ֆ');  // 0x531 - 0x556
    public static final SymbolRange CYRILLIC_SUPPLEMENT_MODIFIER_LETTERS_SUBSET = SymbolRange.range('՚', '՟');  // 0x55a - 0x55f
    public static final SymbolRange CYRILLIC_SUPPLEMENT_LOWERCASE_LETTERS = SymbolRange.range('ՠ', 'ֈ');  // 0x560 - 0x588
    public static final SymbolRange CYRILLIC_SUPPLEMENT_PUNCTUATION_SUBSET = SymbolRange.range('։', '֊');  // 0x589 - 0x58a
    public static final SymbolRange CYRILLIC_SUPPLEMENT_RELIGIOUS_SYMBOLS = SymbolRange.range('֍', '֎');  // 0x58d - 0x58e
    public static final SymbolRange CYRILLIC_SUPPLEMENT_RELIGIOUS_SYMBOLS_TO_RELIGIOUS_SYMBOLS = SymbolRange.range('֍', '֏');  // 0x58d - 0x58f
    public static final SymbolRange CYRILLIC_SUPPLEMENT_HEBREW_TO_ADDITIONAL_PUNCTUATION = SymbolRange.range('֐', '׿');  // 0x590 - 0x5ff
    public static final SymbolRange CYRILLIC_SUPPLEMENT_CANTILLATION_MARKS_TO_POINTS_AND_PUNCTUATION = SymbolRange.range('֑', 'ֽ');  // 0x591 - 0x5bd
    public static final SymbolRange CYRILLIC_SUPPLEMENT_POINTS_AND_PUNCTUATION_SUBSET = SymbolRange.range('ׁ', 'ׂ');  // 0x5c1 - 0x5c2
    public static final SymbolRange CYRILLIC_SUPPLEMENT_PUNCTA_EXTRAORDINARIA = SymbolRange.range('ׄ', 'ׅ');  // 0x5c4 - 0x5c5
    public static final SymbolRange CYRILLIC_SUPPLEMENT_BASED_ON_ISO_8859_8_SUBSET = SymbolRange.range('א', 'ת');  // 0x5d0 - 0x5ea
    public static final SymbolRange CYRILLIC_SUPPLEMENT_SIGN_TO_YIDDISH_DIGRAPHS = SymbolRange.range('ׯ', 'ײ');  // 0x5ef - 0x5f2
    public static final SymbolRange CYRILLIC_SUPPLEMENT_ADDITIONAL_PUNCTUATION_SUBSET = SymbolRange.range('׳', '״');  // 0x5f3 - 0x5f4
    public static final SymbolRange ARABIC_SUBTENDING_MARKS_TO_SUBTENDING_MARKS = SymbolRange.range('؀', '؅');  // 0x600 - 0x605
    public static final SymbolRange ARABIC_SUBTENDING_MARKS_TO_SIGNS_FOR_SINDHI = SymbolRange.range('؀', 'ۿ');  // 0x600 - 0x6ff
    public static final SymbolRange ARABIC_RADIX_SYMBOLS_TO_RADIX_SYMBOLS = SymbolRange.range('؆', '؈');  // 0x606 - 0x608
    public static final SymbolRange ARABIC_PUNCTUATION = SymbolRange.range('؉', '؊');  // 0x609 - 0x60a
    public static final SymbolRange ARABIC_PUNCTUATION_1 = SymbolRange.range('،', '؍');  // 0x60c - 0x60d
    public static final SymbolRange ARABIC_POETIC_MARKS = SymbolRange.range('؎', '؏');  // 0x60e - 0x60f
    public static final SymbolRange ARABIC_HONORIFICS_TO_QURANIC_ANNOTATION_SIGNS = SymbolRange.range('ؐ', 'ؚ');  // 0x610 - 0x61a
    public static final SymbolRange ARABIC_PUNCTUATION_SUBSET = SymbolRange.range('؞', '؟');  // 0x61e - 0x61f
    public static final SymbolRange ARABIC_ADDITION_FOR_KASHMIRI_TO_ADDITIONS_FOR_EARLY_PERSIAN_AND_AZERBAIJANI = SymbolRange.range('ؠ', 'ؿ');  // 0x620 - 0x63f
    public static final SymbolRange ARABIC_ADDITION_FOR_KASHMIRI_TO_BASED_ON_ISO_8859_6 = SymbolRange.range('ؠ', 'ي');  // 0x620 - 0x64a
    public static final SymbolRange ARABIC_BASED_ON_ISO_8859_6_SUBSET = SymbolRange.range('ف', 'ي');  // 0x641 - 0x64a
    public static final SymbolRange ARABIC_TASHKIL_FROM_ISO_8859_6_TO_OTHER_COMBINING_MARKS = SymbolRange.range('ً', 'ٟ');  // 0x64b - 0x65f
    public static final SymbolRange ARABIC_ARABIC_INDIC_DIGITS = SymbolRange.range('٠', '٩');  // 0x660 - 0x669
    public static final SymbolRange ARABIC_PUNCTUATION_4 = SymbolRange.range('٪', '٭');  // 0x66a - 0x66d
    public static final SymbolRange ARABIC_ARCHAIC_LETTERS = SymbolRange.range('ٮ', 'ٯ');  // 0x66e - 0x66f
    public static final SymbolRange ARABIC_EXTENDED_ARABIC_LETTERS_TO_EXTENDED_ARABIC_LETTERS = SymbolRange.range('ٱ', 'ۓ');  // 0x671 - 0x6d3
    public static final SymbolRange ARABIC_QURANIC_ANNOTATION_SIGNS_SUBSET = SymbolRange.range('ۖ', 'ۜ');  // 0x6d6 - 0x6dc
    public static final SymbolRange ARABIC_QURANIC_ANNOTATION_SIGNS_SUBSET_1 = SymbolRange.range('۟', 'ۤ');  // 0x6df - 0x6e4
    public static final SymbolRange ARABIC_QURANIC_ANNOTATION_SIGNS_SUBSET_2 = SymbolRange.range('ۥ', 'ۦ');  // 0x6e5 - 0x6e6
    public static final SymbolRange ARABIC_QURANIC_ANNOTATION_SIGNS_SUBSET_3 = SymbolRange.range('ۧ', 'ۨ');  // 0x6e7 - 0x6e8
    public static final SymbolRange ARABIC_QURANIC_ANNOTATION_SIGNS_SUBSET_4 = SymbolRange.range('۪', 'ۭ');  // 0x6ea - 0x6ed
    public static final SymbolRange ARABIC_EXTENDED_ARABIC_LETTERS_FOR_PARKARI = SymbolRange.range('ۮ', 'ۯ');  // 0x6ee - 0x6ef
    public static final SymbolRange ARABIC_EASTERN_ARABIC_INDIC_DIGITS = SymbolRange.range('۰', '۹');  // 0x6f0 - 0x6f9
    public static final SymbolRange ARABIC_EXTENDED_ARABIC_LETTERS_2 = SymbolRange.range('ۺ', 'ۼ');  // 0x6fa - 0x6fc
    public static final SymbolRange ARABIC_SIGNS_FOR_SINDHI = SymbolRange.range('۽', '۾');  // 0x6fd - 0x6fe
    public static final SymbolRange SYRIAC_SYRIAC_PUNCTUATION_AND_SIGNS_SUBSET = SymbolRange.range('܀', '܍');  // 0x700 - 0x70d
    public static final SymbolRange SYRIAC_SYRIAC_PUNCTUATION_AND_SIGNS_TO_SOGDIAN_LETTERS = SymbolRange.range('܀', 'ݏ');  // 0x700 - 0x74f
    public static final SymbolRange SYRIAC_SYRIAC_LETTERS_TO_PERSIAN_LETTERS = SymbolRange.range('ܒ', 'ܯ');  // 0x712 - 0x72f
    public static final SymbolRange SYRIAC_SYRIAC_POINTS_VOWELS_TO_SYRIAC_MARKS = SymbolRange.range('ܰ', '݊');  // 0x730 - 0x74a
    public static final SymbolRange SYRIAC_TO_THAANA = SymbolRange.range('ݍ', 'ޥ');  // 0x74d - 0x7a5
    public static final SymbolRange THAANA_BASIC_CONSONANTS_TO_CONSONANT_FOR_ADDU_DIALECT = SymbolRange.range('ހ', '޿');  // 0x780 - 0x7bf
    public static final SymbolRange THAANA_VOWELS = SymbolRange.range('ަ', 'ް');  // 0x7a6 - 0x7b0
    public static final SymbolRange NKO_DIGITS = SymbolRange.range('߀', '߉');  // 0x7c0 - 0x7c9
    public static final SymbolRange NKO_LETTERS_TO_ARCHAIC_LETTERS = SymbolRange.range('ߊ', 'ߪ');  // 0x7ca - 0x7ea
    public static final SymbolRange NKO_TONE_MARKS_TO_OTHER_DIACRITICS = SymbolRange.range('߫', '߳');  // 0x7eb - 0x7f3
    public static final SymbolRange NKO_TONAL_APOSTROPHES = SymbolRange.range('ߴ', 'ߵ');  // 0x7f4 - 0x7f5
    public static final SymbolRange NKO_PUNCTUATION = SymbolRange.range('߷', '߹');  // 0x7f7 - 0x7f9
    public static final SymbolRange NKO_CURRENCY_SYMBOLS = SymbolRange.range('߾', '߿');  // 0x7fe - 0x7ff
    public static final SymbolRange SAMARITAN_LETTERS = SymbolRange.range('ࠀ', 'ࠕ');  // 0x800 - 0x815
    public static final SymbolRange SAMARITAN_CONSONANT_MODIFIERS_SUBSET = SymbolRange.range('ࠖ', '࠙');  // 0x816 - 0x819
    public static final SymbolRange SAMARITAN_CONSONANT_MODIFIERS_TO_VOWEL_SIGNS = SymbolRange.range('ࠛ', 'ࠣ');  // 0x81b - 0x823
    public static final SymbolRange SAMARITAN_VOWEL_SIGNS_SUBSET = SymbolRange.range('ࠥ', 'ࠧ');  // 0x825 - 0x827
    public static final SymbolRange SAMARITAN_VOWEL_SIGNS_TO_VOWEL_SIGNS = SymbolRange.range('ࠩ', '࠭');  // 0x829 - 0x82d
    public static final SymbolRange SAMARITAN_PUNCTUATION_SUBSET = SymbolRange.range('࠰', '࠾');  // 0x830 - 0x83e
    public static final SymbolRange MANDAIC_LETTERS = SymbolRange.range('ࡀ', 'ࡘ');  // 0x840 - 0x858
    public static final SymbolRange MANDAIC_DIACRITICS_SUBSET = SymbolRange.range('࡙', '࡛');  // 0x859 - 0x85b
    public static final SymbolRange SYRIAC_SUPPLEMENT_SYRIAC_LETTERS_SUBSET = SymbolRange.range('ࡠ', 'ࡪ');  // 0x860 - 0x86a
    public static final SymbolRange ARABIC_EXTENDED_A_ARABIC_LETTERS_FOR_AFRICAN_LANGUAGES_TO_ARABIC_LETTERS_FOR_ARWI = SymbolRange.range('ࢠ', 'ࢴ');  // 0x8a0 - 0x8b4
    public static final SymbolRange ARABIC_EXTENDED_A_ARABIC_LETTERS_FOR_BRAVANESE_TO_ARABIC_LETTERS_FOR_HAUSA_WOLOF_AND_OTHER_AFRICAN_ORTHOGRAPHIES = SymbolRange.range('ࢶ', 'ࣇ');  // 0x8b6 - 0x8c7
    public static final SymbolRange ARABIC_EXTENDED_A_QURANIC_ANNOTATION_SIGNS_SUBSET = SymbolRange.range('࣓', '࣡');  // 0x8d3 - 0x8e1
    public static final SymbolRange ARABIC_EXTENDED_A_TO_DEVANAGARI = SymbolRange.range('ࣣ', 'ं');  // 0x8e3 - 0x902
    public static final SymbolRange ARABIC_EXTENDED_A_TO_DEVANAGARI_1 = SymbolRange.range('ࣣ', 'ः');  // 0x8e3 - 0x903
    public static final SymbolRange DEVANAGARI_VARIOUS_SIGNS_TO_SINDHI_IMPLOSIVES = SymbolRange.range('ऀ', 'ॿ');  // 0x900 - 0x97f
    public static final SymbolRange DEVANAGARI_INDEPENDENT_VOWELS_TO_CONSONANTS = SymbolRange.range('ऄ', 'ह');  // 0x904 - 0x939
    public static final SymbolRange DEVANAGARI_DEPENDENT_VOWEL_SIGNS_TO_DEPENDENT_VOWEL_SIGNS = SymbolRange.range('ऺ', '़');  // 0x93a - 0x93c
    public static final SymbolRange DEVANAGARI_DEPENDENT_VOWEL_SIGNS_SUBSET_2 = SymbolRange.range('ा', 'ी');  // 0x93e - 0x940
    public static final SymbolRange DEVANAGARI_DEPENDENT_VOWEL_SIGNS_TO_DEPENDENT_VOWEL_SIGNS_1 = SymbolRange.range('ा', 'ॏ');  // 0x93e - 0x94f
    public static final SymbolRange DEVANAGARI_DEPENDENT_VOWEL_SIGNS_SUBSET = SymbolRange.range('ु', 'ै');  // 0x941 - 0x948
    public static final SymbolRange DEVANAGARI_DEPENDENT_VOWEL_SIGNS_SUBSET_1 = SymbolRange.range('ॉ', 'ौ');  // 0x949 - 0x94c
    public static final SymbolRange DEVANAGARI_DEPENDENT_VOWEL_SIGNS_2 = SymbolRange.range('ॎ', 'ॏ');  // 0x94e - 0x94f
    public static final SymbolRange DEVANAGARI_VEDIC_TONE_MARKS_TO_DEPENDENT_VOWEL_SIGNS_FOR_KASHMIRI = SymbolRange.range('॑', 'ॗ');  // 0x951 - 0x957
    public static final SymbolRange DEVANAGARI_ADDITIONAL_CONSONANTS_TO_ADDITIONAL_VOWELS_FOR_SANSKRIT = SymbolRange.range('क़', 'ॡ');  // 0x958 - 0x961
    public static final SymbolRange DEVANAGARI_ADDITIONAL_VOWELS_FOR_SANSKRIT_SUBSET = SymbolRange.range('ॢ', 'ॣ');  // 0x962 - 0x963
    public static final SymbolRange DEVANAGARI_GENERIC_PUNCTUATION_FOR_SCRIPTS_OF_INDIA = SymbolRange.range('।', '॥');  // 0x964 - 0x965
    public static final SymbolRange DEVANAGARI_DIGITS = SymbolRange.range('०', '९');  // 0x966 - 0x96f
    public static final SymbolRange DEVANAGARI_ADDITIONAL_SIGNS_TO_SINDHI_IMPLOSIVES = SymbolRange.range('ॱ', 'ঀ');  // 0x971 - 0x980
    public static final SymbolRange DEVANAGARI_INDEPENDENT_VOWEL_FOR_MARATHI_TO_SINDHI_IMPLOSIVES = SymbolRange.range('ॲ', 'ঀ');  // 0x972 - 0x980
    public static final SymbolRange BENGALI_VARIOUS_SIGNS_TO_SIGNS = SymbolRange.range('ঀ', '৿');  // 0x980 - 0x9ff
    public static final SymbolRange BENGALI_VARIOUS_SIGNS_SUBSET_2 = SymbolRange.range('ঁ', 'ঃ');  // 0x981 - 0x983
    public static final SymbolRange BENGALI_VARIOUS_SIGNS_SUBSET_6 = SymbolRange.range('ং', 'ঃ');  // 0x982 - 0x983
    public static final SymbolRange BENGALI_INDEPENDENT_VOWELS_SUBSET_2 = SymbolRange.range('অ', 'ঌ');  // 0x985 - 0x98c
    public static final SymbolRange BENGALI_INDEPENDENT_VOWELS_SUBSET_6 = SymbolRange.range('এ', 'ঐ');  // 0x98f - 0x990
    public static final SymbolRange BENGALI_INDEPENDENT_VOWELS_TO_CONSONANTS = SymbolRange.range('ও', 'ন');  // 0x993 - 0x9a8
    public static final SymbolRange BENGALI_CONSONANTS_SUBSET_4 = SymbolRange.range('প', 'র');  // 0x9aa - 0x9b0
    public static final SymbolRange BENGALI_CONSONANTS_SUBSET_15 = SymbolRange.range('শ', 'হ');  // 0x9b6 - 0x9b9
    public static final SymbolRange BENGALI_DEPENDENT_VOWEL_SIGNS_SUBSET_13 = SymbolRange.range('া', 'ী');  // 0x9be - 0x9c0
    public static final SymbolRange BENGALI_DEPENDENT_VOWEL_SIGNS_SUBSET_19 = SymbolRange.range('া', 'ৄ');  // 0x9be - 0x9c4
    public static final SymbolRange BENGALI_DEPENDENT_VOWEL_SIGNS_SUBSET_2 = SymbolRange.range('ু', 'ৄ');  // 0x9c1 - 0x9c4
    public static final SymbolRange BENGALI_DEPENDENT_VOWEL_SIGNS_SUBSET_6 = SymbolRange.range('ে', 'ৈ');  // 0x9c7 - 0x9c8
    public static final SymbolRange BENGALI_TWO_PART_DEPENDENT_VOWEL_SIGNS = SymbolRange.range('ো', 'ৌ');  // 0x9cb - 0x9cc
    public static final SymbolRange BENGALI_TWO_PART_DEPENDENT_VOWEL_SIGNS_TO_TWO_PART_DEPENDENT_VOWEL_SIGNS_1 = SymbolRange.range('ো', '্');  // 0x9cb - 0x9cd
    public static final SymbolRange BENGALI_ADDITIONAL_CONSONANTS_SUBSET_1 = SymbolRange.range('ড়', 'ঢ়');  // 0x9dc - 0x9dd
    public static final SymbolRange BENGALI_ADDITIONAL_CONSONANTS_TO_ADDITIONAL_VOWELS_FOR_SANSKRIT = SymbolRange.range('য়', 'ৡ');  // 0x9df - 0x9e1
    public static final SymbolRange BENGALI_ADDITIONAL_VOWELS_FOR_SANSKRIT_SUBSET_1 = SymbolRange.range('ৢ', 'ৣ');  // 0x9e2 - 0x9e3
    public static final SymbolRange BENGALI_DIGITS = SymbolRange.range('০', '৯');  // 0x9e6 - 0x9ef
    public static final SymbolRange BENGALI_ADDITIONS_FOR_ASSAMESE = SymbolRange.range('ৰ', 'ৱ');  // 0x9f0 - 0x9f1
    public static final SymbolRange BENGALI_CURRENCY_SYMBOLS = SymbolRange.range('৲', '৳');  // 0x9f2 - 0x9f3
    public static final SymbolRange BENGALI_HISTORIC_SYMBOLS_FOR_FRACTIONAL_VALUES = SymbolRange.range('৴', '৹');  // 0x9f4 - 0x9f9
    public static final SymbolRange BENGALI_SIGN_TO_SIGN = SymbolRange.range('৺', '৻');  // 0x9fa - 0x9fb
    public static final SymbolRange BENGALI_GURMUKHI_TO_SIGNS = SymbolRange.range('਀', '੿');  // 0xa00 - 0xa7f
    public static final SymbolRange BENGALI_VARIOUS_SIGNS_SUBSET = SymbolRange.range('ਁ', 'ਂ');  // 0xa01 - 0xa02
    public static final SymbolRange BENGALI_VARIOUS_SIGNS_SUBSET_3 = SymbolRange.range('ਁ', 'ਃ');  // 0xa01 - 0xa03
    public static final SymbolRange BENGALI_INDEPENDENT_VOWELS_SUBSET = SymbolRange.range('ਅ', 'ਊ');  // 0xa05 - 0xa0a
    public static final SymbolRange BENGALI_INDEPENDENT_VOWELS_SUBSET_7 = SymbolRange.range('ਏ', 'ਐ');  // 0xa0f - 0xa10
    public static final SymbolRange BENGALI_INDEPENDENT_VOWELS_TO_CONSONANTS_1 = SymbolRange.range('ਓ', 'ਨ');  // 0xa13 - 0xa28
    public static final SymbolRange BENGALI_CONSONANTS_SUBSET_5 = SymbolRange.range('ਪ', 'ਰ');  // 0xa2a - 0xa30
    public static final SymbolRange BENGALI_CONSONANTS_SUBSET_10 = SymbolRange.range('ਲ', 'ਲ਼');  // 0xa32 - 0xa33
    public static final SymbolRange BENGALI_CONSONANTS_SUBSET_12 = SymbolRange.range('ਵ', 'ਸ਼');  // 0xa35 - 0xa36
    public static final SymbolRange BENGALI_CONSONANTS_SUBSET_16 = SymbolRange.range('ਸ', 'ਹ');  // 0xa38 - 0xa39
    public static final SymbolRange BENGALI_DEPENDENT_VOWEL_SIGNS_SUBSET_14 = SymbolRange.range('ਾ', 'ੀ');  // 0xa3e - 0xa40
    public static final SymbolRange BENGALI_DEPENDENT_VOWEL_SIGNS_SUBSET_16 = SymbolRange.range('ਾ', 'ੂ');  // 0xa3e - 0xa42
    public static final SymbolRange BENGALI_DEPENDENT_VOWEL_SIGNS_SUBSET = SymbolRange.range('ੁ', 'ੂ');  // 0xa41 - 0xa42
    public static final SymbolRange BENGALI_DEPENDENT_VOWEL_SIGNS_SUBSET_7 = SymbolRange.range('ੇ', 'ੈ');  // 0xa47 - 0xa48
    public static final SymbolRange BENGALI_DEPENDENT_VOWEL_SIGNS_TO_DEPENDENT_VOWEL_SIGNS = SymbolRange.range('ੋ', '੍');  // 0xa4b - 0xa4d
    public static final SymbolRange BENGALI_ADDITIONAL_CONSONANTS_SUBSET = SymbolRange.range('ਖ਼', 'ੜ');  // 0xa59 - 0xa5c
    public static final SymbolRange BENGALI_DIGITS_1 = SymbolRange.range('੦', '੯');  // 0xa66 - 0xa6f
    public static final SymbolRange BENGALI_SIGNS_1 = SymbolRange.range('ੰ', 'ੱ');  // 0xa70 - 0xa71
    public static final SymbolRange BENGALI_VOWEL_BASES_TO_VOWEL_BASES = SymbolRange.range('ੲ', 'ੴ');  // 0xa72 - 0xa74
    public static final SymbolRange BENGALI_GUJARATI_TO_TRANSLITERATION_SIGNS = SymbolRange.range('઀', '૿');  // 0xa80 - 0xaff
    public static final SymbolRange BENGALI_VARIOUS_SIGNS_SUBSET_1 = SymbolRange.range('ઁ', 'ં');  // 0xa81 - 0xa82
    public static final SymbolRange BENGALI_VARIOUS_SIGNS_SUBSET_4 = SymbolRange.range('ઁ', 'ઃ');  // 0xa81 - 0xa83
    public static final SymbolRange BENGALI_INDEPENDENT_VOWELS_SUBSET_4 = SymbolRange.range('અ', 'ઍ');  // 0xa85 - 0xa8d
    public static final SymbolRange BENGALI_INDEPENDENT_VOWELS_SUBSET_9 = SymbolRange.range('એ', 'ઑ');  // 0xa8f - 0xa91
    public static final SymbolRange BENGALI_INDEPENDENT_VOWELS_TO_CONSONANTS_2 = SymbolRange.range('ઓ', 'ન');  // 0xa93 - 0xaa8
    public static final SymbolRange BENGALI_CONSONANTS_SUBSET_6 = SymbolRange.range('પ', 'ર');  // 0xaaa - 0xab0
    public static final SymbolRange BENGALI_CONSONANTS_SUBSET_9 = SymbolRange.range('લ', 'ળ');  // 0xab2 - 0xab3
    public static final SymbolRange BENGALI_CONSONANTS_SUBSET_13 = SymbolRange.range('વ', 'હ');  // 0xab5 - 0xab9
    public static final SymbolRange BENGALI_DEPENDENT_VOWEL_SIGNS_SUBSET_15 = SymbolRange.range('ા', 'ી');  // 0xabe - 0xac0
    public static final SymbolRange BENGALI_DEPENDENT_VOWEL_SIGNS_SUBSET_18 = SymbolRange.range('ા', 'ૅ');  // 0xabe - 0xac5
    public static final SymbolRange BENGALI_DEPENDENT_VOWEL_SIGNS_SUBSET_4 = SymbolRange.range('ુ', 'ૅ');  // 0xac1 - 0xac5
    public static final SymbolRange BENGALI_DEPENDENT_VOWEL_SIGNS_SUBSET_9 = SymbolRange.range('ે', 'ૈ');  // 0xac7 - 0xac8
    public static final SymbolRange BENGALI_DEPENDENT_VOWEL_SIGNS_SUBSET_10 = SymbolRange.range('ે', 'ૉ');  // 0xac7 - 0xac9
    public static final SymbolRange BENGALI_DEPENDENT_VOWEL_SIGNS_SUBSET_11 = SymbolRange.range('ો', 'ૌ');  // 0xacb - 0xacc
    public static final SymbolRange BENGALI_DEPENDENT_VOWEL_SIGNS_TO_DEPENDENT_VOWEL_SIGNS_1 = SymbolRange.range('ો', '્');  // 0xacb - 0xacd
    public static final SymbolRange BENGALI_ADDITIONAL_VOWELS_FOR_SANSKRIT_SUBSET = SymbolRange.range('ૠ', 'ૡ');  // 0xae0 - 0xae1
    public static final SymbolRange BENGALI_ADDITIONAL_VOWELS_FOR_SANSKRIT_SUBSET_2 = SymbolRange.range('ૢ', 'ૣ');  // 0xae2 - 0xae3
    public static final SymbolRange BENGALI_DIGITS_2 = SymbolRange.range('૦', '૯');  // 0xae6 - 0xaef
    public static final SymbolRange BENGALI_TRANSLITERATION_SIGNS = SymbolRange.range('ૺ', '૿');  // 0xafa - 0xaff
    public static final SymbolRange BENGALI_ORIYA_TO_FRACTION_SIGNS = SymbolRange.range('଀', '୿');  // 0xb00 - 0xb7f
    public static final SymbolRange BENGALI_VARIOUS_SIGNS_SUBSET_5 = SymbolRange.range('ଁ', 'ଃ');  // 0xb01 - 0xb03
    public static final SymbolRange BENGALI_VARIOUS_SIGNS_SUBSET_7 = SymbolRange.range('ଂ', 'ଃ');  // 0xb02 - 0xb03
    public static final SymbolRange BENGALI_INDEPENDENT_VOWELS_SUBSET_3 = SymbolRange.range('ଅ', 'ଌ');  // 0xb05 - 0xb0c
    public static final SymbolRange BENGALI_INDEPENDENT_VOWELS_SUBSET_8 = SymbolRange.range('ଏ', 'ଐ');  // 0xb0f - 0xb10
    public static final SymbolRange BENGALI_INDEPENDENT_VOWELS_TO_CONSONANTS_3 = SymbolRange.range('ଓ', 'ନ');  // 0xb13 - 0xb28
    public static final SymbolRange BENGALI_CONSONANTS_SUBSET_7 = SymbolRange.range('ପ', 'ର');  // 0xb2a - 0xb30
    public static final SymbolRange BENGALI_CONSONANTS_SUBSET_11 = SymbolRange.range('ଲ', 'ଳ');  // 0xb32 - 0xb33
    public static final SymbolRange BENGALI_CONSONANTS_SUBSET_14 = SymbolRange.range('ଵ', 'ହ');  // 0xb35 - 0xb39
    public static final SymbolRange BENGALI_DEPENDENT_VOWEL_SIGNS_SUBSET_20 = SymbolRange.range('ା', 'ୄ');  // 0xb3e - 0xb44
    public static final SymbolRange BENGALI_DEPENDENT_VOWEL_SIGNS_SUBSET_3 = SymbolRange.range('ୁ', 'ୄ');  // 0xb41 - 0xb44
    public static final SymbolRange BENGALI_DEPENDENT_VOWEL_SIGNS_SUBSET_8 = SymbolRange.range('େ', 'ୈ');  // 0xb47 - 0xb48
    public static final SymbolRange BENGALI_TWO_PART_DEPENDENT_VOWEL_SIGNS_1 = SymbolRange.range('ୋ', 'ୌ');  // 0xb4b - 0xb4c
    public static final SymbolRange BENGALI_TWO_PART_DEPENDENT_VOWEL_SIGNS_TO_TWO_PART_DEPENDENT_VOWEL_SIGNS_2 = SymbolRange.range('ୋ', '୍');  // 0xb4b - 0xb4d
    public static final SymbolRange BENGALI_VARIOUS_SIGNS_SUBSET_8 = SymbolRange.range('୕', 'ୖ');  // 0xb55 - 0xb56
    public static final SymbolRange BENGALI_VARIOUS_SIGNS_SUBSET_9 = SymbolRange.range('୕', 'ୗ');  // 0xb55 - 0xb57
    public static final SymbolRange BENGALI_ADDITIONAL_CONSONANTS_SUBSET_2 = SymbolRange.range('ଡ଼', 'ଢ଼');  // 0xb5c - 0xb5d
    public static final SymbolRange BENGALI_ADDITIONAL_CONSONANTS_TO_ADDITIONAL_VOWELS_FOR_SANSKRIT_1 = SymbolRange.range('ୟ', 'ୡ');  // 0xb5f - 0xb61
    public static final SymbolRange BENGALI_DEPENDENT_VOWELS = SymbolRange.range('ୢ', 'ୣ');  // 0xb62 - 0xb63
    public static final SymbolRange BENGALI_DIGITS_3 = SymbolRange.range('୦', '୯');  // 0xb66 - 0xb6f
    public static final SymbolRange BENGALI_FRACTION_SIGNS_SUBSET = SymbolRange.range('୲', '୷');  // 0xb72 - 0xb77
    public static final SymbolRange BENGALI_TAMIL_TO_TAMIL_CLERICAL_SYMBOL = SymbolRange.range('஀', '௿');  // 0xb80 - 0xbff
    public static final SymbolRange BENGALI_INDEPENDENT_VOWELS_SUBSET_1 = SymbolRange.range('அ', 'ஊ');  // 0xb85 - 0xb8a
    public static final SymbolRange BENGALI_INDEPENDENT_VOWELS_SUBSET_5 = SymbolRange.range('எ', 'ஐ');  // 0xb8e - 0xb90
    public static final SymbolRange BENGALI_INDEPENDENT_VOWELS_TO_INDEPENDENT_VOWELS = SymbolRange.range('ஒ', 'க');  // 0xb92 - 0xb95
    public static final SymbolRange BENGALI_CONSONANTS_SUBSET = SymbolRange.range('ங', 'ச');  // 0xb99 - 0xb9a
    public static final SymbolRange BENGALI_CONSONANTS_SUBSET_1 = SymbolRange.range('ஞ', 'ட');  // 0xb9e - 0xb9f
    public static final SymbolRange BENGALI_CONSONANTS_SUBSET_2 = SymbolRange.range('ண', 'த');  // 0xba3 - 0xba4
    public static final SymbolRange BENGALI_CONSONANTS_SUBSET_3 = SymbolRange.range('ந', 'ப');  // 0xba8 - 0xbaa
    public static final SymbolRange BENGALI_CONSONANTS_SUBSET_8 = SymbolRange.range('ம', 'ஹ');  // 0xbae - 0xbb9
    public static final SymbolRange BENGALI_DEPENDENT_VOWEL_SIGNS_SUBSET_12 = SymbolRange.range('ா', 'ி');  // 0xbbe - 0xbbf
    public static final SymbolRange BENGALI_DEPENDENT_VOWEL_SIGNS_SUBSET_17 = SymbolRange.range('ா', 'ூ');  // 0xbbe - 0xbc2
    public static final SymbolRange BENGALI_DEPENDENT_VOWEL_SIGNS_SUBSET_1 = SymbolRange.range('ு', 'ூ');  // 0xbc1 - 0xbc2
    public static final SymbolRange BENGALI_DEPENDENT_VOWEL_SIGNS_SUBSET_5 = SymbolRange.range('ெ', 'ை');  // 0xbc6 - 0xbc8
    public static final SymbolRange BENGALI_TWO_PART_DEPENDENT_VOWEL_SIGNS_TO_TWO_PART_DEPENDENT_VOWEL_SIGNS = SymbolRange.range('ொ', '்');  // 0xbca - 0xbcd
    public static final SymbolRange BENGALI_TWO_PART_DEPENDENT_VOWEL_SIGNS_2 = SymbolRange.range('ொ', 'ௌ');  // 0xbca - 0xbcc
    public static final SymbolRange BENGALI_DIGITS_4 = SymbolRange.range('௦', '௯');  // 0xbe6 - 0xbef
    public static final SymbolRange BENGALI_DIGITS_TO_TAMIL_NUMERICS = SymbolRange.range('௦', '௲');  // 0xbe6 - 0xbf2
    public static final SymbolRange BENGALI_TAMIL_NUMERICS = SymbolRange.range('௰', '௲');  // 0xbf0 - 0xbf2
    public static final SymbolRange BENGALI_TAMIL_CALENDRICAL_SYMBOLS_TO_TAMIL_CLERICAL_SYMBOLS = SymbolRange.range('௳', '௸');  // 0xbf3 - 0xbf8
    public static final SymbolRange BENGALI_TAMIL_CALENDRICAL_SYMBOLS_TO_CURRENCY_SYMBOL = SymbolRange.range('௳', '௺');  // 0xbf3 - 0xbfa
    public static final SymbolRange TELUGU_VARIOUS_SIGNS = SymbolRange.range('ఀ', 'ఄ');  // 0xc00 - 0xc04
    public static final SymbolRange TELUGU_VARIOUS_SIGNS_TO_TELUGU_FRACTIONS_AND_WEIGHTS = SymbolRange.range('ఀ', '౿');  // 0xc00 - 0xc7f
    public static final SymbolRange TELUGU_VARIOUS_SIGNS_SUBSET = SymbolRange.range('ఁ', 'ః');  // 0xc01 - 0xc03
    public static final SymbolRange TELUGU_INDEPENDENT_VOWELS_SUBSET = SymbolRange.range('అ', 'ఌ');  // 0xc05 - 0xc0c
    public static final SymbolRange TELUGU_INDEPENDENT_VOWELS_SUBSET_1 = SymbolRange.range('ఎ', 'ఐ');  // 0xc0e - 0xc10
    public static final SymbolRange TELUGU_INDEPENDENT_VOWELS_TO_CONSONANTS = SymbolRange.range('ఒ', 'న');  // 0xc12 - 0xc28
    public static final SymbolRange TELUGU_CONSONANTS_SUBSET = SymbolRange.range('ప', 'హ');  // 0xc2a - 0xc39
    public static final SymbolRange TELUGU_DEPENDENT_VOWEL_SIGNS_SUBSET_2 = SymbolRange.range('ా', 'ీ');  // 0xc3e - 0xc40
    public static final SymbolRange TELUGU_DEPENDENT_VOWEL_SIGNS_SUBSET_3 = SymbolRange.range('ా', 'ౄ');  // 0xc3e - 0xc44
    public static final SymbolRange TELUGU_DEPENDENT_VOWEL_SIGNS_SUBSET = SymbolRange.range('ు', 'ౄ');  // 0xc41 - 0xc44
    public static final SymbolRange TELUGU_DEPENDENT_VOWEL_SIGNS_SUBSET_1 = SymbolRange.range('ె', 'ై');  // 0xc46 - 0xc48
    public static final SymbolRange TELUGU_DEPENDENT_VOWEL_SIGNS_TO_DEPENDENT_VOWEL_SIGNS = SymbolRange.range('ొ', '్');  // 0xc4a - 0xc4d
    public static final SymbolRange TELUGU_VARIOUS_SIGNS_SUBSET_1 = SymbolRange.range('ౕ', 'ౖ');  // 0xc55 - 0xc56
    public static final SymbolRange TELUGU_HISTORIC_PHONETIC_VARIANTS_SUBSET = SymbolRange.range('ౘ', 'ౚ');  // 0xc58 - 0xc5a
    public static final SymbolRange TELUGU_ADDITIONAL_VOWELS_FOR_SANSKRIT = SymbolRange.range('ౠ', 'ౡ');  // 0xc60 - 0xc61
    public static final SymbolRange TELUGU_DEPENDENT_VOWELS = SymbolRange.range('ౢ', 'ౣ');  // 0xc62 - 0xc63
    public static final SymbolRange TELUGU_DIGITS_SUBSET = SymbolRange.range('౦', '౯');  // 0xc66 - 0xc6f
    public static final SymbolRange TELUGU_TELUGU_FRACTIONS_AND_WEIGHTS_SUBSET = SymbolRange.range('౸', '౾');  // 0xc78 - 0xc7e
    public static final SymbolRange KANNADA_VARIOUS_SIGNS_TO_SIGNS_USED_IN_SANSKRIT = SymbolRange.range('ಀ', '೿');  // 0xc80 - 0xcff
    public static final SymbolRange KANNADA_VARIOUS_SIGNS_SUBSET = SymbolRange.range('ಁ', 'ಃ');  // 0xc81 - 0xc83
    public static final SymbolRange KANNADA_VARIOUS_SIGNS_SUBSET_1 = SymbolRange.range('ಂ', 'ಃ');  // 0xc82 - 0xc83
    public static final SymbolRange KANNADA_INDEPENDENT_VOWELS_SUBSET = SymbolRange.range('ಅ', 'ಌ');  // 0xc85 - 0xc8c
    public static final SymbolRange KANNADA_INDEPENDENT_VOWELS_SUBSET_1 = SymbolRange.range('ಎ', 'ಐ');  // 0xc8e - 0xc90
    public static final SymbolRange KANNADA_INDEPENDENT_VOWELS_TO_CONSONANTS = SymbolRange.range('ಒ', 'ನ');  // 0xc92 - 0xca8
    public static final SymbolRange KANNADA_CONSONANTS_SUBSET = SymbolRange.range('ಪ', 'ಳ');  // 0xcaa - 0xcb3
    public static final SymbolRange KANNADA_CONSONANTS_SUBSET_1 = SymbolRange.range('ವ', 'ಹ');  // 0xcb5 - 0xcb9
    public static final SymbolRange KANNADA_DEPENDENT_VOWEL_SIGNS_SUBSET_4 = SymbolRange.range('ಾ', 'ೄ');  // 0xcbe - 0xcc4
    public static final SymbolRange KANNADA_DEPENDENT_VOWEL_SIGNS_SUBSET = SymbolRange.range('ೀ', 'ೄ');  // 0xcc0 - 0xcc4
    public static final SymbolRange KANNADA_DEPENDENT_VOWEL_SIGNS_SUBSET_1 = SymbolRange.range('ೆ', 'ೈ');  // 0xcc6 - 0xcc8
    public static final SymbolRange KANNADA_DEPENDENT_VOWEL_SIGNS_SUBSET_2 = SymbolRange.range('ೇ', 'ೈ');  // 0xcc7 - 0xcc8
    public static final SymbolRange KANNADA_DEPENDENT_VOWEL_SIGNS_SUBSET_3 = SymbolRange.range('ೊ', 'ೋ');  // 0xcca - 0xccb
    public static final SymbolRange KANNADA_DEPENDENT_VOWEL_SIGNS_TO_DEPENDENT_VOWEL_SIGNS = SymbolRange.range('ೊ', '್');  // 0xcca - 0xccd
    public static final SymbolRange KANNADA_DEPENDENT_VOWEL_SIGNS_TO_DEPENDENT_VOWEL_SIGNS_1 = SymbolRange.range('ೌ', '್');  // 0xccc - 0xccd
    public static final SymbolRange KANNADA_VARIOUS_SIGNS_SUBSET_2 = SymbolRange.range('ೕ', 'ೖ');  // 0xcd5 - 0xcd6
    public static final SymbolRange KANNADA_ADDITIONAL_VOWELS_FOR_SANSKRIT = SymbolRange.range('ೠ', 'ೡ');  // 0xce0 - 0xce1
    public static final SymbolRange KANNADA_DEPENDENT_VOWELS = SymbolRange.range('ೢ', 'ೣ');  // 0xce2 - 0xce3
    public static final SymbolRange KANNADA_DIGITS_SUBSET = SymbolRange.range('೦', '೯');  // 0xce6 - 0xcef
    public static final SymbolRange KANNADA_SIGNS_USED_IN_SANSKRIT_SUBSET = SymbolRange.range('ೱ', 'ೲ');  // 0xcf1 - 0xcf2
    public static final SymbolRange MALAYALAM_VARIOUS_SIGNS_SUBSET = SymbolRange.range('ഀ', 'ഁ');  // 0xd00 - 0xd01
    public static final SymbolRange MALAYALAM_VARIOUS_SIGNS_SUBSET_1 = SymbolRange.range('ഀ', 'ഃ');  // 0xd00 - 0xd03
    public static final SymbolRange MALAYALAM_VARIOUS_SIGNS_TO_CHILLU_LETTERS = SymbolRange.range('ഀ', 'ൿ');  // 0xd00 - 0xd7f
    public static final SymbolRange MALAYALAM_VARIOUS_SIGNS_SUBSET_4 = SymbolRange.range('ം', 'ഃ');  // 0xd02 - 0xd03
    public static final SymbolRange MALAYALAM_VARIOUS_SIGNS_TO_INDEPENDENT_VOWELS = SymbolRange.range('ഄ', 'ഌ');  // 0xd04 - 0xd0c
    public static final SymbolRange MALAYALAM_INDEPENDENT_VOWELS_SUBSET_1 = SymbolRange.range('എ', 'ഐ');  // 0xd0e - 0xd10
    public static final SymbolRange MALAYALAM_INDEPENDENT_VOWELS_TO_CONSONANTS = SymbolRange.range('ഒ', 'ഺ');  // 0xd12 - 0xd3a
    public static final SymbolRange MALAYALAM_VARIANT_SHAPE_VIRAMAS = SymbolRange.range('഻', '഼');  // 0xd3b - 0xd3c
    public static final SymbolRange MALAYALAM_DEPENDENT_VOWEL_SIGNS_SUBSET_5 = SymbolRange.range('ാ', 'ീ');  // 0xd3e - 0xd40
    public static final SymbolRange MALAYALAM_DEPENDENT_VOWEL_SIGNS_SUBSET_6 = SymbolRange.range('ാ', 'ൄ');  // 0xd3e - 0xd44
    public static final SymbolRange MALAYALAM_DEPENDENT_VOWEL_SIGNS_SUBSET = SymbolRange.range('ു', 'ൄ');  // 0xd41 - 0xd44
    public static final SymbolRange MALAYALAM_DEPENDENT_VOWEL_SIGNS_SUBSET_1 = SymbolRange.range('െ', 'ൈ');  // 0xd46 - 0xd48
    public static final SymbolRange MALAYALAM_TWO_PART_DEPENDENT_VOWEL_SIGNS_TO_TWO_PART_DEPENDENT_VOWEL_SIGNS = SymbolRange.range('ൊ', '്');  // 0xd4a - 0xd4d
    public static final SymbolRange MALAYALAM_TWO_PART_DEPENDENT_VOWEL_SIGNS = SymbolRange.range('ൊ', 'ൌ');  // 0xd4a - 0xd4c
    public static final SymbolRange MALAYALAM_ADDITIONAL_HISTORIC_CHILLU_LETTERS = SymbolRange.range('ൔ', 'ൖ');  // 0xd54 - 0xd56
    public static final SymbolRange MALAYALAM_MINOR_FRACTIONS = SymbolRange.range('൘', '൞');  // 0xd58 - 0xd5e
    public static final SymbolRange MALAYALAM_ADDITIONAL_HISTORIC_VOWEL_TO_ADDITIONAL_VOWELS_FOR_SANSKRIT = SymbolRange.range('ൟ', 'ൡ');  // 0xd5f - 0xd61
    public static final SymbolRange MALAYALAM_DEPENDENT_VOWELS = SymbolRange.range('ൢ', 'ൣ');  // 0xd62 - 0xd63
    public static final SymbolRange MALAYALAM_DIGITS = SymbolRange.range('൦', '൯');  // 0xd66 - 0xd6f
    public static final SymbolRange MALAYALAM_DIGITS_TO_FRACTIONS = SymbolRange.range('൦', '൸');  // 0xd66 - 0xd78
    public static final SymbolRange MALAYALAM_MALAYALAM_NUMERICS_TO_FRACTIONS = SymbolRange.range('൰', '൸');  // 0xd70 - 0xd78
    public static final SymbolRange MALAYALAM_CHILLU_LETTERS = SymbolRange.range('ൺ', 'ൿ');  // 0xd7a - 0xd7f
    public static final SymbolRange MALAYALAM_SINHALA_TO_PUNCTUATION = SymbolRange.range('඀', '෿');  // 0xd80 - 0xdff
    public static final SymbolRange MALAYALAM_VARIOUS_SIGNS_SUBSET_2 = SymbolRange.range('ඁ', 'ඃ');  // 0xd81 - 0xd83
    public static final SymbolRange MALAYALAM_VARIOUS_SIGNS_SUBSET_3 = SymbolRange.range('ං', 'ඃ');  // 0xd82 - 0xd83
    public static final SymbolRange MALAYALAM_INDEPENDENT_VOWELS_SUBSET = SymbolRange.range('අ', 'ඖ');  // 0xd85 - 0xd96
    public static final SymbolRange MALAYALAM_CONSONANTS_SUBSET_4 = SymbolRange.range('ක', 'න');  // 0xd9a - 0xdb1
    public static final SymbolRange MALAYALAM_CONSONANTS_SUBSET_5 = SymbolRange.range('ඳ', 'ර');  // 0xdb3 - 0xdbb
    public static final SymbolRange MALAYALAM_CONSONANTS_SUBSET = SymbolRange.range('ව', 'ෆ');  // 0xdc0 - 0xdc6
    public static final SymbolRange MALAYALAM_DEPENDENT_VOWEL_SIGNS_SUBSET_2 = SymbolRange.range('ා', 'ෑ');  // 0xdcf - 0xdd1
    public static final SymbolRange MALAYALAM_DEPENDENT_VOWEL_SIGNS_SUBSET_3 = SymbolRange.range('ා', 'ු');  // 0xdcf - 0xdd4
    public static final SymbolRange MALAYALAM_DEPENDENT_VOWEL_SIGNS_SUBSET_4 = SymbolRange.range('ි', 'ු');  // 0xdd2 - 0xdd4
    public static final SymbolRange MALAYALAM_DEPENDENT_VOWEL_SIGNS_TO_TWO_PART_DEPENDENT_VOWEL_SIGNS = SymbolRange.range('ෘ', 'ෟ');  // 0xdd8 - 0xddf
    public static final SymbolRange MALAYALAM_ASTROLOGICAL_DIGITS_SUBSET = SymbolRange.range('෦', '෯');  // 0xde6 - 0xdef
    public static final SymbolRange MALAYALAM_ADDITIONAL_DEPENDENT_VOWEL_SIGNS = SymbolRange.range('ෲ', 'ෳ');  // 0xdf2 - 0xdf3
    public static final SymbolRange MALAYALAM_THAI_TO_SIGNS = SymbolRange.range('฀', '๿');  // 0xe00 - 0xe7f
    public static final SymbolRange MALAYALAM_CONSONANTS_TO_SIGN = SymbolRange.range('ก', 'ะ');  // 0xe01 - 0xe30
    public static final SymbolRange MALAYALAM_VOWELS_SUBSET_1 = SymbolRange.range('า', 'ำ');  // 0xe32 - 0xe33
    public static final SymbolRange MALAYALAM_VOWELS_SUBSET_3 = SymbolRange.range('ิ', 'ฺ');  // 0xe34 - 0xe3a
    public static final SymbolRange MALAYALAM_VOWELS_TO_VOWELS = SymbolRange.range('เ', 'ๅ');  // 0xe40 - 0xe45
    public static final SymbolRange MALAYALAM_VOWELS_TO_VOWEL_LENGTH_SIGN = SymbolRange.range('เ', 'ๆ');  // 0xe40 - 0xe46
    public static final SymbolRange MALAYALAM_VOWEL_TO_SIGNS = SymbolRange.range('็', '๎');  // 0xe47 - 0xe4e
    public static final SymbolRange MALAYALAM_DIGITS_1 = SymbolRange.range('๐', '๙');  // 0xe50 - 0xe59
    public static final SymbolRange MALAYALAM_SIGNS_SUBSET = SymbolRange.range('๚', '๛');  // 0xe5a - 0xe5b
    public static final SymbolRange MALAYALAM_LAO_TO_CONSONANTS_FOR_KHMU = SymbolRange.range('຀', '໿');  // 0xe80 - 0xeff
    public static final SymbolRange MALAYALAM_CONSONANTS_SUBSET_1 = SymbolRange.range('ກ', 'ຂ');  // 0xe81 - 0xe82
    public static final SymbolRange MALAYALAM_CONSONANTS_SUBSET_2 = SymbolRange.range('ຆ', 'ຊ');  // 0xe86 - 0xe8a
    public static final SymbolRange MALAYALAM_CONSONANTS_SUBSET_3 = SymbolRange.range('ຌ', 'ຣ');  // 0xe8c - 0xea3
    public static final SymbolRange MALAYALAM_CONSONANTS_TO_SIGN_1 = SymbolRange.range('ວ', 'ະ');  // 0xea7 - 0xeb0
    public static final SymbolRange MALAYALAM_VOWELS_SUBSET_2 = SymbolRange.range('າ', 'ຳ');  // 0xeb2 - 0xeb3
    public static final SymbolRange MALAYALAM_VOWELS_TO_VOWEL = SymbolRange.range('ິ', 'ຼ');  // 0xeb4 - 0xebc
    public static final SymbolRange MALAYALAM_VOWELS_SUBSET = SymbolRange.range('ເ', 'ໄ');  // 0xec0 - 0xec4
    public static final SymbolRange MALAYALAM_TONE_MARKS_TO_SIGNS = SymbolRange.range('່', 'ໍ');  // 0xec8 - 0xecd
    public static final SymbolRange MALAYALAM_DIGITS_SUBSET = SymbolRange.range('໐', '໙');  // 0xed0 - 0xed9
    public static final SymbolRange MALAYALAM_DIGRAPHS_TO_CONSONANTS_FOR_KHMU = SymbolRange.range('ໜ', 'ໟ');  // 0xedc - 0xedf
    public static final SymbolRange TIBETAN_SYLLABLE_TO_ANNOTATION_MARKS = SymbolRange.range('ༀ', '࿿');  // 0xf00 - 0xfff
    public static final SymbolRange TIBETAN_HEAD_MARKS_SUBSET = SymbolRange.range('༁', '༃');  // 0xf01 - 0xf03
    public static final SymbolRange TIBETAN_HEAD_MARKS_TO_MARKS_AND_SIGNS = SymbolRange.range('༄', '༒');  // 0xf04 - 0xf12
    public static final SymbolRange TIBETAN_ASTROLOGICAL_SIGNS_SUBSET = SymbolRange.range('༕', '༗');  // 0xf15 - 0xf17
    public static final SymbolRange TIBETAN_ASTROLOGICAL_SIGNS_SUBSET_1 = SymbolRange.range('༘', '༙');  // 0xf18 - 0xf19
    public static final SymbolRange TIBETAN_ASTROLOGICAL_SIGNS_SUBSET_2 = SymbolRange.range('༚', '༟');  // 0xf1a - 0xf1f
    public static final SymbolRange TIBETAN_DIGITS = SymbolRange.range('༠', '༩');  // 0xf20 - 0xf29
    public static final SymbolRange TIBETAN_DIGITS_TO_DIGITS_MINUS_HALF = SymbolRange.range('༠', '༳');  // 0xf20 - 0xf33
    public static final SymbolRange TIBETAN_DIGITS_MINUS_HALF = SymbolRange.range('༪', '༳');  // 0xf2a - 0xf33
    public static final SymbolRange TIBETAN_PAIRED_PUNCTUATION = SymbolRange.range('༺', '༽');  // 0xf3a - 0xf3d
    public static final SymbolRange TIBETAN_ASTROLOGICAL_SIGNS_1 = SymbolRange.range('༾', '༿');  // 0xf3e - 0xf3f
    public static final SymbolRange TIBETAN_CONSONANTS_SUBSET = SymbolRange.range('ཀ', 'ཇ');  // 0xf40 - 0xf47
    public static final SymbolRange TIBETAN_CONSONANTS_TO_EXTENSIONS_FOR_BALTI = SymbolRange.range('ཉ', 'ཬ');  // 0xf49 - 0xf6c
    public static final SymbolRange TIBETAN_DEPENDENT_VOWEL_SIGNS_TO_DEPENDENT_VOWEL_SIGNS = SymbolRange.range('ཱ', 'ཾ');  // 0xf71 - 0xf7e
    public static final SymbolRange TIBETAN_DEPENDENT_VOWEL_SIGNS_TO_MARKS_AND_SIGNS_1 = SymbolRange.range('ཱ', '྄');  // 0xf71 - 0xf84
    public static final SymbolRange TIBETAN_DEPENDENT_VOWEL_SIGNS_TO_MARKS_AND_SIGNS = SymbolRange.range('ྀ', '྄');  // 0xf80 - 0xf84
    public static final SymbolRange TIBETAN_MARKS_AND_SIGNS_SUBSET = SymbolRange.range('྆', '྇');  // 0xf86 - 0xf87
    public static final SymbolRange TIBETAN_TRANSLITERATION_HEAD_LETTERS = SymbolRange.range('ྈ', 'ྌ');  // 0xf88 - 0xf8c
    public static final SymbolRange TIBETAN_TRANSLITERATION_SUBJOINED_SIGNS_TO_SUBJOINED_CONSONANTS = SymbolRange.range('ྍ', 'ྗ');  // 0xf8d - 0xf97
    public static final SymbolRange TIBETAN_SUBJOINED_CONSONANTS_TO_FIXED_FORM_SUBJOINED_CONSONANTS = SymbolRange.range('ྙ', 'ྼ');  // 0xf99 - 0xfbc
    public static final SymbolRange TIBETAN_SIGNS_TO_SYMBOLS = SymbolRange.range('྾', '࿅');  // 0xfbe - 0xfc5
    public static final SymbolRange TIBETAN_SYMBOLS_SUBSET = SymbolRange.range('࿇', '࿌');  // 0xfc7 - 0xfcc
    public static final SymbolRange TIBETAN_ASTROLOGICAL_SIGNS_2 = SymbolRange.range('࿎', '࿏');  // 0xfce - 0xfcf
    public static final SymbolRange TIBETAN_MARKS_TO_HEAD_MARKS = SymbolRange.range('࿐', '࿔');  // 0xfd0 - 0xfd4
    public static final SymbolRange TIBETAN_RELIGIOUS_SYMBOLS = SymbolRange.range('࿕', '࿘');  // 0xfd5 - 0xfd8
    public static final SymbolRange TIBETAN_ANNOTATION_MARKS_SUBSET = SymbolRange.range('࿙', '࿚');  // 0xfd9 - 0xfda
    public static final SymbolRange MYANMAR_CONSONANTS_TO_INDEPENDENT_VOWELS = SymbolRange.range('က', 'ဪ');  // 0x1000 - 0x102a
    public static final SymbolRange MYANMAR_CONSONANTS_TO_SHAN_SYMBOLS = SymbolRange.range('က', '႟');  // 0x1000 - 0x109f
    public static final SymbolRange MYANMAR_DEPENDENT_VOWEL_SIGNS_SUBSET = SymbolRange.range('ါ', 'ာ');  // 0x102b - 0x102c
    public static final SymbolRange MYANMAR_DEPENDENT_VOWEL_SIGNS_TO_DEPENDENT_CONSONANT_SIGNS = SymbolRange.range('ါ', 'ှ');  // 0x102b - 0x103e
    public static final SymbolRange MYANMAR_DEPENDENT_VOWEL_SIGNS_SUBSET_1 = SymbolRange.range('ိ', 'ူ');  // 0x102d - 0x1030
    public static final SymbolRange MYANMAR_DEPENDENT_VOWEL_SIGNS_TO_VARIOUS_SIGNS = SymbolRange.range('ဲ', '့');  // 0x1032 - 0x1037
    public static final SymbolRange MYANMAR_VIRAMA_AND_KILLER = SymbolRange.range('္', '်');  // 0x1039 - 0x103a
    public static final SymbolRange MYANMAR_DEPENDENT_CONSONANT_SIGNS_SUBSET = SymbolRange.range('ျ', 'ြ');  // 0x103b - 0x103c
    public static final SymbolRange MYANMAR_DEPENDENT_CONSONANT_SIGNS_SUBSET_1 = SymbolRange.range('ွ', 'ှ');  // 0x103d - 0x103e
    public static final SymbolRange MYANMAR_DIGITS = SymbolRange.range('၀', '၉');  // 0x1040 - 0x1049
    public static final SymbolRange MYANMAR_PUNCTUATION_TO_VARIOUS_SIGNS = SymbolRange.range('၊', '၏');  // 0x104a - 0x104f
    public static final SymbolRange MYANMAR_PALI_AND_SANSKRIT_EXTENSIONS_SUBSET = SymbolRange.range('ၐ', 'ၕ');  // 0x1050 - 0x1055
    public static final SymbolRange MYANMAR_PALI_AND_SANSKRIT_EXTENSIONS_SUBSET_1 = SymbolRange.range('ၖ', 'ၙ');  // 0x1056 - 0x1059
    public static final SymbolRange MYANMAR_PALI_AND_SANSKRIT_EXTENSIONS_SUBSET_2 = SymbolRange.range('ၖ', 'ၗ');  // 0x1056 - 0x1057
    public static final SymbolRange MYANMAR_PALI_AND_SANSKRIT_EXTENSIONS_SUBSET_3 = SymbolRange.range('ၘ', 'ၙ');  // 0x1058 - 0x1059
    public static final SymbolRange MYANMAR_EXTENSIONS_FOR_MON_SUBSET = SymbolRange.range('ၚ', 'ၝ');  // 0x105a - 0x105d
    public static final SymbolRange MYANMAR_EXTENSIONS_FOR_MON_SUBSET_1 = SymbolRange.range('ၞ', 'ၠ');  // 0x105e - 0x1060
    public static final SymbolRange MYANMAR_EXTENSIONS_FOR_SGAW_KAREN_SUBSET = SymbolRange.range('ၢ', 'ၤ');  // 0x1062 - 0x1064
    public static final SymbolRange MYANMAR_EXTENSIONS_FOR_WESTERN_PWO_KAREN_SUBSET = SymbolRange.range('ၥ', 'ၦ');  // 0x1065 - 0x1066
    public static final SymbolRange MYANMAR_EXTENSIONS_FOR_WESTERN_PWO_KAREN_SUBSET_1 = SymbolRange.range('ၧ', 'ၭ');  // 0x1067 - 0x106d
    public static final SymbolRange MYANMAR_EXTENSIONS_FOR_EASTERN_PWO_KAREN = SymbolRange.range('ၮ', 'ၰ');  // 0x106e - 0x1070
    public static final SymbolRange MYANMAR_EXTENSION_FOR_GEBA_KAREN_TO_EXTENSIONS_FOR_KAYAH = SymbolRange.range('ၱ', 'ၴ');  // 0x1071 - 0x1074
    public static final SymbolRange MYANMAR_EXTENSIONS_FOR_SHAN_SUBSET_4 = SymbolRange.range('ၵ', 'ႁ');  // 0x1075 - 0x1081
    public static final SymbolRange MYANMAR_EXTENSIONS_FOR_SHAN_SUBSET = SymbolRange.range('ႂ', 'ႍ');  // 0x1082 - 0x108d
    public static final SymbolRange MYANMAR_EXTENSIONS_FOR_SHAN_SUBSET_1 = SymbolRange.range('ႃ', 'ႄ');  // 0x1083 - 0x1084
    public static final SymbolRange MYANMAR_EXTENSIONS_FOR_SHAN_SUBSET_2 = SymbolRange.range('ႅ', 'ႆ');  // 0x1085 - 0x1086
    public static final SymbolRange MYANMAR_EXTENSIONS_FOR_SHAN_SUBSET_3 = SymbolRange.range('ႇ', 'ႌ');  // 0x1087 - 0x108c
    public static final SymbolRange MYANMAR_SHAN_DIGITS = SymbolRange.range('႐', '႙');  // 0x1090 - 0x1099
    public static final SymbolRange MYANMAR_EXTENSIONS_FOR_KHAMTI_SHAN_TO_EXTENSIONS_FOR_KHAMTI_SHAN = SymbolRange.range('ႚ', 'ႜ');  // 0x109a - 0x109c
    public static final SymbolRange MYANMAR_EXTENSIONS_FOR_KHAMTI_SHAN_TO_EXTENSIONS_FOR_AITON_AND_PHAKE = SymbolRange.range('ႚ', 'ႝ');  // 0x109a - 0x109d
    public static final SymbolRange MYANMAR_SHAN_SYMBOLS = SymbolRange.range('႞', '႟');  // 0x109e - 0x109f
    public static final SymbolRange GEORGIAN_CAPITAL_LETTERS_KHUTSURI_SUBSET = SymbolRange.range('Ⴀ', 'Ⴥ');  // 0x10a0 - 0x10c5
    public static final SymbolRange GEORGIAN_CAPITAL_LETTERS_KHUTSURI_TO_ADDITIONAL_LETTERS_FOR_OSSETIAN_AND_ABKHAZ = SymbolRange.range('Ⴀ', 'ჿ');  // 0x10a0 - 0x10ff
    public static final SymbolRange GEORGIAN_MKHEDRULI_TO_ADDITIONAL_LETTERS = SymbolRange.range('ა', 'ჺ');  // 0x10d0 - 0x10fa
    public static final SymbolRange GEORGIAN_TO_ETHIOPIC = SymbolRange.range('ჼ', 'ቈ');  // 0x10fc - 0x1248
    public static final SymbolRange GEORGIAN_ADDITIONAL_LETTERS_FOR_OSSETIAN_AND_ABKHAZ = SymbolRange.range('ჽ', 'ჿ');  // 0x10fd - 0x10ff
    public static final SymbolRange HANGUL_JAMO_INITIAL_CONSONANTS_TO_OLD_FINAL_CONSONANTS = SymbolRange.range('ᄀ', 'ᇿ');  // 0x1100 - 0x11ff
    public static final SymbolRange HANGUL_JAMO_TO_ETHIOPIC = SymbolRange.range('ᄀ', 'ቈ');  // 0x1100 - 0x1248
    public static final SymbolRange ETHIOPIC_SYLLABLES_TO_NUMBERS = SymbolRange.range('ሀ', '፿');  // 0x1200 - 0x137f
    public static final SymbolRange ETHIOPIC_SYLLABLES_SUBSET_3 = SymbolRange.range('ቊ', 'ቍ');  // 0x124a - 0x124d
    public static final SymbolRange ETHIOPIC_SYLLABLES_SUBSET_4 = SymbolRange.range('ቐ', 'ቖ');  // 0x1250 - 0x1256
    public static final SymbolRange ETHIOPIC_SYLLABLES_SUBSET_9 = SymbolRange.range('ቚ', 'ቝ');  // 0x125a - 0x125d
    public static final SymbolRange ETHIOPIC_SYLLABLES_SUBSET_10 = SymbolRange.range('በ', 'ኈ');  // 0x1260 - 0x1288
    public static final SymbolRange ETHIOPIC_SYLLABLES_SUBSET_2 = SymbolRange.range('ኊ', 'ኍ');  // 0x128a - 0x128d
    public static final SymbolRange ETHIOPIC_SYLLABLES_SUBSET_5 = SymbolRange.range('ነ', 'ኰ');  // 0x1290 - 0x12b0
    public static final SymbolRange ETHIOPIC_SYLLABLES_SUBSET_11 = SymbolRange.range('ኲ', 'ኵ');  // 0x12b2 - 0x12b5
    public static final SymbolRange ETHIOPIC_SYLLABLES_SUBSET_12 = SymbolRange.range('ኸ', 'ኾ');  // 0x12b8 - 0x12be
    public static final SymbolRange ETHIOPIC_SYLLABLES_SUBSET = SymbolRange.range('ዂ', 'ዅ');  // 0x12c2 - 0x12c5
    public static final SymbolRange ETHIOPIC_SYLLABLES_SUBSET_1 = SymbolRange.range('ወ', 'ዖ');  // 0x12c8 - 0x12d6
    public static final SymbolRange ETHIOPIC_SYLLABLES_SUBSET_7 = SymbolRange.range('ዘ', 'ጐ');  // 0x12d8 - 0x1310
    public static final SymbolRange ETHIOPIC_SYLLABLES_SUBSET_6 = SymbolRange.range('ጒ', 'ጕ');  // 0x1312 - 0x1315
    public static final SymbolRange ETHIOPIC_SYLLABLES_SUBSET_8 = SymbolRange.range('ጘ', 'ፚ');  // 0x1318 - 0x135a
    public static final SymbolRange ETHIOPIC_COMBINING_MARKS = SymbolRange.range('፝', '፟');  // 0x135d - 0x135f
    public static final SymbolRange ETHIOPIC_PUNCTUATION = SymbolRange.range('፠', '፨');  // 0x1360 - 0x1368
    public static final SymbolRange ETHIOPIC_DIGITS_TO_NUMBERS = SymbolRange.range('፩', '፼');  // 0x1369 - 0x137c
    public static final SymbolRange ETHIOPIC_SUPPLEMENT_SYLLABLES_FOR_SEBATBEIT = SymbolRange.range('ᎀ', 'ᎏ');  // 0x1380 - 0x138f
    public static final SymbolRange ETHIOPIC_SUPPLEMENT_TONAL_MARKS_SUBSET = SymbolRange.range('᎐', '᎙');  // 0x1390 - 0x1399
    public static final SymbolRange CHEROKEE_UPPERCASE_SYLLABLES_TO_UPPERCASE_SYLLABLES = SymbolRange.range('Ꭰ', 'Ᏽ');  // 0x13a0 - 0x13f5
    public static final SymbolRange CHEROKEE_UPPERCASE_SYLLABLES_TO_ARCHAIC_LOWERCASE_SYLLABLE = SymbolRange.range('Ꭰ', '᏿');  // 0x13a0 - 0x13ff
    public static final SymbolRange CHEROKEE_LOWERCASE_SYLLABLES_TO_LOWERCASE_SYLLABLES = SymbolRange.range('ᏸ', 'ᏽ');  // 0x13f8 - 0x13fd
    public static final SymbolRange UNIFIED_CANADIAN_ABORIGINAL_SYLLABICS_PUNCTUATION_TO_SYLLABLES = SymbolRange.range('᐀', 'ᙿ');  // 0x1400 - 0x167f
    public static final SymbolRange UNIFIED_CANADIAN_ABORIGINAL_SYLLABICS_SYLLABLES_TO_SYLLABLES_FOR_CARRIER = SymbolRange.range('ᐁ', 'ᙬ');  // 0x1401 - 0x166c
    public static final SymbolRange UNIFIED_CANADIAN_ABORIGINAL_SYLLABICS_SYLLABLES_1 = SymbolRange.range('ᙯ', 'ᙿ');  // 0x166f - 0x167f
    public static final SymbolRange OGHAM_SPACE_TO_PUNCTUATION = SymbolRange.range(' ', '᚟');  // 0x1680 - 0x169f
    public static final SymbolRange OGHAM_TRADITIONAL_LETTERS_TO_FORFEDA_SUPPLEMENTARY_LETTERS = SymbolRange.range('ᚁ', 'ᚚ');  // 0x1681 - 0x169a
    public static final SymbolRange OGHAM_PUNCTUATION_SUBSET = SymbolRange.range('᚛', '᚜');  // 0x169b - 0x169c
    public static final SymbolRange RUNIC_LETTERS = SymbolRange.range('ᚠ', 'ᛪ');  // 0x16a0 - 0x16ea
    public static final SymbolRange RUNIC_LETTERS_TO_CRYPTOGRAMMIC_LETTERS = SymbolRange.range('ᚠ', '᛿');  // 0x16a0 - 0x16ff
    public static final SymbolRange RUNIC_PUNCTUATION = SymbolRange.range('᛫', '᛭');  // 0x16eb - 0x16ed
    public static final SymbolRange RUNIC_GOLDEN_NUMBER_RUNES = SymbolRange.range('ᛮ', 'ᛰ');  // 0x16ee - 0x16f0
    public static final SymbolRange RUNIC_TOLKIENIAN_EXTENSIONS_TO_CRYPTOGRAMMIC_LETTERS = SymbolRange.range('ᛱ', 'ᛸ');  // 0x16f1 - 0x16f8
    public static final SymbolRange TAGALOG_INDEPENDENT_VOWELS_TO_CONSONANTS = SymbolRange.range('ᜀ', 'ᜌ');  // 0x1700 - 0x170c
    public static final SymbolRange TAGALOG_INDEPENDENT_VOWELS_TO_VIRAMAS = SymbolRange.range('ᜀ', 'ᜟ');  // 0x1700 - 0x171f
    public static final SymbolRange TAGALOG_CONSONANTS_SUBSET = SymbolRange.range('ᜎ', 'ᜑ');  // 0x170e - 0x1711
    public static final SymbolRange TAGALOG_DEPENDENT_VOWEL_SIGNS_TO_DEPENDENT_VOWEL_SIGNS = SymbolRange.range('ᜒ', '᜔');  // 0x1712 - 0x1714
    public static final SymbolRange HANUNOO_INDEPENDENT_VOWELS_TO_CONSONANTS = SymbolRange.range('ᜠ', 'ᜱ');  // 0x1720 - 0x1731
    public static final SymbolRange HANUNOO_INDEPENDENT_VOWELS_TO_GENERIC_PUNCTUATION_FOR_PHILIPPINE_SCRIPTS = SymbolRange.range('ᜠ', '᜿');  // 0x1720 - 0x173f
    public static final SymbolRange HANUNOO_DEPENDENT_VOWEL_SIGNS_TO_DEPENDENT_VOWEL_SIGNS = SymbolRange.range('ᜲ', '᜴');  // 0x1732 - 0x1734
    public static final SymbolRange HANUNOO_GENERIC_PUNCTUATION_FOR_PHILIPPINE_SCRIPTS_SUBSET = SymbolRange.range('᜵', '᜶');  // 0x1735 - 0x1736
    public static final SymbolRange BUHID_INDEPENDENT_VOWELS_TO_CONSONANTS = SymbolRange.range('ᝀ', 'ᝑ');  // 0x1740 - 0x1751
    public static final SymbolRange BUHID_INDEPENDENT_VOWELS_TO_DEPENDENT_VOWEL_SIGNS = SymbolRange.range('ᝀ', '᝟');  // 0x1740 - 0x175f
    public static final SymbolRange BUHID_DEPENDENT_VOWEL_SIGNS_SUBSET = SymbolRange.range('ᝒ', 'ᝓ');  // 0x1752 - 0x1753
    public static final SymbolRange TAGBANWA_INDEPENDENT_VOWELS_TO_CONSONANTS = SymbolRange.range('ᝠ', 'ᝬ');  // 0x1760 - 0x176c
    public static final SymbolRange TAGBANWA_INDEPENDENT_VOWELS_TO_DEPENDENT_VOWEL_SIGNS = SymbolRange.range('ᝠ', '᝿');  // 0x1760 - 0x177f
    public static final SymbolRange TAGBANWA_CONSONANTS_SUBSET = SymbolRange.range('ᝮ', 'ᝰ');  // 0x176e - 0x1770
    public static final SymbolRange TAGBANWA_DEPENDENT_VOWEL_SIGNS_SUBSET = SymbolRange.range('ᝲ', 'ᝳ');  // 0x1772 - 0x1773
    public static final SymbolRange KHMER_CONSONANTS_TO_INDEPENDENT_VOWELS = SymbolRange.range('ក', 'ឳ');  // 0x1780 - 0x17b3
    public static final SymbolRange KHMER_CONSONANTS_TO_NUMERIC_SYMBOLS_FOR_DIVINATION_LORE = SymbolRange.range('ក', '៿');  // 0x1780 - 0x17ff
    public static final SymbolRange KHMER_INHERENT_VOWELS = SymbolRange.range('឴', '឵');  // 0x17b4 - 0x17b5
    public static final SymbolRange KHMER_INHERENT_VOWELS_TO_VARIOUS_SIGNS = SymbolRange.range('឴', '៓');  // 0x17b4 - 0x17d3
    public static final SymbolRange KHMER_DEPENDENT_VOWEL_SIGNS_SUBSET = SymbolRange.range('ិ', 'ួ');  // 0x17b7 - 0x17bd
    public static final SymbolRange KHMER_TWO_PART_DEPENDENT_VOWEL_SIGNS_TO_TWO_PART_DEPENDENT_VOWEL_SIGNS = SymbolRange.range('ើ', 'ៅ');  // 0x17be - 0x17c5
    public static final SymbolRange KHMER_VARIOUS_SIGNS_SUBSET = SymbolRange.range('ះ', 'ៈ');  // 0x17c7 - 0x17c8
    public static final SymbolRange KHMER_CONSONANT_SHIFTERS_TO_VARIOUS_SIGNS = SymbolRange.range('៉', '៓');  // 0x17c9 - 0x17d3
    public static final SymbolRange KHMER_VARIOUS_SIGNS_SUBSET_1 = SymbolRange.range('។', '៖');  // 0x17d4 - 0x17d6
    public static final SymbolRange KHMER_VARIOUS_SIGNS_SUBSET_2 = SymbolRange.range('៘', '៚');  // 0x17d8 - 0x17da
    public static final SymbolRange KHMER_DIGITS_SUBSET = SymbolRange.range('០', '៩');  // 0x17e0 - 0x17e9
    public static final SymbolRange KHMER_NUMERIC_SYMBOLS_FOR_DIVINATION_LORE_SUBSET = SymbolRange.range('៰', '៹');  // 0x17f0 - 0x17f9
    public static final SymbolRange MONGOLIAN_PUNCTUATION_SUBSET = SymbolRange.range('᠀', '᠅');  // 0x1800 - 0x1805
    public static final SymbolRange MONGOLIAN_PUNCTUATION = SymbolRange.range('᠀', '᠊');  // 0x1800 - 0x180a
    public static final SymbolRange MONGOLIAN_PUNCTUATION_TO_EXTENSIONS_FOR_SANSKRIT_AND_TIBETAN = SymbolRange.range('᠀', '᢯');  // 0x1800 - 0x18af
    public static final SymbolRange MONGOLIAN_PUNCTUATION_SUBSET_1 = SymbolRange.range('᠇', '᠊');  // 0x1807 - 0x180a
    public static final SymbolRange MONGOLIAN_FORMAT_CONTROLS_SUBSET = SymbolRange.range('᠋', '᠍');  // 0x180b - 0x180d
    public static final SymbolRange MONGOLIAN_DIGITS_SUBSET = SymbolRange.range('᠐', '᠙');  // 0x1810 - 0x1819
    public static final SymbolRange MONGOLIAN_BASIC_LETTERS = SymbolRange.range('ᠠ', 'ᡂ');  // 0x1820 - 0x1842
    public static final SymbolRange MONGOLIAN_BASIC_LETTERS_TO_MANCHU_LETTERS = SymbolRange.range('ᠠ', 'ᡸ');  // 0x1820 - 0x1878
    public static final SymbolRange MONGOLIAN_TODO_LETTERS_TO_MANCHU_LETTERS = SymbolRange.range('ᡄ', 'ᡸ');  // 0x1844 - 0x1878
    public static final SymbolRange MONGOLIAN_EXTENSIONS_FOR_SANSKRIT_AND_TIBETAN_SUBSET = SymbolRange.range('ᢀ', 'ᢄ');  // 0x1880 - 0x1884
    public static final SymbolRange MONGOLIAN_EXTENSIONS_FOR_SANSKRIT_AND_TIBETAN_SUBSET_1 = SymbolRange.range('ᢅ', 'ᢆ');  // 0x1885 - 0x1886
    public static final SymbolRange MONGOLIAN_EXTENSIONS_FOR_SANSKRIT_AND_TIBETAN_SUBSET_2 = SymbolRange.range('ᢇ', 'ᢨ');  // 0x1887 - 0x18a8
    public static final SymbolRange UNIFIED_CANADIAN_ABORIGINAL_SYLLABICS_EXTENDED_SYLLABLES_FOR_MOOSE_CREE_TO_FINALS_FOR_DENE_AND_CARRIER = SymbolRange.range('ᢰ', 'ᣵ');  // 0x18b0 - 0x18f5
    public static final SymbolRange LIMBU_CONSONANTS_SUBSET = SymbolRange.range('ᤀ', 'ᤞ');  // 0x1900 - 0x191e
    public static final SymbolRange LIMBU_CONSONANTS_TO_DIGITS = SymbolRange.range('ᤀ', '᥏');  // 0x1900 - 0x194f
    public static final SymbolRange LIMBU_DEPENDENT_VOWEL_SIGNS_SUBSET = SymbolRange.range('ᤠ', 'ᤢ');  // 0x1920 - 0x1922
    public static final SymbolRange LIMBU_DEPENDENT_VOWEL_SIGNS_TO_SUBJOINED_CONSONANTS = SymbolRange.range('ᤠ', 'ᤫ');  // 0x1920 - 0x192b
    public static final SymbolRange LIMBU_DEPENDENT_VOWEL_SIGNS_SUBSET_1 = SymbolRange.range('ᤣ', 'ᤦ');  // 0x1923 - 0x1926
    public static final SymbolRange LIMBU_DEPENDENT_VOWEL_SIGNS_SUBSET_2 = SymbolRange.range('ᤧ', 'ᤨ');  // 0x1927 - 0x1928
    public static final SymbolRange LIMBU_SUBJOINED_CONSONANTS_SUBSET = SymbolRange.range('ᤩ', 'ᤫ');  // 0x1929 - 0x192b
    public static final SymbolRange LIMBU_FINAL_CONSONANTS_SUBSET = SymbolRange.range('ᤰ', 'ᤱ');  // 0x1930 - 0x1931
    public static final SymbolRange LIMBU_FINAL_CONSONANTS_TO_VARIOUS_SIGNS = SymbolRange.range('ᤰ', '᤻');  // 0x1930 - 0x193b
    public static final SymbolRange LIMBU_FINAL_CONSONANTS_SUBSET_1 = SymbolRange.range('ᤳ', 'ᤸ');  // 0x1933 - 0x1938
    public static final SymbolRange LIMBU_VARIOUS_SIGNS_SUBSET_1 = SymbolRange.range('᤹', '᤻');  // 0x1939 - 0x193b
    public static final SymbolRange LIMBU_VARIOUS_SIGNS_SUBSET = SymbolRange.range('᥄', '᥅');  // 0x1944 - 0x1945
    public static final SymbolRange LIMBU_DIGITS = SymbolRange.range('᥆', '᥏');  // 0x1946 - 0x194f
    public static final SymbolRange TAI_LE_CONSONANTS_TO_VOWELS = SymbolRange.range('ᥐ', 'ᥭ');  // 0x1950 - 0x196d
    public static final SymbolRange TAI_LE_CONSONANTS_TO_TONE_LETTERS = SymbolRange.range('ᥐ', '᥿');  // 0x1950 - 0x197f
    public static final SymbolRange TAI_LE_TONE_LETTERS_SUBSET = SymbolRange.range('ᥰ', 'ᥴ');  // 0x1970 - 0x1974
    public static final SymbolRange NEW_TAI_LUE_CONSONANTS_SUBSET = SymbolRange.range('ᦀ', 'ᦫ');  // 0x1980 - 0x19ab
    public static final SymbolRange NEW_TAI_LUE_VOWEL_SIGNS_TO_TONE_MARKS = SymbolRange.range('ᦰ', 'ᧉ');  // 0x19b0 - 0x19c9
    public static final SymbolRange NEW_TAI_LUE_DIGITS_SUBSET = SymbolRange.range('᧐', '᧚');  // 0x19d0 - 0x19da
    public static final SymbolRange NEW_TAI_LUE_DIGITS_SUBSET_1 = SymbolRange.range('᧐', '᧙');  // 0x19d0 - 0x19d9
    public static final SymbolRange NEW_TAI_LUE_TO_KHMER_SYMBOLS = SymbolRange.range('᧞', '᧿');  // 0x19de - 0x19ff
    public static final SymbolRange KHMER_SYMBOLS_LUNAR_DATE_SYMBOLS = SymbolRange.range('᧠', '᧿');  // 0x19e0 - 0x19ff
    public static final SymbolRange BUGINESE_CONSONANTS = SymbolRange.range('ᨀ', 'ᨖ');  // 0x1a00 - 0x1a16
    public static final SymbolRange BUGINESE_VOWELS_SUBSET = SymbolRange.range('ᨗ', 'ᨘ');  // 0x1a17 - 0x1a18
    public static final SymbolRange BUGINESE_VOWELS_SUBSET_1 = SymbolRange.range('ᨗ', 'ᨛ');  // 0x1a17 - 0x1a1b
    public static final SymbolRange BUGINESE_VOWELS_SUBSET_2 = SymbolRange.range('ᨙ', 'ᨚ');  // 0x1a19 - 0x1a1a
    public static final SymbolRange BUGINESE_VARIOUS_SIGNS = SymbolRange.range('᨞', '᨟');  // 0x1a1e - 0x1a1f
    public static final SymbolRange TAI_THAM_CONSONANTS_TO_CONSONANTS = SymbolRange.range('ᨠ', 'ᩔ');  // 0x1a20 - 0x1a54
    public static final SymbolRange TAI_THAM_CONSONANT_SIGNS_SUBSET = SymbolRange.range('ᩕ', 'ᩞ');  // 0x1a55 - 0x1a5e
    public static final SymbolRange TAI_THAM_CONSONANT_SIGNS_SUBSET_1 = SymbolRange.range('ᩘ', 'ᩞ');  // 0x1a58 - 0x1a5e
    public static final SymbolRange TAI_THAM_SIGN_TO_OTHER_MARKS = SymbolRange.range('᩠', '᩼');  // 0x1a60 - 0x1a7c
    public static final SymbolRange TAI_THAM_DEPENDENT_VOWEL_SIGNS_SUBSET = SymbolRange.range('ᩣ', 'ᩤ');  // 0x1a63 - 0x1a64
    public static final SymbolRange TAI_THAM_DEPENDENT_VOWEL_SIGNS_SUBSET_1 = SymbolRange.range('ᩥ', 'ᩬ');  // 0x1a65 - 0x1a6c
    public static final SymbolRange TAI_THAM_DEPENDENT_VOWEL_SIGNS_SUBSET_2 = SymbolRange.range('ᩭ', 'ᩲ');  // 0x1a6d - 0x1a72
    public static final SymbolRange TAI_THAM_DEPENDENT_VOWEL_SIGNS_TO_OTHER_MARKS = SymbolRange.range('ᩳ', '᩼');  // 0x1a73 - 0x1a7c
    public static final SymbolRange TAI_THAM_HORA_DIGITS_SUBSET = SymbolRange.range('᪀', '᪉');  // 0x1a80 - 0x1a89
    public static final SymbolRange TAI_THAM_THAM_DIGITS_SUBSET = SymbolRange.range('᪐', '᪙');  // 0x1a90 - 0x1a99
    public static final SymbolRange TAI_THAM_LOGOGRAPHS_TO_PUNCTUATION = SymbolRange.range('᪠', '᪦');  // 0x1aa0 - 0x1aa6
    public static final SymbolRange TAI_THAM_PUNCTUATION_SUBSET = SymbolRange.range('᪨', '᪭');  // 0x1aa8 - 0x1aad
    public static final SymbolRange COMBINING_DIACRITICAL_MARKS_EXTENDED_USED_IN_GERMAN_DIALECTOLOGY_TO_MARKS_SURROUNDING_OTHER_DIACRITICS_OR_LETTERS = SymbolRange.range('᪰', '᪽');  // 0x1ab0 - 0x1abd
    public static final SymbolRange COMBINING_DIACRITICAL_MARKS_EXTENDED_USED_IN_GERMAN_DIALECTOLOGY_TO_USED_FOR_SCOTS_DIALECTOLOGY = SymbolRange.range('᪰', 'ᫀ');  // 0x1ab0 - 0x1ac0
    public static final SymbolRange COMBINING_DIACRITICAL_MARKS_EXTENDED_USED_FOR_SCOTS_DIALECTOLOGY = SymbolRange.range('ᪿ', 'ᫀ');  // 0x1abf - 0x1ac0
    public static final SymbolRange BALINESE_VARIOUS_SIGNS_SUBSET = SymbolRange.range('ᬀ', 'ᬃ');  // 0x1b00 - 0x1b03
    public static final SymbolRange BALINESE_VARIOUS_SIGNS = SymbolRange.range('ᬀ', 'ᬄ');  // 0x1b00 - 0x1b04
    public static final SymbolRange BALINESE_INDEPENDENT_VOWELS_TO_CONSONANTS = SymbolRange.range('ᬅ', 'ᬳ');  // 0x1b05 - 0x1b33
    public static final SymbolRange BALINESE_SIGN_TO_DEPENDENT_VOWEL_SIGNS = SymbolRange.range('᬴', '᭄');  // 0x1b34 - 0x1b44
    public static final SymbolRange BALINESE_DEPENDENT_VOWEL_SIGNS_SUBSET = SymbolRange.range('ᬶ', 'ᬺ');  // 0x1b36 - 0x1b3a
    public static final SymbolRange BALINESE_DEPENDENT_VOWEL_SIGNS_SUBSET_1 = SymbolRange.range('ᬽ', 'ᭁ');  // 0x1b3d - 0x1b41
    public static final SymbolRange BALINESE_DEPENDENT_VOWEL_SIGNS_TO_DEPENDENT_VOWEL_SIGNS = SymbolRange.range('ᭃ', '᭄');  // 0x1b43 - 0x1b44
    public static final SymbolRange BALINESE_ADDITIONAL_CONSONANTS_SUBSET = SymbolRange.range('ᭅ', 'ᭋ');  // 0x1b45 - 0x1b4b
    public static final SymbolRange BALINESE_DIGITS = SymbolRange.range('᭐', '᭙');  // 0x1b50 - 0x1b59
    public static final SymbolRange BALINESE_PUNCTUATION = SymbolRange.range('᭚', '᭠');  // 0x1b5a - 0x1b60
    public static final SymbolRange BALINESE_MUSICAL_SYMBOLS_FOR_NOTES = SymbolRange.range('᭡', '᭪');  // 0x1b61 - 0x1b6a
    public static final SymbolRange BALINESE_DIACRITICAL_MARKS_FOR_MUSICAL_SYMBOLS = SymbolRange.range('᭫', '᭳');  // 0x1b6b - 0x1b73
    public static final SymbolRange BALINESE_MUSICAL_SYMBOLS = SymbolRange.range('᭴', '᭼');  // 0x1b74 - 0x1b7c
    public static final SymbolRange SUNDANESE_VARIOUS_SIGNS = SymbolRange.range('ᮀ', 'ᮂ');  // 0x1b80 - 0x1b82
    public static final SymbolRange SUNDANESE_VARIOUS_SIGNS_SUBSET = SymbolRange.range('ᮀ', 'ᮁ');  // 0x1b80 - 0x1b81
    public static final SymbolRange SUNDANESE_VOWELS_TO_CONSONANTS = SymbolRange.range('ᮃ', 'ᮠ');  // 0x1b83 - 0x1ba0
    public static final SymbolRange SUNDANESE_CONSONANT_SIGNS_TO_CONSONANT_SIGNS = SymbolRange.range('ᮡ', 'ᮭ');  // 0x1ba1 - 0x1bad
    public static final SymbolRange SUNDANESE_CONSONANT_SIGNS_TO_VOWEL_SIGNS = SymbolRange.range('ᮢ', 'ᮥ');  // 0x1ba2 - 0x1ba5
    public static final SymbolRange SUNDANESE_VOWEL_SIGNS_SUBSET = SymbolRange.range('ᮦ', 'ᮧ');  // 0x1ba6 - 0x1ba7
    public static final SymbolRange SUNDANESE_VOWEL_SIGNS_SUBSET_1 = SymbolRange.range('ᮨ', 'ᮩ');  // 0x1ba8 - 0x1ba9
    public static final SymbolRange SUNDANESE_VIRAMAS_TO_CONSONANT_SIGNS = SymbolRange.range('᮫', 'ᮭ');  // 0x1bab - 0x1bad
    public static final SymbolRange SUNDANESE_ADDITIONAL_CONSONANTS = SymbolRange.range('ᮮ', 'ᮯ');  // 0x1bae - 0x1baf
    public static final SymbolRange SUNDANESE_DIGITS = SymbolRange.range('᮰', '᮹');  // 0x1bb0 - 0x1bb9
    public static final SymbolRange SUNDANESE_TO_BATAK = SymbolRange.range('ᮺ', 'ᯥ');  // 0x1bba - 0x1be5
    public static final SymbolRange BATAK_SIGN_TO_SIGNS = SymbolRange.range('᯦', '᯳');  // 0x1be6 - 0x1bf3
    public static final SymbolRange BATAK_DEPENDENT_VOWEL_SIGNS_SUBSET = SymbolRange.range('ᯨ', 'ᯩ');  // 0x1be8 - 0x1be9
    public static final SymbolRange BATAK_DEPENDENT_VOWEL_SIGNS_SUBSET_1 = SymbolRange.range('ᯪ', 'ᯬ');  // 0x1bea - 0x1bec
    public static final SymbolRange BATAK_DEPENDENT_VOWEL_SIGNS_TO_DEPENDENT_CONSONANT_SIGNS = SymbolRange.range('ᯯ', 'ᯱ');  // 0x1bef - 0x1bf1
    public static final SymbolRange BATAK_SIGNS_SUBSET = SymbolRange.range('᯲', '᯳');  // 0x1bf2 - 0x1bf3
    public static final SymbolRange BATAK_PUNCTUATION = SymbolRange.range('᯼', '᯿');  // 0x1bfc - 0x1bff
    public static final SymbolRange LEPCHA_CONSONANTS = SymbolRange.range('ᰀ', 'ᰣ');  // 0x1c00 - 0x1c23
    public static final SymbolRange LEPCHA_SUBJOINED_CONSONANTS_TO_DEPENDENT_VOWELS = SymbolRange.range('ᰤ', 'ᰫ');  // 0x1c24 - 0x1c2b
    public static final SymbolRange LEPCHA_SUBJOINED_CONSONANTS_TO_VARIOUS_SIGNS = SymbolRange.range('ᰤ', '᰷');  // 0x1c24 - 0x1c37
    public static final SymbolRange LEPCHA_DEPENDENT_VOWELS_TO_CONSONANT_SIGNS = SymbolRange.range('ᰬ', 'ᰳ');  // 0x1c2c - 0x1c33
    public static final SymbolRange LEPCHA_CONSONANT_SIGNS_SUBSET = SymbolRange.range('ᰴ', 'ᰵ');  // 0x1c34 - 0x1c35
    public static final SymbolRange LEPCHA_VARIOUS_SIGNS_SUBSET = SymbolRange.range('ᰶ', '᰷');  // 0x1c36 - 0x1c37
    public static final SymbolRange LEPCHA_PUNCTUATION = SymbolRange.range('᰻', '᰿');  // 0x1c3b - 0x1c3f
    public static final SymbolRange LEPCHA_DIGITS_SUBSET = SymbolRange.range('᱀', '᱉');  // 0x1c40 - 0x1c49
    public static final SymbolRange LEPCHA_ADDITIONAL_LETTERS = SymbolRange.range('ᱍ', 'ᱏ');  // 0x1c4d - 0x1c4f
    public static final SymbolRange OL_CHIKI_DIGITS = SymbolRange.range('᱐', '᱙');  // 0x1c50 - 0x1c59
    public static final SymbolRange OL_CHIKI_LETTERS = SymbolRange.range('ᱚ', 'ᱷ');  // 0x1c5a - 0x1c77
    public static final SymbolRange OL_CHIKI_LETTERS_TO_MODIFIER_LETTERS = SymbolRange.range('ᱚ', 'ᱽ');  // 0x1c5a - 0x1c7d
    public static final SymbolRange OL_CHIKI_MODIFIER_LETTERS = SymbolRange.range('ᱸ', 'ᱽ');  // 0x1c78 - 0x1c7d
    public static final SymbolRange OL_CHIKI_PUNCTUATION = SymbolRange.range('᱾', '᱿');  // 0x1c7e - 0x1c7f
    public static final SymbolRange CYRILLIC_EXTENDED_C_HISTORIC_LETTER_VARIANTS_SUBSET = SymbolRange.range('ᲀ', 'ᲈ');  // 0x1c80 - 0x1c88
    public static final SymbolRange GEORGIAN_EXTENDED_CAPITAL_LETTERS_MTAVRULI_TO_ADDITIONAL_LETTERS = SymbolRange.range('Ა', 'Ჺ');  // 0x1c90 - 0x1cba
    public static final SymbolRange GEORGIAN_EXTENDED_ADDITIONAL_LETTERS_FOR_OSSETIAN_AND_ABKHAZ = SymbolRange.range('Ჽ', 'Ჿ');  // 0x1cbd - 0x1cbf
    public static final SymbolRange SUNDANESE_SUPPLEMENT_PUNCTUATION_SUBSET = SymbolRange.range('᳀', '᳇');  // 0x1cc0 - 0x1cc7
    public static final SymbolRange VEDIC_EXTENSIONS_TONE_MARKS_FOR_THE_SAMAVEDA = SymbolRange.range('᳐', '᳒');  // 0x1cd0 - 0x1cd2
    public static final SymbolRange VEDIC_EXTENSIONS_SIGNS_FOR_YAJURVEDIC_TO_TONE_MARKS_FOR_THE_SATAPATHABRAHMANA = SymbolRange.range('᳔', '᳠');  // 0x1cd4 - 0x1ce0
    public static final SymbolRange VEDIC_EXTENSIONS_SIGNS_FOR_YAJURVEDIC_TO_DIACRITICS_FOR_VISARGA = SymbolRange.range('᳔', '᳨');  // 0x1cd4 - 0x1ce8
    public static final SymbolRange VEDIC_EXTENSIONS_DIACRITICS_FOR_VISARGA = SymbolRange.range('᳢', '᳨');  // 0x1ce2 - 0x1ce8
    public static final SymbolRange VEDIC_EXTENSIONS_NASALIZATION_SIGNS_SUBSET = SymbolRange.range('ᳩ', 'ᳬ');  // 0x1ce9 - 0x1cec
    public static final SymbolRange VEDIC_EXTENSIONS_NASALIZATION_SIGNS_TO_ARDHAVISARGA = SymbolRange.range('ᳮ', 'ᳳ');  // 0x1cee - 0x1cf3
    public static final SymbolRange VEDIC_EXTENSIONS_SIGNS_SUBSET = SymbolRange.range('ᳵ', 'ᳶ');  // 0x1cf5 - 0x1cf6
    public static final SymbolRange VEDIC_EXTENSIONS_SIGNS_TO_SIGNS_FOR_JAIMINIYA_SAMA_VEDA = SymbolRange.range('᳷', '᳹');  // 0x1cf7 - 0x1cf9
    public static final SymbolRange VEDIC_EXTENSIONS_SIGNS_FOR_JAIMINIYA_SAMA_VEDA = SymbolRange.range('᳸', '᳹');  // 0x1cf8 - 0x1cf9
    public static final SymbolRange PHONETIC_EXTENSIONS_LATIN_LETTERS_TO_GREEK_LETTERS = SymbolRange.range('ᴀ', 'ᴫ');  // 0x1d00 - 0x1d2b
    public static final SymbolRange PHONETIC_EXTENSIONS_LATIN_LETTERS_TO_OTHER_PHONETIC_SYMBOLS = SymbolRange.range('ᴀ', 'ᵿ');  // 0x1d00 - 0x1d7f
    public static final SymbolRange PHONETIC_EXTENSIONS_TO_PHONETIC_EXTENSIONS_SUPPLEMENT = SymbolRange.range('ᴀ', 'ᶿ');  // 0x1d00 - 0x1dbf
    public static final SymbolRange PHONETIC_EXTENSIONS_LATIN_SUPERSCRIPT_MODIFIER_LETTERS_TO_GREEK_SUBSCRIPT_MODIFIER_LETTERS = SymbolRange.range('ᴬ', 'ᵪ');  // 0x1d2c - 0x1d6a
    public static final SymbolRange PHONETIC_EXTENSIONS_LATIN_LETTER_TO_LATIN_LETTERS_WITH_MIDDLE_TILDE = SymbolRange.range('ᵫ', 'ᵷ');  // 0x1d6b - 0x1d77
    public static final SymbolRange PHONETIC_EXTENSIONS_TO_PHONETIC_EXTENSIONS_SUPPLEMENT_1 = SymbolRange.range('ᵹ', 'ᶚ');  // 0x1d79 - 0x1d9a
    public static final SymbolRange PHONETIC_EXTENSIONS_SUPPLEMENT_MODIFIER_LETTERS = SymbolRange.range('ᶛ', 'ᶿ');  // 0x1d9b - 0x1dbf
    public static final SymbolRange COMBINING_DIACRITICAL_MARKS_SUPPLEMENT_USED_FOR_ANCIENT_GREEK_TO_MISCELLANEOUS_MARKS = SymbolRange.range('᷀', '᷹');  // 0x1dc0 - 0x1df9
    public static final SymbolRange COMBINING_DIACRITICAL_MARKS_SUPPLEMENT_MISCELLANEOUS_MARKS_TO_ADDITIONAL_MARKS_FOR_UPA = SymbolRange.range('᷻', '᷿');  // 0x1dfb - 0x1dff
    public static final SymbolRange LATIN_EXTENDED_ADDITIONAL_LATIN_GENERAL_USE_EXTENSIONS_TO_MEDIEVALIST_ADDITIONS = SymbolRange.range('Ḁ', 'ỿ');  // 0x1e00 - 0x1eff
    public static final SymbolRange LATIN_EXTENDED_ADDITIONAL_TO_GREEK_EXTENDED = SymbolRange.range('Ḁ', 'ἕ');  // 0x1e00 - 0x1f15
    public static final SymbolRange LATIN_EXTENDED_ADDITIONAL_LATIN_GENERAL_USE_EXTENSIONS_TO_MEDIEVALIST_ADDITIONS_1 = SymbolRange.range('ẕ', 'ẝ');  // 0x1e95 - 0x1e9d
    public static final SymbolRange LATIN_EXTENDED_ADDITIONAL_TO_GREEK_EXTENDED_1 = SymbolRange.range('ỿ', 'ἇ');  // 0x1eff - 0x1f07
    public static final SymbolRange GREEK_EXTENDED_PRECOMPOSED_POLYTONIC_GREEK = SymbolRange.range('ἀ', '῿');  // 0x1f00 - 0x1fff
    public static final SymbolRange GREEK_EXTENDED_PRECOMPOSED_POLYTONIC_GREEK_SUBSET_7 = SymbolRange.range('Ἀ', 'Ἇ');  // 0x1f08 - 0x1f0f
    public static final SymbolRange GREEK_EXTENDED_PRECOMPOSED_POLYTONIC_GREEK_SUBSET_14 = SymbolRange.range('ἐ', 'ἕ');  // 0x1f10 - 0x1f15
    public static final SymbolRange GREEK_EXTENDED_PRECOMPOSED_POLYTONIC_GREEK_SUBSET_19 = SymbolRange.range('Ἐ', 'Ἕ');  // 0x1f18 - 0x1f1d
    public static final SymbolRange GREEK_EXTENDED_PRECOMPOSED_POLYTONIC_GREEK_SUBSET_22 = SymbolRange.range('ἠ', 'ἧ');  // 0x1f20 - 0x1f27
    public static final SymbolRange GREEK_EXTENDED_PRECOMPOSED_POLYTONIC_GREEK_SUBSET_27 = SymbolRange.range('ἠ', 'ὅ');  // 0x1f20 - 0x1f45
    public static final SymbolRange GREEK_EXTENDED_PRECOMPOSED_POLYTONIC_GREEK_SUBSET_28 = SymbolRange.range('Ἠ', 'Ἧ');  // 0x1f28 - 0x1f2f
    public static final SymbolRange GREEK_EXTENDED_PRECOMPOSED_POLYTONIC_GREEK_SUBSET_33 = SymbolRange.range('ἰ', 'ἷ');  // 0x1f30 - 0x1f37
    public static final SymbolRange GREEK_EXTENDED_PRECOMPOSED_POLYTONIC_GREEK_SUBSET_43 = SymbolRange.range('Ἰ', 'Ἷ');  // 0x1f38 - 0x1f3f
    public static final SymbolRange GREEK_EXTENDED_PRECOMPOSED_POLYTONIC_GREEK_SUBSET_1 = SymbolRange.range('ὀ', 'ὅ');  // 0x1f40 - 0x1f45
    public static final SymbolRange GREEK_EXTENDED_PRECOMPOSED_POLYTONIC_GREEK_SUBSET_9 = SymbolRange.range('Ὀ', 'Ὅ');  // 0x1f48 - 0x1f4d
    public static final SymbolRange GREEK_EXTENDED_PRECOMPOSED_POLYTONIC_GREEK_SUBSET_12 = SymbolRange.range('ὐ', 'ὗ');  // 0x1f50 - 0x1f57
    public static final SymbolRange GREEK_EXTENDED_PRECOMPOSED_POLYTONIC_GREEK_SUBSET_21 = SymbolRange.range('Ὗ', 'ώ');  // 0x1f5f - 0x1f7d
    public static final SymbolRange GREEK_EXTENDED_PRECOMPOSED_POLYTONIC_GREEK_SUBSET_23 = SymbolRange.range('ὠ', 'ὧ');  // 0x1f60 - 0x1f67
    public static final SymbolRange GREEK_EXTENDED_PRECOMPOSED_POLYTONIC_GREEK_SUBSET_29 = SymbolRange.range('Ὠ', 'Ὧ');  // 0x1f68 - 0x1f6f
    public static final SymbolRange GREEK_EXTENDED_PRECOMPOSED_POLYTONIC_GREEK_SUBSET_35 = SymbolRange.range('ὰ', 'ώ');  // 0x1f70 - 0x1f7d
    public static final SymbolRange GREEK_EXTENDED_PRECOMPOSED_POLYTONIC_GREEK_SUBSET = SymbolRange.range('ᾀ', 'ᾇ');  // 0x1f80 - 0x1f87
    public static final SymbolRange GREEK_EXTENDED_PRECOMPOSED_POLYTONIC_GREEK_SUBSET_2 = SymbolRange.range('ᾀ', 'ᾴ');  // 0x1f80 - 0x1fb4
    public static final SymbolRange GREEK_EXTENDED_PRECOMPOSED_POLYTONIC_GREEK_SUBSET_8 = SymbolRange.range('ᾈ', 'ᾏ');  // 0x1f88 - 0x1f8f
    public static final SymbolRange GREEK_EXTENDED_PRECOMPOSED_POLYTONIC_GREEK_SUBSET_13 = SymbolRange.range('ᾐ', 'ᾗ');  // 0x1f90 - 0x1f97
    public static final SymbolRange GREEK_EXTENDED_PRECOMPOSED_POLYTONIC_GREEK_SUBSET_18 = SymbolRange.range('ᾘ', 'ᾟ');  // 0x1f98 - 0x1f9f
    public static final SymbolRange GREEK_EXTENDED_PRECOMPOSED_POLYTONIC_GREEK_SUBSET_24 = SymbolRange.range('ᾠ', 'ᾧ');  // 0x1fa0 - 0x1fa7
    public static final SymbolRange GREEK_EXTENDED_PRECOMPOSED_POLYTONIC_GREEK_SUBSET_30 = SymbolRange.range('ᾨ', 'ᾯ');  // 0x1fa8 - 0x1faf
    public static final SymbolRange GREEK_EXTENDED_PRECOMPOSED_POLYTONIC_GREEK_SUBSET_34 = SymbolRange.range('ᾰ', 'ᾴ');  // 0x1fb0 - 0x1fb4
    public static final SymbolRange GREEK_EXTENDED_PRECOMPOSED_POLYTONIC_GREEK_SUBSET_37 = SymbolRange.range('ᾶ', 'ᾷ');  // 0x1fb6 - 0x1fb7
    public static final SymbolRange GREEK_EXTENDED_PRECOMPOSED_POLYTONIC_GREEK_SUBSET_39 = SymbolRange.range('ᾶ', 'ᾼ');  // 0x1fb6 - 0x1fbc
    public static final SymbolRange GREEK_EXTENDED_PRECOMPOSED_POLYTONIC_GREEK_SUBSET_41 = SymbolRange.range('Ᾰ', 'Ά');  // 0x1fb8 - 0x1fbb
    public static final SymbolRange GREEK_EXTENDED_PRECOMPOSED_POLYTONIC_GREEK_SUBSET_45 = SymbolRange.range('᾿', '῁');  // 0x1fbf - 0x1fc1
    public static final SymbolRange GREEK_EXTENDED_PRECOMPOSED_POLYTONIC_GREEK_SUBSET_3 = SymbolRange.range('ῂ', 'ῄ');  // 0x1fc2 - 0x1fc4
    public static final SymbolRange GREEK_EXTENDED_PRECOMPOSED_POLYTONIC_GREEK_SUBSET_4 = SymbolRange.range('ῆ', 'ῇ');  // 0x1fc6 - 0x1fc7
    public static final SymbolRange GREEK_EXTENDED_PRECOMPOSED_POLYTONIC_GREEK_SUBSET_5 = SymbolRange.range('ῆ', 'ῌ');  // 0x1fc6 - 0x1fcc
    public static final SymbolRange GREEK_EXTENDED_PRECOMPOSED_POLYTONIC_GREEK_SUBSET_6 = SymbolRange.range('Ὲ', 'Ή');  // 0x1fc8 - 0x1fcb
    public static final SymbolRange GREEK_EXTENDED_PRECOMPOSED_POLYTONIC_GREEK_SUBSET_10 = SymbolRange.range('῍', '῏');  // 0x1fcd - 0x1fcf
    public static final SymbolRange GREEK_EXTENDED_PRECOMPOSED_POLYTONIC_GREEK_SUBSET_11 = SymbolRange.range('ῐ', 'ΐ');  // 0x1fd0 - 0x1fd3
    public static final SymbolRange GREEK_EXTENDED_PRECOMPOSED_POLYTONIC_GREEK_SUBSET_15 = SymbolRange.range('ῖ', 'ῗ');  // 0x1fd6 - 0x1fd7
    public static final SymbolRange GREEK_EXTENDED_PRECOMPOSED_POLYTONIC_GREEK_SUBSET_16 = SymbolRange.range('ῖ', 'Ί');  // 0x1fd6 - 0x1fdb
    public static final SymbolRange GREEK_EXTENDED_PRECOMPOSED_POLYTONIC_GREEK_SUBSET_17 = SymbolRange.range('Ῐ', 'Ί');  // 0x1fd8 - 0x1fdb
    public static final SymbolRange GREEK_EXTENDED_PRECOMPOSED_POLYTONIC_GREEK_SUBSET_20 = SymbolRange.range('῝', '῟');  // 0x1fdd - 0x1fdf
    public static final SymbolRange GREEK_EXTENDED_PRECOMPOSED_POLYTONIC_GREEK_SUBSET_25 = SymbolRange.range('ῠ', 'ῧ');  // 0x1fe0 - 0x1fe7
    public static final SymbolRange GREEK_EXTENDED_PRECOMPOSED_POLYTONIC_GREEK_SUBSET_26 = SymbolRange.range('ῠ', 'Ῥ');  // 0x1fe0 - 0x1fec
    public static final SymbolRange GREEK_EXTENDED_PRECOMPOSED_POLYTONIC_GREEK_SUBSET_31 = SymbolRange.range('Ῠ', 'Ῥ');  // 0x1fe8 - 0x1fec
    public static final SymbolRange GREEK_EXTENDED_PRECOMPOSED_POLYTONIC_GREEK_SUBSET_32 = SymbolRange.range('῭', '`');  // 0x1fed - 0x1fef
    public static final SymbolRange GREEK_EXTENDED_PRECOMPOSED_POLYTONIC_GREEK_SUBSET_36 = SymbolRange.range('ῲ', 'ῴ');  // 0x1ff2 - 0x1ff4
    public static final SymbolRange GREEK_EXTENDED_PRECOMPOSED_POLYTONIC_GREEK_SUBSET_38 = SymbolRange.range('ῶ', 'ῷ');  // 0x1ff6 - 0x1ff7
    public static final SymbolRange GREEK_EXTENDED_PRECOMPOSED_POLYTONIC_GREEK_SUBSET_40 = SymbolRange.range('ῶ', 'ῼ');  // 0x1ff6 - 0x1ffc
    public static final SymbolRange GREEK_EXTENDED_PRECOMPOSED_POLYTONIC_GREEK_SUBSET_42 = SymbolRange.range('Ὸ', 'Ώ');  // 0x1ff8 - 0x1ffb
    public static final SymbolRange GREEK_EXTENDED_PRECOMPOSED_POLYTONIC_GREEK_SUBSET_44 = SymbolRange.range('´', '῾');  // 0x1ffd - 0x1ffe
    public static final SymbolRange GENERAL_PUNCTUATION_SPACES = SymbolRange.range(' ', ' ');  // 0x2000 - 0x200a
    public static final SymbolRange GENERAL_PUNCTUATION_SPACES_TO_DEPRECATED = SymbolRange.range(' ', '⁯');  // 0x2000 - 0x206f
    public static final SymbolRange GENERAL_PUNCTUATION_FORMAT_CHARACTERS = SymbolRange.range('​', '‏');  // 0x200b - 0x200f
    public static final SymbolRange GENERAL_PUNCTUATION_DASHES = SymbolRange.range('‐', '―');  // 0x2010 - 0x2015
    public static final SymbolRange GENERAL_PUNCTUATION_DASHES_TO_GENERAL_PUNCTUATION = SymbolRange.range('‐', '‧');  // 0x2010 - 0x2027
    public static final SymbolRange GENERAL_PUNCTUATION_GENERAL_PUNCTUATION = SymbolRange.range('‖', '‗');  // 0x2016 - 0x2017
    public static final SymbolRange GENERAL_PUNCTUATION_QUOTATION_MARKS_AND_APOSTROPHE_SUBSET = SymbolRange.range('‛', '“');  // 0x201b - 0x201c
    public static final SymbolRange GENERAL_PUNCTUATION_GENERAL_PUNCTUATION_1 = SymbolRange.range('†', '‧');  // 0x2020 - 0x2027
    public static final SymbolRange GENERAL_PUNCTUATION_SEPARATORS = SymbolRange.range(' ', ' ');  // 0x2028 - 0x2029
    public static final SymbolRange GENERAL_PUNCTUATION_FORMAT_CHARACTERS_1 = SymbolRange.range('‪', '‮');  // 0x202a - 0x202e
    public static final SymbolRange GENERAL_PUNCTUATION_GENERAL_PUNCTUATION_2 = SymbolRange.range('‰', '‸');  // 0x2030 - 0x2038
    public static final SymbolRange GENERAL_PUNCTUATION_GENERAL_PUNCTUATION_TO_GENERAL_PUNCTUATION = SymbolRange.range('‰', '⁃');  // 0x2030 - 0x2043
    public static final SymbolRange GENERAL_PUNCTUATION_GENERAL_PUNCTUATION_TO_GENERAL_PUNCTUATION_1 = SymbolRange.range('※', '‾');  // 0x203b - 0x203e
    public static final SymbolRange GENERAL_PUNCTUATION_GENERAL_PUNCTUATION_SUBSET_1 = SymbolRange.range('‿', '⁀');  // 0x203f - 0x2040
    public static final SymbolRange GENERAL_PUNCTUATION_GENERAL_PUNCTUATION_SUBSET = SymbolRange.range('⁁', '⁃');  // 0x2041 - 0x2043
    public static final SymbolRange GENERAL_PUNCTUATION_BRACKETS_TO_GENERAL_PUNCTUATION = SymbolRange.range('⁅', '⁑');  // 0x2045 - 0x2051
    public static final SymbolRange GENERAL_PUNCTUATION_DOUBLE_PUNCTUATION_FOR_VERTICAL_TEXT_TO_GENERAL_PUNCTUATION = SymbolRange.range('⁇', '⁑');  // 0x2047 - 0x2051
    public static final SymbolRange GENERAL_PUNCTUATION_GENERAL_PUNCTUATION_TO_ARCHAIC_PUNCTUATION = SymbolRange.range('⁓', '⁞');  // 0x2053 - 0x205e
    public static final SymbolRange GENERAL_PUNCTUATION_GENERAL_PUNCTUATION_TO_ARCHAIC_PUNCTUATION_1 = SymbolRange.range('⁕', '⁞');  // 0x2055 - 0x205e
    public static final SymbolRange GENERAL_PUNCTUATION_FORMAT_CHARACTER_TO_INVISIBLE_OPERATORS = SymbolRange.range('⁠', '⁤');  // 0x2060 - 0x2064
    public static final SymbolRange GENERAL_PUNCTUATION_FORMAT_CHARACTERS_TO_DEPRECATED = SymbolRange.range('⁦', '⁯');  // 0x2066 - 0x206f
    public static final SymbolRange SUPERSCRIPTS_AND_SUBSCRIPTS_SUPERSCRIPTS_TO_SUBSCRIPTS_FOR_UPA = SymbolRange.range('⁰', '₟');  // 0x2070 - 0x209f
    public static final SymbolRange SUPERSCRIPTS_AND_SUBSCRIPTS_SUPERSCRIPTS_SUBSET = SymbolRange.range('⁴', '⁹');  // 0x2074 - 0x2079
    public static final SymbolRange SUPERSCRIPTS_AND_SUBSCRIPTS_SUPERSCRIPTS_SUBSET_1 = SymbolRange.range('⁺', '⁼');  // 0x207a - 0x207c
    public static final SymbolRange SUPERSCRIPTS_AND_SUBSCRIPTS_SUPERSCRIPTS_SUBSET_2 = SymbolRange.range('⁽', '⁾');  // 0x207d - 0x207e
    public static final SymbolRange SUPERSCRIPTS_AND_SUBSCRIPTS_SUBSCRIPTS_SUBSET = SymbolRange.range('₀', '₉');  // 0x2080 - 0x2089
    public static final SymbolRange SUPERSCRIPTS_AND_SUBSCRIPTS_SUBSCRIPTS_SUBSET_1 = SymbolRange.range('₊', '₌');  // 0x208a - 0x208c
    public static final SymbolRange SUPERSCRIPTS_AND_SUBSCRIPTS_SUBSCRIPTS_SUBSET_2 = SymbolRange.range('₍', '₎');  // 0x208d - 0x208e
    public static final SymbolRange SUPERSCRIPTS_AND_SUBSCRIPTS_SUBSCRIPTS_TO_SUBSCRIPTS_FOR_UPA = SymbolRange.range('ₐ', 'ₜ');  // 0x2090 - 0x209c
    public static final SymbolRange CURRENCY_SYMBOLS_CURRENCY_SYMBOLS_SUBSET = SymbolRange.range('₠', '₿');  // 0x20a0 - 0x20bf
    public static final SymbolRange CURRENCY_SYMBOLS_CURRENCY_SYMBOLS = SymbolRange.range('₠', '⃏');  // 0x20a0 - 0x20cf
    public static final SymbolRange COMBINING_DIACRITICAL_MARKS_FOR_SYMBOLS_COMBINING_DIACRITICAL_MARKS_FOR_SYMBOLS = SymbolRange.range('⃐', '⃜');  // 0x20d0 - 0x20dc
    public static final SymbolRange COMBINING_DIACRITICAL_MARKS_FOR_SYMBOLS_COMBINING_DIACRITICAL_MARKS_FOR_SYMBOLS_TO_ADDITIONAL_DIACRITICAL_MARKS_FOR_SYMBOLS = SymbolRange.range('⃐', '⃰');  // 0x20d0 - 0x20f0
    public static final SymbolRange COMBINING_DIACRITICAL_MARKS_FOR_SYMBOLS_ENCLOSING_DIACRITICS = SymbolRange.range('⃝', '⃠');  // 0x20dd - 0x20e0
    public static final SymbolRange COMBINING_DIACRITICAL_MARKS_FOR_SYMBOLS_ADDITIONAL_ENCLOSING_DIACRITICS = SymbolRange.range('⃢', '⃤');  // 0x20e2 - 0x20e4
    public static final SymbolRange COMBINING_DIACRITICAL_MARKS_FOR_SYMBOLS_ADDITIONAL_DIACRITICAL_MARKS_FOR_SYMBOLS_SUBSET = SymbolRange.range('⃥', '⃰');  // 0x20e5 - 0x20f0
    public static final SymbolRange LETTERLIKE_SYMBOLS_LETTERLIKE_SYMBOLS_SUBSET = SymbolRange.range('℀', '℁');  // 0x2100 - 0x2101
    public static final SymbolRange LETTERLIKE_SYMBOLS_LETTERLIKE_SYMBOLS_TO_LOWERCASE_CLAUDIAN_LETTER = SymbolRange.range('℀', '⅏');  // 0x2100 - 0x214f
    public static final SymbolRange LETTERLIKE_SYMBOLS_LETTERLIKE_SYMBOLS_SUBSET_1 = SymbolRange.range('℃', '℆');  // 0x2103 - 0x2106
    public static final SymbolRange LETTERLIKE_SYMBOLS_LETTERLIKE_SYMBOLS_SUBSET_2 = SymbolRange.range('℈', '℉');  // 0x2108 - 0x2109
    public static final SymbolRange LETTERLIKE_SYMBOLS_LETTERLIKE_SYMBOLS_SUBSET_3 = SymbolRange.range('ℊ', 'ℓ');  // 0x210a - 0x2113
    public static final SymbolRange LETTERLIKE_SYMBOLS_LETTERLIKE_SYMBOLS_SUBSET_4 = SymbolRange.range('ℋ', 'ℍ');  // 0x210b - 0x210d
    public static final SymbolRange LETTERLIKE_SYMBOLS_LETTERLIKE_SYMBOLS_SUBSET_5 = SymbolRange.range('ℎ', 'ℏ');  // 0x210e - 0x210f
    public static final SymbolRange LETTERLIKE_SYMBOLS_LETTERLIKE_SYMBOLS_SUBSET_6 = SymbolRange.range('ℐ', 'ℒ');  // 0x2110 - 0x2112
    public static final SymbolRange LETTERLIKE_SYMBOLS_LETTERLIKE_SYMBOLS_SUBSET_7 = SymbolRange.range('№', '℗');  // 0x2116 - 0x2117
    public static final SymbolRange LETTERLIKE_SYMBOLS_LETTERLIKE_SYMBOLS_SUBSET_8 = SymbolRange.range('№', '℘');  // 0x2116 - 0x2118
    public static final SymbolRange LETTERLIKE_SYMBOLS_LETTERLIKE_SYMBOLS_SUBSET_9 = SymbolRange.range('ℙ', 'ℝ');  // 0x2119 - 0x211d
    public static final SymbolRange LETTERLIKE_SYMBOLS_LETTERLIKE_SYMBOLS_SUBSET_10 = SymbolRange.range('℞', '℣');  // 0x211e - 0x2123
    public static final SymbolRange LETTERLIKE_SYMBOLS_LETTERLIKE_SYMBOLS_SUBSET_11 = SymbolRange.range('K', 'ℭ');  // 0x212a - 0x212d
    public static final SymbolRange LETTERLIKE_SYMBOLS_LETTERLIKE_SYMBOLS_TO_HEBREW_LETTERLIKE_MATH_SYMBOLS = SymbolRange.range('ℯ', 'ℹ');  // 0x212f - 0x2139
    public static final SymbolRange LETTERLIKE_SYMBOLS_LETTERLIKE_SYMBOLS_SUBSET_12 = SymbolRange.range('ℰ', 'ℳ');  // 0x2130 - 0x2133
    public static final SymbolRange LETTERLIKE_SYMBOLS_HEBREW_LETTERLIKE_MATH_SYMBOLS = SymbolRange.range('ℵ', 'ℸ');  // 0x2135 - 0x2138
    public static final SymbolRange LETTERLIKE_SYMBOLS_ADDITIONAL_LETTERLIKE_SYMBOLS_SUBSET_1 = SymbolRange.range('℺', '℻');  // 0x213a - 0x213b
    public static final SymbolRange LETTERLIKE_SYMBOLS_ADDITIONAL_LETTERLIKE_SYMBOLS_SUBSET_2 = SymbolRange.range('ℼ', 'ℽ');  // 0x213c - 0x213d
    public static final SymbolRange LETTERLIKE_SYMBOLS_ADDITIONAL_LETTERLIKE_SYMBOLS_SUBSET_3 = SymbolRange.range('ℼ', 'ℿ');  // 0x213c - 0x213f
    public static final SymbolRange LETTERLIKE_SYMBOLS_ADDITIONAL_LETTERLIKE_SYMBOLS_SUBSET_4 = SymbolRange.range('ℾ', 'ℿ');  // 0x213e - 0x213f
    public static final SymbolRange LETTERLIKE_SYMBOLS_DOUBLE_STRUCK_LARGE_OPERATOR_TO_ADDITIONAL_LETTERLIKE_SYMBOLS = SymbolRange.range('⅀', '⅄');  // 0x2140 - 0x2144
    public static final SymbolRange LETTERLIKE_SYMBOLS_DOUBLE_STRUCK_ITALIC_MATH_SYMBOLS = SymbolRange.range('ⅅ', 'ⅉ');  // 0x2145 - 0x2149
    public static final SymbolRange LETTERLIKE_SYMBOLS_DOUBLE_STRUCK_ITALIC_MATH_SYMBOLS_SUBSET = SymbolRange.range('ⅆ', 'ⅉ');  // 0x2146 - 0x2149
    public static final SymbolRange LETTERLIKE_SYMBOLS_ADDITIONAL_LETTERLIKE_SYMBOLS_2 = SymbolRange.range('⅊', '⅍');  // 0x214a - 0x214d
    public static final SymbolRange LETTERLIKE_SYMBOLS_ADDITIONAL_LETTERLIKE_SYMBOLS_SUBSET = SymbolRange.range('⅌', '⅍');  // 0x214c - 0x214d
    public static final SymbolRange NUMBER_FORMS_FRACTIONS = SymbolRange.range('⅐', '⅟');  // 0x2150 - 0x215f
    public static final SymbolRange NUMBER_FORMS_FRACTIONS_TO_ARCHAIC_ROMAN_NUMERALS = SymbolRange.range('⅐', 'ↂ');  // 0x2150 - 0x2182
    public static final SymbolRange NUMBER_FORMS_FRACTIONS_TO_TURNED_DIGITS = SymbolRange.range('⅐', '↏');  // 0x2150 - 0x218f
    public static final SymbolRange NUMBER_FORMS_ROMAN_NUMERALS_TO_ARCHAIC_ROMAN_NUMERALS = SymbolRange.range('Ⅰ', 'ↂ');  // 0x2160 - 0x2182
    public static final SymbolRange NUMBER_FORMS_ARCHAIC_ROMAN_NUMERALS_TO_ARCHAIC_ROMAN_NUMERALS = SymbolRange.range('Ↄ', 'ↄ');  // 0x2183 - 0x2184
    public static final SymbolRange NUMBER_FORMS_ARCHAIC_ROMAN_NUMERALS_TO_ARCHAIC_ROMAN_NUMERALS_1 = SymbolRange.range('ↅ', '↉');  // 0x2185 - 0x2189
    public static final SymbolRange NUMBER_FORMS_ARCHAIC_ROMAN_NUMERALS_1 = SymbolRange.range('ↅ', 'ↈ');  // 0x2185 - 0x2188
    public static final SymbolRange NUMBER_FORMS_TURNED_DIGITS_SUBSET = SymbolRange.range('↊', '↋');  // 0x218a - 0x218b
    public static final SymbolRange ARROWS_SIMPLE_ARROWS_SUBSET = SymbolRange.range('←', '↔');  // 0x2190 - 0x2194
    public static final SymbolRange ARROWS_SIMPLE_ARROWS_TO_MISCELLANEOUS_ARROWS = SymbolRange.range('←', '⇿');  // 0x2190 - 0x21ff
    public static final SymbolRange ARROWS_TO_MISCELLANEOUS_TECHNICAL = SymbolRange.range('←', '⌇');  // 0x2190 - 0x2307
    public static final SymbolRange ARROWS_SIMPLE_ARROWS_SUBSET_1 = SymbolRange.range('↕', '↙');  // 0x2195 - 0x2199
    public static final SymbolRange ARROWS_ARROWS_WITH_MODIFICATIONS_SUBSET = SymbolRange.range('↚', '↛');  // 0x219a - 0x219b
    public static final SymbolRange ARROWS_ARROWS_WITH_MODIFICATIONS_SUBSET_1 = SymbolRange.range('↜', '↟');  // 0x219c - 0x219f
    public static final SymbolRange ARROWS_ARROWS_WITH_MODIFICATIONS_SUBSET_2 = SymbolRange.range('↡', '↢');  // 0x21a1 - 0x21a2
    public static final SymbolRange ARROWS_ARROWS_WITH_MODIFICATIONS_SUBSET_3 = SymbolRange.range('↤', '↥');  // 0x21a4 - 0x21a5
    public static final SymbolRange ARROWS_ARROWS_WITH_MODIFICATIONS_SUBSET_4 = SymbolRange.range('↧', '↭');  // 0x21a7 - 0x21ad
    public static final SymbolRange ARROWS_ARROWS_WITH_MODIFICATIONS_TO_PAIRED_ARROWS_AND_HARPOONS = SymbolRange.range('↯', '⇍');  // 0x21af - 0x21cd
    public static final SymbolRange ARROWS_DOUBLE_ARROWS_SUBSET = SymbolRange.range('⇎', '⇏');  // 0x21ce - 0x21cf
    public static final SymbolRange ARROWS_DOUBLE_ARROWS_SUBSET_1 = SymbolRange.range('⇐', '⇑');  // 0x21d0 - 0x21d1
    public static final SymbolRange ARROWS_DOUBLE_ARROWS_TO_WHITE_ARROWS_AND_KEYBOARD_SYMBOLS = SymbolRange.range('⇕', '⇳');  // 0x21d5 - 0x21f3
    public static final SymbolRange ARROWS_TO_MATHEMATICAL_OPERATORS = SymbolRange.range('⇴', '⋿');  // 0x21f4 - 0x22ff
    public static final SymbolRange MATHEMATICAL_OPERATORS_MISCELLANEOUS_MATHEMATICAL_SYMBOLS_TO_RELATIONS = SymbolRange.range('∀', '⋿');  // 0x2200 - 0x22ff
    public static final SymbolRange MISCELLANEOUS_TECHNICAL_MISCELLANEOUS_TECHNICAL = SymbolRange.range('⌀', '⌇');  // 0x2300 - 0x2307
    public static final SymbolRange MISCELLANEOUS_TECHNICAL_MISCELLANEOUS_TECHNICAL_TO_POWER_SYMBOL_FROM_IEEE_1621_2004 = SymbolRange.range('⌀', '⏿');  // 0x2300 - 0x23ff
    public static final SymbolRange MISCELLANEOUS_TECHNICAL_CEILINGS_AND_FLOORS = SymbolRange.range('⌈', '⌋');  // 0x2308 - 0x230b
    public static final SymbolRange MISCELLANEOUS_TECHNICAL_CROPS_TO_QUINE_CORNERS = SymbolRange.range('⌌', '⌟');  // 0x230c - 0x231f
    public static final SymbolRange MISCELLANEOUS_TECHNICAL_CROPS_TO_KEYBOARD_SYMBOLS = SymbolRange.range('⌌', '⌨');  // 0x230c - 0x2328
    public static final SymbolRange MISCELLANEOUS_TECHNICAL_INTEGRAL_PIECES = SymbolRange.range('⌠', '⌡');  // 0x2320 - 0x2321
    public static final SymbolRange MISCELLANEOUS_TECHNICAL_FROWN_AND_SMILE_TO_KEYBOARD_SYMBOLS = SymbolRange.range('⌢', '⌨');  // 0x2322 - 0x2328
    public static final SymbolRange MISCELLANEOUS_TECHNICAL_DEPRECATED_ANGLE_BRACKETS = SymbolRange.range('〈', '〉');  // 0x2329 - 0x232a
    public static final SymbolRange MISCELLANEOUS_TECHNICAL_KEYBOARD_SYMBOL_TO_APL = SymbolRange.range('⌫', '⍻');  // 0x232b - 0x237b
    public static final SymbolRange MISCELLANEOUS_TECHNICAL_TO_CONTROL_PICTURES_1 = SymbolRange.range('⌫', '␦');  // 0x232b - 0x2426
    public static final SymbolRange MISCELLANEOUS_TECHNICAL_GRAPHICS_FOR_CONTROL_CODES_TO_KEYBOARD_SYMBOLS_FROM_ISO_9995_7 = SymbolRange.range('⍽', '⎚');  // 0x237d - 0x239a
    public static final SymbolRange MISCELLANEOUS_TECHNICAL_BRACKET_PIECES_TO_SUMMATION_SIGN_PARTS = SymbolRange.range('⎛', '⎳');  // 0x239b - 0x23b3
    public static final SymbolRange MISCELLANEOUS_TECHNICAL_HORIZONTAL_BRACKETS_TO_ELECTROTECHNICAL_SYMBOLS = SymbolRange.range('⎴', '⏛');  // 0x23b4 - 0x23db
    public static final SymbolRange MISCELLANEOUS_TECHNICAL_HORIZONTAL_BRACKETS_1 = SymbolRange.range('⏜', '⏡');  // 0x23dc - 0x23e1
    public static final SymbolRange MISCELLANEOUS_TECHNICAL_TO_CONTROL_PICTURES = SymbolRange.range('⏢', '␦');  // 0x23e2 - 0x2426
    public static final SymbolRange CONTROL_PICTURES_GRAPHIC_PICTURES_FOR_CONTROL_CODES_TO_SPECIFIC_SYMBOL_FOR_CONTROL_CODE = SymbolRange.range('␀', '␿');  // 0x2400 - 0x243f
    public static final SymbolRange OPTICAL_CHARACTER_RECOGNITION_OCR_A_TO_MICR = SymbolRange.range('⑀', '⑊');  // 0x2440 - 0x244a
    public static final SymbolRange OPTICAL_CHARACTER_RECOGNITION_OCR_A_TO_OCR = SymbolRange.range('⑀', '⑟');  // 0x2440 - 0x245f
    public static final SymbolRange ENCLOSED_ALPHANUMERICS_CIRCLED_NUMBERS_TO_NUMBERS_PERIOD = SymbolRange.range('①', '⒛');  // 0x2460 - 0x249b
    public static final SymbolRange ENCLOSED_ALPHANUMERICS_CIRCLED_NUMBERS_TO_DOUBLE_CIRCLED_NUMBERS = SymbolRange.range('①', '⓿');  // 0x2460 - 0x24ff
    public static final SymbolRange ENCLOSED_ALPHANUMERICS_PARENTHESIZED_LATIN_LETTERS_TO_CIRCLED_LATIN_LETTERS = SymbolRange.range('⒜', 'ⓩ');  // 0x249c - 0x24e9
    public static final SymbolRange ENCLOSED_ALPHANUMERICS_ADDITIONAL_CIRCLED_NUMBER_TO_DOUBLE_CIRCLED_NUMBERS = SymbolRange.range('⓪', '⓿');  // 0x24ea - 0x24ff
    public static final SymbolRange BOX_DRAWING_LIGHT_AND_HEAVY_SOLID_LINES_TO_MIXED_LIGHT_AND_HEAVY_LINES = SymbolRange.range('─', '╿');  // 0x2500 - 0x257f
    public static final SymbolRange BOX_DRAWING_TO_GEOMETRIC_SHAPES = SymbolRange.range('─', '▶');  // 0x2500 - 0x25b6
    public static final SymbolRange BOX_DRAWING_TO_DINGBATS = SymbolRange.range('─', '❧');  // 0x2500 - 0x2767
    public static final SymbolRange BLOCK_ELEMENTS_BLOCK_ELEMENTS_TO_TERMINAL_GRAPHIC_CHARACTERS = SymbolRange.range('▀', '▟');  // 0x2580 - 0x259f
    public static final SymbolRange GEOMETRIC_SHAPES_GEOMETRIC_SHAPES_TO_GEOMETRIC_SHAPES = SymbolRange.range('■', '◿');  // 0x25a0 - 0x25ff
    public static final SymbolRange GEOMETRIC_SHAPES_GEOMETRIC_SHAPES_SUBSET = SymbolRange.range('▸', '◀');  // 0x25b8 - 0x25c0
    public static final SymbolRange GEOMETRIC_SHAPES_GEOMETRIC_SHAPES_TO_CONTROL_CODE_GRAPHICS = SymbolRange.range('◂', '◷');  // 0x25c2 - 0x25f7
    public static final SymbolRange GEOMETRIC_SHAPES_GEOMETRIC_SHAPES_1 = SymbolRange.range('◸', '◿');  // 0x25f8 - 0x25ff
    public static final SymbolRange MISCELLANEOUS_SYMBOLS_WEATHER_AND_ASTROLOGICAL_SYMBOLS_TO_MUSICAL_SYMBOLS = SymbolRange.range('☀', '♮');  // 0x2600 - 0x266e
    public static final SymbolRange MISCELLANEOUS_SYMBOLS_WEATHER_AND_ASTROLOGICAL_SYMBOLS_TO_MAP_SYMBOLS_FROM_ARIB_STD_B24 = SymbolRange.range('☀', '⛿');  // 0x2600 - 0x26ff
    public static final SymbolRange MISCELLANEOUS_SYMBOLS_TO_DINGBATS = SymbolRange.range('♰', '❧');  // 0x2670 - 0x2767
    public static final SymbolRange DINGBATS_MISCELLANEOUS_TO_DINGBAT_ARROWS = SymbolRange.range('✀', '➿');  // 0x2700 - 0x27bf
    public static final SymbolRange DINGBATS_ORNAMENTAL_BRACKETS = SymbolRange.range('❨', '❵');  // 0x2768 - 0x2775
    public static final SymbolRange DINGBATS_DINGBAT_CIRCLED_DIGITS = SymbolRange.range('❶', '➓');  // 0x2776 - 0x2793
    public static final SymbolRange DINGBATS_DINGBAT_ARROW_TO_DINGBAT_ARROWS = SymbolRange.range('➔', '➿');  // 0x2794 - 0x27bf
    public static final SymbolRange DINGBATS_TO_MISCELLANEOUS_MATHEMATICAL_SYMBOLS_A = SymbolRange.range('➔', '⟄');  // 0x2794 - 0x27c4
    public static final SymbolRange MISCELLANEOUS_MATHEMATICAL_SYMBOLS_A_MISCELLANEOUS_SYMBOLS = SymbolRange.range('⟀', '⟄');  // 0x27c0 - 0x27c4
    public static final SymbolRange MISCELLANEOUS_MATHEMATICAL_SYMBOLS_A_PAIRED_PUNCTUATION = SymbolRange.range('⟅', '⟆');  // 0x27c5 - 0x27c6
    public static final SymbolRange MISCELLANEOUS_MATHEMATICAL_SYMBOLS_A_OPERATOR_TO_MODAL_LOGIC_OPERATORS = SymbolRange.range('⟇', '⟥');  // 0x27c7 - 0x27e5
    public static final SymbolRange MISCELLANEOUS_MATHEMATICAL_SYMBOLS_A_MATHEMATICAL_BRACKETS = SymbolRange.range('⟦', '⟯');  // 0x27e6 - 0x27ef
    public static final SymbolRange SUPPLEMENTAL_ARROWS_A_ARROWS_TO_LONG_ARROWS = SymbolRange.range('⟰', '⟿');  // 0x27f0 - 0x27ff
    public static final SymbolRange SUPPLEMENTAL_ARROWS_A_TO_MISCELLANEOUS_MATHEMATICAL_SYMBOLS_B = SymbolRange.range('⟰', '⦂');  // 0x27f0 - 0x2982
    public static final SymbolRange BRAILLE_PATTERNS_BRAILLE_PATTERNS = SymbolRange.range('⠀', '⣿');  // 0x2800 - 0x28ff
    public static final SymbolRange SUPPLEMENTAL_ARROWS_B_TO_MISCELLANEOUS_MATHEMATICAL_SYMBOLS_B = SymbolRange.range('⤀', '⦂');  // 0x2900 - 0x2982
    public static final SymbolRange MISCELLANEOUS_MATHEMATICAL_SYMBOLS_B_BRACKETS_TO_BRACKETS = SymbolRange.range('⦃', '⦘');  // 0x2983 - 0x2998
    public static final SymbolRange MISCELLANEOUS_MATHEMATICAL_SYMBOLS_B_FENCES_TO_BOWTIE_SYMBOLS = SymbolRange.range('⦙', '⧗');  // 0x2999 - 0x29d7
    public static final SymbolRange MISCELLANEOUS_MATHEMATICAL_SYMBOLS_B_FENCES_1 = SymbolRange.range('⧘', '⧛');  // 0x29d8 - 0x29db
    public static final SymbolRange MISCELLANEOUS_MATHEMATICAL_SYMBOLS_B_MISCELLANEOUS_MATHEMATICAL_SYMBOLS_TO_SPECIALIZED_PLUS_SIGN_OPERATORS = SymbolRange.range('⧜', '⧻');  // 0x29dc - 0x29fb
    public static final SymbolRange MISCELLANEOUS_MATHEMATICAL_SYMBOLS_B_BRACKETS_2 = SymbolRange.range('⧼', '⧽');  // 0x29fc - 0x29fd
    public static final SymbolRange MISCELLANEOUS_MATHEMATICAL_SYMBOLS_B_TO_SUPPLEMENTAL_MATHEMATICAL_OPERATORS = SymbolRange.range('⧾', '⫿');  // 0x29fe - 0x2aff
    public static final SymbolRange MISCELLANEOUS_MATHEMATICAL_SYMBOLS_B_TO_MISCELLANEOUS_SYMBOLS_AND_ARROWS = SymbolRange.range('⧾', '⭳');  // 0x29fe - 0x2b73
    public static final SymbolRange SUPPLEMENTAL_MATHEMATICAL_OPERATORS_N_ARY_OPERATORS_TO_OPERATORS = SymbolRange.range('⨀', '⫿');  // 0x2a00 - 0x2aff
    public static final SymbolRange MISCELLANEOUS_SYMBOLS_AND_ARROWS_WHITE_AND_BLACK_ARROWS_TO_ELLIPSES = SymbolRange.range('⬀', '⬯');  // 0x2b00 - 0x2b2f
    public static final SymbolRange MISCELLANEOUS_SYMBOLS_AND_ARROWS_WHITE_AND_BLACK_ARROWS_TO_SYMBOLS_USED_IN_CHESS_NOTATION = SymbolRange.range('⬀', '⯿');  // 0x2b00 - 0x2bff
    public static final SymbolRange MISCELLANEOUS_SYMBOLS_AND_ARROWS_MATHEMATICAL_ARROWS_SUBSET_2 = SymbolRange.range('⬰', '⭄');  // 0x2b30 - 0x2b44
    public static final SymbolRange MISCELLANEOUS_SYMBOLS_AND_ARROWS_MATHEMATICAL_ARROWS_SUBSET = SymbolRange.range('⭅', '⭆');  // 0x2b45 - 0x2b46
    public static final SymbolRange MISCELLANEOUS_SYMBOLS_AND_ARROWS_MATHEMATICAL_ARROWS_SUBSET_1 = SymbolRange.range('⭇', '⭌');  // 0x2b47 - 0x2b4c
    public static final SymbolRange MISCELLANEOUS_SYMBOLS_AND_ARROWS_MISCELLANEOUS_ARROW_TO_TRIANGLE_HEADED_ARROWS = SymbolRange.range('⭍', '⭳');  // 0x2b4d - 0x2b73
    public static final SymbolRange MISCELLANEOUS_SYMBOLS_AND_ARROWS_TRIANGLE_HEADED_ARROWS_TO_MISCELLANEOUS_ARROW_SYMBOL = SymbolRange.range('⭶', '⮕');  // 0x2b76 - 0x2b95
    public static final SymbolRange MISCELLANEOUS_SYMBOLS_AND_ARROWS_MISCELLANEOUS_SYMBOL_TO_SYMBOLS_USED_IN_CHESS_NOTATION = SymbolRange.range('⮗', '⯿');  // 0x2b97 - 0x2bff
    public static final SymbolRange GLAGOLITIC_CAPITAL_LETTERS_SUBSET = SymbolRange.range('Ⰰ', 'Ⱞ');  // 0x2c00 - 0x2c2e
    public static final SymbolRange GLAGOLITIC_SMALL_LETTERS_SUBSET = SymbolRange.range('ⰰ', 'ⱞ');  // 0x2c30 - 0x2c5e
    public static final SymbolRange LATIN_EXTENDED_C_TO_COPTIC = SymbolRange.range('Ⱡ', 'ⳤ');  // 0x2c60 - 0x2ce4
    public static final SymbolRange LATIN_EXTENDED_C_ORTHOGRAPHIC_LATIN_ADDITIONS_SUBSET = SymbolRange.range('Ɫ', 'Ɽ');  // 0x2c62 - 0x2c64
    public static final SymbolRange LATIN_EXTENDED_C_ORTHOGRAPHIC_LATIN_ADDITIONS_SUBSET_1 = SymbolRange.range('ⱥ', 'ⱦ');  // 0x2c65 - 0x2c66
    public static final SymbolRange LATIN_EXTENDED_C_MISCELLANEOUS_ADDITIONS_SUBSET = SymbolRange.range('Ɑ', 'Ɒ');  // 0x2c6d - 0x2c70
    public static final SymbolRange LATIN_EXTENDED_C_MISCELLANEOUS_ADDITIONS_SUBSET_1 = SymbolRange.range('ⱳ', 'ⱴ');  // 0x2c73 - 0x2c74
    public static final SymbolRange LATIN_EXTENDED_C_CLAUDIAN_LETTERS_TO_ADDITIONS_FOR_UPA = SymbolRange.range('ⱶ', 'ⱻ');  // 0x2c76 - 0x2c7b
    public static final SymbolRange LATIN_EXTENDED_C_ADDITIONS_FOR_UPA_SUBSET = SymbolRange.range('ⱼ', 'ⱽ');  // 0x2c7c - 0x2c7d
    public static final SymbolRange LATIN_EXTENDED_C_ADDITIONS_FOR_SHONA_TO_ADDITIONS_FOR_SHONA = SymbolRange.range('Ȿ', 'Ⲁ');  // 0x2c7e - 0x2c80
    public static final SymbolRange COPTIC_OLD_NUBIAN_LETTERS_TO_OLD_NUBIAN_LETTERS = SymbolRange.range('ⳣ', 'ⳤ');  // 0x2ce3 - 0x2ce4
    public static final SymbolRange COPTIC_SYMBOLS_SUBSET = SymbolRange.range('⳥', '⳪');  // 0x2ce5 - 0x2cea
    public static final SymbolRange COPTIC_CRYPTOGRAMMIC_LETTERS = SymbolRange.range('Ⳬ', 'ⳮ');  // 0x2ceb - 0x2cee
    public static final SymbolRange COPTIC_COMBINING_MARKS = SymbolRange.range('⳯', '⳱');  // 0x2cef - 0x2cf1
    public static final SymbolRange COPTIC_BOHAIRIC_COPTIC_LETTERS_SUBSET = SymbolRange.range('Ⳳ', 'ⳳ');  // 0x2cf2 - 0x2cf3
    public static final SymbolRange COPTIC_OLD_NUBIAN_PUNCTUATION = SymbolRange.range('⳹', '⳼');  // 0x2cf9 - 0x2cfc
    public static final SymbolRange COPTIC_PUNCTUATION = SymbolRange.range('⳾', '⳿');  // 0x2cfe - 0x2cff
    public static final SymbolRange GEORGIAN_SUPPLEMENT_SMALL_LETTERS_KHUTSURI_SUBSET = SymbolRange.range('ⴀ', 'ⴥ');  // 0x2d00 - 0x2d25
    public static final SymbolRange TIFINAGH_LETTERS_SUBSET = SymbolRange.range('ⴰ', 'ⵧ');  // 0x2d30 - 0x2d67
    public static final SymbolRange ETHIOPIC_EXTENDED_SYLLABLES_FOR_MEEN_TO_SYLLABLES_FOR_BLIN = SymbolRange.range('ⶀ', 'ⶖ');  // 0x2d80 - 0x2d96
    public static final SymbolRange ETHIOPIC_EXTENDED_SYLLABLES_FOR_BENCH_SUBSET = SymbolRange.range('ⶠ', 'ⶦ');  // 0x2da0 - 0x2da6
    public static final SymbolRange ETHIOPIC_EXTENDED_SYLLABLES_FOR_BENCH_SUBSET_1 = SymbolRange.range('ⶨ', 'ⶮ');  // 0x2da8 - 0x2dae
    public static final SymbolRange ETHIOPIC_EXTENDED_SYLLABLES_FOR_BENCH_SUBSET_2 = SymbolRange.range('ⶰ', 'ⶶ');  // 0x2db0 - 0x2db6
    public static final SymbolRange ETHIOPIC_EXTENDED_SYLLABLES_FOR_BENCH_SUBSET_3 = SymbolRange.range('ⶸ', 'ⶾ');  // 0x2db8 - 0x2dbe
    public static final SymbolRange ETHIOPIC_EXTENDED_SYLLABLES_FOR_SEBATBEIT_SUBSET = SymbolRange.range('ⷀ', 'ⷆ');  // 0x2dc0 - 0x2dc6
    public static final SymbolRange ETHIOPIC_EXTENDED_SYLLABLES_FOR_SEBATBEIT_SUBSET_1 = SymbolRange.range('ⷈ', 'ⷎ');  // 0x2dc8 - 0x2dce
    public static final SymbolRange ETHIOPIC_EXTENDED_SYLLABLES_FOR_SEBATBEIT_SUBSET_2 = SymbolRange.range('ⷐ', 'ⷖ');  // 0x2dd0 - 0x2dd6
    public static final SymbolRange ETHIOPIC_EXTENDED_SYLLABLES_FOR_SEBATBEIT_SUBSET_3 = SymbolRange.range('ⷘ', 'ⷞ');  // 0x2dd8 - 0x2dde
    public static final SymbolRange CYRILLIC_EXTENDED_A_OLD_CHURCH_SLAVONIC_COMBINING_LETTERS = SymbolRange.range('ⷠ', 'ⷿ');  // 0x2de0 - 0x2dff
    public static final SymbolRange SUPPLEMENTAL_PUNCTUATION_NEW_TESTAMENT_EDITORIAL_SYMBOLS_SUBSET = SymbolRange.range('⸀', '⸁');  // 0x2e00 - 0x2e01
    public static final SymbolRange SUPPLEMENTAL_PUNCTUATION_NEW_TESTAMENT_EDITORIAL_SYMBOLS_TO_HISTORIC_PUNCTUATION = SymbolRange.range('⸀', '⸮');  // 0x2e00 - 0x2e2e
    public static final SymbolRange SUPPLEMENTAL_PUNCTUATION_NEW_TESTAMENT_EDITORIAL_SYMBOLS_SUBSET_1 = SymbolRange.range('⸆', '⸈');  // 0x2e06 - 0x2e08
    public static final SymbolRange SUPPLEMENTAL_PUNCTUATION_ANCIENT_GREEK_TEXTUAL_SYMBOLS = SymbolRange.range('⸎', '⸖');  // 0x2e0e - 0x2e16
    public static final SymbolRange SUPPLEMENTAL_PUNCTUATION_GENERAL_PUNCTUATION = SymbolRange.range('⸘', '⸙');  // 0x2e18 - 0x2e19
    public static final SymbolRange SUPPLEMENTAL_PUNCTUATION_DICTIONARY_PUNCTUATION_1 = SymbolRange.range('⸞', '⸟');  // 0x2e1e - 0x2e1f
    public static final SymbolRange SUPPLEMENTAL_PUNCTUATION_HISTORIC_PUNCTUATION_SUBSET_1 = SymbolRange.range('⸪', '⸮');  // 0x2e2a - 0x2e2e
    public static final SymbolRange SUPPLEMENTAL_PUNCTUATION_HISTORIC_PUNCTUATION_TO_PALAEOTYPE_TRANSLITERATION_SYMBOLS = SymbolRange.range('⸰', '⸹');  // 0x2e30 - 0x2e39
    public static final SymbolRange SUPPLEMENTAL_PUNCTUATION_HISTORIC_PUNCTUATION_TO_HISTORIC_PUNCTUATION = SymbolRange.range('⸰', '⹏');  // 0x2e30 - 0x2e4f
    public static final SymbolRange SUPPLEMENTAL_PUNCTUATION_DASHES = SymbolRange.range('⸺', '⸻');  // 0x2e3a - 0x2e3b
    public static final SymbolRange SUPPLEMENTAL_PUNCTUATION_ALTERNATE_FORMS_OF_PUNCTUATION_TO_ALTERNATE_FORMS_OF_PUNCTUATION = SymbolRange.range('⸼', '⸿');  // 0x2e3c - 0x2e3f
    public static final SymbolRange SUPPLEMENTAL_PUNCTUATION_MISCELLANEOUS_PUNCTUATION_TO_HISTORIC_PUNCTUATION = SymbolRange.range('⹃', '⹏');  // 0x2e43 - 0x2e4f
    public static final SymbolRange SUPPLEMENTAL_PUNCTUATION_HISTORIC_PUNCTUATION_SUBSET = SymbolRange.range('⹐', '⹑');  // 0x2e50 - 0x2e51
    public static final SymbolRange CJK_RADICALS_SUPPLEMENT_CJK_RADICALS_SUPPLEMENT_SUBSET = SymbolRange.range('⺀', '⺙');  // 0x2e80 - 0x2e99
    public static final SymbolRange CJK_RADICALS_SUPPLEMENT_CJK_RADICALS_SUPPLEMENT = SymbolRange.range('⺀', '⻿');  // 0x2e80 - 0x2eff
    public static final SymbolRange CJK_RADICALS_SUPPLEMENT_CJK_RADICALS_SUPPLEMENT_SUBSET_1 = SymbolRange.range('⺛', '⻳');  // 0x2e9b - 0x2ef3
    public static final SymbolRange KANGXI_RADICALS_KANGXI_RADICALS_SUBSET = SymbolRange.range('⼀', '⿕');  // 0x2f00 - 0x2fd5
    public static final SymbolRange KANGXI_RADICALS_KANGXI_RADICALS_SUBSET_1 = SymbolRange.range('⼀', '⿟');  // 0x2f00 - 0x2fdf
    public static final SymbolRange IDEOGRAPHIC_DESCRIPTION_CHARACTERS_IDEOGRAPHIC_DESCRIPTION_CHARACTERS = SymbolRange.range('⿰', '⿿');  // 0x2ff0 - 0x2fff
    public static final SymbolRange IDEOGRAPHIC_DESCRIPTION_CHARACTERS_IDEOGRAPHIC_DESCRIPTION_CHARACTERS_SUBSET = SymbolRange.range('⿰', '⿻');  // 0x2ff0 - 0x2ffb
    public static final SymbolRange CJK_SYMBOLS_AND_PUNCTUATION_CJK_SYMBOLS_AND_PUNCTUATION_TO_SPECIAL_CJK_INDICATORS = SymbolRange.range('　', '〿');  // 0x3000 - 0x303f
    public static final SymbolRange CJK_SYMBOLS_AND_PUNCTUATION_CJK_SYMBOLS_AND_PUNCTUATION_SUBSET = SymbolRange.range('、', '〃');  // 0x3001 - 0x3003
    public static final SymbolRange CJK_SYMBOLS_AND_PUNCTUATION_CJK_SYMBOLS_AND_PUNCTUATION_SUBSET_1 = SymbolRange.range('々', '〆');  // 0x3005 - 0x3006
    public static final SymbolRange CJK_SYMBOLS_AND_PUNCTUATION_CJK_ANGLE_BRACKETS_TO_CJK_BRACKETS = SymbolRange.range('〈', '】');  // 0x3008 - 0x3011
    public static final SymbolRange CJK_SYMBOLS_AND_PUNCTUATION_CJK_SYMBOLS = SymbolRange.range('〒', '〓');  // 0x3012 - 0x3013
    public static final SymbolRange CJK_SYMBOLS_AND_PUNCTUATION_CJK_BRACKETS_TO_CJK_PUNCTUATION = SymbolRange.range('〔', '〟');  // 0x3014 - 0x301f
    public static final SymbolRange CJK_SYMBOLS_AND_PUNCTUATION_CJK_PUNCTUATION_SUBSET = SymbolRange.range('〞', '〟');  // 0x301e - 0x301f
    public static final SymbolRange CJK_SYMBOLS_AND_PUNCTUATION_SUZHOU_NUMERALS = SymbolRange.range('〡', '〩');  // 0x3021 - 0x3029
    public static final SymbolRange CJK_SYMBOLS_AND_PUNCTUATION_COMBINING_TONE_MARKS = SymbolRange.range('〪', '〯');  // 0x302a - 0x302f
    public static final SymbolRange CJK_SYMBOLS_AND_PUNCTUATION_COMBINING_TONE_MARKS_SUBSET = SymbolRange.range('〪', '〭');  // 0x302a - 0x302d
    public static final SymbolRange CJK_SYMBOLS_AND_PUNCTUATION_COMBINING_TONE_MARKS_SUBSET_1 = SymbolRange.range('〮', '〯');  // 0x302e - 0x302f
    public static final SymbolRange CJK_SYMBOLS_AND_PUNCTUATION_KANA_REPEAT_MARKS = SymbolRange.range('〱', '〵');  // 0x3031 - 0x3035
    public static final SymbolRange CJK_SYMBOLS_AND_PUNCTUATION_OTHER_CJK_SYMBOLS = SymbolRange.range('〶', '〷');  // 0x3036 - 0x3037
    public static final SymbolRange CJK_SYMBOLS_AND_PUNCTUATION_ADDITIONAL_SUZHOU_NUMERALS = SymbolRange.range('〸', '〺');  // 0x3038 - 0x303a
    public static final SymbolRange CJK_SYMBOLS_AND_PUNCTUATION_OTHER_CJK_PUNCTUATION_SUBSET = SymbolRange.range('〻', '〼');  // 0x303b - 0x303c
    public static final SymbolRange CJK_SYMBOLS_AND_PUNCTUATION_SPECIAL_CJK_INDICATORS = SymbolRange.range('〾', '〿');  // 0x303e - 0x303f
    public static final SymbolRange CJK_SYMBOLS_AND_PUNCTUATION_HIRAGANA_TO_ITERATION_MARKS = SymbolRange.range('぀', 'ゟ');  // 0x3040 - 0x309f
    public static final SymbolRange CJK_SYMBOLS_AND_PUNCTUATION_HIRAGANA_LETTERS_TO_SMALL_LETTERS = SymbolRange.range('ぁ', 'ゖ');  // 0x3041 - 0x3096
    public static final SymbolRange CJK_SYMBOLS_AND_PUNCTUATION_VOICING_MARKS_SUBSET = SymbolRange.range('゙', '゚');  // 0x3099 - 0x309a
    public static final SymbolRange CJK_SYMBOLS_AND_PUNCTUATION_VOICING_MARKS_SUBSET_1 = SymbolRange.range('゛', '゜');  // 0x309b - 0x309c
    public static final SymbolRange CJK_SYMBOLS_AND_PUNCTUATION_ITERATION_MARKS_TO_ITERATION_MARKS = SymbolRange.range('ゝ', 'ゟ');  // 0x309d - 0x309f
    public static final SymbolRange CJK_SYMBOLS_AND_PUNCTUATION_ITERATION_MARKS = SymbolRange.range('ゝ', 'ゞ');  // 0x309d - 0x309e
    public static final SymbolRange KATAKANA_KATAKANA_PUNCTUATION_TO_ITERATION_MARKS = SymbolRange.range('゠', 'ヿ');  // 0x30a0 - 0x30ff
    public static final SymbolRange KATAKANA_KATAKANA_LETTERS = SymbolRange.range('ァ', 'ヺ');  // 0x30a1 - 0x30fa
    public static final SymbolRange KATAKANA_CONJUNCTION_AND_LENGTH_MARKS_TO_ITERATION_MARKS = SymbolRange.range('ー', 'ヾ');  // 0x30fc - 0x30fe
    public static final SymbolRange KATAKANA_CONJUNCTION_AND_LENGTH_MARKS_TO_ITERATION_MARKS_1 = SymbolRange.range('ー', 'ヿ');  // 0x30fc - 0x30ff
    public static final SymbolRange KATAKANA_BOPOMOFO_TO_MISCELLANEOUS_ADDITIONS = SymbolRange.range('㄀', 'ㄯ');  // 0x3100 - 0x312f
    public static final SymbolRange KATAKANA_BASED_ON_GB_2312_TO_MISCELLANEOUS_ADDITIONS = SymbolRange.range('ㄅ', 'ㄯ');  // 0x3105 - 0x312f
    public static final SymbolRange KATAKANA_HANGUL_COMPATIBILITY_JAMO_TO_OLD_VOWEL_LETTERS = SymbolRange.range('㄰', '㆏');  // 0x3130 - 0x318f
    public static final SymbolRange KATAKANA_CONSONANT_LETTERS_TO_OLD_VOWEL_LETTERS = SymbolRange.range('ㄱ', 'ㆎ');  // 0x3131 - 0x318e
    public static final SymbolRange KANBUN_TATETEN_TO_TATETEN = SymbolRange.range('㆐', '㆑');  // 0x3190 - 0x3191
    public static final SymbolRange KANBUN_TATETEN_TO_KAERITEN = SymbolRange.range('㆐', '㆟');  // 0x3190 - 0x319f
    public static final SymbolRange KANBUN_KAERITEN_SUBSET = SymbolRange.range('㆒', '㆕');  // 0x3192 - 0x3195
    public static final SymbolRange KANBUN_KAERITEN_SUBSET_1 = SymbolRange.range('㆖', '㆟');  // 0x3196 - 0x319f
    public static final SymbolRange BOPOMOFO_EXTENDED_EXTENDED_BOPOMOFO_FOR_MINNAN_AND_HAKKA_TO_EXTENDED_BOPOMOFO_FOR_CANTONESE = SymbolRange.range('ㆠ', 'ㆿ');  // 0x31a0 - 0x31bf
    public static final SymbolRange CJK_STROKES_CJK_STROKES_SUBSET = SymbolRange.range('㇀', '㇣');  // 0x31c0 - 0x31e3
    public static final SymbolRange KATAKANA_PHONETIC_EXTENSIONS_PHONETIC_EXTENSIONS_FOR_AINU = SymbolRange.range('ㇰ', 'ㇿ');  // 0x31f0 - 0x31ff
    public static final SymbolRange ENCLOSED_CJK_LETTERS_AND_MONTHS_PARENTHESIZED_HANGUL_LETTERS_TO_PARENTHESIZED_KOREAN_WORDS = SymbolRange.range('㈀', '㈞');  // 0x3200 - 0x321e
    public static final SymbolRange ENCLOSED_CJK_LETTERS_AND_MONTHS_PARENTHESIZED_HANGUL_LETTERS_TO_CIRCLED_KATAKANA = SymbolRange.range('㈀', '㋿');  // 0x3200 - 0x32ff
    public static final SymbolRange ENCLOSED_CJK_LETTERS_AND_MONTHS_PARENTHESIZED_IDEOGRAPHS_SUBSET = SymbolRange.range('㈠', '㈩');  // 0x3220 - 0x3229
    public static final SymbolRange ENCLOSED_CJK_LETTERS_AND_MONTHS_PARENTHESIZED_IDEOGRAPHS_TO_CIRCLED_IDEOGRAPHS_FROM_ARIB_STD_B24 = SymbolRange.range('㈪', '㉇');  // 0x322a - 0x3247
    public static final SymbolRange ENCLOSED_CJK_LETTERS_AND_MONTHS_CIRCLED_NUMBERS_ON_BLACK_SQUARES_FROM_ARIB_STD_B24 = SymbolRange.range('㉈', '㉏');  // 0x3248 - 0x324f
    public static final SymbolRange ENCLOSED_CJK_LETTERS_AND_MONTHS_CIRCLED_NUMBERS = SymbolRange.range('㉑', '㉟');  // 0x3251 - 0x325f
    public static final SymbolRange ENCLOSED_CJK_LETTERS_AND_MONTHS_CIRCLED_HANGUL_LETTERS_TO_CIRCLED_HANGUL_SYLLABLE = SymbolRange.range('㉠', '㉿');  // 0x3260 - 0x327f
    public static final SymbolRange ENCLOSED_CJK_LETTERS_AND_MONTHS_CIRCLED_IDEOGRAPHS_SUBSET = SymbolRange.range('㊀', '㊉');  // 0x3280 - 0x3289
    public static final SymbolRange ENCLOSED_CJK_LETTERS_AND_MONTHS_CIRCLED_IDEOGRAPHS_SUBSET_1 = SymbolRange.range('㊊', '㊰');  // 0x328a - 0x32b0
    public static final SymbolRange ENCLOSED_CJK_LETTERS_AND_MONTHS_CIRCLED_NUMBERS_1 = SymbolRange.range('㊱', '㊿');  // 0x32b1 - 0x32bf
    public static final SymbolRange ENCLOSED_CJK_LETTERS_AND_MONTHS_TO_CJK_COMPATIBILITY = SymbolRange.range('㋀', '㏿');  // 0x32c0 - 0x33ff
    public static final SymbolRange CJK_COMPATIBILITY_SQUARED_KATAKANA_WORDS_TO_TELEGRAPH_SYMBOLS_FOR_DAYS = SymbolRange.range('㌀', '㏿');  // 0x3300 - 0x33ff
    public static final SymbolRange CJK_COMPATIBILITY_CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A = SymbolRange.range('㐀', '䶿');  // 0x3400 - 0x4dbf
    public static final SymbolRange YIJING_HEXAGRAM_SYMBOLS_YIJING_HEXAGRAM_SYMBOLS = SymbolRange.range('䷀', '䷿');  // 0x4dc0 - 0x4dff
    public static final SymbolRange YIJING_HEXAGRAM_SYMBOLS_CJK_UNIFIED_IDEOGRAPHS = SymbolRange.range('一', '鿿');  // 0x4e00 - 0x9fff
    public static final SymbolRange YIJING_HEXAGRAM_SYMBOLS_CJK_UNIFIED_IDEOGRAPHS_SUBSET = SymbolRange.range('一', '鿼');  // 0x4e00 - 0x9ffc
    public static final SymbolRange YI_SYLLABLES_SYLLABLES = SymbolRange.range('ꀀ', 'ꀔ');  // 0xa000 - 0xa014
    public static final SymbolRange YI_SYLLABLES_SYLLABLES_TO_SYLLABLES = SymbolRange.range('ꀀ', 'ꒌ');  // 0xa000 - 0xa48c
    public static final SymbolRange YI_SYLLABLES_SYLLABLES_TO_SYLLABLES_1 = SymbolRange.range('ꀀ', '꒏');  // 0xa000 - 0xa48f
    public static final SymbolRange YI_SYLLABLES_SYLLABLES_SUBSET = SymbolRange.range('ꀖ', 'ꒌ');  // 0xa016 - 0xa48c
    public static final SymbolRange YI_RADICALS_YI_RADICALS_SUBSET = SymbolRange.range('꒐', '꓆');  // 0xa490 - 0xa4c6
    public static final SymbolRange YI_RADICALS_YI_RADICALS = SymbolRange.range('꒐', '꓏');  // 0xa490 - 0xa4cf
    public static final SymbolRange LISU_CONSONANTS_TO_VOWELS = SymbolRange.range('ꓐ', 'ꓷ');  // 0xa4d0 - 0xa4f7
    public static final SymbolRange LISU_CONSONANTS_TO_TONES = SymbolRange.range('ꓐ', 'ꓽ');  // 0xa4d0 - 0xa4fd
    public static final SymbolRange LISU_TONES = SymbolRange.range('ꓸ', 'ꓽ');  // 0xa4f8 - 0xa4fd
    public static final SymbolRange LISU_PUNCTUATION = SymbolRange.range('꓾', '꓿');  // 0xa4fe - 0xa4ff
    public static final SymbolRange VAI_SYLLABLES_IN__EE_TO_SYLLABLE_FINALS = SymbolRange.range('ꔀ', 'ꘌ');  // 0xa500 - 0xa60c
    public static final SymbolRange VAI_SYLLABLES_IN__EE_TO_SYLLABLES_IN__E = SymbolRange.range('ꔀ', 'ꘋ');  // 0xa500 - 0xa60b
    public static final SymbolRange VAI_PUNCTUATION = SymbolRange.range('꘍', '꘏');  // 0xa60d - 0xa60f
    public static final SymbolRange VAI_HISTORIC_SYLLABLES_TO_LOGOGRAMS = SymbolRange.range('ꘐ', 'ꘟ');  // 0xa610 - 0xa61f
    public static final SymbolRange VAI_DIGITS = SymbolRange.range('꘠', '꘩');  // 0xa620 - 0xa629
    public static final SymbolRange VAI_HISTORIC_SYLLABLES_SUBSET = SymbolRange.range('ꘪ', 'ꘫ');  // 0xa62a - 0xa62b
    public static final SymbolRange CYRILLIC_EXTENDED_B_LETTERS_FOR_OLD_CYRILLIC = SymbolRange.range('Ꙁ', 'ꙮ');  // 0xa640 - 0xa66e
    public static final SymbolRange CYRILLIC_EXTENDED_B_ABBREVIATION_MARK_TO_COMBINING_NUMERIC_SIGNS = SymbolRange.range('꙯', '꙲');  // 0xa66f - 0xa672
    public static final SymbolRange CYRILLIC_EXTENDED_B_COMBINING_NUMERIC_SIGNS = SymbolRange.range('꙰', '꙲');  // 0xa670 - 0xa672
    public static final SymbolRange CYRILLIC_EXTENDED_B_COMBINING_MARKS_FOR_OLD_CYRILLIC = SymbolRange.range('ꙴ', '꙽');  // 0xa674 - 0xa67d
    public static final SymbolRange CYRILLIC_EXTENDED_B_MODIFIER_LETTER_TO_INTONATION_MARKS_FOR_LITHUANIAN_DIALECTOLOGY = SymbolRange.range('ꙿ', 'ꚝ');  // 0xa67f - 0xa69d
    public static final SymbolRange CYRILLIC_EXTENDED_B_INTONATION_MARKS_FOR_LITHUANIAN_DIALECTOLOGY = SymbolRange.range('ꚜ', 'ꚝ');  // 0xa69c - 0xa69d
    public static final SymbolRange CYRILLIC_EXTENDED_B_COMBINING_MARKS_FOR_OLD_CYRILLIC_1 = SymbolRange.range('ꚞ', 'ꚟ');  // 0xa69e - 0xa69f
    public static final SymbolRange BAMUM_SYLLABLES_SUBSET = SymbolRange.range('ꚠ', 'ꛥ');  // 0xa6a0 - 0xa6e5
    public static final SymbolRange BAMUM_SYLLABLES_SUBSET_1 = SymbolRange.range('ꛦ', 'ꛯ');  // 0xa6e6 - 0xa6ef
    public static final SymbolRange BAMUM_COMBINING_MARKS = SymbolRange.range('꛰', '꛱');  // 0xa6f0 - 0xa6f1
    public static final SymbolRange BAMUM_PUNCTUATION_SUBSET = SymbolRange.range('꛲', '꛷');  // 0xa6f2 - 0xa6f7
    public static final SymbolRange MODIFIER_TONE_LETTERS_CORNER_TONE_MARKS_FOR_CHINESE_TO_LEFT_STEM_TONE_LETTERS = SymbolRange.range('꜀', '꜖');  // 0xa700 - 0xa716
    public static final SymbolRange MODIFIER_TONE_LETTERS_CHINANTEC_TONE_MARKS_TO_AFRICANIST_TONE_LETTERS = SymbolRange.range('ꜗ', 'ꜟ');  // 0xa717 - 0xa71f
    public static final SymbolRange LATIN_EXTENDED_D_ADDITIONS_FOR_UPA = SymbolRange.range('꜠', '꜡');  // 0xa720 - 0xa721
    public static final SymbolRange LATIN_EXTENDED_D_EGYPTOLOGICAL_ADDITIONS_TO_INSULAR_AND_CELTICIST_LETTERS = SymbolRange.range('Ꜣ', 'ꞈ');  // 0xa722 - 0xa788
    public static final SymbolRange LATIN_EXTENDED_D_MAYANIST_ADDITIONS_TO_MEDIEVALIST_ADDITIONS = SymbolRange.range('ꜯ', 'ꜱ');  // 0xa72f - 0xa731
    public static final SymbolRange LATIN_EXTENDED_D_MEDIEVALIST_ADDITIONS_SUBSET = SymbolRange.range('ꝱ', 'ꝸ');  // 0xa771 - 0xa778
    public static final SymbolRange LATIN_EXTENDED_D_INSULAR_AND_CELTICIST_LETTERS_SUBSET = SymbolRange.range('Ᵹ', 'Ꝿ');  // 0xa77d - 0xa77e
    public static final SymbolRange LATIN_EXTENDED_D_MODIFIER_LETTERS_SUBSET = SymbolRange.range('꞉', '꞊');  // 0xa789 - 0xa78a
    public static final SymbolRange LATIN_EXTENDED_D_ORTHOGRAPHIC_LETTERS_FOR_GLOTTALS_TO_LETTERS_FOR_UGARITIC_AND_EGYPTOLOGICAL_TRANSLITERATION = SymbolRange.range('Ꞌ', 'ꞿ');  // 0xa78b - 0xa7bf
    public static final SymbolRange LATIN_EXTENDED_D_ADDITIONAL_LETTERS_TO_ADDITIONS_FOR_LITHUANIAN_DIALECTOLOGY = SymbolRange.range('ꞓ', 'ꞕ');  // 0xa793 - 0xa795
    public static final SymbolRange LATIN_EXTENDED_D_ADDITIONAL_LETTERS_TO_ADDITIONAL_LETTERS = SymbolRange.range('Ɦ', 'Ɪ');  // 0xa7aa - 0xa7ae
    public static final SymbolRange LATIN_EXTENDED_D_LETTERS_FOR_AMERICANIST_ORTHOGRAPHIES_TO_LETTER_FOR_GERMAN_DIALECTOLOGY = SymbolRange.range('Ʞ', 'Ꞵ');  // 0xa7b0 - 0xa7b4
    public static final SymbolRange LATIN_EXTENDED_D_ADDITIONAL_MEDIEVAL_LETTERS_TO_ADDITIONAL_LETTERS_FOR_GAULISH = SymbolRange.range('Ꟃ', 'ꟊ');  // 0xa7c2 - 0xa7ca
    public static final SymbolRange LATIN_EXTENDED_D_LETTERS_USED_IN_EARLY_PINYIN_ROMANIZATION_TO_LETTERS_USED_IN_EARLY_PINYIN_ROMANIZATION = SymbolRange.range('Ꞔ', 'Ꟈ');  // 0xa7c4 - 0xa7c7
    public static final SymbolRange LATIN_EXTENDED_D_TO_SYLOTI_NAGRI = SymbolRange.range('Ꟶ', 'ꠁ');  // 0xa7f5 - 0xa801
    public static final SymbolRange LATIN_EXTENDED_D_ADDITIONS_FOR_EXTENDED_IPA = SymbolRange.range('ꟸ', 'ꟹ');  // 0xa7f8 - 0xa7f9
    public static final SymbolRange LATIN_EXTENDED_D_TO_SYLOTI_NAGRI_1 = SymbolRange.range('ꟻ', 'ꠁ');  // 0xa7fb - 0xa801
    public static final SymbolRange SYLOTI_NAGRI_INDEPENDENT_VOWELS_AND_DVISVARA_SUBSET = SymbolRange.range('ꠃ', 'ꠅ');  // 0xa803 - 0xa805
    public static final SymbolRange SYLOTI_NAGRI_CONSONANTS_AND_CONSONANT_SIGNS_SUBSET = SymbolRange.range('ꠇ', 'ꠊ');  // 0xa807 - 0xa80a
    public static final SymbolRange SYLOTI_NAGRI_CONSONANTS_AND_CONSONANT_SIGNS_SUBSET_1 = SymbolRange.range('ꠌ', 'ꠢ');  // 0xa80c - 0xa822
    public static final SymbolRange SYLOTI_NAGRI_DEPENDENT_VOWEL_SIGNS = SymbolRange.range('ꠣ', 'ꠧ');  // 0xa823 - 0xa827
    public static final SymbolRange SYLOTI_NAGRI_DEPENDENT_VOWEL_SIGNS_SUBSET = SymbolRange.range('ꠣ', 'ꠤ');  // 0xa823 - 0xa824
    public static final SymbolRange SYLOTI_NAGRI_DEPENDENT_VOWEL_SIGNS_SUBSET_1 = SymbolRange.range('ꠥ', 'ꠦ');  // 0xa825 - 0xa826
    public static final SymbolRange SYLOTI_NAGRI_POETRY_MARKS = SymbolRange.range('꠨', '꠫');  // 0xa828 - 0xa82b
    public static final SymbolRange COMMON_INDIC_NUMBER_FORMS_NUMBER_FORMS_SUBSET = SymbolRange.range('꠰', '꠵');  // 0xa830 - 0xa835
    public static final SymbolRange COMMON_INDIC_NUMBER_FORMS_NUMBER_FORMS_TO_NUMBER_FORMS = SymbolRange.range('꠶', '꠷');  // 0xa836 - 0xa837
    public static final SymbolRange COMMON_INDIC_NUMBER_FORMS_NUMBER_FORMS_TO_CURRENCY_SYMBOL = SymbolRange.range('꠶', '꠹');  // 0xa836 - 0xa839
    public static final SymbolRange PHAGS_PA_CONSONANTS_TO_CONSONANT_ADDITION_FOR_TIBETAN = SymbolRange.range('ꡀ', 'ꡳ');  // 0xa840 - 0xa873
    public static final SymbolRange PHAGS_PA_HEAD_MARKS_FOR_TIBETAN_TO_PUNCTUATION_FOR_TIBETAN = SymbolRange.range('꡴', '꡷');  // 0xa874 - 0xa877
    public static final SymbolRange SAURASHTRA_VARIOUS_SIGNS = SymbolRange.range('ꢀ', 'ꢁ');  // 0xa880 - 0xa881
    public static final SymbolRange SAURASHTRA_INDEPENDENT_VOWELS_TO_CONSONANTS = SymbolRange.range('ꢂ', 'ꢳ');  // 0xa882 - 0xa8b3
    public static final SymbolRange SAURASHTRA_CONSONANTS_TO_VIRAMA = SymbolRange.range('ꢴ', 'ꣅ');  // 0xa8b4 - 0xa8c5
    public static final SymbolRange SAURASHTRA_CONSONANTS_TO_DEPENDENT_VOWEL_SIGNS = SymbolRange.range('ꢴ', 'ꣃ');  // 0xa8b4 - 0xa8c3
    public static final SymbolRange SAURASHTRA_VIRAMA_TO_VIRAMA = SymbolRange.range('꣄', 'ꣅ');  // 0xa8c4 - 0xa8c5
    public static final SymbolRange SAURASHTRA_PUNCTUATION = SymbolRange.range('꣎', '꣏');  // 0xa8ce - 0xa8cf
    public static final SymbolRange SAURASHTRA_DIGITS_SUBSET = SymbolRange.range('꣐', '꣙');  // 0xa8d0 - 0xa8d9
    public static final SymbolRange DEVANAGARI_EXTENDED_CANTILLATION_MARKS_SVARA_FOR_THE_SAMAVEDA = SymbolRange.range('꣠', '꣱');  // 0xa8e0 - 0xa8f1
    public static final SymbolRange DEVANAGARI_EXTENDED_MARKS_OF_NASALIZATION = SymbolRange.range('ꣲ', 'ꣷ');  // 0xa8f2 - 0xa8f7
    public static final SymbolRange DEVANAGARI_EXTENDED_EDITORIAL_MARKS_SUBSET = SymbolRange.range('꣸', '꣺');  // 0xa8f8 - 0xa8fa
    public static final SymbolRange DEVANAGARI_EXTENDED_SIGNS_TO_SIGNS = SymbolRange.range('ꣽ', 'ꣾ');  // 0xa8fd - 0xa8fe
    public static final SymbolRange KAYAH_LI_DIGITS = SymbolRange.range('꤀', '꤉');  // 0xa900 - 0xa909
    public static final SymbolRange KAYAH_LI_CONSONANTS_TO_VOWELS = SymbolRange.range('ꤊ', 'ꤥ');  // 0xa90a - 0xa925
    public static final SymbolRange KAYAH_LI_VOWELS_TO_TONE_MARKS = SymbolRange.range('ꤦ', '꤭');  // 0xa926 - 0xa92d
    public static final SymbolRange KAYAH_LI_PUNCTUATION = SymbolRange.range('꤮', '꤯');  // 0xa92e - 0xa92f
    public static final SymbolRange REJANG_CONSONANTS = SymbolRange.range('ꤰ', 'ꥆ');  // 0xa930 - 0xa946
    public static final SymbolRange REJANG_VOWEL_SIGNS_TO_CONSONANT_SIGNS = SymbolRange.range('ꥇ', '꥓');  // 0xa947 - 0xa953
    public static final SymbolRange REJANG_VOWEL_SIGNS_TO_CONSONANT_SIGNS_1 = SymbolRange.range('ꥇ', 'ꥑ');  // 0xa947 - 0xa951
    public static final SymbolRange REJANG_CONSONANT_SIGNS_TO_CONSONANT_SIGNS = SymbolRange.range('ꥒ', '꥓');  // 0xa952 - 0xa953
    public static final SymbolRange HANGUL_JAMO_EXTENDED_A_OLD_INITIAL_CONSONANTS_SUBSET = SymbolRange.range('ꥠ', 'ꥼ');  // 0xa960 - 0xa97c
    public static final SymbolRange JAVANESE_VARIOUS_SIGNS = SymbolRange.range('ꦀ', 'ꦃ');  // 0xa980 - 0xa983
    public static final SymbolRange JAVANESE_VARIOUS_SIGNS_SUBSET = SymbolRange.range('ꦀ', 'ꦂ');  // 0xa980 - 0xa982
    public static final SymbolRange JAVANESE_LETTERS = SymbolRange.range('ꦄ', 'ꦲ');  // 0xa984 - 0xa9b2
    public static final SymbolRange JAVANESE_SIGN_TO_DEPENDENT_CONSONANT_SIGNS = SymbolRange.range('꦳', '꧀');  // 0xa9b3 - 0xa9c0
    public static final SymbolRange JAVANESE_DEPENDENT_VOWEL_SIGNS_SUBSET = SymbolRange.range('ꦴ', 'ꦵ');  // 0xa9b4 - 0xa9b5
    public static final SymbolRange JAVANESE_DEPENDENT_VOWEL_SIGNS_SUBSET_1 = SymbolRange.range('ꦶ', 'ꦹ');  // 0xa9b6 - 0xa9b9
    public static final SymbolRange JAVANESE_DEPENDENT_VOWEL_SIGNS_SUBSET_2 = SymbolRange.range('ꦺ', 'ꦻ');  // 0xa9ba - 0xa9bb
    public static final SymbolRange JAVANESE_DEPENDENT_VOWEL_SIGNS_TO_DEPENDENT_VOWEL_SIGNS = SymbolRange.range('ꦼ', 'ꦽ');  // 0xa9bc - 0xa9bd
    public static final SymbolRange JAVANESE_DEPENDENT_CONSONANT_SIGNS_TO_DEPENDENT_CONSONANT_SIGNS = SymbolRange.range('ꦾ', '꧀');  // 0xa9be - 0xa9c0
    public static final SymbolRange JAVANESE_PUNCTUATION_SUBSET = SymbolRange.range('꧁', '꧍');  // 0xa9c1 - 0xa9cd
    public static final SymbolRange JAVANESE_DIGITS_SUBSET = SymbolRange.range('꧐', '꧙');  // 0xa9d0 - 0xa9d9
    public static final SymbolRange JAVANESE_ELLIPSIS_MARKS = SymbolRange.range('꧞', '꧟');  // 0xa9de - 0xa9df
    public static final SymbolRange MYANMAR_EXTENDED_B_ADDITIONS_FOR_SHAN_PALI_SUBSET = SymbolRange.range('ꧠ', 'ꧤ');  // 0xa9e0 - 0xa9e4
    public static final SymbolRange MYANMAR_EXTENDED_B_REDUPLICATION_MARK_TO_TAI_LAING_CONSONANTS = SymbolRange.range('ꧦ', 'ꧯ');  // 0xa9e6 - 0xa9ef
    public static final SymbolRange MYANMAR_EXTENDED_B_TAI_LAING_CONSONANTS = SymbolRange.range('ꧧ', 'ꧯ');  // 0xa9e7 - 0xa9ef
    public static final SymbolRange MYANMAR_EXTENDED_B_TAI_LAING_DIGITS = SymbolRange.range('꧰', '꧹');  // 0xa9f0 - 0xa9f9
    public static final SymbolRange MYANMAR_EXTENDED_B_TAI_LAING_CONSONANTS_SUBSET = SymbolRange.range('ꧺ', 'ꧾ');  // 0xa9fa - 0xa9fe
    public static final SymbolRange CHAM_INDEPENDENT_VOWELS_TO_CONSONANTS = SymbolRange.range('ꨀ', 'ꨨ');  // 0xaa00 - 0xaa28
    public static final SymbolRange CHAM_DEPENDENT_VOWEL_SIGNS_SUBSET = SymbolRange.range('ꨩ', 'ꨮ');  // 0xaa29 - 0xaa2e
    public static final SymbolRange CHAM_DEPENDENT_VOWEL_SIGNS_TO_CONSONANT_SIGNS = SymbolRange.range('ꨩ', 'ꨶ');  // 0xaa29 - 0xaa36
    public static final SymbolRange CHAM_DEPENDENT_VOWEL_SIGNS_SUBSET_1 = SymbolRange.range('ꨯ', 'ꨰ');  // 0xaa2f - 0xaa30
    public static final SymbolRange CHAM_DEPENDENT_VOWEL_SIGNS_SUBSET_2 = SymbolRange.range('ꨱ', 'ꨲ');  // 0xaa31 - 0xaa32
    public static final SymbolRange CHAM_CONSONANT_SIGNS_SUBSET = SymbolRange.range('ꨳ', 'ꨴ');  // 0xaa33 - 0xaa34
    public static final SymbolRange CHAM_CONSONANT_SIGNS_SUBSET_1 = SymbolRange.range('ꨵ', 'ꨶ');  // 0xaa35 - 0xaa36
    public static final SymbolRange CHAM_FINAL_CONSONANTS_SUBSET = SymbolRange.range('ꩀ', 'ꩂ');  // 0xaa40 - 0xaa42
    public static final SymbolRange CHAM_FINAL_CONSONANTS_SUBSET_1 = SymbolRange.range('ꩄ', 'ꩋ');  // 0xaa44 - 0xaa4b
    public static final SymbolRange CHAM_FINAL_CONSONANTS_SUBSET_2 = SymbolRange.range('ꩌ', 'ꩍ');  // 0xaa4c - 0xaa4d
    public static final SymbolRange CHAM_DIGITS_SUBSET = SymbolRange.range('꩐', '꩙');  // 0xaa50 - 0xaa59
    public static final SymbolRange CHAM_PUNCTUATION = SymbolRange.range('꩜', '꩟');  // 0xaa5c - 0xaa5f
    public static final SymbolRange MYANMAR_EXTENDED_A_KHAMTI_SHAN_CONSONANTS_TO_KHAMTI_SHAN_LOGOGRAMS = SymbolRange.range('ꩠ', 'ꩶ');  // 0xaa60 - 0xaa76
    public static final SymbolRange MYANMAR_EXTENDED_A_KHAMTI_SHAN_CONSONANTS_SUBSET = SymbolRange.range('ꩠ', 'ꩯ');  // 0xaa60 - 0xaa6f
    public static final SymbolRange MYANMAR_EXTENDED_A_KHAMTI_SHAN_CONSONANTS_TO_KHAMTI_SHAN_LOGOGRAMS_1 = SymbolRange.range('ꩱ', 'ꩶ');  // 0xaa71 - 0xaa76
    public static final SymbolRange MYANMAR_EXTENDED_A_AITON_SYMBOLS_AND_LETTERS_SUBSET = SymbolRange.range('꩷', '꩹');  // 0xaa77 - 0xaa79
    public static final SymbolRange MYANMAR_EXTENDED_A_PAO_KAREN_TONE_MARK_TO_TAI_LAING_TONE_MARKS = SymbolRange.range('ꩻ', 'ꩽ');  // 0xaa7b - 0xaa7d
    public static final SymbolRange MYANMAR_EXTENDED_A_TO_TAI_VIET = SymbolRange.range('ꩾ', 'ꪯ');  // 0xaa7e - 0xaaaf
    public static final SymbolRange TAI_VIET_VOWELS_AND_FINALS_SUBSET = SymbolRange.range('ꪲ', 'ꪴ');  // 0xaab2 - 0xaab4
    public static final SymbolRange TAI_VIET_VOWELS_AND_FINALS_SUBSET_1 = SymbolRange.range('ꪵ', 'ꪶ');  // 0xaab5 - 0xaab6
    public static final SymbolRange TAI_VIET_VOWELS_AND_FINALS_SUBSET_2 = SymbolRange.range('ꪷ', 'ꪸ');  // 0xaab7 - 0xaab8
    public static final SymbolRange TAI_VIET_VOWELS_AND_FINALS_SUBSET_3 = SymbolRange.range('ꪹ', 'ꪽ');  // 0xaab9 - 0xaabd
    public static final SymbolRange TAI_VIET_VOWELS_AND_FINALS_TO_VOWELS_AND_FINALS = SymbolRange.range('ꪾ', '꪿');  // 0xaabe - 0xaabf
    public static final SymbolRange TAI_VIET_WORD_LIGATURE_SYMBOLS = SymbolRange.range('ꫛ', 'ꫜ');  // 0xaadb - 0xaadc
    public static final SymbolRange TAI_VIET_WORD_LIGATURE_SYMBOLS_TO_WORD_LIGATURE_SYMBOLS = SymbolRange.range('ꫛ', 'ꫝ');  // 0xaadb - 0xaadd
    public static final SymbolRange TAI_VIET_PUNCTUATION = SymbolRange.range('꫞', '꫟');  // 0xaade - 0xaadf
    public static final SymbolRange MEETEI_MAYEK_EXTENSIONS_INDEPENDENT_VOWEL_SIGNS_TO_CONSONANTS = SymbolRange.range('ꫠ', 'ꫪ');  // 0xaae0 - 0xaaea
    public static final SymbolRange MEETEI_MAYEK_EXTENSIONS_DEPENDENT_VOWEL_SIGNS = SymbolRange.range('ꫫ', 'ꫯ');  // 0xaaeb - 0xaaef
    public static final SymbolRange MEETEI_MAYEK_EXTENSIONS_DEPENDENT_VOWEL_SIGNS_SUBSET = SymbolRange.range('ꫬ', 'ꫭ');  // 0xaaec - 0xaaed
    public static final SymbolRange MEETEI_MAYEK_EXTENSIONS_DEPENDENT_VOWEL_SIGNS_SUBSET_1 = SymbolRange.range('ꫮ', 'ꫯ');  // 0xaaee - 0xaaef
    public static final SymbolRange MEETEI_MAYEK_EXTENSIONS_PUNCTUATION = SymbolRange.range('꫰', '꫱');  // 0xaaf0 - 0xaaf1
    public static final SymbolRange MEETEI_MAYEK_EXTENSIONS_SIGN_TO_REPETITION_MARKS = SymbolRange.range('ꫲ', 'ꫴ');  // 0xaaf2 - 0xaaf4
    public static final SymbolRange MEETEI_MAYEK_EXTENSIONS_REPETITION_MARKS = SymbolRange.range('ꫳ', 'ꫴ');  // 0xaaf3 - 0xaaf4
    public static final SymbolRange MEETEI_MAYEK_EXTENSIONS_SIGN_TO_SIGN = SymbolRange.range('ꫵ', '꫶');  // 0xaaf5 - 0xaaf6
    public static final SymbolRange MEETEI_MAYEK_EXTENSIONS_GAMO_GOFA_DAWRO_AND_BASKETO_SUBSET = SymbolRange.range('ꬁ', 'ꬆ');  // 0xab01 - 0xab06
    public static final SymbolRange MEETEI_MAYEK_EXTENSIONS_GAMO_GOFA_DAWRO_AND_BASKETO_SUBSET_1 = SymbolRange.range('ꬉ', 'ꬎ');  // 0xab09 - 0xab0e
    public static final SymbolRange MEETEI_MAYEK_EXTENSIONS_GAMO_GOFA_DAWRO_SUBSET = SymbolRange.range('ꬑ', 'ꬖ');  // 0xab11 - 0xab16
    public static final SymbolRange MEETEI_MAYEK_EXTENSIONS_GUMUZ_SUBSET = SymbolRange.range('ꬠ', 'ꬦ');  // 0xab20 - 0xab26
    public static final SymbolRange MEETEI_MAYEK_EXTENSIONS_GUMUZ_SUBSET_1 = SymbolRange.range('ꬨ', 'ꬮ');  // 0xab28 - 0xab2e
    public static final SymbolRange LATIN_EXTENDED_E_LETTERS_FOR_GERMAN_DIALECTOLOGY = SymbolRange.range('ꬰ', 'ꭚ');  // 0xab30 - 0xab5a
    public static final SymbolRange LATIN_EXTENDED_E_MODIFIER_LETTERS_FOR_GERMAN_DIALECTOLOGY_SUBSET = SymbolRange.range('ꭜ', 'ꭟ');  // 0xab5c - 0xab5f
    public static final SymbolRange LATIN_EXTENDED_E_MODIFIER_LETTERS_FOR_GERMAN_DIALECTOLOGY_TO_LETTERS_FOR_SCOTS_DIALECTOLOGY = SymbolRange.range('ꭜ', 'ꭩ');  // 0xab5c - 0xab69
    public static final SymbolRange LATIN_EXTENDED_E_HISTORIC_LETTERS_FOR_SAKHA_YAKUT_TO_LETTERS_FOR_SINOLOGICAL_TRANSCRIPTION = SymbolRange.range('ꭠ', 'ꭨ');  // 0xab60 - 0xab68
    public static final SymbolRange LATIN_EXTENDED_E_LETTERS_FOR_SCOTS_DIALECTOLOGY_SUBSET = SymbolRange.range('꭪', '꭫');  // 0xab6a - 0xab6b
    public static final SymbolRange CHEROKEE_SUPPLEMENT_LOWERCASE_SYLLABLES = SymbolRange.range('ꭰ', 'ꮿ');  // 0xab70 - 0xabbf
    public static final SymbolRange CHEROKEE_SUPPLEMENT_TO_MEETEI_MAYEK = SymbolRange.range('ꭰ', 'ꯢ');  // 0xab70 - 0xabe2
    public static final SymbolRange MEETEI_MAYEK_LETTERS_TO_FINAL_CONSONANTS = SymbolRange.range('ꯀ', 'ꯢ');  // 0xabc0 - 0xabe2
    public static final SymbolRange MEETEI_MAYEK_DEPENDENT_VOWEL_SIGNS = SymbolRange.range('ꯣ', 'ꯪ');  // 0xabe3 - 0xabea
    public static final SymbolRange MEETEI_MAYEK_DEPENDENT_VOWEL_SIGNS_SUBSET = SymbolRange.range('ꯣ', 'ꯤ');  // 0xabe3 - 0xabe4
    public static final SymbolRange MEETEI_MAYEK_DEPENDENT_VOWEL_SIGNS_SUBSET_1 = SymbolRange.range('ꯦ', 'ꯧ');  // 0xabe6 - 0xabe7
    public static final SymbolRange MEETEI_MAYEK_DEPENDENT_VOWEL_SIGNS_SUBSET_2 = SymbolRange.range('ꯩ', 'ꯪ');  // 0xabe9 - 0xabea
    public static final SymbolRange MEETEI_MAYEK_PUNCTUATION_SUBSET = SymbolRange.range('꯬', '꯭');  // 0xabec - 0xabed
    public static final SymbolRange MEETEI_MAYEK_DIGITS_SUBSET = SymbolRange.range('꯰', '꯹');  // 0xabf0 - 0xabf9
    public static final SymbolRange MEETEI_MAYEK_HANGUL_SYLLABLES_SUBSET = SymbolRange.range('가', '힣');  // 0xac00 - 0xd7a3
    public static final SymbolRange MEETEI_MAYEK_HANGUL_SYLLABLES = SymbolRange.range('가', '힯');  // 0xac00 - 0xd7af
    public static final SymbolRange HANGUL_JAMO_EXTENDED_B_OLD_MEDIAL_VOWELS_SUBSET = SymbolRange.range('ힰ', 'ퟆ');  // 0xd7b0 - 0xd7c6
    public static final SymbolRange HANGUL_JAMO_EXTENDED_B_OLD_FINAL_CONSONANTS_SUBSET = SymbolRange.range('ퟋ', 'ퟻ');  // 0xd7cb - 0xd7fb
}
