/*
 * Decompiled with CFR 0.152.
 */
package com.github.curiousoddman.rgxgen.nodes;

import com.github.curiousoddman.rgxgen.config.RgxGenOption;
import com.github.curiousoddman.rgxgen.config.RgxGenProperties;
import com.github.curiousoddman.rgxgen.model.MatchType;
import com.github.curiousoddman.rgxgen.model.RgxGenCharsDefinition;
import com.github.curiousoddman.rgxgen.model.SymbolRange;
import com.github.curiousoddman.rgxgen.model.UnicodeCategory;
import com.github.curiousoddman.rgxgen.nodes.Node;
import com.github.curiousoddman.rgxgen.parsing.dflt.ConstantsProvider;
import com.github.curiousoddman.rgxgen.util.Util;
import com.github.curiousoddman.rgxgen.util.chars.CharList;
import com.github.curiousoddman.rgxgen.visitors.NodeVisitor;
import com.github.curiousoddman.rgxgen.visitors.helpers.SymbolSetIndexer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SymbolSet
extends Node {
    private final MatchType originalMatchType;
    private final RgxGenCharsDefinition positiveGenerationChars;
    private final RgxGenCharsDefinition negativeMatchExclusion;
    private final boolean isAscii;
    protected final SymbolRange universeCharacters;
    private final List<SymbolRange> symbolRanges;
    private final CharList symbols;
    private SymbolSetIndexer symbolSetIndexer;
    private SymbolSetIndexer caseInsensitiveSymbolSetIndexer;

    public static SymbolSet ofDotPattern(RgxGenProperties properties) {
        RgxGenCharsDefinition charsDefinition = RgxGenOption.DOT_MATCHES_ONLY.getFromProperties(properties);
        if (charsDefinition != null) {
            boolean isAscii = charsDefinition.isAsciiOnly();
            if (isAscii) {
                return SymbolSet.ofAscii(".", charsDefinition.getRangeList(), charsDefinition.getCharacters(), MatchType.POSITIVE);
            }
            return SymbolSet.ofUnicode(".", charsDefinition.getRangeList(), charsDefinition.getCharacters(), MatchType.POSITIVE);
        }
        return SymbolSet.ofAscii(".", Collections.singletonList(ConstantsProvider.ASCII_SYMBOL_RANGE), CharList.empty(), MatchType.POSITIVE);
    }

    public static SymbolSet ofAsciiCharacters(String pattern, char[] symbols, MatchType type) {
        return new SymbolSet(pattern, Collections.emptyList(), CharList.charList(symbols), type, ConstantsProvider.ASCII_SYMBOL_RANGE);
    }

    public static SymbolSet ofUnicodeCharacterClass(String pattern, UnicodeCategory unicodeCategory, MatchType type) {
        return new SymbolSet(pattern, unicodeCategory.getSymbolRanges(), CharList.charList(unicodeCategory.getSymbols()), type, ConstantsProvider.UNICODE_SYMBOL_RANGE);
    }

    public static SymbolSet ofUnicode(String pattern, List<SymbolRange> symbolRanges, CharList symbols, MatchType matchType) {
        return new SymbolSet(pattern, symbolRanges, symbols, matchType, ConstantsProvider.UNICODE_SYMBOL_RANGE);
    }

    public static SymbolSet ofUnicode(String pattern, RgxGenCharsDefinition positiveMatchDefinitions, RgxGenCharsDefinition negativeMatchDefinitions, MatchType matchType) {
        return new SymbolSet(pattern, positiveMatchDefinitions, negativeMatchDefinitions, matchType, ConstantsProvider.UNICODE_SYMBOL_RANGE);
    }

    public static SymbolSet ofAscii(String pattern, List<SymbolRange> symbolRanges, CharList charList, MatchType type) {
        return new SymbolSet(pattern, symbolRanges, charList, type, ConstantsProvider.ASCII_SYMBOL_RANGE);
    }

    public static SymbolSet ofAsciiRanges(String pattern, List<SymbolRange> symbolRanges, MatchType type) {
        return new SymbolSet(pattern, symbolRanges, CharList.empty(), type, ConstantsProvider.ASCII_SYMBOL_RANGE);
    }

    public static SymbolSet ofAscii(String pattern, RgxGenCharsDefinition positiveMatchDefinitions, RgxGenCharsDefinition negativeMatchDefinitions, MatchType matchType) {
        return new SymbolSet(pattern, positiveMatchDefinitions, negativeMatchDefinitions, matchType, ConstantsProvider.ASCII_SYMBOL_RANGE);
    }

    public SymbolSet(String pattern, List<SymbolRange> symbolRanges, CharList symbols, MatchType type, SymbolRange universeCharacters) {
        this(pattern, RgxGenCharsDefinition.of(symbolRanges, symbols), null, type, universeCharacters);
    }

    public SymbolSet(String pattern, RgxGenCharsDefinition positiveGenerationChars, RgxGenCharsDefinition negativeMatchExclusion, MatchType type, SymbolRange universeCharacters) {
        super(pattern);
        this.positiveGenerationChars = positiveGenerationChars;
        this.negativeMatchExclusion = negativeMatchExclusion;
        this.isAscii = universeCharacters == ConstantsProvider.ASCII_SYMBOL_RANGE;
        this.universeCharacters = universeCharacters;
        if (type == MatchType.POSITIVE) {
            ArrayList<SymbolRange> compactedRanges = new ArrayList<SymbolRange>(positiveGenerationChars.getRangeList().size());
            CharList compactedCharacters = CharList.ofCapacity(positiveGenerationChars.getCharacters().size());
            Util.compactOverlappingRangesAndSymbols(positiveGenerationChars.getRangeList(), positiveGenerationChars.getCharacters(), compactedRanges, compactedCharacters);
            this.symbolRanges = compactedRanges;
            this.symbols = compactedCharacters;
        } else {
            this.symbolRanges = new ArrayList<SymbolRange>();
            this.symbols = CharList.empty();
            RgxGenCharsDefinition defsToUse = negativeMatchExclusion == null ? positiveGenerationChars : negativeMatchExclusion;
            ArrayList<SymbolRange> compactedRanges = new ArrayList<SymbolRange>(defsToUse.getRangeList().size());
            CharList compactedCharacters = CharList.ofCapacity(defsToUse.getCharacters().size());
            Util.compactOverlappingRangesAndSymbols(defsToUse.getRangeList(), defsToUse.getCharacters(), compactedRanges, compactedCharacters);
            Util.invertSymbolsAndRanges(compactedRanges, compactedCharacters, universeCharacters, this.symbolRanges, this.symbols);
        }
        this.originalMatchType = type;
    }

    public SymbolSet getInvertedNode() {
        if (this.isAscii) {
            return SymbolSet.ofAscii("[^" + this.getPattern().substring(1), this.symbolRanges, this.symbols, MatchType.NEGATIVE);
        }
        return SymbolSet.ofUnicode("[^" + this.getPattern().substring(1), this.symbolRanges, this.symbols, MatchType.NEGATIVE);
    }

    @Override
    public void visit(NodeVisitor visitor) {
        visitor.visit(this);
    }

    public SymbolSetIndexer getSymbolSetIndexer() {
        if (this.symbolSetIndexer == null) {
            this.symbolSetIndexer = new SymbolSetIndexer(this);
        }
        return this.symbolSetIndexer;
    }

    public SymbolSetIndexer getCaseInsensitiveSymbolSetIndexer() {
        if (this.caseInsensitiveSymbolSetIndexer == null) {
            CharList caseInsensitiveSymbols = this.positiveGenerationChars.getCharacters().copy();
            CharList characters = this.positiveGenerationChars.getCharacters();
            for (int i = 0; i < characters.size(); ++i) {
                SymbolSet.addIfChangedCase(caseInsensitiveSymbols, characters.get(i));
            }
            for (SymbolRange originalSymbolRange : this.positiveGenerationChars.getRangeList()) {
                for (char c = (char)originalSymbolRange.getFrom(); c <= originalSymbolRange.getTo(); c = (char)(c + '\u0001')) {
                    SymbolSet.addIfChangedCase(caseInsensitiveSymbols, c);
                }
            }
            this.caseInsensitiveSymbolSetIndexer = new SymbolSetIndexer(new SymbolSet(this.getPattern(), this.positiveGenerationChars.getRangeList(), caseInsensitiveSymbols, this.originalMatchType, this.universeCharacters));
        }
        return this.caseInsensitiveSymbolSetIndexer;
    }

    private static void addIfChangedCase(CharList caseInsensitiveSymbols, char c) {
        if (Character.isUpperCase(c)) {
            caseInsensitiveSymbols.add(Character.toLowerCase(c));
        } else if (Character.isLowerCase(c)) {
            caseInsensitiveSymbols.add(Character.toUpperCase(c));
        }
    }

    public boolean isAscii() {
        return this.isAscii;
    }

    public List<SymbolRange> getSymbolRanges() {
        return this.symbolRanges;
    }

    public CharList getSymbols() {
        return this.symbols;
    }

    public String toString() {
        return "SymbolSet{originalMatchType=" + this.originalMatchType + ", positiveGenerationChars=" + this.positiveGenerationChars + ", negativeMatchExclusion=" + this.negativeMatchExclusion + ", isAscii=" + this.isAscii + ", symbolRanges=" + this.symbolRanges + ", symbols=" + this.symbols + "} ";
    }

    public boolean hasModifiedExclusionChars() {
        return this.negativeMatchExclusion != null;
    }

    public RgxGenCharsDefinition getNegativeMatchExclusionChars() {
        return this.negativeMatchExclusion;
    }
}

