/*
 * Decompiled with CFR 0.152.
 */
package com.github.curiousoddman.rgxgen;

import com.github.curiousoddman.rgxgen.config.RgxGenProperties;
import com.github.curiousoddman.rgxgen.iterators.StringIterator;
import com.github.curiousoddman.rgxgen.nodes.Node;
import com.github.curiousoddman.rgxgen.parsing.dflt.DefaultTreeBuilder;
import com.github.curiousoddman.rgxgen.visitors.GenerationVisitor;
import com.github.curiousoddman.rgxgen.visitors.NotMatchingGenerationVisitor;
import com.github.curiousoddman.rgxgen.visitors.UniqueGenerationVisitor;
import com.github.curiousoddman.rgxgen.visitors.UniqueValuesCountingVisitor;
import java.math.BigInteger;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Stream;

public class RgxGen {
    private final Node node;
    private final RgxGenProperties properties;

    public static RgxGen parse(String pattern) {
        return RgxGen.parse(null, pattern);
    }

    public static RgxGen parse(RgxGenProperties rgxGenProperties, String pattern) {
        return new RgxGen(rgxGenProperties, pattern);
    }

    private RgxGen(RgxGenProperties properties, String pattern) {
        this.properties = properties;
        DefaultTreeBuilder defaultTreeBuilder = new DefaultTreeBuilder(pattern, this.properties);
        this.node = defaultTreeBuilder.get();
    }

    public Optional<BigInteger> getUniqueEstimation() {
        UniqueValuesCountingVisitor v = new UniqueValuesCountingVisitor(this.properties);
        this.node.visit(v);
        return v.getEstimation();
    }

    public Stream<String> stream() {
        return Stream.generate(this::generate);
    }

    public StringIterator iterateUnique() {
        UniqueGenerationVisitor ugv = new UniqueGenerationVisitor(this.properties);
        this.node.visit(ugv);
        return ugv.getUniqueStrings();
    }

    public String generate() {
        return this.generate(new Random());
    }

    public String generate(Random random) {
        GenerationVisitor gv = GenerationVisitor.builder().withRandom(random).withProperties(this.properties).get();
        this.node.visit(gv);
        return gv.getString();
    }

    public String generateNotMatching() {
        return this.generateNotMatching(new Random());
    }

    public String generateNotMatching(Random random) {
        GenerationVisitor nmgv = NotMatchingGenerationVisitor.builder().withRandom(random).get();
        this.node.visit(nmgv);
        return nmgv.getString();
    }
}

