/*
 * Decompiled with CFR 0.152.
 */
package com.github.curiousoddman.rgxgen.iterators;

import com.github.curiousoddman.rgxgen.iterators.StringIterator;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Supplier;

public class PermutationsIterator
extends StringIterator {
    private final StringIterator[] aIterators;
    private final String[] aGeneratedParts;

    public PermutationsIterator(List<Supplier<StringIterator>> iteratorsSuppliers) {
        this.aIterators = new StringIterator[iteratorsSuppliers.size()];
        this.aGeneratedParts = new String[this.aIterators.length];
        for (int i = 0; i < this.aIterators.length; ++i) {
            StringIterator iterator;
            this.aIterators[i] = iterator = iteratorsSuppliers.get(i).get();
        }
        this.aGeneratedParts[0] = null;
    }

    @Override
    public boolean hasNext() {
        return this.aGeneratedParts[0] == null || Arrays.stream(this.aIterators).anyMatch(Iterator::hasNext);
    }

    @Override
    public String nextImpl() {
        if (this.aGeneratedParts[0] == null) {
            for (int i = 0; i < this.aGeneratedParts.length; ++i) {
                this.aGeneratedParts[i] = this.aIterators[i].next();
            }
        } else {
            for (int i = this.aGeneratedParts.length - 1; i >= 0; --i) {
                if (this.aIterators[i].hasNext()) {
                    this.aGeneratedParts[i] = this.aIterators[i].next();
                    break;
                }
                if (i == 0) {
                    throw new NoSuchElementException("No more unique values");
                }
                this.aIterators[i].reset();
                this.aGeneratedParts[i] = this.aIterators[i].next();
            }
        }
        return Arrays.stream(this.aIterators).map(StringIterator::current).reduce("", String::concat);
    }

    @Override
    public void reset() {
        this.aGeneratedParts[0] = null;
        for (StringIterator iterator : this.aIterators) {
            iterator.reset();
        }
    }

    @Override
    public String current() {
        return Arrays.stream(this.aIterators).map(StringIterator::current).reduce("", String::concat);
    }

    public String toString() {
        return "PermutationsIterator{, aIterators=" + Arrays.toString(this.aIterators) + ", aGeneratedParts=" + Arrays.toString(this.aGeneratedParts) + '}';
    }
}

