/*
 * Decompiled with CFR 0.152.
 */
package com.github.curiousoddman.rgxgen.generator.visitors;

import com.github.curiousoddman.rgxgen.generator.nodes.Choice;
import com.github.curiousoddman.rgxgen.generator.nodes.FinalSymbol;
import com.github.curiousoddman.rgxgen.generator.nodes.Group;
import com.github.curiousoddman.rgxgen.generator.nodes.GroupRef;
import com.github.curiousoddman.rgxgen.generator.nodes.Node;
import com.github.curiousoddman.rgxgen.generator.nodes.NotSymbol;
import com.github.curiousoddman.rgxgen.generator.nodes.Repeat;
import com.github.curiousoddman.rgxgen.generator.nodes.Sequence;
import com.github.curiousoddman.rgxgen.generator.nodes.SymbolSet;
import com.github.curiousoddman.rgxgen.generator.visitors.NodeVisitor;
import java.math.BigInteger;
import java.util.function.Function;

public class UniqueValuesCountingVisitor
implements NodeVisitor {
    private BigInteger aCount = BigInteger.ZERO;
    private final Node aParentNode;

    public UniqueValuesCountingVisitor() {
        this(null);
    }

    public UniqueValuesCountingVisitor(Node parentNode) {
        this.aParentNode = parentNode;
    }

    private void applyOrSkip(Function<BigInteger, BigInteger> func) {
        if (this.aCount != null) {
            this.aCount = func.apply(this.aCount);
        }
    }

    @Override
    public void visit(SymbolSet node) {
        this.applyOrSkip(v -> v.add(BigInteger.valueOf(node.getSymbols().length)));
    }

    @Override
    public void visit(Choice node) {
        for (Node vnode : node.getNodes()) {
            BigInteger count = UniqueValuesCountingVisitor.countSeparately(node, vnode);
            this.applyOrSkip(v -> {
                if (count == null) {
                    return null;
                }
                return v.add(count);
            });
        }
    }

    @Override
    public void visit(FinalSymbol node) {
        this.applyOrSkip(v -> v.add(BigInteger.ONE));
    }

    @Override
    public void visit(Repeat node) {
        UniqueValuesCountingVisitor countingVisitor = new UniqueValuesCountingVisitor(node);
        node.getNode().visit(countingVisitor);
        if (node.getMax() < 0 || countingVisitor.aCount == null) {
            this.aCount = null;
        } else if (this.aCount != null) {
            for (int i = node.getMin(); i <= node.getMax(); ++i) {
                this.aCount = this.aCount.add(countingVisitor.aCount.pow(i));
            }
        }
    }

    @Override
    public void visit(Sequence node) {
        for (Node vnode : node.getNodes()) {
            BigInteger count = UniqueValuesCountingVisitor.countSeparately(node, vnode);
            this.applyOrSkip(v -> {
                if (count == null) {
                    return null;
                }
                if (v.equals(BigInteger.ZERO)) {
                    return count;
                }
                return count.equals(BigInteger.ZERO) ? v : v.multiply(count);
            });
        }
    }

    private static BigInteger countSeparately(Node parentNode, Node vnode) {
        UniqueValuesCountingVisitor countingVisitor = new UniqueValuesCountingVisitor(parentNode);
        vnode.visit(countingVisitor);
        return countingVisitor.aCount;
    }

    @Override
    public void visit(NotSymbol node) {
        this.aCount = null;
    }

    @Override
    public void visit(GroupRef groupRef) {
        if (this.aParentNode != null && (this.aParentNode instanceof Repeat || this.aParentNode instanceof Choice)) {
            this.aCount = this.aCount.add(BigInteger.ONE);
        }
    }

    @Override
    public void visit(Group group) {
        group.getNode().visit(this);
    }

    public BigInteger getCount() {
        return this.aCount;
    }
}

