/*
 * Decompiled with CFR 0.152.
 */
package com.github.curiousoddman.rgxgen.parsing;

import com.github.curiousoddman.rgxgen.generator.nodes.AnySymbol;
import com.github.curiousoddman.rgxgen.generator.nodes.Choice;
import com.github.curiousoddman.rgxgen.generator.nodes.FinalSymbol;
import com.github.curiousoddman.rgxgen.generator.nodes.Node;
import com.github.curiousoddman.rgxgen.generator.nodes.Repeat;
import com.github.curiousoddman.rgxgen.generator.nodes.Sequence;
import com.github.curiousoddman.rgxgen.parsing.NodeTreeBuilder;
import com.github.curiousoddman.rgxgen.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.IntStream;

public class DefaultTreeBuilder
implements NodeTreeBuilder {
    private final String aExpr;
    private int aCurrentIndex = 0;
    private Node aNode;

    public DefaultTreeBuilder(String expr) {
        this.aExpr = expr;
    }

    public Node parseGroup() {
        ArrayList<Node> choices = new ArrayList<Node>();
        ArrayList<Node> nodes = new ArrayList<Node>();
        StringBuilder sb = new StringBuilder();
        boolean isChoice = false;
        block9: while (this.aExpr.length() > this.aCurrentIndex) {
            char c = this.aExpr.charAt(this.aCurrentIndex++);
            switch (c) {
                case '[': {
                    if (sb.length() != 0) {
                        nodes.add(new FinalSymbol(sb.toString()));
                        sb.delete(0, sb.length());
                    }
                    nodes.add(this.handleCharacterVariations());
                    continue block9;
                }
                case '(': {
                    if (sb.length() != 0) {
                        nodes.add(new FinalSymbol(sb.toString()));
                        sb.delete(0, sb.length());
                    }
                    nodes.add(this.parseGroup());
                    continue block9;
                }
                case '|': {
                    if (sb.length() != 0) {
                        nodes.add(new FinalSymbol(sb.toString()));
                        sb.delete(0, sb.length());
                    }
                    choices.add(DefaultTreeBuilder.sequenceOrNot(nodes, choices, false));
                    nodes.clear();
                    isChoice = true;
                    continue block9;
                }
                case ')': {
                    if (sb.length() != 0) {
                        nodes.add(new FinalSymbol(sb.toString()));
                        sb.delete(0, sb.length());
                    }
                    if (isChoice) {
                        choices.add(DefaultTreeBuilder.sequenceOrNot(nodes, choices, false));
                        nodes.clear();
                    }
                    return DefaultTreeBuilder.sequenceOrNot(nodes, choices, isChoice);
                }
                case '*': 
                case '+': 
                case '?': 
                case '{': {
                    Node repeatNode = null;
                    if (sb.length() == 0) {
                        repeatNode = nodes.remove(nodes.size() - 1);
                    } else {
                        char charToRepeat = sb.charAt(sb.length() - 1);
                        sb.deleteCharAt(sb.length() - 1);
                        if (sb.length() > 0) {
                            nodes.add(new FinalSymbol(sb.toString()));
                            sb.delete(0, sb.length());
                        }
                        repeatNode = new FinalSymbol(String.valueOf(charToRepeat));
                    }
                    nodes.add(this.handleRepeat(c, repeatNode));
                    continue block9;
                }
                case '.': {
                    if (sb.length() != 0) {
                        nodes.add(new FinalSymbol(sb.toString()));
                        sb.delete(0, sb.length());
                    }
                    nodes.add(DefaultTreeBuilder.handleDot());
                    continue block9;
                }
                case '\\': {
                    c = this.aExpr.charAt(this.aCurrentIndex++);
                    if (c != 'd') break;
                    if (sb.length() != 0) {
                        nodes.add(new FinalSymbol(sb.toString()));
                        sb.delete(0, sb.length());
                    }
                    nodes.add(new Choice((Node[])IntStream.rangeClosed(0, 9).mapToObj(Integer::toString).map(FinalSymbol::new).toArray(FinalSymbol[]::new)));
                    continue block9;
                }
            }
            sb.append(c);
        }
        if (sb.length() != 0) {
            nodes.add(new FinalSymbol(sb.toString()));
        }
        return DefaultTreeBuilder.sequenceOrNot(nodes, choices, isChoice);
    }

    private Repeat handleRepeat(char c, Node repeatNode) {
        if (c == '*') {
            return Repeat.minimum(repeatNode, 0);
        }
        if (c == '?') {
            return new Repeat(repeatNode, 0, 1);
        }
        if (c == '+') {
            return Repeat.minimum(repeatNode, 1);
        }
        if (c == '{') {
            StringBuilder sb = new StringBuilder();
            int min = -1;
            block5: while (this.aExpr.length() > this.aCurrentIndex) {
                char tmpc = this.aExpr.charAt(this.aCurrentIndex++);
                switch (tmpc) {
                    case ',': {
                        min = Integer.parseInt(sb.toString());
                        sb.delete(0, sb.length());
                        continue block5;
                    }
                    case '}': {
                        if (min == -1) {
                            return new Repeat(repeatNode, Integer.parseInt(sb.toString()));
                        }
                        return new Repeat(repeatNode, min, Integer.parseInt(sb.toString()));
                    }
                    case '\\': {
                        tmpc = this.aExpr.charAt(this.aCurrentIndex++);
                    }
                }
                sb.append(tmpc);
            }
            throw new RuntimeException("Unbalanced '{' - missing '}'");
        }
        throw new RuntimeException("Unknown repetition character '" + c + '\'');
    }

    private static Node sequenceOrNot(List<Node> nodes, List<Node> choices, boolean isChoice) {
        if (nodes.size() == 1) {
            return nodes.get(0);
        }
        if (isChoice) {
            if (choices.isEmpty()) {
                throw new RuntimeException("Empty nodes");
            }
            return new Choice(choices.toArray(new Node[0]));
        }
        if (nodes.isEmpty()) {
            throw new RuntimeException("Empty nodes");
        }
        return new Sequence(nodes.toArray(new Node[0]));
    }

    private static Node handleDot() {
        return new AnySymbol();
    }

    private Node handleCharacterVariations() {
        StringBuilder sb = new StringBuilder();
        block5: while (this.aExpr.length() > this.aCurrentIndex) {
            char c = this.aExpr.charAt(this.aCurrentIndex++);
            switch (c) {
                case ']': {
                    Node[] nodes = (Node[])Arrays.stream(Util.stringToCharsSubstrings(sb.toString())).map(FinalSymbol::new).toArray(Node[]::new);
                    return new Choice(nodes);
                }
                case '-': {
                    c = this.aExpr.charAt(this.aCurrentIndex++);
                    sb.deleteCharAt(sb.length() - 1);
                    for (char currentChar = sb.charAt(sb.length() - 1); currentChar <= c; currentChar = (char)(currentChar + '\u0001')) {
                        sb.append(currentChar);
                    }
                    continue block5;
                }
                case '\\': {
                    c = this.aExpr.charAt(this.aCurrentIndex++);
                }
            }
            sb.append(c);
        }
        throw new RuntimeException("Unexpected End Of Expression. Didn't find closing ']'");
    }

    public void build() {
        this.aNode = this.parseGroup();
        if (this.aCurrentIndex < this.aExpr.length()) {
            throw new RuntimeException("Expression was not fully parsed");
        }
    }

    @Override
    public Node get() {
        if (this.aNode == null) {
            this.build();
        }
        return this.aNode;
    }
}

