/*
 * Decompiled with CFR 0.152.
 */
package com.github.curiousoddman.rgxgen.generator.visitors;

import com.github.curiousoddman.rgxgen.generator.nodes.AnySymbol;
import com.github.curiousoddman.rgxgen.generator.nodes.Choice;
import com.github.curiousoddman.rgxgen.generator.nodes.FinalSymbol;
import com.github.curiousoddman.rgxgen.generator.nodes.Node;
import com.github.curiousoddman.rgxgen.generator.nodes.Repeat;
import com.github.curiousoddman.rgxgen.generator.nodes.Sequence;
import com.github.curiousoddman.rgxgen.generator.visitors.NodeVisitor;
import java.util.concurrent.ThreadLocalRandom;

public class GenerationVisitor
implements NodeVisitor {
    private StringBuilder aStringBuilder = new StringBuilder();

    @Override
    public void visit(AnySymbol node) {
        String[] allSymbols = AnySymbol.ALL_SYMBOLS;
        int idx = ThreadLocalRandom.current().nextInt(allSymbols.length);
        this.aStringBuilder.append(allSymbols[idx]);
    }

    @Override
    public void visit(Choice node) {
        Node[] nodes = node.getNodes();
        int idx = ThreadLocalRandom.current().nextInt(nodes.length);
        nodes[idx].visit(this);
    }

    @Override
    public void visit(FinalSymbol node) {
        this.aStringBuilder.append(node.getValue());
    }

    @Override
    public void visit(Repeat node) {
        int max = node.getMax() == -1 ? 100 : node.getMax();
        int repeat = node.getMin() >= max ? node.getMin() : ThreadLocalRandom.current().nextInt(node.getMin(), max);
        for (long i = 0L; i < (long)repeat; ++i) {
            node.getNode().visit(this);
        }
    }

    @Override
    public void visit(Sequence node) {
        for (Node n : node.getNodes()) {
            n.visit(this);
        }
    }

    public String getString() {
        return this.aStringBuilder.toString();
    }
}

