/*
 * Decompiled with CFR 0.152.
 */
package master.flame.danmaku.danmaku.model.android;

import android.graphics.Typeface;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import master.flame.danmaku.controller.DanmakuFilters;
import master.flame.danmaku.danmaku.model.AbsDisplayer;
import master.flame.danmaku.danmaku.model.AlphaValue;
import master.flame.danmaku.danmaku.model.GlobalFlagValues;
import master.flame.danmaku.danmaku.model.android.AndroidDisplayer;
import master.flame.danmaku.danmaku.model.android.BaseCacheStuffer;
import master.flame.danmaku.danmaku.model.android.DanmakuFactory;

public class DanmakuContext {
    public Typeface mFont = null;
    public int transparency = AlphaValue.MAX;
    public float scaleTextSize = 1.0f;
    public boolean FTDanmakuVisibility = true;
    public boolean FBDanmakuVisibility = true;
    public boolean L2RDanmakuVisibility = true;
    public boolean R2LDanmakuVisibility = true;
    public boolean SecialDanmakuVisibility = true;
    List<Integer> mFilterTypes = new ArrayList<Integer>();
    public int maximumNumsInScreen = -1;
    public float scrollSpeedFactor = 1.0f;
    public int refreshRateMS = 15;
    public BorderType shadowType = BorderType.SHADOW;
    public int shadowRadius = 3;
    List<Integer> mColorValueWhiteList = new ArrayList<Integer>();
    List<Integer> mUserIdBlackList = new ArrayList<Integer>();
    List<String> mUserHashBlackList = new ArrayList<String>();
    private List<WeakReference<ConfigChangedCallback>> mCallbackList;
    private boolean mBlockGuestDanmaku = false;
    private boolean mDuplicateMergingEnable = false;
    private BaseCacheStuffer mCacheStuffer;
    private boolean mIsMaxLinesLimited;
    private boolean mIsPreventOverlappingEnabled;
    private final AbsDisplayer mDisplayer = new AndroidDisplayer();
    public final GlobalFlagValues mGlobalFlagValues = new GlobalFlagValues();
    public final DanmakuFilters mDanmakuFilters = new DanmakuFilters();
    public final DanmakuFactory mDanmakuFactory = DanmakuFactory.create();

    public static DanmakuContext create() {
        return new DanmakuContext();
    }

    public AbsDisplayer getDisplayer() {
        return this.mDisplayer;
    }

    public DanmakuContext setTypeface(Typeface font) {
        if (this.mFont != font) {
            this.mFont = font;
            this.mDisplayer.clearTextHeightCache();
            this.mDisplayer.setTypeFace(font);
            this.notifyConfigureChanged(DanmakuConfigTag.TYPEFACE, new Object[0]);
        }
        return this;
    }

    public DanmakuContext setDanmakuTransparency(float p) {
        int newTransparency = (int)(p * (float)AlphaValue.MAX);
        if (newTransparency != this.transparency) {
            this.transparency = newTransparency;
            this.mDisplayer.setTransparency(newTransparency);
            this.notifyConfigureChanged(DanmakuConfigTag.TRANSPARENCY, Float.valueOf(p));
        }
        return this;
    }

    public DanmakuContext setScaleTextSize(float p) {
        if (this.scaleTextSize != p) {
            this.scaleTextSize = p;
            this.mDisplayer.clearTextHeightCache();
            this.mDisplayer.setScaleTextSizeFactor(p);
            this.mGlobalFlagValues.updateMeasureFlag();
            this.mGlobalFlagValues.updateVisibleFlag();
            this.notifyConfigureChanged(DanmakuConfigTag.SCALE_TEXTSIZE, Float.valueOf(p));
        }
        return this;
    }

    public boolean getFTDanmakuVisibility() {
        return this.FTDanmakuVisibility;
    }

    public DanmakuContext setFTDanmakuVisibility(boolean visible) {
        this.setDanmakuVisible(visible, 5);
        this.setFilterData("1010_Filter", this.mFilterTypes);
        this.mGlobalFlagValues.updateFilterFlag();
        if (this.FTDanmakuVisibility != visible) {
            this.FTDanmakuVisibility = visible;
            this.notifyConfigureChanged(DanmakuConfigTag.FT_DANMAKU_VISIBILITY, visible);
        }
        return this;
    }

    private <T> void setFilterData(String tag, T data) {
        this.setFilterData(tag, data, true);
    }

    private <T> void setFilterData(String tag, T data, boolean primary) {
        DanmakuFilters.IDanmakuFilter<?> filter = this.mDanmakuFilters.get(tag, primary);
        filter.setData(data);
    }

    private void setDanmakuVisible(boolean visible, int type) {
        if (visible) {
            this.mFilterTypes.remove((Object)type);
        } else if (!this.mFilterTypes.contains(type)) {
            this.mFilterTypes.add(type);
        }
    }

    public boolean getFBDanmakuVisibility() {
        return this.FBDanmakuVisibility;
    }

    public DanmakuContext setFBDanmakuVisibility(boolean visible) {
        this.setDanmakuVisible(visible, 4);
        this.setFilterData("1010_Filter", this.mFilterTypes);
        this.mGlobalFlagValues.updateFilterFlag();
        if (this.FBDanmakuVisibility != visible) {
            this.FBDanmakuVisibility = visible;
            this.notifyConfigureChanged(DanmakuConfigTag.FB_DANMAKU_VISIBILITY, visible);
        }
        return this;
    }

    public boolean getL2RDanmakuVisibility() {
        return this.L2RDanmakuVisibility;
    }

    public DanmakuContext setL2RDanmakuVisibility(boolean visible) {
        this.setDanmakuVisible(visible, 6);
        this.setFilterData("1010_Filter", this.mFilterTypes);
        this.mGlobalFlagValues.updateFilterFlag();
        if (this.L2RDanmakuVisibility != visible) {
            this.L2RDanmakuVisibility = visible;
            this.notifyConfigureChanged(DanmakuConfigTag.L2R_DANMAKU_VISIBILITY, visible);
        }
        return this;
    }

    public boolean getR2LDanmakuVisibility() {
        return this.R2LDanmakuVisibility;
    }

    public DanmakuContext setR2LDanmakuVisibility(boolean visible) {
        this.setDanmakuVisible(visible, 1);
        this.setFilterData("1010_Filter", this.mFilterTypes);
        this.mGlobalFlagValues.updateFilterFlag();
        if (this.R2LDanmakuVisibility != visible) {
            this.R2LDanmakuVisibility = visible;
            this.notifyConfigureChanged(DanmakuConfigTag.R2L_DANMAKU_VISIBILIY, visible);
        }
        return this;
    }

    public boolean getSecialDanmakuVisibility() {
        return this.SecialDanmakuVisibility;
    }

    public DanmakuContext setSpecialDanmakuVisibility(boolean visible) {
        this.setDanmakuVisible(visible, 7);
        this.setFilterData("1010_Filter", this.mFilterTypes);
        this.mGlobalFlagValues.updateFilterFlag();
        if (this.SecialDanmakuVisibility != visible) {
            this.SecialDanmakuVisibility = visible;
            this.notifyConfigureChanged(DanmakuConfigTag.SPECIAL_DANMAKU_VISIBILITY, visible);
        }
        return this;
    }

    public DanmakuContext setMaximumVisibleSizeInScreen(int maxSize) {
        this.maximumNumsInScreen = maxSize;
        if (maxSize == 0) {
            this.mDanmakuFilters.unregisterFilter("1011_Filter");
            this.mDanmakuFilters.unregisterFilter("1012_Filter");
            this.notifyConfigureChanged(DanmakuConfigTag.MAXIMUM_NUMS_IN_SCREEN, maxSize);
            return this;
        }
        if (maxSize == -1) {
            this.mDanmakuFilters.unregisterFilter("1011_Filter");
            this.mDanmakuFilters.registerFilter("1012_Filter");
            this.notifyConfigureChanged(DanmakuConfigTag.MAXIMUM_NUMS_IN_SCREEN, maxSize);
            return this;
        }
        this.setFilterData("1011_Filter", maxSize);
        this.mGlobalFlagValues.updateFilterFlag();
        this.notifyConfigureChanged(DanmakuConfigTag.MAXIMUM_NUMS_IN_SCREEN, maxSize);
        return this;
    }

    public DanmakuContext setDanmakuStyle(int style, float ... values) {
        this.mDisplayer.setDanmakuStyle(style, values);
        this.notifyConfigureChanged(DanmakuConfigTag.DANMAKU_STYLE, style, values);
        return this;
    }

    public DanmakuContext setDanmakuBold(boolean bold) {
        this.mDisplayer.setFakeBoldText(bold);
        this.notifyConfigureChanged(DanmakuConfigTag.DANMAKU_BOLD, bold);
        return this;
    }

    public DanmakuContext setColorValueWhiteList(Integer ... colors) {
        this.mColorValueWhiteList.clear();
        if (colors == null || colors.length == 0) {
            this.mDanmakuFilters.unregisterFilter("1013_Filter");
        } else {
            Collections.addAll(this.mColorValueWhiteList, colors);
            this.setFilterData("1013_Filter", this.mColorValueWhiteList);
        }
        this.mGlobalFlagValues.updateFilterFlag();
        this.notifyConfigureChanged(DanmakuConfigTag.COLOR_VALUE_WHITE_LIST, this.mColorValueWhiteList);
        return this;
    }

    public List<Integer> getColorValueWhiteList() {
        return this.mColorValueWhiteList;
    }

    public DanmakuContext setUserHashBlackList(String ... hashes) {
        this.mUserHashBlackList.clear();
        if (hashes == null || hashes.length == 0) {
            this.mDanmakuFilters.unregisterFilter("1015_Filter");
        } else {
            Collections.addAll(this.mUserHashBlackList, hashes);
            this.setFilterData("1015_Filter", this.mUserHashBlackList);
        }
        this.mGlobalFlagValues.updateFilterFlag();
        this.notifyConfigureChanged(DanmakuConfigTag.USER_HASH_BLACK_LIST, this.mUserHashBlackList);
        return this;
    }

    public DanmakuContext removeUserHashBlackList(String ... hashes) {
        if (hashes == null || hashes.length == 0) {
            return this;
        }
        for (String hash : hashes) {
            this.mUserHashBlackList.remove(hash);
        }
        this.setFilterData("1015_Filter", this.mUserHashBlackList);
        this.mGlobalFlagValues.updateFilterFlag();
        this.notifyConfigureChanged(DanmakuConfigTag.USER_HASH_BLACK_LIST, this.mUserHashBlackList);
        return this;
    }

    public DanmakuContext addUserHashBlackList(String ... hashes) {
        if (hashes == null || hashes.length == 0) {
            return this;
        }
        Collections.addAll(this.mUserHashBlackList, hashes);
        this.setFilterData("1015_Filter", this.mUserHashBlackList);
        this.mGlobalFlagValues.updateFilterFlag();
        this.notifyConfigureChanged(DanmakuConfigTag.USER_HASH_BLACK_LIST, this.mUserHashBlackList);
        return this;
    }

    public List<String> getUserHashBlackList() {
        return this.mUserHashBlackList;
    }

    public DanmakuContext setUserIdBlackList(Integer ... ids) {
        this.mUserIdBlackList.clear();
        if (ids == null || ids.length == 0) {
            this.mDanmakuFilters.unregisterFilter("1014_Filter");
        } else {
            Collections.addAll(this.mUserIdBlackList, ids);
            this.setFilterData("1014_Filter", this.mUserIdBlackList);
        }
        this.mGlobalFlagValues.updateFilterFlag();
        this.notifyConfigureChanged(DanmakuConfigTag.USER_ID_BLACK_LIST, this.mUserIdBlackList);
        return this;
    }

    public DanmakuContext removeUserIdBlackList(Integer ... ids) {
        if (ids == null || ids.length == 0) {
            return this;
        }
        for (Integer id : ids) {
            this.mUserIdBlackList.remove(id);
        }
        this.setFilterData("1014_Filter", this.mUserIdBlackList);
        this.mGlobalFlagValues.updateFilterFlag();
        this.notifyConfigureChanged(DanmakuConfigTag.USER_ID_BLACK_LIST, this.mUserIdBlackList);
        return this;
    }

    public DanmakuContext addUserIdBlackList(Integer ... ids) {
        if (ids == null || ids.length == 0) {
            return this;
        }
        Collections.addAll(this.mUserIdBlackList, ids);
        this.setFilterData("1014_Filter", this.mUserIdBlackList);
        this.mGlobalFlagValues.updateFilterFlag();
        this.notifyConfigureChanged(DanmakuConfigTag.USER_ID_BLACK_LIST, this.mUserIdBlackList);
        return this;
    }

    public List<Integer> getUserIdBlackList() {
        return this.mUserIdBlackList;
    }

    public DanmakuContext blockGuestDanmaku(boolean block) {
        if (this.mBlockGuestDanmaku != block) {
            this.mBlockGuestDanmaku = block;
            if (block) {
                this.setFilterData("1016_Filter", block);
            } else {
                this.mDanmakuFilters.unregisterFilter("1016_Filter");
            }
            this.mGlobalFlagValues.updateFilterFlag();
            this.notifyConfigureChanged(DanmakuConfigTag.BLOCK_GUEST_DANMAKU, block);
        }
        return this;
    }

    public DanmakuContext setScrollSpeedFactor(float p) {
        if (this.scrollSpeedFactor != p) {
            this.scrollSpeedFactor = p;
            this.mDanmakuFactory.updateDurationFactor(p);
            this.mGlobalFlagValues.updateMeasureFlag();
            this.mGlobalFlagValues.updateVisibleFlag();
            this.notifyConfigureChanged(DanmakuConfigTag.SCROLL_SPEED_FACTOR, Float.valueOf(p));
        }
        return this;
    }

    public DanmakuContext setDuplicateMergingEnabled(boolean enable) {
        if (this.mDuplicateMergingEnable != enable) {
            this.mDuplicateMergingEnable = enable;
            this.mGlobalFlagValues.updateFilterFlag();
            this.notifyConfigureChanged(DanmakuConfigTag.DUPLICATE_MERGING_ENABLED, enable);
        }
        return this;
    }

    public boolean isDuplicateMergingEnabled() {
        return this.mDuplicateMergingEnable;
    }

    public DanmakuContext setMaximumLines(Map<Integer, Integer> pairs) {
        boolean bl = this.mIsMaxLinesLimited = pairs != null;
        if (pairs == null) {
            this.mDanmakuFilters.unregisterFilter("1018_Filter", false);
        } else {
            this.setFilterData("1018_Filter", pairs, false);
        }
        this.mGlobalFlagValues.updateFilterFlag();
        this.notifyConfigureChanged(DanmakuConfigTag.MAXIMUN_LINES, pairs);
        return this;
    }

    @Deprecated
    public DanmakuContext setOverlapping(Map<Integer, Boolean> pairs) {
        return this.preventOverlapping(pairs);
    }

    public DanmakuContext preventOverlapping(Map<Integer, Boolean> pairs) {
        boolean bl = this.mIsPreventOverlappingEnabled = pairs != null;
        if (pairs == null) {
            this.mDanmakuFilters.unregisterFilter("1019_Filter", false);
        } else {
            this.setFilterData("1019_Filter", pairs, false);
        }
        this.mGlobalFlagValues.updateFilterFlag();
        this.notifyConfigureChanged(DanmakuConfigTag.OVERLAPPING_ENABLE, pairs);
        return this;
    }

    public boolean isMaxLinesLimited() {
        return this.mIsMaxLinesLimited;
    }

    public boolean isPreventOverlappingEnabled() {
        return this.mIsPreventOverlappingEnabled;
    }

    public DanmakuContext setCacheStuffer(BaseCacheStuffer cacheStuffer, BaseCacheStuffer.Proxy cacheStufferAdapter) {
        this.mCacheStuffer = cacheStuffer;
        if (this.mCacheStuffer != null) {
            this.mCacheStuffer.setProxy(cacheStufferAdapter);
            this.mDisplayer.setCacheStuffer(this.mCacheStuffer);
        }
        return this;
    }

    public void registerConfigChangedCallback(ConfigChangedCallback listener) {
        if (listener == null || this.mCallbackList == null) {
            this.mCallbackList = Collections.synchronizedList(new ArrayList());
        }
        for (WeakReference<ConfigChangedCallback> configReferer : this.mCallbackList) {
            if (!listener.equals(configReferer.get())) continue;
            return;
        }
        this.mCallbackList.add(new WeakReference<ConfigChangedCallback>(listener));
    }

    public void unregisterConfigChangedCallback(ConfigChangedCallback listener) {
        if (listener == null || this.mCallbackList == null) {
            return;
        }
        for (WeakReference<ConfigChangedCallback> configReferer : this.mCallbackList) {
            if (!listener.equals(configReferer.get())) continue;
            this.mCallbackList.remove(listener);
            return;
        }
    }

    public void unregisterAllConfigChangedCallbacks() {
        if (this.mCallbackList != null) {
            this.mCallbackList.clear();
            this.mCallbackList = null;
        }
    }

    private void notifyConfigureChanged(DanmakuConfigTag tag, Object ... values) {
        if (this.mCallbackList != null) {
            for (WeakReference<ConfigChangedCallback> configReferer : this.mCallbackList) {
                ConfigChangedCallback cb = (ConfigChangedCallback)configReferer.get();
                if (cb == null) continue;
                cb.onDanmakuConfigChanged(this, tag, values);
            }
        }
    }

    public static interface ConfigChangedCallback {
        public boolean onDanmakuConfigChanged(DanmakuContext var1, DanmakuConfigTag var2, Object ... var3);
    }

    public static enum BorderType {
        NONE,
        SHADOW,
        STROKEN;

    }

    public static enum DanmakuConfigTag {
        FT_DANMAKU_VISIBILITY,
        FB_DANMAKU_VISIBILITY,
        L2R_DANMAKU_VISIBILITY,
        R2L_DANMAKU_VISIBILIY,
        SPECIAL_DANMAKU_VISIBILITY,
        TYPEFACE,
        TRANSPARENCY,
        SCALE_TEXTSIZE,
        MAXIMUM_NUMS_IN_SCREEN,
        DANMAKU_STYLE,
        DANMAKU_BOLD,
        COLOR_VALUE_WHITE_LIST,
        USER_ID_BLACK_LIST,
        USER_HASH_BLACK_LIST,
        SCROLL_SPEED_FACTOR,
        BLOCK_GUEST_DANMAKU,
        DUPLICATE_MERGING_ENABLED,
        MAXIMUN_LINES,
        OVERLAPPING_ENABLE;


        public boolean isVisibilityRelatedTag() {
            return this.equals((Object)FT_DANMAKU_VISIBILITY) || this.equals((Object)FB_DANMAKU_VISIBILITY) || this.equals((Object)L2R_DANMAKU_VISIBILITY) || this.equals((Object)R2L_DANMAKU_VISIBILIY) || this.equals((Object)SPECIAL_DANMAKU_VISIBILITY) || this.equals((Object)COLOR_VALUE_WHITE_LIST) || this.equals((Object)USER_ID_BLACK_LIST);
        }
    }
}

