/*
 * Decompiled with CFR 0.152.
 */
package com.crabshue.commons.validations.file.validators;

import com.crabshue.commons.validations.file.annotations.AccessMode;
import com.crabshue.commons.validations.file.annotations.ValidDirectory;
import java.io.File;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

public class DirectoryValidator
implements ConstraintValidator<ValidDirectory, File> {
    private AccessMode[] accessModes;

    public void initialize(ValidDirectory constraintAnnotation) {
        this.accessModes = constraintAnnotation.accessModes();
    }

    public boolean isValid(File file, ConstraintValidatorContext constraintValidatorContext) {
        if (file != null) {
            if (!file.exists()) {
                this.setErrorMessage(constraintValidatorContext, "The directory '${validatedValue}' does not exist");
                return false;
            }
            if (!file.isDirectory()) {
                this.setErrorMessage(constraintValidatorContext, "'${validatedValue}' is not a directory");
                return false;
            }
            for (AccessMode accessMode : this.accessModes) {
                if (accessMode.canAccessInMode(file).booleanValue()) continue;
                this.setErrorMessage(constraintValidatorContext, "The directory '${validatedValue}' cannot be accessed in " + accessMode.getAccessMode());
                return false;
            }
        }
        return true;
    }

    private void setErrorMessage(ConstraintValidatorContext constraintValidatorContext, String message) {
        constraintValidatorContext.disableDefaultConstraintViolation();
        constraintValidatorContext.buildConstraintViolationWithTemplate(message).addConstraintViolation();
    }
}

