package com.crabshue.commons.validations.path.annotations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import javax.validation.Constraint;
import javax.validation.Payload;

import com.crabshue.commons.validations.path.validators.DirectoryPathValidator;

/**
 * Annotation used to validate a directory
 * <p>
 * It checks that the object is a directory, exists and can be accessed in the defined modes.
 */
@Constraint(validatedBy = DirectoryPathValidator.class)
@Target(ElementType.FIELD)
@Retention(RetentionPolicy.RUNTIME)
public @interface ValidDirectoryPath {

    PathAccessMode[] accessModes() default {PathAccessMode.READ, PathAccessMode.WRITE, PathAccessMode.EXEC};

    String message() default "The directory ${validatedValue} is not valid";

    Class<?>[] groups() default {};

    Class<? extends Payload>[] payload() default {};
}
