package com.crabshue.commons.validations.file.annotations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import javax.validation.Constraint;
import javax.validation.Payload;

import com.crabshue.commons.validations.file.validators.DirectoryValidator;

/**
 * Annotation used to validate a directory
 *
 * It checks that the object is a directory, exists and can be accessed in the defined modes.
 */
@Constraint(validatedBy = DirectoryValidator.class)
@Target(ElementType.FIELD)
@Retention(RetentionPolicy.RUNTIME)
public @interface ValidDirectory {

    AccessMode[] accessModes() default {AccessMode.READ, AccessMode.WRITE, AccessMode.EXEC};

    String message() default "The directory ${validatedValue} is not valid";

    Class<?>[] groups() default {};

    Class<? extends Payload>[] payload() default {};
}
