package com.crabshue.commons.validations.file.annotations;

import java.io.File;

import lombok.AllArgsConstructor;
import lombok.Getter;

@Getter
@AllArgsConstructor
public enum AccessMode implements AccessModeValidator {
    READ("read mode") {
        @Override
        public Boolean canAccessInMode(File file) {
            return file.canRead();
        }
    },
    WRITE("write mode") {
        @Override
        public Boolean canAccessInMode(File file) {
            return file.canWrite();
        }
    },
    EXEC("execute mode") {
        @Override
        public Boolean canAccessInMode(File file) {
            return file.canExecute();
        }
    };

    private String accessMode;
}
