/*
 * Decompiled with CFR 0.152.
 */
package com.crabshue.commons.json.serialization;

import com.crabshue.commons.exceptions.SystemException;
import com.crabshue.commons.exceptions.context.ErrorType;
import com.crabshue.commons.file.FileIOUtils;
import com.crabshue.commons.json.serialization.ObjectMapperBuilder;
import com.crabshue.commons.json.serialization.exceptions.JsonErrorType;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.NonNull;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonDeserializer {
    private static final Logger logger = LoggerFactory.getLogger(JsonDeserializer.class);
    private InputStream sourceToDeserialize;
    private Class<?> deserializationView;
    private final List<DeserializationFeature> deserializationFeatures = new ArrayList<DeserializationFeature>();

    public static JsonDeserializer of(@NonNull String sourceToDeserialize) {
        if (sourceToDeserialize == null) {
            throw new NullPointerException("sourceToDeserialize is marked @NonNull but is null");
        }
        JsonDeserializer ret = new JsonDeserializer();
        ret.sourceToDeserialize = IOUtils.toInputStream((String)sourceToDeserialize, (Charset)StandardCharsets.UTF_8);
        return ret;
    }

    public static JsonDeserializer of(@NonNull File sourceToDeserialize) {
        if (sourceToDeserialize == null) {
            throw new NullPointerException("sourceToDeserialize is marked @NonNull but is null");
        }
        JsonDeserializer ret = new JsonDeserializer();
        ret.sourceToDeserialize = FileIOUtils.openInputStream((File)sourceToDeserialize);
        return ret;
    }

    public static JsonDeserializer of(@NonNull byte[] sourceToDeserialize) {
        if (sourceToDeserialize == null) {
            throw new NullPointerException("sourceToDeserialize is marked @NonNull but is null");
        }
        JsonDeserializer ret = new JsonDeserializer();
        ret.sourceToDeserialize = new ByteArrayInputStream(sourceToDeserialize);
        return ret;
    }

    public JsonDeserializer withView(@NonNull Class<?> deserializationView) {
        if (deserializationView == null) {
            throw new NullPointerException("deserializationView is marked @NonNull but is null");
        }
        this.deserializationView = deserializationView;
        return this;
    }

    public JsonDeserializer withDeserializationFeature(@NonNull DeserializationFeature serializationFeature) {
        if (serializationFeature == null) {
            throw new NullPointerException("serializationFeature is marked @NonNull but is null");
        }
        this.deserializationFeatures.add(serializationFeature);
        return this;
    }

    public <T> T deserialize(Class<T> clazz) {
        logger.debug("Invoked JSON deserializer [{}]", (Object)this);
        try {
            ObjectReader reader = ObjectMapperBuilder.builder().build().readerFor(clazz);
            this.deserializationFeatures.forEach(xva$0 -> reader.withFeatures(new DeserializationFeature[]{xva$0}));
            Optional.ofNullable(this.deserializationView).ifPresent(arg_0 -> ((ObjectReader)reader).withView(arg_0));
            return (T)reader.readValue(this.sourceToDeserialize);
        }
        catch (IOException e) {
            throw new SystemException((ErrorType)JsonErrorType.JSON_PARSING_ERROR, (Throwable)e);
        }
    }

    public String toString() {
        return "JsonDeserializer(sourceToDeserialize=" + this.sourceToDeserialize + ", deserializationView=" + this.deserializationView + ", deserializationFeatures=" + this.deserializationFeatures + ")";
    }
}

