package com.crabshue.commons.json.serialization.exceptions;

import com.crabshue.commons.exceptions.context.ErrorType;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * {@link ErrorType} for JSON operations.
 */
@Getter
@AllArgsConstructor
public enum JsonErrorType implements ErrorType {

    JSON_PARSING_ERROR("Error parsing JSON"),

    JSON_CONVERSION_ERROR("Error converting to JSON"),

    UNSUPPORTED_OUTPUT_FOR_JSON_SERIALIZATION("The output type configured is not supported by the JSON serializer");

    private String message;
}
