/*
 * Decompiled with CFR 0.152.
 */
package redis.embedded;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import redis.embedded.RedisInstance;
import redis.embedded.core.ExecutableProvider;
import redis.embedded.core.RedisServerBuilder;

public final class RedisServer
extends RedisInstance {
    public RedisServer() {
        this(6379);
    }

    public RedisServer(int port) {
        this(port, RedisServer.newRedisServer().port(port).buildCommandArgs());
    }

    public RedisServer(int port, File executable) {
        this(port, Arrays.asList(executable.getAbsolutePath(), "--port", Integer.toString(port)));
    }

    public RedisServer(int port, ExecutableProvider executableProvider) throws IOException {
        this(port, Arrays.asList(executableProvider.get().getAbsolutePath(), "--port", Integer.toString(port)));
    }

    public RedisServer(int port, List<String> args) {
        super(port, args, SERVER_READY_PATTERN);
    }

    public static RedisServerBuilder newRedisServer() {
        return new RedisServerBuilder();
    }
}

