/*
 * Decompiled with CFR 0.152.
 */
package com.github.cloudyrock.mongock.driver.mongodb.v3.driver;

import com.github.cloudyrock.mongock.driver.api.driver.ChangeSetDependency;
import com.github.cloudyrock.mongock.driver.api.driver.ConnectionDriver;
import com.github.cloudyrock.mongock.driver.api.driver.TransactionStrategy;
import com.github.cloudyrock.mongock.driver.api.driver.Transactionable;
import com.github.cloudyrock.mongock.driver.api.entry.ChangeEntry;
import com.github.cloudyrock.mongock.driver.api.entry.ChangeEntryService;
import com.github.cloudyrock.mongock.driver.api.lock.guard.invoker.LockGuardInvoker;
import com.github.cloudyrock.mongock.driver.api.lock.guard.invoker.LockGuardInvokerImpl;
import com.github.cloudyrock.mongock.driver.core.driver.ConnectionDriverBase;
import com.github.cloudyrock.mongock.driver.core.lock.LockRepository;
import com.github.cloudyrock.mongock.driver.mongodb.v3.decorator.impl.MongoDataBaseDecoratorImpl;
import com.github.cloudyrock.mongock.driver.mongodb.v3.repository.Mongo3LockRepository;
import com.github.cloudyrock.mongock.driver.mongodb.v3.repository.ReadWriteConfiguration;
import com.github.cloudyrock.mongock.exception.MongockException;
import com.github.cloudyrock.mongock.utils.annotation.NotThreadSafe;
import com.mongodb.MongoClientException;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.TransactionOptions;
import com.mongodb.WriteConcern;
import com.mongodb.client.ClientSession;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.TransactionBody;
import java.util.HashSet;
import java.util.Set;
import org.bson.Document;

@NotThreadSafe
public abstract class MongoCore3DriverBase<CHANGE_ENTRY extends ChangeEntry>
extends ConnectionDriverBase<CHANGE_ENTRY>
implements ConnectionDriver<CHANGE_ENTRY>,
Transactionable {
    private static final String DEFAULT_CHANGELOG_COLLECTION_NAME = "mongockChangeLog";
    private static final String DEFAULT_LOCK_COLLECTION_NAME = "mongockLock";
    private static final WriteConcern DEFAULT_WRITE_CONCERN = WriteConcern.MAJORITY.withJournal(Boolean.valueOf(true));
    private static final ReadConcern DEFAULT_READ_CONCERN = ReadConcern.MAJORITY;
    private static final ReadPreference DEFAULT_READ_PREFERENCE = ReadPreference.primary();
    protected final MongoDatabase mongoDatabase;
    protected String changeLogCollectionName = "mongockChangeLog";
    protected String lockCollectionName = "mongockLock";
    protected boolean indexCreation = true;
    protected Mongo3LockRepository lockRepository;
    protected Set<ChangeSetDependency> dependencies;
    protected TransactionStrategy transactionStrategy;
    protected MongoClient mongoClient;
    private TransactionOptions txOptions;
    private WriteConcern writeConcern;
    private ReadConcern readConcern;
    private ReadPreference readPreference;

    MongoCore3DriverBase(MongoClient mongoClient, String databaseName, long lockAcquiredForMinutes, long maxWaitingForLockMinutes, int maxTries) {
        this(mongoClient.getDatabase(databaseName), lockAcquiredForMinutes, maxWaitingForLockMinutes, maxTries);
        this.mongoClient = mongoClient;
        this.transactionStrategy = TransactionStrategy.MIGRATION;
    }

    MongoCore3DriverBase(MongoDatabase mongoDatabase, long lockAcquiredForMinutes, long maxWaitingForLockMinutes, int maxTries) {
        super(lockAcquiredForMinutes, maxWaitingForLockMinutes, maxTries);
        this.mongoDatabase = mongoDatabase;
        this.transactionStrategy = TransactionStrategy.NONE;
    }

    public void setChangeLogRepositoryName(String changeLogCollectionName) {
        this.changeLogCollectionName = changeLogCollectionName;
    }

    public void setLockRepositoryName(String lockCollectionName) {
        this.lockCollectionName = lockCollectionName;
    }

    public String getChangeLogRepositoryName() {
        return this.changeLogCollectionName;
    }

    public String getLockRepositoryName() {
        return this.lockCollectionName;
    }

    public void setIndexCreation(boolean indexCreation) {
        this.indexCreation = indexCreation;
    }

    public void setWriteConcern(WriteConcern writeConcern) {
        this.writeConcern = writeConcern;
    }

    public void setReadConcern(ReadConcern readConcern) {
        this.readConcern = readConcern;
    }

    public void setReadPreference(ReadPreference readPreference) {
        this.readPreference = readPreference;
    }

    public void runValidation() throws MongockException {
        if (this.mongoDatabase == null) {
            throw new MongockException("MongoDatabase cannot be null");
        }
        if (this.getLockManager() == null) {
            throw new MongockException("Internal error: Driver needs to be initialized by the runner");
        }
    }

    protected LockRepository getLockRepository() {
        if (this.lockRepository == null) {
            MongoCollection collection = this.mongoDatabase.getCollection(this.lockCollectionName);
            this.lockRepository = new Mongo3LockRepository((MongoCollection<Document>)collection, this.indexCreation, this.getReadWriteConfiguration());
        }
        return this.lockRepository;
    }

    public Set<ChangeSetDependency> getDependencies() {
        if (this.dependencies == null) {
            throw new MongockException("Driver not initialized");
        }
        return this.dependencies;
    }

    public void specificInitialization() {
        this.dependencies = new HashSet<ChangeSetDependency>();
        this.dependencies.add(new ChangeSetDependency(MongoDatabase.class, (Object)new MongoDataBaseDecoratorImpl(this.mongoDatabase, (LockGuardInvoker)new LockGuardInvokerImpl(this.getLockManager()))));
        this.dependencies.add(new ChangeSetDependency(ChangeEntryService.class, (Object)this.getChangeEntryService()));
        this.txOptions = this.txOptions != null ? this.txOptions : this.buildDefaultTxOptions();
    }

    public void disableTransaction() {
        this.transactionStrategy = TransactionStrategy.NONE;
    }

    public TransactionStrategy getTransactionStrategy() {
        return this.transactionStrategy;
    }

    public void executeInTransaction(Runnable operation) {
        ClientSession clientSession;
        try {
            clientSession = this.mongoClient.startSession();
        }
        catch (MongoClientException ex) {
            throw new MongockException("ERROR starting session. If Mongock is connected to a MongoDB cluster which doesn't support transactions, you must to disable transactions", (Exception)((Object)ex));
        }
        try {
            clientSession.withTransaction(this.getTransactionBody(operation), this.txOptions);
        }
        catch (Exception ex) {
            throw new MongockException(ex);
        }
        finally {
            clientSession.close();
        }
    }

    protected ReadWriteConfiguration getReadWriteConfiguration() {
        return new ReadWriteConfiguration(this.writeConcern != null ? this.writeConcern : DEFAULT_WRITE_CONCERN, this.readConcern != null ? this.readConcern : DEFAULT_READ_CONCERN, this.readPreference != null ? this.readPreference : DEFAULT_READ_PREFERENCE);
    }

    public void setTransactionOptions(TransactionOptions txOptions) {
        this.txOptions = txOptions;
    }

    private TransactionOptions buildDefaultTxOptions() {
        return TransactionOptions.builder().readPreference(ReadPreference.primary()).readConcern(ReadConcern.MAJORITY).writeConcern(WriteConcern.MAJORITY).build();
    }

    private TransactionBody getTransactionBody(Runnable operation) {
        return () -> {
            operation.run();
            return "Mongock transaction operation";
        };
    }
}

