/*
 * Decompiled with CFR 0.152.
 */
package com.github.cloudyrock.spring.v5;

import com.github.cloudyrock.mongock.config.LegacyMigration;
import com.github.cloudyrock.mongock.config.MongockSpringConfiguration;
import com.github.cloudyrock.mongock.driver.api.driver.ChangeSetDependency;
import com.github.cloudyrock.mongock.driver.api.driver.ConnectionDriver;
import com.github.cloudyrock.mongock.exception.MongockException;
import com.github.cloudyrock.mongock.runner.core.builder.RunnerBuilderBase;
import com.github.cloudyrock.mongock.runner.core.executor.DependencyContext;
import com.github.cloudyrock.mongock.runner.core.executor.DependencyManagerWithContext;
import com.github.cloudyrock.mongock.runner.core.executor.MigrationExecutorConfiguration;
import com.github.cloudyrock.mongock.utils.CollectionUtils;
import com.github.cloudyrock.spring.util.SpringDependencyContext;
import com.github.cloudyrock.spring.util.SpringEventPublisher;
import com.github.cloudyrock.spring.v5.core.ProfiledChangeLogService;
import com.github.cloudyrock.spring.v5.core.SpringMigrationExecutor;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.ApplicationRunner;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.core.env.Environment;

public abstract class MongockSpringBuilderBase<BUILDER_TYPE extends MongockSpringBuilderBase, SPRING_APP_RUNNER_TYPE extends ApplicationRunner, SPRING_INIT_BEAN_TYPE extends InitializingBean, DRIVER extends ConnectionDriver, SPRING_CONFIG extends MongockSpringConfiguration>
extends RunnerBuilderBase<BUILDER_TYPE, DRIVER, SPRING_CONFIG> {
    protected static final String DEFAULT_PROFILE = "default";
    protected ApplicationContext springContext;
    protected ApplicationEventPublisher applicationEventPublisher;

    public BUILDER_TYPE setSpringContext(ApplicationContext springContext) {
        this.springContext = springContext;
        return (BUILDER_TYPE)((Object)((MongockSpringBuilderBase)this.returnInstance()));
    }

    public BUILDER_TYPE setEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
        return (BUILDER_TYPE)((Object)((MongockSpringBuilderBase)this.returnInstance()));
    }

    public BUILDER_TYPE setConfig(SPRING_CONFIG config) {
        super.setConfig(config);
        return (BUILDER_TYPE)((Object)((MongockSpringBuilderBase)this.returnInstance()));
    }

    public abstract SPRING_APP_RUNNER_TYPE buildApplicationRunner();

    public abstract SPRING_INIT_BEAN_TYPE buildInitializingBeanRunner();

    protected SpringMigrationExecutor buildExecutorWithEnvironmentDependency() {
        return new SpringMigrationExecutor(this.driver, this.buildDependencyManagerWithContext(), new MigrationExecutorConfiguration(this.trackIgnored, this.serviceIdentifier), this.metadata);
    }

    protected DependencyManagerWithContext buildDependencyManagerWithContext() {
        DependencyManagerWithContext dependencyManager = new DependencyManagerWithContext((DependencyContext)new SpringDependencyContext(this.springContext));
        if (this.legacyMigration != null) {
            dependencyManager.addStandardDependency(new ChangeSetDependency("legacy-migration", LegacyMigration.class, (Object)this.legacyMigration));
        }
        dependencyManager.addDriverDependencies(this.dependencies);
        return dependencyManager;
    }

    protected ProfiledChangeLogService buildProfiledChangeLogService() {
        if (this.springContext == null) {
            throw new MongockException("ApplicationContext from Spring must be injected to Builder");
        }
        Environment springEnvironment = this.springContext.getEnvironment();
        List<String> activeProfiles = springEnvironment != null && CollectionUtils.isNotNullOrEmpty((Object[])springEnvironment.getActiveProfiles()) ? Arrays.asList(springEnvironment.getActiveProfiles()) : Collections.singletonList(DEFAULT_PROFILE);
        return new ProfiledChangeLogService(this.changeLogsScanPackage, this.changeLogsScanClasses, this.startSystemVersion, this.endSystemVersion, activeProfiles, this.annotationProcessor);
    }

    protected SpringEventPublisher buildSpringEventPublisher() {
        return new SpringEventPublisher(this.applicationEventPublisher);
    }

    public void runValidation() {
        super.runValidation();
        if (this.springContext == null) {
            throw new MongockException("ApplicationContext from Spring must be injected to Builder");
        }
    }
}

