/*
 * Decompiled with CFR 0.152.
 */
package com.chuckerteam.chucker.internal.ui.transaction;

import android.annotation.SuppressLint;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Bundle;
import android.os.IBinder;
import android.text.SpannableStringBuilder;
import android.text.style.StyleSpan;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.TextView;
import android.widget.Toast;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.activity.result.contract.ActivityResultContracts;
import androidx.appcompat.widget.LinearLayoutCompat;
import androidx.appcompat.widget.SearchView;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.content.ContextCompat;
import androidx.core.text.HtmlCompat;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentViewModelLazyKt;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleDestroyedException;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.LifecycleOwnerKt;
import androidx.lifecycle.Observer;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStore;
import androidx.lifecycle.WithLifecycleStateKt;
import androidx.lifecycle.viewmodel.CreationExtras;
import androidx.recyclerview.widget.RecyclerView;
import com.chuckerteam.chucker.R;
import com.chuckerteam.chucker.databinding.ChuckerFragmentTransactionPayloadBinding;
import com.chuckerteam.chucker.internal.data.entity.HttpTransaction;
import com.chuckerteam.chucker.internal.support.BitmapUtilsKt;
import com.chuckerteam.chucker.internal.support.FileSaver;
import com.chuckerteam.chucker.internal.support.LiveDataUtilsKt;
import com.chuckerteam.chucker.internal.support.Logger;
import com.chuckerteam.chucker.internal.support.SpannableStringExtensionKt;
import com.chuckerteam.chucker.internal.ui.transaction.PayloadType;
import com.chuckerteam.chucker.internal.ui.transaction.TransactionBodyAdapter;
import com.chuckerteam.chucker.internal.ui.transaction.TransactionPayloadItem;
import com.chuckerteam.chucker.internal.ui.transaction.TransactionViewModel;
import com.chuckerteam.chucker.internal.ui.transaction.TransactionViewModelFactory;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Function;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FunctionAdapter;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.MainCoroutineDispatcher;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00b4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\r\n\u0002\b\u0002\b\u0000\u0018\u0000 Z2\u00020\u00012\u00020\u0002:\u0001ZB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010%H\u0016J$\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\b\u0010*\u001a\u0004\u0018\u00010+2\b\u0010$\u001a\u0004\u0018\u00010%H\u0016J\u001a\u0010,\u001a\u00020#2\u0006\u0010-\u001a\u00020'2\b\u0010$\u001a\u0004\u0018\u00010%H\u0016J\b\u0010.\u001a\u00020#H\u0002J \u0010/\u001a\u00020#2\u0006\u00100\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\u00122\u0006\u00101\u001a\u00020\u0012H\u0002J\u0010\u00102\u001a\u00020#2\u0006\u00103\u001a\u000204H\u0002J\b\u00105\u001a\u00020#H\u0002J\b\u00106\u001a\u00020#H\u0002J\u0018\u00107\u001a\u00020#2\u0006\u00108\u001a\u0002092\u0006\u0010(\u001a\u00020:H\u0017J\u0012\u0010;\u001a\u0002042\b\u0010<\u001a\u0004\u0018\u00010=H\u0002J\u0012\u0010>\u001a\u0002042\b\u0010<\u001a\u0004\u0018\u00010=H\u0002J\u0010\u0010?\u001a\u00020#2\u0006\u0010@\u001a\u00020AH\u0016J\b\u0010B\u001a\u00020#H\u0002J\u0010\u0010C\u001a\u0002042\u0006\u0010D\u001a\u00020\u0012H\u0016J\u0010\u0010E\u001a\u0002042\u0006\u0010F\u001a\u00020\u0012H\u0016J\u0012\u0010G\u001a\u00020#2\b\b\u0002\u0010H\u001a\u000204H\u0002J\u001a\u0010I\u001a\u00020#2\u0006\u0010J\u001a\u00020\u00192\b\b\u0002\u0010K\u001a\u00020\u0019H\u0002J\u0010\u0010L\u001a\u00020#2\u0006\u0010M\u001a\u00020\u0019H\u0002J,\u0010N\u001a\b\u0012\u0004\u0012\u00020P0O2\u0006\u0010Q\u001a\u00020\f2\u0006\u0010<\u001a\u00020=2\u0006\u0010R\u001a\u000204H\u0082@\u00a2\u0006\u0002\u0010SJ\u0018\u0010T\u001a\u00020U2\u0006\u0010Q\u001a\u00020\f2\u0006\u0010<\u001a\u00020=H\u0002J\u0018\u0010V\u001a\u0002042\u0006\u0010Q\u001a\u00020\f2\u0006\u0010<\u001a\u00020=H\u0002J\u0012\u0010W\u001a\b\u0012\u0004\u0012\u00020Y0X*\u00020YH\u0002R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\n\u001a\u0004\b\r\u0010\u000eR\u001c\u0010\u0010\u001a\u0010\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u00120\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001c\u001a\u0012\u0012\u0004\u0012\u00020\u001e0\u001dj\b\u0012\u0004\u0012\u00020\u001e`\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006["}, d2={"Lcom/chuckerteam/chucker/internal/ui/transaction/TransactionPayloadFragment;", "Landroidx/fragment/app/Fragment;", "Landroidx/appcompat/widget/SearchView$OnQueryTextListener;", "<init>", "()V", "viewModel", "Lcom/chuckerteam/chucker/internal/ui/transaction/TransactionViewModel;", "getViewModel", "()Lcom/chuckerteam/chucker/internal/ui/transaction/TransactionViewModel;", "viewModel$delegate", "Lkotlin/Lazy;", "payloadType", "Lcom/chuckerteam/chucker/internal/ui/transaction/PayloadType;", "getPayloadType", "()Lcom/chuckerteam/chucker/internal/ui/transaction/PayloadType;", "payloadType$delegate", "saveToFile", "Landroidx/activity/result/ActivityResultLauncher;", "", "kotlin.jvm.PlatformType", "payloadBinding", "Lcom/chuckerteam/chucker/databinding/ChuckerFragmentTransactionPayloadBinding;", "payloadAdapter", "Lcom/chuckerteam/chucker/internal/ui/transaction/TransactionBodyAdapter;", "backgroundSpanColor", "", "foregroundSpanColor", "backgroundSpanColorSearchItem", "scrollableIndices", "Ljava/util/ArrayList;", "Lcom/chuckerteam/chucker/internal/ui/transaction/TransactionBodyAdapter$SearchItemBodyLine;", "Lkotlin/collections/ArrayList;", "currentSearchScrollIndex", "currentSearchQuery", "onCreate", "", "savedInstanceState", "Landroid/os/Bundle;", "onCreateView", "Landroid/view/View;", "inflater", "Landroid/view/LayoutInflater;", "container", "Landroid/view/ViewGroup;", "onViewCreated", "view", "copyResponse", "copyToClipboard", "payload", "toastSuccessMessage", "onSearchScrollerButtonClick", "goNext", "", "showEmptyState", "showPayloadState", "onCreateOptionsMenu", "menu", "Landroid/view/Menu;", "Landroid/view/MenuInflater;", "shouldShowSaveIcon", "transaction", "Lcom/chuckerteam/chucker/internal/data/entity/HttpTransaction;", "shouldShowSearchIcon", "onAttach", "context", "Landroid/content/Context;", "createFileToSaveBody", "onQueryTextSubmit", "query", "onQueryTextChange", "newText", "makeToolbarSearchSummaryVisible", "visible", "updateToolbarText", "searchResultsCount", "currentIndex", "scrollToSearchedItemPosition", "positionOfScrollableIndices", "processPayload", "", "Lcom/chuckerteam/chucker/internal/ui/transaction/TransactionPayloadItem;", "type", "formatRequestBody", "(Lcom/chuckerteam/chucker/internal/ui/transaction/PayloadType;Lcom/chuckerteam/chucker/internal/data/entity/HttpTransaction;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "prepareDataToSave", "Lokio/Source;", "isBodyEmpty", "lines", "", "", "Companion", "com.github.ChuckerTeam.Chucker.library"})
@SourceDebugExtension(value={"SMAP\nTransactionPayloadFragment.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TransactionPayloadFragment.kt\ncom/chuckerteam/chucker/internal/ui/transaction/TransactionPayloadFragment\n+ 2 FragmentViewModelLazy.kt\nandroidx/fragment/app/FragmentViewModelLazyKt\n+ 3 View.kt\nandroidx/core/view/ViewKt\n+ 4 SpannableStringBuilder.kt\nandroidx/core/text/SpannableStringBuilderKt\n*L\n1#1,546:1\n172#2,9:547\n256#3,2:556\n87#4:558\n74#4,4:559\n*S KotlinDebug\n*F\n+ 1 TransactionPayloadFragment.kt\ncom/chuckerteam/chucker/internal/ui/transaction/TransactionPayloadFragment\n*L\n51#1:547,9\n353#1:556,2\n362#1:558\n362#1:559,4\n*E\n"})
public final class TransactionPayloadFragment
extends Fragment
implements SearchView.OnQueryTextListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy viewModel$delegate;
    @NotNull
    private final Lazy payloadType$delegate;
    @NotNull
    private final ActivityResultLauncher<String> saveToFile;
    private ChuckerFragmentTransactionPayloadBinding payloadBinding;
    @NotNull
    private final TransactionBodyAdapter payloadAdapter;
    private int backgroundSpanColor;
    private int foregroundSpanColor;
    private int backgroundSpanColorSearchItem;
    @NotNull
    private final ArrayList<TransactionBodyAdapter.SearchItemBodyLine> scrollableIndices;
    private int currentSearchScrollIndex;
    @NotNull
    private String currentSearchQuery;
    @NotNull
    private static final String ARG_TYPE = "type";
    @NotNull
    private static final String TRANSACTION_EXCEPTION = "Transaction not ready";
    private static final long DELAY_FOR_SEARCH_SCROLL = 600L;
    private static final int NUMBER_OF_IGNORED_SYMBOLS = 1;
    private static final int LINE_LENGTH_THRESHOLD = 500;
    @NotNull
    public static final String DEFAULT_FILE_PREFIX = "chucker-export-";

    /*
     * WARNING - void declaration
     */
    public TransactionPayloadFragment() {
        void $this$activityViewModels_u24default$iv;
        Fragment fragment = this;
        Function0 factoryProducer$iv = TransactionPayloadFragment::viewModel_delegate$lambda$0;
        Function0 extrasProducer$iv = null;
        boolean $i$f$activityViewModels = false;
        KClass kClass = Reflection.getOrCreateKotlinClass(TransactionViewModel.class);
        Function0 function0 = (Function0)new Function0<ViewModelStore>((Fragment)$this$activityViewModels_u24default$iv){
            final /* synthetic */ Fragment $this_activityViewModels;
            {
                this.$this_activityViewModels = $receiver;
                super(0);
            }

            @NotNull
            public final ViewModelStore invoke() {
                return this.$this_activityViewModels.requireActivity().getViewModelStore();
            }
        };
        Function0 function02 = (Function0)new Function0<CreationExtras>(extrasProducer$iv, (Fragment)$this$activityViewModels_u24default$iv){
            final /* synthetic */ Function0 $extrasProducer;
            final /* synthetic */ Fragment $this_activityViewModels;
            {
                this.$extrasProducer = $extrasProducer;
                this.$this_activityViewModels = $receiver;
                super(0);
            }

            @NotNull
            public final CreationExtras invoke() {
                Function0 function0 = this.$extrasProducer;
                if (function0 == null || (function0 = (CreationExtras)function0.invoke()) == null) {
                    function0 = this.$this_activityViewModels.requireActivity().getDefaultViewModelCreationExtras();
                }
                return function0;
            }
        };
        Function0 function03 = factoryProducer$iv;
        if (function03 == null) {
            function03 = (Function0)new Function0<ViewModelProvider.Factory>((Fragment)$this$activityViewModels_u24default$iv){
                final /* synthetic */ Fragment $this_activityViewModels;
                {
                    this.$this_activityViewModels = $receiver;
                    super(0);
                }

                @NotNull
                public final ViewModelProvider.Factory invoke() {
                    return this.$this_activityViewModels.requireActivity().getDefaultViewModelProviderFactory();
                }
            };
        }
        this.viewModel$delegate = FragmentViewModelLazyKt.createViewModelLazy((Fragment)$this$activityViewModels_u24default$iv, (KClass)kClass, (Function0)function0, (Function0)function02, (Function0)function03);
        this.payloadType$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> TransactionPayloadFragment.payloadType_delegate$lambda$1(this));
        ActivityResultLauncher activityResultLauncher = this.registerForActivityResult((ActivityResultContract)new ActivityResultContracts.CreateDocument(), arg_0 -> TransactionPayloadFragment.saveToFile$lambda$2(this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)activityResultLauncher, (String)"registerForActivityResult(...)");
        this.saveToFile = activityResultLauncher;
        this.payloadAdapter = new TransactionBodyAdapter((Function0<Unit>)((Function0)new Function0<Unit>((Object)this){

            public final void invoke() {
                TransactionPayloadFragment.access$copyResponse((TransactionPayloadFragment)((Object)this.receiver));
            }
        }));
        this.backgroundSpanColor = -256;
        this.foregroundSpanColor = -65536;
        this.backgroundSpanColorSearchItem = -16711936;
        this.scrollableIndices = new ArrayList();
        this.currentSearchScrollIndex = -1;
        this.currentSearchQuery = "";
    }

    private final TransactionViewModel getViewModel() {
        Lazy lazy = this.viewModel$delegate;
        return (TransactionViewModel)((Object)lazy.getValue());
    }

    private final PayloadType getPayloadType() {
        Lazy lazy = this.payloadType$delegate;
        return (PayloadType)((Object)lazy.getValue());
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setHasOptionsMenu(true);
    }

    @NotNull
    public View onCreateView(@NotNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        Intrinsics.checkNotNullParameter((Object)inflater, (String)"inflater");
        ChuckerFragmentTransactionPayloadBinding chuckerFragmentTransactionPayloadBinding = ChuckerFragmentTransactionPayloadBinding.inflate(inflater, container, false);
        Intrinsics.checkNotNullExpressionValue((Object)chuckerFragmentTransactionPayloadBinding, (String)"inflate(...)");
        this.payloadBinding = chuckerFragmentTransactionPayloadBinding;
        ChuckerFragmentTransactionPayloadBinding chuckerFragmentTransactionPayloadBinding2 = this.payloadBinding;
        if (chuckerFragmentTransactionPayloadBinding2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"payloadBinding");
            chuckerFragmentTransactionPayloadBinding2 = null;
        }
        ConstraintLayout constraintLayout = chuckerFragmentTransactionPayloadBinding2.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)constraintLayout, (String)"getRoot(...)");
        return (View)constraintLayout;
    }

    public void onViewCreated(@NotNull View view, @Nullable Bundle savedInstanceState) {
        RecyclerView recyclerView;
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        super.onViewCreated(view, savedInstanceState);
        ChuckerFragmentTransactionPayloadBinding chuckerFragmentTransactionPayloadBinding = this.payloadBinding;
        if (chuckerFragmentTransactionPayloadBinding == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"payloadBinding");
            chuckerFragmentTransactionPayloadBinding = null;
        }
        RecyclerView $this$onViewCreated_u24lambda_u243 = recyclerView = chuckerFragmentTransactionPayloadBinding.payloadRecyclerView;
        boolean bl = false;
        $this$onViewCreated_u24lambda_u243.setHasFixedSize(true);
        $this$onViewCreated_u24lambda_u243.setAdapter((RecyclerView.Adapter)this.payloadAdapter);
        LiveDataUtilsKt.combineLatest(this.getViewModel().getTransaction(), this.getViewModel().getFormatRequestBody()).observe(this.getViewLifecycleOwner(), arg_0 -> TransactionPayloadFragment.onViewCreated$lambda$4(this, arg_0));
        ChuckerFragmentTransactionPayloadBinding chuckerFragmentTransactionPayloadBinding2 = this.payloadBinding;
        if (chuckerFragmentTransactionPayloadBinding2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"payloadBinding");
            chuckerFragmentTransactionPayloadBinding2 = null;
        }
        chuckerFragmentTransactionPayloadBinding2.searchNavButton.setOnClickListener(arg_0 -> TransactionPayloadFragment.onViewCreated$lambda$5(this, arg_0));
        ChuckerFragmentTransactionPayloadBinding chuckerFragmentTransactionPayloadBinding3 = this.payloadBinding;
        if (chuckerFragmentTransactionPayloadBinding3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"payloadBinding");
            chuckerFragmentTransactionPayloadBinding3 = null;
        }
        chuckerFragmentTransactionPayloadBinding3.searchNavButtonUp.setOnClickListener(arg_0 -> TransactionPayloadFragment.onViewCreated$lambda$6(this, arg_0));
    }

    private final void copyResponse() {
        block2: {
            String string2;
            HttpTransaction transaction;
            block1: {
                transaction = (HttpTransaction)this.getViewModel().getTransaction().getValue();
                string2 = this.getPayloadType().name();
                if (!Intrinsics.areEqual((Object)string2, (Object)"REQUEST")) break block1;
                Object object = transaction;
                if (object == null || (object = ((HttpTransaction)object).getRequestBody()) == null) break block2;
                Object request = object;
                boolean bl = false;
                String string3 = this.getString(R.string.chucker_request);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getString(...)");
                String string4 = this.getString(R.string.chucker_request_copied);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getString(...)");
                this.copyToClipboard((String)request, string3, string4);
                break block2;
            }
            if (!Intrinsics.areEqual((Object)string2, (Object)"RESPONSE")) break block2;
            Object object = transaction;
            if (object != null && (object = ((HttpTransaction)object).getResponseBody()) != null) {
                Object response = object;
                boolean bl = false;
                String string5 = this.getString(R.string.chucker_response);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getString(...)");
                String string6 = this.getString(R.string.chucker_response_copied);
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getString(...)");
                this.copyToClipboard((String)response, string5, string6);
            }
        }
    }

    private final void copyToClipboard(String payload, String payloadType, String toastSuccessMessage) {
        FragmentActivity fragmentActivity = this.getActivity();
        Object object = fragmentActivity != null ? fragmentActivity.getSystemService("clipboard") : null;
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.content.ClipboardManager");
        ClipboardManager clipboard = (ClipboardManager)object;
        ClipData clip = ClipData.newPlainText((CharSequence)payloadType, (CharSequence)payload);
        clipboard.setPrimaryClip(clip);
        Toast.makeText((Context)((Context)this.getActivity()), (CharSequence)toastSuccessMessage, (int)1).show();
    }

    private final void onSearchScrollerButtonClick(boolean goNext) {
        FragmentActivity fragmentActivity = this.getActivity();
        Object object = fragmentActivity != null ? fragmentActivity.getSystemService("input_method") : null;
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.view.inputmethod.InputMethodManager");
        InputMethodManager inputMethodManager = (InputMethodManager)object;
        if (inputMethodManager.isAcceptingText()) {
            FragmentActivity fragmentActivity2 = this.getActivity();
            if (fragmentActivity2 != null && (fragmentActivity2 = fragmentActivity2.getCurrentFocus()) != null) {
                fragmentActivity2.clearFocus();
            }
            View view = this.getView();
            inputMethodManager.hideSoftInputFromWindow((IBinder)(view != null ? view.getWindowToken() : null), 0);
        }
        if (!((Collection)this.scrollableIndices).isEmpty()) {
            int scrollToIndex = goNext ? (this.currentSearchScrollIndex + 1) % this.scrollableIndices.size() : Math.abs(this.currentSearchScrollIndex - 1 + this.scrollableIndices.size()) % this.scrollableIndices.size();
            this.scrollToSearchedItemPosition(scrollToIndex);
        }
    }

    private final void showEmptyState() {
        ChuckerFragmentTransactionPayloadBinding chuckerFragmentTransactionPayloadBinding;
        ChuckerFragmentTransactionPayloadBinding chuckerFragmentTransactionPayloadBinding2 = this.payloadBinding;
        if (chuckerFragmentTransactionPayloadBinding2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"payloadBinding");
            chuckerFragmentTransactionPayloadBinding2 = null;
        }
        ChuckerFragmentTransactionPayloadBinding $this$showEmptyState_u24lambda_u249 = chuckerFragmentTransactionPayloadBinding = chuckerFragmentTransactionPayloadBinding2;
        boolean bl = false;
        $this$showEmptyState_u24lambda_u249.emptyPayloadTextView.setText(this.getPayloadType() == PayloadType.RESPONSE ? (CharSequence)this.getString(R.string.chucker_response_is_empty) : (CharSequence)this.getString(R.string.chucker_request_is_empty));
        $this$showEmptyState_u24lambda_u249.emptyStateGroup.setVisibility(0);
        $this$showEmptyState_u24lambda_u249.payloadRecyclerView.setVisibility(8);
    }

    private final void showPayloadState() {
        ChuckerFragmentTransactionPayloadBinding chuckerFragmentTransactionPayloadBinding;
        ChuckerFragmentTransactionPayloadBinding chuckerFragmentTransactionPayloadBinding2 = this.payloadBinding;
        if (chuckerFragmentTransactionPayloadBinding2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"payloadBinding");
            chuckerFragmentTransactionPayloadBinding2 = null;
        }
        ChuckerFragmentTransactionPayloadBinding $this$showPayloadState_u24lambda_u2410 = chuckerFragmentTransactionPayloadBinding = chuckerFragmentTransactionPayloadBinding2;
        boolean bl = false;
        $this$showPayloadState_u24lambda_u2410.emptyStateGroup.setVisibility(8);
        $this$showPayloadState_u24lambda_u2410.payloadRecyclerView.setVisibility(0);
    }

    @SuppressLint(value={"NewApi"})
    public void onCreateOptionsMenu(@NotNull Menu menu2, @NotNull MenuInflater inflater) {
        MenuItem menuItem;
        Intrinsics.checkNotNullParameter((Object)menu2, (String)"menu");
        Intrinsics.checkNotNullParameter((Object)inflater, (String)"inflater");
        HttpTransaction transaction = (HttpTransaction)this.getViewModel().getTransaction().getValue();
        if (this.shouldShowSearchIcon(transaction)) {
            MenuItem searchMenuItem = menu2.findItem(R.id.search);
            searchMenuItem.setVisible(true);
            View view = searchMenuItem.getActionView();
            Intrinsics.checkNotNull((Object)view, (String)"null cannot be cast to non-null type androidx.appcompat.widget.SearchView");
            SearchView searchView = (SearchView)view;
            searchView.setOnQueryTextListener((SearchView.OnQueryTextListener)this);
            searchView.setIconifiedByDefault(true);
        }
        if (this.shouldShowSaveIcon(transaction)) {
            MenuItem $this$onCreateOptionsMenu_u24lambda_u2412 = menuItem = menu2.findItem(R.id.save_body);
            boolean bl = false;
            $this$onCreateOptionsMenu_u24lambda_u2412.setVisible(true);
            $this$onCreateOptionsMenu_u24lambda_u2412.setOnMenuItemClickListener(arg_0 -> TransactionPayloadFragment.onCreateOptionsMenu$lambda$12$lambda$11(this, arg_0));
        }
        if (this.getPayloadType() == PayloadType.REQUEST) {
            menuItem = arg_0 -> TransactionPayloadFragment.onCreateOptionsMenu$lambda$13(menu2, arg_0);
            this.getViewModel().getDoesRequestBodyRequireEncoding().observe(this.getViewLifecycleOwner(), new Observer((Function1)menuItem){
                private final /* synthetic */ Function1 function;
                {
                    Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                    this.function = function;
                }

                public final /* synthetic */ void onChanged(Object value) {
                    this.function.invoke(value);
                }

                @NotNull
                public final Function<?> getFunctionDelegate() {
                    return (Function)this.function;
                }

                public final boolean equals(@Nullable Object other) {
                    return other instanceof Observer ? (other instanceof FunctionAdapter ? Intrinsics.areEqual((Object)((FunctionAdapter)this).getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
                }

                public final int hashCode() {
                    return ((FunctionAdapter)this).getFunctionDelegate().hashCode();
                }
            });
        } else {
            menu2.findItem(R.id.encode_url).setVisible(false);
        }
        super.onCreateOptionsMenu(menu2, inflater);
    }

    private final boolean shouldShowSaveIcon(HttpTransaction transaction) {
        boolean bl;
        if (this.getPayloadType() == PayloadType.REQUEST) {
            boolean bl2;
            if (transaction != null) {
                Long l = transaction.getRequestPayloadSize();
                bl2 = l != null && 0L == l;
            } else {
                bl2 = false;
            }
            bl = !bl2;
        } else if (this.getPayloadType() == PayloadType.RESPONSE) {
            boolean bl3;
            if (transaction != null) {
                Long l = transaction.getResponsePayloadSize();
                bl3 = l != null && 0L == l;
            } else {
                bl3 = false;
            }
            bl = !bl3;
        } else {
            bl = true;
        }
        return bl;
    }

    private final boolean shouldShowSearchIcon(HttpTransaction transaction) {
        boolean bl;
        switch (WhenMappings.$EnumSwitchMapping$0[this.getPayloadType().ordinal()]) {
            case 1: {
                boolean bl2 = transaction != null ? !transaction.isRequestBodyEncoded() : false;
                if (bl2) {
                    Long l = transaction.getRequestPayloadSize();
                    if (l == null || 0L != l) {
                        bl = true;
                        break;
                    }
                }
                bl = false;
                break;
            }
            case 2: {
                boolean bl3 = transaction != null ? !transaction.isResponseBodyEncoded() : false;
                if (bl3) {
                    Long l = transaction.getResponsePayloadSize();
                    if (l == null || 0L != l) {
                        bl = true;
                        break;
                    }
                }
                bl = false;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    public void onAttach(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super.onAttach(context);
        this.backgroundSpanColor = ContextCompat.getColor((Context)context, (int)R.color.chucker_background_span_color);
        this.foregroundSpanColor = ContextCompat.getColor((Context)context, (int)R.color.chucker_foreground_span_color);
    }

    private final void createFileToSaveBody() {
        HttpTransaction transaction = (HttpTransaction)this.getViewModel().getTransaction().getValue();
        if (transaction != null && this.isBodyEmpty(this.getPayloadType(), transaction)) {
            Toast.makeText((Context)((Context)this.getActivity()), (int)R.string.chucker_file_not_saved_body_is_empty, (int)0).show();
        } else {
            this.saveToFile.launch((Object)(DEFAULT_FILE_PREFIX + System.currentTimeMillis()));
        }
    }

    public boolean onQueryTextSubmit(@NotNull String query) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        return false;
    }

    public boolean onQueryTextChange(@NotNull String newText) {
        Intrinsics.checkNotNullParameter((Object)newText, (String)"newText");
        this.scrollableIndices.clear();
        this.currentSearchQuery = newText;
        this.currentSearchScrollIndex = -1;
        if (!StringsKt.isBlank((CharSequence)newText) && newText.length() > 1) {
            List<TransactionBodyAdapter.SearchItemBodyLine> listOfSearchQuery = this.payloadAdapter.highlightQueryWithColors$com_github_ChuckerTeam_Chucker_library(newText, this.backgroundSpanColor, this.foregroundSpanColor);
            if (!((Collection)listOfSearchQuery).isEmpty()) {
                this.scrollableIndices.addAll((Collection<TransactionBodyAdapter.SearchItemBodyLine>)listOfSearchQuery);
            } else {
                this.payloadAdapter.resetHighlight$com_github_ChuckerTeam_Chucker_library();
                this.makeToolbarSearchSummaryVisible(false);
            }
        } else {
            this.payloadAdapter.resetHighlight$com_github_ChuckerTeam_Chucker_library();
            this.makeToolbarSearchSummaryVisible(false);
        }
        BuildersKt.launch$default((CoroutineScope)((CoroutineScope)LifecycleOwnerKt.getLifecycleScope((LifecycleOwner)((LifecycleOwner)this))), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            Object L$0;
            Object L$1;
            Object L$2;
            Object L$3;
            int I$0;
            int I$1;
            boolean Z$0;
            int label;
            final /* synthetic */ TransactionPayloadFragment this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var11_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        v0 = DelayKt.delay((long)600L, (Continuation)((Continuation)this));
                        if (v0 == var11_2) {
                            return var11_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        v1 = this.this$0.getLifecycle();
                        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"<get-lifecycle>(...)");
                        var2_3 = v1;
                        var3_5 = this.this$0;
                        $i$f$withResumed = 0;
                        var5_8 = $this$withResumed$iv;
                        state$iv$iv = Lifecycle.State.RESUMED;
                        $i$f$withStateAtLeastUnchecked = 0;
                        lifecycleDispatcher$iv$iv = Dispatchers.getMain().getImmediate();
                        dispatchNeeded$iv$iv = lifecycleDispatcher$iv$iv.isDispatchNeeded(this.getContext());
                        if (dispatchNeeded$iv$iv) ** GOTO lbl-1000
                        if ($this$withStateAtLeastUnchecked$iv$iv.getCurrentState() == Lifecycle.State.DESTROYED) {
                            throw new LifecycleDestroyedException();
                        }
                        if ($this$withStateAtLeastUnchecked$iv$iv.getCurrentState().compareTo((Enum)state$iv$iv) >= 0) {
                            $i$a$-withResumed-TransactionPayloadFragment$onQueryTextChange$1$1 = false;
                            if (((Collection)TransactionPayloadFragment.access$getScrollableIndices$p(var3_5)).isEmpty() == false) {
                                TransactionPayloadFragment.access$scrollToSearchedItemPosition(var3_5, 0);
                            } else {
                                TransactionPayloadFragment.access$setCurrentSearchScrollIndex$p(var3_5, -1);
                            }
                            v2 = Unit.INSTANCE;
                        } else lbl-1000:
                        // 2 sources

                        {
                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$withResumed$iv);
                            this.L$1 = SpillingKt.nullOutSpilledVariable((Object)$this$withStateAtLeastUnchecked$iv$iv);
                            this.L$2 = SpillingKt.nullOutSpilledVariable((Object)state$iv$iv);
                            this.L$3 = SpillingKt.nullOutSpilledVariable((Object)lifecycleDispatcher$iv$iv);
                            this.I$0 = $i$f$withResumed;
                            this.I$1 = $i$f$withStateAtLeastUnchecked;
                            this.Z$0 = dispatchNeeded$iv$iv;
                            this.label = 2;
                            v2 = WithLifecycleStateKt.suspendWithStateAtLeastUnchecked((Lifecycle)$this$withStateAtLeastUnchecked$iv$iv, (Lifecycle.State)state$iv$iv, (boolean)(dispatchNeeded$iv$iv != false), (CoroutineDispatcher)((CoroutineDispatcher)lifecycleDispatcher$iv$iv), (Function0)((Function0)new Function0<Unit>(var3_5){
                                final /* synthetic */ TransactionPayloadFragment this$0;
                                {
                                    this.this$0 = transactionPayloadFragment;
                                }

                                public final Unit invoke() {
                                    boolean bl = false;
                                    if (!((Collection)TransactionPayloadFragment.access$getScrollableIndices$p(this.this$0)).isEmpty()) {
                                        TransactionPayloadFragment.access$scrollToSearchedItemPosition(this.this$0, 0);
                                    } else {
                                        TransactionPayloadFragment.access$setCurrentSearchScrollIndex$p(this.this$0, -1);
                                    }
                                    return Unit.INSTANCE;
                                }
                            }), (Continuation)((Continuation)this));
                            if (v2 == var11_2) {
                                return var11_2;
                            }
                        }
                        ** GOTO lbl59
                    }
                    case 2: {
                        dispatchNeeded$iv$iv = this.Z$0;
                        $i$f$withStateAtLeastUnchecked = this.I$1;
                        $i$f$withResumed = this.I$0;
                        lifecycleDispatcher$iv$iv = (MainCoroutineDispatcher)this.L$3;
                        state$iv$iv = (Lifecycle.State)this.L$2;
                        $this$withStateAtLeastUnchecked$iv$iv = (Lifecycle)this.L$1;
                        $this$withResumed$iv = (Lifecycle)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl59:
                        // 3 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final void makeToolbarSearchSummaryVisible(boolean visible) {
        void $this$isVisible$iv;
        ChuckerFragmentTransactionPayloadBinding chuckerFragmentTransactionPayloadBinding = this.payloadBinding;
        if (chuckerFragmentTransactionPayloadBinding == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"payloadBinding");
            chuckerFragmentTransactionPayloadBinding = null;
        }
        LinearLayoutCompat linearLayoutCompat = chuckerFragmentTransactionPayloadBinding.rootSearchSummary;
        Intrinsics.checkNotNullExpressionValue((Object)linearLayoutCompat, (String)"rootSearchSummary");
        View view = (View)linearLayoutCompat;
        boolean value$iv = visible;
        boolean $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(value$iv ? 0 : 8);
    }

    static /* synthetic */ void makeToolbarSearchSummaryVisible$default(TransactionPayloadFragment transactionPayloadFragment, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        transactionPayloadFragment.makeToolbarSearchSummaryVisible(bl);
    }

    /*
     * WARNING - void declaration
     */
    private final void updateToolbarText(int searchResultsCount, int currentIndex) {
        void $this$inSpans$iv$iv;
        void $this$updateToolbarText_u24lambda_u2415;
        SpannableStringBuilder spannableStringBuilder;
        ChuckerFragmentTransactionPayloadBinding chuckerFragmentTransactionPayloadBinding = this.payloadBinding;
        if (chuckerFragmentTransactionPayloadBinding == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"payloadBinding");
            chuckerFragmentTransactionPayloadBinding = null;
        }
        SpannableStringBuilder spannableStringBuilder2 = spannableStringBuilder = new SpannableStringBuilder();
        TextView textView = chuckerFragmentTransactionPayloadBinding.searchSummary;
        boolean bl = false;
        void $this$bold$iv = $this$updateToolbarText_u24lambda_u2415;
        boolean $i$f$bold = false;
        void var8_9 = $this$bold$iv;
        StyleSpan span$iv$iv = new StyleSpan(1);
        boolean $i$f$inSpans = false;
        int start$iv$iv = $this$inSpans$iv$iv.length();
        void $this$updateToolbarText_u24lambda_u2415_u24lambda_u2414 = $this$inSpans$iv$iv;
        boolean bl2 = false;
        $this$updateToolbarText_u24lambda_u2415_u24lambda_u2414.append((CharSequence)(currentIndex + " / " + searchResultsCount));
        $this$inSpans$iv$iv.setSpan((Object)span$iv$iv, start$iv$iv, $this$inSpans$iv$iv.length(), 17);
        textView.setText((CharSequence)spannableStringBuilder);
    }

    static /* synthetic */ void updateToolbarText$default(TransactionPayloadFragment transactionPayloadFragment, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n2 = 1;
        }
        transactionPayloadFragment.updateToolbarText(n, n2);
    }

    private final void scrollToSearchedItemPosition(int positionOfScrollableIndices) {
        TransactionBodyAdapter.SearchItemBodyLine searchItemBodyLine = (TransactionBodyAdapter.SearchItemBodyLine)CollectionsKt.getOrNull((List)this.scrollableIndices, (int)this.currentSearchScrollIndex);
        if (searchItemBodyLine != null) {
            TransactionBodyAdapter.SearchItemBodyLine it = searchItemBodyLine;
            boolean bl = false;
            this.payloadAdapter.highlightItemWithColorOnPosition$com_github_ChuckerTeam_Chucker_library(it.getIndexBodyLine(), it.getIndexStartOfQuerySubString(), this.currentSearchQuery, this.backgroundSpanColor, this.foregroundSpanColor);
        }
        this.currentSearchScrollIndex = positionOfScrollableIndices;
        TransactionBodyAdapter.SearchItemBodyLine scrollTo = (TransactionBodyAdapter.SearchItemBodyLine)CollectionsKt.getOrNull((List)this.scrollableIndices, (int)positionOfScrollableIndices);
        if (scrollTo != null) {
            this.payloadAdapter.highlightItemWithColorOnPosition$com_github_ChuckerTeam_Chucker_library(scrollTo.getIndexBodyLine(), scrollTo.getIndexStartOfQuerySubString(), this.currentSearchQuery, this.backgroundSpanColorSearchItem, this.foregroundSpanColor);
            this.updateToolbarText(this.scrollableIndices.size(), positionOfScrollableIndices + 1);
            TransactionPayloadFragment.makeToolbarSearchSummaryVisible$default(this, false, 1, null);
            ChuckerFragmentTransactionPayloadBinding chuckerFragmentTransactionPayloadBinding = this.payloadBinding;
            if (chuckerFragmentTransactionPayloadBinding == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"payloadBinding");
                chuckerFragmentTransactionPayloadBinding = null;
            }
            chuckerFragmentTransactionPayloadBinding.payloadRecyclerView.smoothScrollToPosition(scrollTo.getIndexBodyLine());
            this.currentSearchScrollIndex = positionOfScrollableIndices;
        }
    }

    private final Object processPayload(PayloadType type, HttpTransaction transaction, boolean formatRequestBody, Continuation<? super List<TransactionPayloadItem>> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getDefault()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<TransactionPayloadItem>>, Object>(type, transaction, formatRequestBody, this, null){
            Object L$0;
            Object L$1;
            Object L$2;
            Object L$3;
            boolean Z$0;
            int label;
            final /* synthetic */ PayloadType $type;
            final /* synthetic */ HttpTransaction $transaction;
            final /* synthetic */ boolean $formatRequestBody;
            final /* synthetic */ TransactionPayloadFragment this$0;
            {
                this.$type = $type;
                this.$transaction = $transaction;
                this.$formatRequestBody = $formatRequestBody;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var14_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        result = new ArrayList<E>();
                        headersString = null;
                        isBodyEncoded = false;
                        bodyString = null;
                        if (this.$type == PayloadType.REQUEST) {
                            headersString = this.$transaction.getRequestHeadersString(true);
                            isBodyEncoded = this.$transaction.isRequestBodyEncoded();
                            if (this.$formatRequestBody) {
                                v0 = this.$transaction.getSpannedRequestBody(this.this$0.getContext());
                            } else {
                                v1 = this.$transaction.getRequestBody();
                                if (v1 == null) {
                                    v1 = "";
                                }
                                v0 = v1;
                            }
                            bodyString = v0;
                        } else {
                            headersString = this.$transaction.getResponseHeadersString(true);
                            isBodyEncoded = this.$transaction.isResponseBodyEncoded();
                            bodyString = this.$transaction.getSpannedResponseBody(this.this$0.getContext());
                        }
                        if (StringsKt.isBlank((CharSequence)headersString) == false) {
                            v2 = HtmlCompat.fromHtml((String)headersString, (int)0);
                            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"fromHtml(...)");
                            result.add(new TransactionPayloadItem.HeaderItem(v2));
                        }
                        responseBitmap = this.$transaction.getResponseImageBitmap();
                        if (this.$type != PayloadType.RESPONSE || responseBitmap == null) break;
                        this.L$0 = result;
                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)headersString);
                        this.L$2 = SpillingKt.nullOutSpilledVariable((Object)bodyString);
                        this.L$3 = responseBitmap;
                        this.Z$0 = isBodyEncoded;
                        this.label = 1;
                        v3 = BitmapUtilsKt.calculateLuminance(responseBitmap, (Continuation<? super Double>)((Continuation)this));
                        if (v3 == var14_2) {
                            return var14_2;
                        }
                        ** GOTO lbl49
                    }
                    case 1: {
                        isBodyEncoded = this.Z$0;
                        responseBitmap = (Bitmap)this.L$3;
                        bodyString = (CharSequence)this.L$2;
                        headersString = (String)this.L$1;
                        result = (List)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
lbl49:
                        // 2 sources

                        bitmapLuminance = (Double)v3;
                        result.add(new TransactionPayloadItem.ImageItem(responseBitmap, bitmapLuminance));
                        return result;
                    }
                }
                if (isBodyEncoded) {
                    v4 = this.this$0.requireContext().getString(R.string.chucker_body_omitted);
                    Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"getString(...)");
                    text = v4;
                    v5 = SpannableStringBuilder.valueOf((CharSequence)text);
                    Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"valueOf(...)");
                    v6 = Boxing.boxBoolean((boolean)result.add(new TransactionPayloadItem.BodyLineItem(v5)));
                } else if (StringsKt.isBlank((CharSequence)bodyString)) {
                    v7 = this.this$0.requireContext().getString(R.string.chucker_body_empty);
                    Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"getString(...)");
                    text = v7;
                    v8 = SpannableStringBuilder.valueOf((CharSequence)text);
                    Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"valueOf(...)");
                    v6 = Boxing.boxBoolean((boolean)result.add(new TransactionPayloadItem.BodyLineItem(v8)));
                } else {
                    v9 = this.this$0.getString(R.string.chucker_copy_response);
                    Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"getString(...)");
                    result.add(new TransactionPayloadItem.CopyItem(v9));
                    $this$forEach$iv = TransactionPayloadFragment.access$lines(this.this$0, bodyString);
                    $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        it = (CharSequence)element$iv;
                        $i$a$-forEach-TransactionPayloadFragment$processPayload$2$1 = false;
                        var13_20 = it instanceof SpannableStringBuilder != false ? (SpannableStringBuilder)it : SpannableStringBuilder.valueOf((CharSequence)it);
                        Intrinsics.checkNotNull((Object)var13_20);
                        result.add(new TransactionPayloadItem.BodyLineItem(var13_20));
                    }
                    v6 = Unit.INSTANCE;
                }
                return result;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super List<TransactionPayloadItem>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    private final Source prepareDataToSave(PayloadType type, HttpTransaction transaction) {
        String string2;
        switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                string2 = transaction.getRequestBody();
                if (string2 != null) {
                    String string3 = string2;
                    Charset charset = Charsets.UTF_8;
                    byte[] byArray = string3.getBytes(charset);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                    string2 = Okio.source((InputStream)new ByteArrayInputStream(byArray));
                    if (string2 != null) break;
                }
                throw new IOException(TRANSACTION_EXCEPTION);
            }
            case 2: {
                string2 = transaction.getResponseBody();
                if (string2 != null) {
                    String string4 = string2;
                    Charset charset = Charsets.UTF_8;
                    byte[] byArray = string4.getBytes(charset);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                    string2 = Okio.source((InputStream)new ByteArrayInputStream(byArray));
                    if (string2 != null) break;
                }
                throw new IOException(TRANSACTION_EXCEPTION);
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string2;
    }

    private final boolean isBodyEmpty(PayloadType type, HttpTransaction transaction) {
        return type == PayloadType.REQUEST && transaction.getRequestBody() == null ? true : type == PayloadType.RESPONSE && transaction.getResponseBody() == null;
    }

    private final List<CharSequence> lines(CharSequence $this$lines) {
        List linesList = SequencesKt.toList((Sequence)StringsKt.lineSequence((CharSequence)$this$lines));
        List result = new ArrayList();
        int lineIndex = 0;
        int n = ((Collection)linesList).size();
        for (int index = 0; index < n; ++index) {
            CharSequence line = $this$lines.subSequence(lineIndex, lineIndex + ((String)linesList.get(index)).length());
            boolean bl = line.length() > 500 ? (line instanceof SpannableStringBuilder ? result.addAll((Collection)SpannableStringExtensionKt.spannableChunked((SpannableStringBuilder)line, 500)) : result.addAll(StringsKt.chunked((CharSequence)line, (int)500))) : result.add(line);
            lineIndex += ((String)linesList.get(index)).length() + 1;
        }
        if (result.isEmpty()) {
            result.add($this$lines.subSequence(0, $this$lines.length()));
        }
        return result;
    }

    private static final ViewModelProvider.Factory viewModel_delegate$lambda$0() {
        return (ViewModelProvider.Factory)new TransactionViewModelFactory(0L, 1, null);
    }

    private static final PayloadType payloadType_delegate$lambda$1(TransactionPayloadFragment this$0) {
        Bundle bundle = this$0.getArguments();
        Serializable serializable = bundle != null ? bundle.getSerializable(ARG_TYPE) : null;
        Intrinsics.checkNotNull((Object)serializable, (String)"null cannot be cast to non-null type com.chuckerteam.chucker.internal.ui.transaction.PayloadType");
        return (PayloadType)((Object)serializable);
    }

    private static final void saveToFile$lambda$2(TransactionPayloadFragment this$0, Uri uri) {
        HttpTransaction transaction = (HttpTransaction)this$0.getViewModel().getTransaction().getValue();
        Context applicationContext = this$0.requireContext().getApplicationContext();
        if (uri != null && transaction != null) {
            BuildersKt.launch$default((CoroutineScope)((CoroutineScope)LifecycleOwnerKt.getLifecycleScope((LifecycleOwner)((LifecycleOwner)this$0))), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(uri, applicationContext, this$0, transaction, null){
                Object L$1;
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ Uri $uri;
                final /* synthetic */ Context $applicationContext;
                final /* synthetic */ TransactionPayloadFragment this$0;
                final /* synthetic */ HttpTransaction $transaction;
                {
                    this.$uri = $uri;
                    this.$applicationContext = $applicationContext;
                    this.this$0 = $receiver;
                    this.$transaction = $transaction;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object $result) {
                    var2_2 = (CoroutineScope)this.L$0;
                    var9_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            var4_4 = $this$launch;
                            var5_6 = this.this$0;
                            var6_8 = this.$transaction;
                            try {
                                $this$invokeSuspend_u24lambda_u240 = var4_4;
                                $i$a$-runCatching-TransactionPayloadFragment$saveToFile$1$1$source$1 = false;
                                var7_10 = Result.constructor-impl((Object)TransactionPayloadFragment.access$prepareDataToSave(var5_6, TransactionPayloadFragment.access$getPayloadType(var5_6), var6_8));
                            }
                            catch (Throwable var8_12) {
                                var7_10 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)var8_12));
                            }
                            var4_4 = var7_10;
                            v0 = Result.exceptionOrNull-impl((Object)var4_4);
                            if (v0 != null) {
                                it = v0;
                                $i$a$-getOrElse-TransactionPayloadFragment$saveToFile$1$1$source$2 = false;
                                Logger.Companion.error("Failed to save transaction to a file", it);
                                return Unit.INSTANCE;
                            }
                            source = (Source)var4_4;
                            v1 = this.$applicationContext.getContentResolver();
                            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getContentResolver(...)");
                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$launch);
                            this.L$1 = SpillingKt.nullOutSpilledVariable((Object)source);
                            this.label = 1;
                            v2 = FileSaver.INSTANCE.saveFile(source, this.$uri, v1, (Continuation<? super Boolean>)((Continuation)this));
                            if (v2 == var9_3) {
                                return var9_3;
                            }
                            ** GOTO lbl40
                        }
                        case 1: {
                            source = (Source)this.L$1;
                            ResultKt.throwOnFailure((Object)$result);
                            v2 = $result;
lbl40:
                            // 2 sources

                            toastMessageId = (result = ((Boolean)v2).booleanValue()) != false ? R.string.chucker_file_saved : R.string.chucker_file_not_saved;
                            Toast.makeText((Context)this.$applicationContext, (int)toastMessageId, (int)0).show();
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.L$0 = value;
                    return (Continuation)var3_3;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        } else {
            Toast.makeText((Context)applicationContext, (int)R.string.chucker_save_failed_to_open_document, (int)0).show();
        }
    }

    private static final void onViewCreated$lambda$4(TransactionPayloadFragment this$0, Pair pair) {
        HttpTransaction transaction = (HttpTransaction)pair.component1();
        boolean formatRequestBody = (Boolean)pair.component2();
        if (transaction == null) {
            return;
        }
        BuildersKt.launch$default((CoroutineScope)((CoroutineScope)LifecycleOwnerKt.getLifecycleScope((LifecycleOwner)((LifecycleOwner)this$0))), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this$0, transaction, formatRequestBody, null){
            int label;
            final /* synthetic */ TransactionPayloadFragment this$0;
            final /* synthetic */ HttpTransaction $transaction;
            final /* synthetic */ boolean $formatRequestBody;
            {
                this.this$0 = $receiver;
                this.$transaction = $transaction;
                this.$formatRequestBody = $formatRequestBody;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = TransactionPayloadFragment.access$getPayloadBinding$p(this.this$0);
                        if (v0 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"payloadBinding");
                            v0 = null;
                        }
                        v0.loadingProgress.setVisibility(0);
                        this.label = 1;
                        v1 = TransactionPayloadFragment.access$processPayload(this.this$0, TransactionPayloadFragment.access$getPayloadType(this.this$0), this.$transaction, this.$formatRequestBody, (Continuation)this);
                        if (v1 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl18
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl18:
                        // 2 sources

                        if ((result = (List)v1).isEmpty()) {
                            TransactionPayloadFragment.access$showEmptyState(this.this$0);
                        } else {
                            TransactionPayloadFragment.access$getPayloadAdapter$p(this.this$0).setItems(result);
                            TransactionPayloadFragment.access$showPayloadState(this.this$0);
                        }
                        this.this$0.requireActivity().invalidateOptionsMenu();
                        v2 = TransactionPayloadFragment.access$getPayloadBinding$p(this.this$0);
                        if (v2 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"payloadBinding");
                            v2 = null;
                        }
                        v2.loadingProgress.setVisibility(8);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private static final void onViewCreated$lambda$5(TransactionPayloadFragment this$0, View it) {
        this$0.onSearchScrollerButtonClick(true);
    }

    private static final void onViewCreated$lambda$6(TransactionPayloadFragment this$0, View it) {
        this$0.onSearchScrollerButtonClick(false);
    }

    private static final boolean onCreateOptionsMenu$lambda$12$lambda$11(TransactionPayloadFragment this$0, MenuItem it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.createFileToSaveBody();
        return true;
    }

    private static final Unit onCreateOptionsMenu$lambda$13(Menu $menu, Boolean it) {
        MenuItem menuItem = $menu.findItem(R.id.encode_url);
        Intrinsics.checkNotNull((Object)it);
        menuItem.setVisible(it.booleanValue());
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ ArrayList access$getScrollableIndices$p(TransactionPayloadFragment $this) {
        return $this.scrollableIndices;
    }

    public static final /* synthetic */ void access$scrollToSearchedItemPosition(TransactionPayloadFragment $this, int positionOfScrollableIndices) {
        $this.scrollToSearchedItemPosition(positionOfScrollableIndices);
    }

    public static final /* synthetic */ void access$setCurrentSearchScrollIndex$p(TransactionPayloadFragment $this, int n) {
        $this.currentSearchScrollIndex = n;
    }

    public static final /* synthetic */ Object access$processPayload(TransactionPayloadFragment $this, PayloadType type, HttpTransaction transaction, boolean formatRequestBody, Continuation $completion) {
        return $this.processPayload(type, transaction, formatRequestBody, (Continuation<? super List<TransactionPayloadItem>>)$completion);
    }

    public static final /* synthetic */ List access$lines(TransactionPayloadFragment $this, CharSequence $receiver) {
        return $this.lines($receiver);
    }

    public static final /* synthetic */ Source access$prepareDataToSave(TransactionPayloadFragment $this, PayloadType type, HttpTransaction transaction) {
        return $this.prepareDataToSave(type, transaction);
    }

    public static final /* synthetic */ PayloadType access$getPayloadType(TransactionPayloadFragment $this) {
        return $this.getPayloadType();
    }

    public static final /* synthetic */ ChuckerFragmentTransactionPayloadBinding access$getPayloadBinding$p(TransactionPayloadFragment $this) {
        return $this.payloadBinding;
    }

    public static final /* synthetic */ void access$showEmptyState(TransactionPayloadFragment $this) {
        $this.showEmptyState();
    }

    public static final /* synthetic */ TransactionBodyAdapter access$getPayloadAdapter$p(TransactionPayloadFragment $this) {
        return $this.payloadAdapter;
    }

    public static final /* synthetic */ void access$showPayloadState(TransactionPayloadFragment $this) {
        $this.showPayloadState();
    }

    public static final /* synthetic */ void access$copyResponse(TransactionPayloadFragment $this) {
        $this.copyResponse();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/chuckerteam/chucker/internal/ui/transaction/TransactionPayloadFragment$Companion;", "", "<init>", "()V", "ARG_TYPE", "", "TRANSACTION_EXCEPTION", "DELAY_FOR_SEARCH_SCROLL", "", "NUMBER_OF_IGNORED_SYMBOLS", "", "LINE_LENGTH_THRESHOLD", "DEFAULT_FILE_PREFIX", "newInstance", "Lcom/chuckerteam/chucker/internal/ui/transaction/TransactionPayloadFragment;", "type", "Lcom/chuckerteam/chucker/internal/ui/transaction/PayloadType;", "com.github.ChuckerTeam.Chucker.library"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final TransactionPayloadFragment newInstance(@NotNull PayloadType type) {
            void $this$newInstance_u24lambda_u241_u24lambda_u240;
            Bundle bundle;
            TransactionPayloadFragment transactionPayloadFragment;
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)TransactionPayloadFragment.ARG_TYPE);
            TransactionPayloadFragment $this$newInstance_u24lambda_u241 = transactionPayloadFragment = new TransactionPayloadFragment();
            boolean bl = false;
            Bundle bundle2 = bundle = new Bundle();
            TransactionPayloadFragment transactionPayloadFragment2 = $this$newInstance_u24lambda_u241;
            boolean bl2 = false;
            $this$newInstance_u24lambda_u241_u24lambda_u240.putSerializable(TransactionPayloadFragment.ARG_TYPE, (Serializable)((Object)type));
            transactionPayloadFragment2.setArguments(bundle);
            return transactionPayloadFragment;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PayloadType.values().length];
            try {
                nArray[PayloadType.REQUEST.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PayloadType.RESPONSE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

