/*
 * Decompiled with CFR 0.152.
 */
package com.chuckerteam.chucker.internal.data.room;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.lifecycle.LiveData;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.chuckerteam.chucker.internal.data.entity.HttpTransaction;
import com.chuckerteam.chucker.internal.data.entity.HttpTransactionTuple;
import com.chuckerteam.chucker.internal.data.room.HttpTransactionDao;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.coroutines.Continuation;

public final class HttpTransactionDao_Impl
implements HttpTransactionDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<HttpTransaction> __insertionAdapterOfHttpTransaction;
    private final EntityDeletionOrUpdateAdapter<HttpTransaction> __updateAdapterOfHttpTransaction;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;
    private final SharedSQLiteStatement __preparedStmtOfDeleteBefore;

    public HttpTransactionDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfHttpTransaction = new EntityInsertionAdapter<HttpTransaction>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR ABORT INTO `transactions` (`id`,`requestDate`,`responseDate`,`tookMs`,`protocol`,`method`,`url`,`host`,`path`,`scheme`,`responseTlsVersion`,`responseCipherSuite`,`requestPayloadSize`,`requestContentType`,`requestHeaders`,`requestHeadersSize`,`requestBody`,`isRequestBodyEncoded`,`responseCode`,`responseMessage`,`error`,`responsePayloadSize`,`responseContentType`,`responseHeaders`,`responseHeadersSize`,`responseBody`,`isResponseBodyEncoded`,`responseImageData`,`graphQlDetected`,`graphQlOperationName`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull HttpTransaction entity) {
                statement.bindLong(1, entity.getId());
                if (entity.getRequestDate() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindLong(2, entity.getRequestDate().longValue());
                }
                if (entity.getResponseDate() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindLong(3, entity.getResponseDate().longValue());
                }
                if (entity.getTookMs() == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindLong(4, entity.getTookMs().longValue());
                }
                if (entity.getProtocol() == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindString(5, entity.getProtocol());
                }
                if (entity.getMethod() == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindString(6, entity.getMethod());
                }
                if (entity.getUrl() == null) {
                    statement.bindNull(7);
                } else {
                    statement.bindString(7, entity.getUrl());
                }
                if (entity.getHost() == null) {
                    statement.bindNull(8);
                } else {
                    statement.bindString(8, entity.getHost());
                }
                if (entity.getPath() == null) {
                    statement.bindNull(9);
                } else {
                    statement.bindString(9, entity.getPath());
                }
                if (entity.getScheme() == null) {
                    statement.bindNull(10);
                } else {
                    statement.bindString(10, entity.getScheme());
                }
                if (entity.getResponseTlsVersion() == null) {
                    statement.bindNull(11);
                } else {
                    statement.bindString(11, entity.getResponseTlsVersion());
                }
                if (entity.getResponseCipherSuite() == null) {
                    statement.bindNull(12);
                } else {
                    statement.bindString(12, entity.getResponseCipherSuite());
                }
                if (entity.getRequestPayloadSize() == null) {
                    statement.bindNull(13);
                } else {
                    statement.bindLong(13, entity.getRequestPayloadSize().longValue());
                }
                if (entity.getRequestContentType() == null) {
                    statement.bindNull(14);
                } else {
                    statement.bindString(14, entity.getRequestContentType());
                }
                if (entity.getRequestHeaders() == null) {
                    statement.bindNull(15);
                } else {
                    statement.bindString(15, entity.getRequestHeaders());
                }
                if (entity.getRequestHeadersSize() == null) {
                    statement.bindNull(16);
                } else {
                    statement.bindLong(16, entity.getRequestHeadersSize().longValue());
                }
                if (entity.getRequestBody() == null) {
                    statement.bindNull(17);
                } else {
                    statement.bindString(17, entity.getRequestBody());
                }
                int _tmp = entity.isRequestBodyEncoded() ? 1 : 0;
                statement.bindLong(18, (long)_tmp);
                if (entity.getResponseCode() == null) {
                    statement.bindNull(19);
                } else {
                    statement.bindLong(19, (long)entity.getResponseCode().intValue());
                }
                if (entity.getResponseMessage() == null) {
                    statement.bindNull(20);
                } else {
                    statement.bindString(20, entity.getResponseMessage());
                }
                if (entity.getError() == null) {
                    statement.bindNull(21);
                } else {
                    statement.bindString(21, entity.getError());
                }
                if (entity.getResponsePayloadSize() == null) {
                    statement.bindNull(22);
                } else {
                    statement.bindLong(22, entity.getResponsePayloadSize().longValue());
                }
                if (entity.getResponseContentType() == null) {
                    statement.bindNull(23);
                } else {
                    statement.bindString(23, entity.getResponseContentType());
                }
                if (entity.getResponseHeaders() == null) {
                    statement.bindNull(24);
                } else {
                    statement.bindString(24, entity.getResponseHeaders());
                }
                if (entity.getResponseHeadersSize() == null) {
                    statement.bindNull(25);
                } else {
                    statement.bindLong(25, entity.getResponseHeadersSize().longValue());
                }
                if (entity.getResponseBody() == null) {
                    statement.bindNull(26);
                } else {
                    statement.bindString(26, entity.getResponseBody());
                }
                int _tmp_1 = entity.isResponseBodyEncoded() ? 1 : 0;
                statement.bindLong(27, (long)_tmp_1);
                if (entity.getResponseImageData() == null) {
                    statement.bindNull(28);
                } else {
                    statement.bindBlob(28, entity.getResponseImageData());
                }
                int _tmp_2 = entity.getGraphQlDetected() ? 1 : 0;
                statement.bindLong(29, (long)_tmp_2);
                if (entity.getGraphQlOperationName() == null) {
                    statement.bindNull(30);
                } else {
                    statement.bindString(30, entity.getGraphQlOperationName());
                }
            }
        };
        this.__updateAdapterOfHttpTransaction = new EntityDeletionOrUpdateAdapter<HttpTransaction>(__db){

            @NonNull
            protected String createQuery() {
                return "UPDATE OR REPLACE `transactions` SET `id` = ?,`requestDate` = ?,`responseDate` = ?,`tookMs` = ?,`protocol` = ?,`method` = ?,`url` = ?,`host` = ?,`path` = ?,`scheme` = ?,`responseTlsVersion` = ?,`responseCipherSuite` = ?,`requestPayloadSize` = ?,`requestContentType` = ?,`requestHeaders` = ?,`requestHeadersSize` = ?,`requestBody` = ?,`isRequestBodyEncoded` = ?,`responseCode` = ?,`responseMessage` = ?,`error` = ?,`responsePayloadSize` = ?,`responseContentType` = ?,`responseHeaders` = ?,`responseHeadersSize` = ?,`responseBody` = ?,`isResponseBodyEncoded` = ?,`responseImageData` = ?,`graphQlDetected` = ?,`graphQlOperationName` = ? WHERE `id` = ?";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull HttpTransaction entity) {
                statement.bindLong(1, entity.getId());
                if (entity.getRequestDate() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindLong(2, entity.getRequestDate().longValue());
                }
                if (entity.getResponseDate() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindLong(3, entity.getResponseDate().longValue());
                }
                if (entity.getTookMs() == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindLong(4, entity.getTookMs().longValue());
                }
                if (entity.getProtocol() == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindString(5, entity.getProtocol());
                }
                if (entity.getMethod() == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindString(6, entity.getMethod());
                }
                if (entity.getUrl() == null) {
                    statement.bindNull(7);
                } else {
                    statement.bindString(7, entity.getUrl());
                }
                if (entity.getHost() == null) {
                    statement.bindNull(8);
                } else {
                    statement.bindString(8, entity.getHost());
                }
                if (entity.getPath() == null) {
                    statement.bindNull(9);
                } else {
                    statement.bindString(9, entity.getPath());
                }
                if (entity.getScheme() == null) {
                    statement.bindNull(10);
                } else {
                    statement.bindString(10, entity.getScheme());
                }
                if (entity.getResponseTlsVersion() == null) {
                    statement.bindNull(11);
                } else {
                    statement.bindString(11, entity.getResponseTlsVersion());
                }
                if (entity.getResponseCipherSuite() == null) {
                    statement.bindNull(12);
                } else {
                    statement.bindString(12, entity.getResponseCipherSuite());
                }
                if (entity.getRequestPayloadSize() == null) {
                    statement.bindNull(13);
                } else {
                    statement.bindLong(13, entity.getRequestPayloadSize().longValue());
                }
                if (entity.getRequestContentType() == null) {
                    statement.bindNull(14);
                } else {
                    statement.bindString(14, entity.getRequestContentType());
                }
                if (entity.getRequestHeaders() == null) {
                    statement.bindNull(15);
                } else {
                    statement.bindString(15, entity.getRequestHeaders());
                }
                if (entity.getRequestHeadersSize() == null) {
                    statement.bindNull(16);
                } else {
                    statement.bindLong(16, entity.getRequestHeadersSize().longValue());
                }
                if (entity.getRequestBody() == null) {
                    statement.bindNull(17);
                } else {
                    statement.bindString(17, entity.getRequestBody());
                }
                int _tmp = entity.isRequestBodyEncoded() ? 1 : 0;
                statement.bindLong(18, (long)_tmp);
                if (entity.getResponseCode() == null) {
                    statement.bindNull(19);
                } else {
                    statement.bindLong(19, (long)entity.getResponseCode().intValue());
                }
                if (entity.getResponseMessage() == null) {
                    statement.bindNull(20);
                } else {
                    statement.bindString(20, entity.getResponseMessage());
                }
                if (entity.getError() == null) {
                    statement.bindNull(21);
                } else {
                    statement.bindString(21, entity.getError());
                }
                if (entity.getResponsePayloadSize() == null) {
                    statement.bindNull(22);
                } else {
                    statement.bindLong(22, entity.getResponsePayloadSize().longValue());
                }
                if (entity.getResponseContentType() == null) {
                    statement.bindNull(23);
                } else {
                    statement.bindString(23, entity.getResponseContentType());
                }
                if (entity.getResponseHeaders() == null) {
                    statement.bindNull(24);
                } else {
                    statement.bindString(24, entity.getResponseHeaders());
                }
                if (entity.getResponseHeadersSize() == null) {
                    statement.bindNull(25);
                } else {
                    statement.bindLong(25, entity.getResponseHeadersSize().longValue());
                }
                if (entity.getResponseBody() == null) {
                    statement.bindNull(26);
                } else {
                    statement.bindString(26, entity.getResponseBody());
                }
                int _tmp_1 = entity.isResponseBodyEncoded() ? 1 : 0;
                statement.bindLong(27, (long)_tmp_1);
                if (entity.getResponseImageData() == null) {
                    statement.bindNull(28);
                } else {
                    statement.bindBlob(28, entity.getResponseImageData());
                }
                int _tmp_2 = entity.getGraphQlDetected() ? 1 : 0;
                statement.bindLong(29, (long)_tmp_2);
                if (entity.getGraphQlOperationName() == null) {
                    statement.bindNull(30);
                } else {
                    statement.bindString(30, entity.getGraphQlOperationName());
                }
                statement.bindLong(31, entity.getId());
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            @NonNull
            public String createQuery() {
                String _query = "DELETE FROM transactions";
                return "DELETE FROM transactions";
            }
        };
        this.__preparedStmtOfDeleteBefore = new SharedSQLiteStatement(__db){

            @NonNull
            public String createQuery() {
                String _query = "DELETE FROM transactions WHERE requestDate <= ?";
                return "DELETE FROM transactions WHERE requestDate <= ?";
            }
        };
    }

    @Override
    public Object insert(final HttpTransaction transaction, Continuation<? super Long> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Long>(){

            @Override
            @Nullable
            public Long call() throws Exception {
                HttpTransactionDao_Impl.this.__db.beginTransaction();
                try {
                    Long _result = HttpTransactionDao_Impl.this.__insertionAdapterOfHttpTransaction.insertAndReturnId((Object)transaction);
                    HttpTransactionDao_Impl.this.__db.setTransactionSuccessful();
                    Long l = _result;
                    return l;
                }
                finally {
                    HttpTransactionDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public Object update(final HttpTransaction transaction, Continuation<? super Integer> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Integer>(){

            @Override
            @NonNull
            public Integer call() throws Exception {
                int _total = 0;
                HttpTransactionDao_Impl.this.__db.beginTransaction();
                try {
                    HttpTransactionDao_Impl.this.__db.setTransactionSuccessful();
                    Integer n = _total += HttpTransactionDao_Impl.this.__updateAdapterOfHttpTransaction.handle((Object)transaction);
                    return n;
                }
                finally {
                    HttpTransactionDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public Object deleteAll(Continuation<? super Integer> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public Integer call() throws Exception {
                SupportSQLiteStatement _stmt = HttpTransactionDao_Impl.this.__preparedStmtOfDeleteAll.acquire();
                try {
                    Integer n;
                    HttpTransactionDao_Impl.this.__db.beginTransaction();
                    try {
                        Integer _result = _stmt.executeUpdateDelete();
                        HttpTransactionDao_Impl.this.__db.setTransactionSuccessful();
                        n = _result;
                    }
                    catch (Throwable throwable) {
                        HttpTransactionDao_Impl.this.__db.endTransaction();
                        throw throwable;
                    }
                    HttpTransactionDao_Impl.this.__db.endTransaction();
                    return n;
                }
                finally {
                    HttpTransactionDao_Impl.this.__preparedStmtOfDeleteAll.release(_stmt);
                }
            }
        }, $completion);
    }

    @Override
    public Object deleteBefore(final long threshold, Continuation<? super Integer> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public Integer call() throws Exception {
                SupportSQLiteStatement _stmt = HttpTransactionDao_Impl.this.__preparedStmtOfDeleteBefore.acquire();
                int _argIndex = 1;
                _stmt.bindLong(_argIndex, threshold);
                try {
                    Integer n;
                    HttpTransactionDao_Impl.this.__db.beginTransaction();
                    try {
                        Integer _result = _stmt.executeUpdateDelete();
                        HttpTransactionDao_Impl.this.__db.setTransactionSuccessful();
                        n = _result;
                    }
                    catch (Throwable throwable) {
                        HttpTransactionDao_Impl.this.__db.endTransaction();
                        throw throwable;
                    }
                    HttpTransactionDao_Impl.this.__db.endTransaction();
                    return n;
                }
                finally {
                    HttpTransactionDao_Impl.this.__preparedStmtOfDeleteBefore.release(_stmt);
                }
            }
        }, $completion);
    }

    @Override
    public LiveData<List<HttpTransactionTuple>> getSortedTuples() {
        String _sql = "SELECT id, requestDate, tookMs, protocol, method, host, path, scheme, responseCode, requestPayloadSize, responsePayloadSize, error, graphQLDetected, graphQlOperationName FROM transactions ORDER BY requestDate DESC";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT id, requestDate, tookMs, protocol, method, host, path, scheme, responseCode, requestPayloadSize, responsePayloadSize, error, graphQLDetected, graphQlOperationName FROM transactions ORDER BY requestDate DESC", (int)0);
        return this.__db.getInvalidationTracker().createLiveData(new String[]{"transactions"}, false, (Callable)new Callable<List<HttpTransactionTuple>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public List<HttpTransactionTuple> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)HttpTransactionDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    boolean _cursorIndexOfId = false;
                    boolean _cursorIndexOfRequestDate = true;
                    int _cursorIndexOfTookMs = 2;
                    int _cursorIndexOfProtocol = 3;
                    int _cursorIndexOfMethod = 4;
                    int _cursorIndexOfHost = 5;
                    int _cursorIndexOfPath = 6;
                    int _cursorIndexOfScheme = 7;
                    int _cursorIndexOfResponseCode = 8;
                    int _cursorIndexOfRequestPayloadSize = 9;
                    int _cursorIndexOfResponsePayloadSize = 10;
                    int _cursorIndexOfError = 11;
                    int _cursorIndexOfGraphQlDetected = 12;
                    int _cursorIndexOfGraphQlOperationName = 13;
                    ArrayList<HttpTransactionTuple> _result = new ArrayList<HttpTransactionTuple>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        long _tmpId = _cursor.getLong(0);
                        Long _tmpRequestDate = _cursor.isNull(1) ? null : Long.valueOf(_cursor.getLong(1));
                        Long _tmpTookMs = _cursor.isNull(2) ? null : Long.valueOf(_cursor.getLong(2));
                        String _tmpProtocol = _cursor.isNull(3) ? null : _cursor.getString(3);
                        String _tmpMethod = _cursor.isNull(4) ? null : _cursor.getString(4);
                        String _tmpHost = _cursor.isNull(5) ? null : _cursor.getString(5);
                        String _tmpPath = _cursor.isNull(6) ? null : _cursor.getString(6);
                        String _tmpScheme = _cursor.isNull(7) ? null : _cursor.getString(7);
                        Integer _tmpResponseCode = _cursor.isNull(8) ? null : Integer.valueOf(_cursor.getInt(8));
                        Long _tmpRequestPayloadSize = _cursor.isNull(9) ? null : Long.valueOf(_cursor.getLong(9));
                        Long _tmpResponsePayloadSize = _cursor.isNull(10) ? null : Long.valueOf(_cursor.getLong(10));
                        String _tmpError = _cursor.isNull(11) ? null : _cursor.getString(11);
                        int _tmp = _cursor.getInt(12);
                        boolean _tmpGraphQlDetected = _tmp != 0;
                        String _tmpGraphQlOperationName = _cursor.isNull(13) ? null : _cursor.getString(13);
                        HttpTransactionTuple _item = new HttpTransactionTuple(_tmpId, _tmpRequestDate, _tmpTookMs, _tmpProtocol, _tmpMethod, _tmpHost, _tmpPath, _tmpScheme, _tmpResponseCode, _tmpRequestPayloadSize, _tmpResponsePayloadSize, _tmpError, _tmpGraphQlDetected, _tmpGraphQlOperationName);
                        _result.add(_item);
                    }
                    ArrayList<HttpTransactionTuple> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public LiveData<List<HttpTransactionTuple>> getFilteredTuples(String codeQuery, String pathQuery, String graphQlQuery) {
        String _sql = "SELECT id, requestDate, tookMs, protocol, method, host, path, scheme, responseCode, requestPayloadSize, responsePayloadSize, error, graphQLDetected, graphQlOperationName FROM transactions WHERE responseCode LIKE ? AND (path LIKE ? OR graphQlOperationName LIKE ?) ORDER BY requestDate DESC";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT id, requestDate, tookMs, protocol, method, host, path, scheme, responseCode, requestPayloadSize, responsePayloadSize, error, graphQLDetected, graphQlOperationName FROM transactions WHERE responseCode LIKE ? AND (path LIKE ? OR graphQlOperationName LIKE ?) ORDER BY requestDate DESC", (int)3);
        int _argIndex = 1;
        _statement.bindString(_argIndex, codeQuery);
        _argIndex = 2;
        _statement.bindString(_argIndex, pathQuery);
        _argIndex = 3;
        _statement.bindString(_argIndex, graphQlQuery);
        return this.__db.getInvalidationTracker().createLiveData(new String[]{"transactions"}, false, (Callable)new Callable<List<HttpTransactionTuple>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public List<HttpTransactionTuple> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)HttpTransactionDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    boolean _cursorIndexOfId = false;
                    boolean _cursorIndexOfRequestDate = true;
                    int _cursorIndexOfTookMs = 2;
                    int _cursorIndexOfProtocol = 3;
                    int _cursorIndexOfMethod = 4;
                    int _cursorIndexOfHost = 5;
                    int _cursorIndexOfPath = 6;
                    int _cursorIndexOfScheme = 7;
                    int _cursorIndexOfResponseCode = 8;
                    int _cursorIndexOfRequestPayloadSize = 9;
                    int _cursorIndexOfResponsePayloadSize = 10;
                    int _cursorIndexOfError = 11;
                    int _cursorIndexOfGraphQlDetected = 12;
                    int _cursorIndexOfGraphQlOperationName = 13;
                    ArrayList<HttpTransactionTuple> _result = new ArrayList<HttpTransactionTuple>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        long _tmpId = _cursor.getLong(0);
                        Long _tmpRequestDate = _cursor.isNull(1) ? null : Long.valueOf(_cursor.getLong(1));
                        Long _tmpTookMs = _cursor.isNull(2) ? null : Long.valueOf(_cursor.getLong(2));
                        String _tmpProtocol = _cursor.isNull(3) ? null : _cursor.getString(3);
                        String _tmpMethod = _cursor.isNull(4) ? null : _cursor.getString(4);
                        String _tmpHost = _cursor.isNull(5) ? null : _cursor.getString(5);
                        String _tmpPath = _cursor.isNull(6) ? null : _cursor.getString(6);
                        String _tmpScheme = _cursor.isNull(7) ? null : _cursor.getString(7);
                        Integer _tmpResponseCode = _cursor.isNull(8) ? null : Integer.valueOf(_cursor.getInt(8));
                        Long _tmpRequestPayloadSize = _cursor.isNull(9) ? null : Long.valueOf(_cursor.getLong(9));
                        Long _tmpResponsePayloadSize = _cursor.isNull(10) ? null : Long.valueOf(_cursor.getLong(10));
                        String _tmpError = _cursor.isNull(11) ? null : _cursor.getString(11);
                        int _tmp = _cursor.getInt(12);
                        boolean _tmpGraphQlDetected = _tmp != 0;
                        String _tmpGraphQlOperationName = _cursor.isNull(13) ? null : _cursor.getString(13);
                        HttpTransactionTuple _item = new HttpTransactionTuple(_tmpId, _tmpRequestDate, _tmpTookMs, _tmpProtocol, _tmpMethod, _tmpHost, _tmpPath, _tmpScheme, _tmpResponseCode, _tmpRequestPayloadSize, _tmpResponsePayloadSize, _tmpError, _tmpGraphQlDetected, _tmpGraphQlOperationName);
                        _result.add(_item);
                    }
                    ArrayList<HttpTransactionTuple> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public LiveData<HttpTransaction> getById(long id2) {
        String _sql = "SELECT * FROM transactions WHERE id = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM transactions WHERE id = ?", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, id2);
        return this.__db.getInvalidationTracker().createLiveData(new String[]{"transactions"}, false, (Callable)new Callable<HttpTransaction>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public HttpTransaction call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)HttpTransactionDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    HttpTransaction _result;
                    int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                    int _cursorIndexOfRequestDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requestDate");
                    int _cursorIndexOfResponseDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"responseDate");
                    int _cursorIndexOfTookMs = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tookMs");
                    int _cursorIndexOfProtocol = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"protocol");
                    int _cursorIndexOfMethod = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"method");
                    int _cursorIndexOfUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"url");
                    int _cursorIndexOfHost = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"host");
                    int _cursorIndexOfPath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"path");
                    int _cursorIndexOfScheme = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scheme");
                    int _cursorIndexOfResponseTlsVersion = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"responseTlsVersion");
                    int _cursorIndexOfResponseCipherSuite = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"responseCipherSuite");
                    int _cursorIndexOfRequestPayloadSize = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requestPayloadSize");
                    int _cursorIndexOfRequestContentType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requestContentType");
                    int _cursorIndexOfRequestHeaders = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requestHeaders");
                    int _cursorIndexOfRequestHeadersSize = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requestHeadersSize");
                    int _cursorIndexOfRequestBody = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requestBody");
                    int _cursorIndexOfIsRequestBodyEncoded = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isRequestBodyEncoded");
                    int _cursorIndexOfResponseCode = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"responseCode");
                    int _cursorIndexOfResponseMessage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"responseMessage");
                    int _cursorIndexOfError = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"error");
                    int _cursorIndexOfResponsePayloadSize = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"responsePayloadSize");
                    int _cursorIndexOfResponseContentType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"responseContentType");
                    int _cursorIndexOfResponseHeaders = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"responseHeaders");
                    int _cursorIndexOfResponseHeadersSize = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"responseHeadersSize");
                    int _cursorIndexOfResponseBody = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"responseBody");
                    int _cursorIndexOfIsResponseBodyEncoded = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isResponseBodyEncoded");
                    int _cursorIndexOfResponseImageData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"responseImageData");
                    int _cursorIndexOfGraphQlDetected = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"graphQlDetected");
                    int _cursorIndexOfGraphQlOperationName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"graphQlOperationName");
                    if (_cursor.moveToFirst()) {
                        long _tmpId = _cursor.getLong(_cursorIndexOfId);
                        Long _tmpRequestDate = _cursor.isNull(_cursorIndexOfRequestDate) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfRequestDate));
                        Long _tmpResponseDate = _cursor.isNull(_cursorIndexOfResponseDate) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfResponseDate));
                        Long _tmpTookMs = _cursor.isNull(_cursorIndexOfTookMs) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfTookMs));
                        String _tmpProtocol = _cursor.isNull(_cursorIndexOfProtocol) ? null : _cursor.getString(_cursorIndexOfProtocol);
                        String _tmpMethod = _cursor.isNull(_cursorIndexOfMethod) ? null : _cursor.getString(_cursorIndexOfMethod);
                        String _tmpUrl = _cursor.isNull(_cursorIndexOfUrl) ? null : _cursor.getString(_cursorIndexOfUrl);
                        String _tmpHost = _cursor.isNull(_cursorIndexOfHost) ? null : _cursor.getString(_cursorIndexOfHost);
                        String _tmpPath = _cursor.isNull(_cursorIndexOfPath) ? null : _cursor.getString(_cursorIndexOfPath);
                        String _tmpScheme = _cursor.isNull(_cursorIndexOfScheme) ? null : _cursor.getString(_cursorIndexOfScheme);
                        String _tmpResponseTlsVersion = _cursor.isNull(_cursorIndexOfResponseTlsVersion) ? null : _cursor.getString(_cursorIndexOfResponseTlsVersion);
                        String _tmpResponseCipherSuite = _cursor.isNull(_cursorIndexOfResponseCipherSuite) ? null : _cursor.getString(_cursorIndexOfResponseCipherSuite);
                        Long _tmpRequestPayloadSize = _cursor.isNull(_cursorIndexOfRequestPayloadSize) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfRequestPayloadSize));
                        String _tmpRequestContentType = _cursor.isNull(_cursorIndexOfRequestContentType) ? null : _cursor.getString(_cursorIndexOfRequestContentType);
                        String _tmpRequestHeaders = _cursor.isNull(_cursorIndexOfRequestHeaders) ? null : _cursor.getString(_cursorIndexOfRequestHeaders);
                        Long _tmpRequestHeadersSize = _cursor.isNull(_cursorIndexOfRequestHeadersSize) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfRequestHeadersSize));
                        String _tmpRequestBody = _cursor.isNull(_cursorIndexOfRequestBody) ? null : _cursor.getString(_cursorIndexOfRequestBody);
                        int _tmp = _cursor.getInt(_cursorIndexOfIsRequestBodyEncoded);
                        boolean _tmpIsRequestBodyEncoded = _tmp != 0;
                        Integer _tmpResponseCode = _cursor.isNull(_cursorIndexOfResponseCode) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfResponseCode));
                        String _tmpResponseMessage = _cursor.isNull(_cursorIndexOfResponseMessage) ? null : _cursor.getString(_cursorIndexOfResponseMessage);
                        String _tmpError = _cursor.isNull(_cursorIndexOfError) ? null : _cursor.getString(_cursorIndexOfError);
                        Long _tmpResponsePayloadSize = _cursor.isNull(_cursorIndexOfResponsePayloadSize) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfResponsePayloadSize));
                        String _tmpResponseContentType = _cursor.isNull(_cursorIndexOfResponseContentType) ? null : _cursor.getString(_cursorIndexOfResponseContentType);
                        String _tmpResponseHeaders = _cursor.isNull(_cursorIndexOfResponseHeaders) ? null : _cursor.getString(_cursorIndexOfResponseHeaders);
                        Long _tmpResponseHeadersSize = _cursor.isNull(_cursorIndexOfResponseHeadersSize) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfResponseHeadersSize));
                        String _tmpResponseBody = _cursor.isNull(_cursorIndexOfResponseBody) ? null : _cursor.getString(_cursorIndexOfResponseBody);
                        int _tmp_1 = _cursor.getInt(_cursorIndexOfIsResponseBodyEncoded);
                        boolean _tmpIsResponseBodyEncoded = _tmp_1 != 0;
                        byte[] _tmpResponseImageData = _cursor.isNull(_cursorIndexOfResponseImageData) ? null : _cursor.getBlob(_cursorIndexOfResponseImageData);
                        int _tmp_2 = _cursor.getInt(_cursorIndexOfGraphQlDetected);
                        boolean _tmpGraphQlDetected = _tmp_2 != 0;
                        String _tmpGraphQlOperationName = _cursor.isNull(_cursorIndexOfGraphQlOperationName) ? null : _cursor.getString(_cursorIndexOfGraphQlOperationName);
                        _result = new HttpTransaction(_tmpId, _tmpRequestDate, _tmpResponseDate, _tmpTookMs, _tmpProtocol, _tmpMethod, _tmpUrl, _tmpHost, _tmpPath, _tmpScheme, _tmpResponseTlsVersion, _tmpResponseCipherSuite, _tmpRequestPayloadSize, _tmpRequestContentType, _tmpRequestHeaders, _tmpRequestHeadersSize, _tmpRequestBody, _tmpIsRequestBodyEncoded, _tmpResponseCode, _tmpResponseMessage, _tmpError, _tmpResponsePayloadSize, _tmpResponseContentType, _tmpResponseHeaders, _tmpResponseHeadersSize, _tmpResponseBody, _tmpIsResponseBodyEncoded, _tmpResponseImageData, _tmpGraphQlDetected, _tmpGraphQlOperationName);
                    } else {
                        _result = null;
                    }
                    HttpTransaction httpTransaction = _result;
                    return httpTransaction;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public Object getAll(Continuation<? super List<HttpTransaction>> $completion) {
        String _sql = "SELECT * FROM transactions";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM transactions", (int)0);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<HttpTransaction>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<HttpTransaction> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)HttpTransactionDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                    int _cursorIndexOfRequestDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requestDate");
                    int _cursorIndexOfResponseDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"responseDate");
                    int _cursorIndexOfTookMs = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tookMs");
                    int _cursorIndexOfProtocol = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"protocol");
                    int _cursorIndexOfMethod = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"method");
                    int _cursorIndexOfUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"url");
                    int _cursorIndexOfHost = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"host");
                    int _cursorIndexOfPath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"path");
                    int _cursorIndexOfScheme = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scheme");
                    int _cursorIndexOfResponseTlsVersion = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"responseTlsVersion");
                    int _cursorIndexOfResponseCipherSuite = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"responseCipherSuite");
                    int _cursorIndexOfRequestPayloadSize = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requestPayloadSize");
                    int _cursorIndexOfRequestContentType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requestContentType");
                    int _cursorIndexOfRequestHeaders = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requestHeaders");
                    int _cursorIndexOfRequestHeadersSize = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requestHeadersSize");
                    int _cursorIndexOfRequestBody = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requestBody");
                    int _cursorIndexOfIsRequestBodyEncoded = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isRequestBodyEncoded");
                    int _cursorIndexOfResponseCode = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"responseCode");
                    int _cursorIndexOfResponseMessage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"responseMessage");
                    int _cursorIndexOfError = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"error");
                    int _cursorIndexOfResponsePayloadSize = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"responsePayloadSize");
                    int _cursorIndexOfResponseContentType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"responseContentType");
                    int _cursorIndexOfResponseHeaders = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"responseHeaders");
                    int _cursorIndexOfResponseHeadersSize = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"responseHeadersSize");
                    int _cursorIndexOfResponseBody = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"responseBody");
                    int _cursorIndexOfIsResponseBodyEncoded = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isResponseBodyEncoded");
                    int _cursorIndexOfResponseImageData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"responseImageData");
                    int _cursorIndexOfGraphQlDetected = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"graphQlDetected");
                    int _cursorIndexOfGraphQlOperationName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"graphQlOperationName");
                    ArrayList<HttpTransaction> _result = new ArrayList<HttpTransaction>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        long _tmpId = _cursor.getLong(_cursorIndexOfId);
                        Long _tmpRequestDate = _cursor.isNull(_cursorIndexOfRequestDate) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfRequestDate));
                        Long _tmpResponseDate = _cursor.isNull(_cursorIndexOfResponseDate) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfResponseDate));
                        Long _tmpTookMs = _cursor.isNull(_cursorIndexOfTookMs) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfTookMs));
                        String _tmpProtocol = _cursor.isNull(_cursorIndexOfProtocol) ? null : _cursor.getString(_cursorIndexOfProtocol);
                        String _tmpMethod = _cursor.isNull(_cursorIndexOfMethod) ? null : _cursor.getString(_cursorIndexOfMethod);
                        String _tmpUrl = _cursor.isNull(_cursorIndexOfUrl) ? null : _cursor.getString(_cursorIndexOfUrl);
                        String _tmpHost = _cursor.isNull(_cursorIndexOfHost) ? null : _cursor.getString(_cursorIndexOfHost);
                        String _tmpPath = _cursor.isNull(_cursorIndexOfPath) ? null : _cursor.getString(_cursorIndexOfPath);
                        String _tmpScheme = _cursor.isNull(_cursorIndexOfScheme) ? null : _cursor.getString(_cursorIndexOfScheme);
                        String _tmpResponseTlsVersion = _cursor.isNull(_cursorIndexOfResponseTlsVersion) ? null : _cursor.getString(_cursorIndexOfResponseTlsVersion);
                        String _tmpResponseCipherSuite = _cursor.isNull(_cursorIndexOfResponseCipherSuite) ? null : _cursor.getString(_cursorIndexOfResponseCipherSuite);
                        Long _tmpRequestPayloadSize = _cursor.isNull(_cursorIndexOfRequestPayloadSize) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfRequestPayloadSize));
                        String _tmpRequestContentType = _cursor.isNull(_cursorIndexOfRequestContentType) ? null : _cursor.getString(_cursorIndexOfRequestContentType);
                        String _tmpRequestHeaders = _cursor.isNull(_cursorIndexOfRequestHeaders) ? null : _cursor.getString(_cursorIndexOfRequestHeaders);
                        Long _tmpRequestHeadersSize = _cursor.isNull(_cursorIndexOfRequestHeadersSize) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfRequestHeadersSize));
                        String _tmpRequestBody = _cursor.isNull(_cursorIndexOfRequestBody) ? null : _cursor.getString(_cursorIndexOfRequestBody);
                        int _tmp = _cursor.getInt(_cursorIndexOfIsRequestBodyEncoded);
                        boolean _tmpIsRequestBodyEncoded = _tmp != 0;
                        Integer _tmpResponseCode = _cursor.isNull(_cursorIndexOfResponseCode) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfResponseCode));
                        String _tmpResponseMessage = _cursor.isNull(_cursorIndexOfResponseMessage) ? null : _cursor.getString(_cursorIndexOfResponseMessage);
                        String _tmpError = _cursor.isNull(_cursorIndexOfError) ? null : _cursor.getString(_cursorIndexOfError);
                        Long _tmpResponsePayloadSize = _cursor.isNull(_cursorIndexOfResponsePayloadSize) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfResponsePayloadSize));
                        String _tmpResponseContentType = _cursor.isNull(_cursorIndexOfResponseContentType) ? null : _cursor.getString(_cursorIndexOfResponseContentType);
                        String _tmpResponseHeaders = _cursor.isNull(_cursorIndexOfResponseHeaders) ? null : _cursor.getString(_cursorIndexOfResponseHeaders);
                        Long _tmpResponseHeadersSize = _cursor.isNull(_cursorIndexOfResponseHeadersSize) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfResponseHeadersSize));
                        String _tmpResponseBody = _cursor.isNull(_cursorIndexOfResponseBody) ? null : _cursor.getString(_cursorIndexOfResponseBody);
                        int _tmp_1 = _cursor.getInt(_cursorIndexOfIsResponseBodyEncoded);
                        boolean _tmpIsResponseBodyEncoded = _tmp_1 != 0;
                        byte[] _tmpResponseImageData = _cursor.isNull(_cursorIndexOfResponseImageData) ? null : _cursor.getBlob(_cursorIndexOfResponseImageData);
                        int _tmp_2 = _cursor.getInt(_cursorIndexOfGraphQlDetected);
                        boolean _tmpGraphQlDetected = _tmp_2 != 0;
                        String _tmpGraphQlOperationName = _cursor.isNull(_cursorIndexOfGraphQlOperationName) ? null : _cursor.getString(_cursorIndexOfGraphQlOperationName);
                        HttpTransaction _item = new HttpTransaction(_tmpId, _tmpRequestDate, _tmpResponseDate, _tmpTookMs, _tmpProtocol, _tmpMethod, _tmpUrl, _tmpHost, _tmpPath, _tmpScheme, _tmpResponseTlsVersion, _tmpResponseCipherSuite, _tmpRequestPayloadSize, _tmpRequestContentType, _tmpRequestHeaders, _tmpRequestHeadersSize, _tmpRequestBody, _tmpIsRequestBodyEncoded, _tmpResponseCode, _tmpResponseMessage, _tmpError, _tmpResponsePayloadSize, _tmpResponseContentType, _tmpResponseHeaders, _tmpResponseHeadersSize, _tmpResponseBody, _tmpIsResponseBodyEncoded, _tmpResponseImageData, _tmpGraphQlDetected, _tmpGraphQlOperationName);
                        _result.add(_item);
                    }
                    ArrayList<HttpTransaction> arrayList = _result;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<HttpTransaction> getTransactionsInTimeRange(long timestamp) {
        String _sql = "SELECT * FROM transactions WHERE requestDate >= ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM transactions WHERE requestDate >= ?", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, timestamp);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
            int _cursorIndexOfRequestDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requestDate");
            int _cursorIndexOfResponseDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"responseDate");
            int _cursorIndexOfTookMs = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tookMs");
            int _cursorIndexOfProtocol = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"protocol");
            int _cursorIndexOfMethod = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"method");
            int _cursorIndexOfUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"url");
            int _cursorIndexOfHost = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"host");
            int _cursorIndexOfPath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"path");
            int _cursorIndexOfScheme = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scheme");
            int _cursorIndexOfResponseTlsVersion = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"responseTlsVersion");
            int _cursorIndexOfResponseCipherSuite = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"responseCipherSuite");
            int _cursorIndexOfRequestPayloadSize = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requestPayloadSize");
            int _cursorIndexOfRequestContentType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requestContentType");
            int _cursorIndexOfRequestHeaders = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requestHeaders");
            int _cursorIndexOfRequestHeadersSize = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requestHeadersSize");
            int _cursorIndexOfRequestBody = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requestBody");
            int _cursorIndexOfIsRequestBodyEncoded = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isRequestBodyEncoded");
            int _cursorIndexOfResponseCode = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"responseCode");
            int _cursorIndexOfResponseMessage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"responseMessage");
            int _cursorIndexOfError = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"error");
            int _cursorIndexOfResponsePayloadSize = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"responsePayloadSize");
            int _cursorIndexOfResponseContentType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"responseContentType");
            int _cursorIndexOfResponseHeaders = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"responseHeaders");
            int _cursorIndexOfResponseHeadersSize = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"responseHeadersSize");
            int _cursorIndexOfResponseBody = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"responseBody");
            int _cursorIndexOfIsResponseBodyEncoded = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isResponseBodyEncoded");
            int _cursorIndexOfResponseImageData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"responseImageData");
            int _cursorIndexOfGraphQlDetected = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"graphQlDetected");
            int _cursorIndexOfGraphQlOperationName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"graphQlOperationName");
            ArrayList<HttpTransaction> _result = new ArrayList<HttpTransaction>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                long _tmpId = _cursor.getLong(_cursorIndexOfId);
                Long _tmpRequestDate = _cursor.isNull(_cursorIndexOfRequestDate) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfRequestDate));
                Long _tmpResponseDate = _cursor.isNull(_cursorIndexOfResponseDate) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfResponseDate));
                Long _tmpTookMs = _cursor.isNull(_cursorIndexOfTookMs) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfTookMs));
                String _tmpProtocol = _cursor.isNull(_cursorIndexOfProtocol) ? null : _cursor.getString(_cursorIndexOfProtocol);
                String _tmpMethod = _cursor.isNull(_cursorIndexOfMethod) ? null : _cursor.getString(_cursorIndexOfMethod);
                String _tmpUrl = _cursor.isNull(_cursorIndexOfUrl) ? null : _cursor.getString(_cursorIndexOfUrl);
                String _tmpHost = _cursor.isNull(_cursorIndexOfHost) ? null : _cursor.getString(_cursorIndexOfHost);
                String _tmpPath = _cursor.isNull(_cursorIndexOfPath) ? null : _cursor.getString(_cursorIndexOfPath);
                String _tmpScheme = _cursor.isNull(_cursorIndexOfScheme) ? null : _cursor.getString(_cursorIndexOfScheme);
                String _tmpResponseTlsVersion = _cursor.isNull(_cursorIndexOfResponseTlsVersion) ? null : _cursor.getString(_cursorIndexOfResponseTlsVersion);
                String _tmpResponseCipherSuite = _cursor.isNull(_cursorIndexOfResponseCipherSuite) ? null : _cursor.getString(_cursorIndexOfResponseCipherSuite);
                Long _tmpRequestPayloadSize = _cursor.isNull(_cursorIndexOfRequestPayloadSize) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfRequestPayloadSize));
                String _tmpRequestContentType = _cursor.isNull(_cursorIndexOfRequestContentType) ? null : _cursor.getString(_cursorIndexOfRequestContentType);
                String _tmpRequestHeaders = _cursor.isNull(_cursorIndexOfRequestHeaders) ? null : _cursor.getString(_cursorIndexOfRequestHeaders);
                Long _tmpRequestHeadersSize = _cursor.isNull(_cursorIndexOfRequestHeadersSize) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfRequestHeadersSize));
                String _tmpRequestBody = _cursor.isNull(_cursorIndexOfRequestBody) ? null : _cursor.getString(_cursorIndexOfRequestBody);
                int _tmp = _cursor.getInt(_cursorIndexOfIsRequestBodyEncoded);
                boolean _tmpIsRequestBodyEncoded = _tmp != 0;
                Integer _tmpResponseCode = _cursor.isNull(_cursorIndexOfResponseCode) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfResponseCode));
                String _tmpResponseMessage = _cursor.isNull(_cursorIndexOfResponseMessage) ? null : _cursor.getString(_cursorIndexOfResponseMessage);
                String _tmpError = _cursor.isNull(_cursorIndexOfError) ? null : _cursor.getString(_cursorIndexOfError);
                Long _tmpResponsePayloadSize = _cursor.isNull(_cursorIndexOfResponsePayloadSize) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfResponsePayloadSize));
                String _tmpResponseContentType = _cursor.isNull(_cursorIndexOfResponseContentType) ? null : _cursor.getString(_cursorIndexOfResponseContentType);
                String _tmpResponseHeaders = _cursor.isNull(_cursorIndexOfResponseHeaders) ? null : _cursor.getString(_cursorIndexOfResponseHeaders);
                Long _tmpResponseHeadersSize = _cursor.isNull(_cursorIndexOfResponseHeadersSize) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfResponseHeadersSize));
                String _tmpResponseBody = _cursor.isNull(_cursorIndexOfResponseBody) ? null : _cursor.getString(_cursorIndexOfResponseBody);
                int _tmp_1 = _cursor.getInt(_cursorIndexOfIsResponseBodyEncoded);
                boolean _tmpIsResponseBodyEncoded = _tmp_1 != 0;
                byte[] _tmpResponseImageData = _cursor.isNull(_cursorIndexOfResponseImageData) ? null : _cursor.getBlob(_cursorIndexOfResponseImageData);
                int _tmp_2 = _cursor.getInt(_cursorIndexOfGraphQlDetected);
                boolean _tmpGraphQlDetected = _tmp_2 != 0;
                String _tmpGraphQlOperationName = _cursor.isNull(_cursorIndexOfGraphQlOperationName) ? null : _cursor.getString(_cursorIndexOfGraphQlOperationName);
                HttpTransaction _item = new HttpTransaction(_tmpId, _tmpRequestDate, _tmpResponseDate, _tmpTookMs, _tmpProtocol, _tmpMethod, _tmpUrl, _tmpHost, _tmpPath, _tmpScheme, _tmpResponseTlsVersion, _tmpResponseCipherSuite, _tmpRequestPayloadSize, _tmpRequestContentType, _tmpRequestHeaders, _tmpRequestHeadersSize, _tmpRequestBody, _tmpIsRequestBodyEncoded, _tmpResponseCode, _tmpResponseMessage, _tmpError, _tmpResponsePayloadSize, _tmpResponseContentType, _tmpResponseHeaders, _tmpResponseHeadersSize, _tmpResponseBody, _tmpIsResponseBodyEncoded, _tmpResponseImageData, _tmpGraphQlDetected, _tmpGraphQlOperationName);
                _result.add(_item);
            }
            ArrayList<HttpTransaction> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

