/*
 * Decompiled with CFR 0.152.
 */
package com.chuckerteam.chucker.internal.ui.transaction;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentViewModelLazyKt;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStore;
import androidx.lifecycle.viewmodel.CreationExtras;
import com.chuckerteam.chucker.R;
import com.chuckerteam.chucker.databinding.ChuckerFragmentTransactionOverviewBinding;
import com.chuckerteam.chucker.internal.data.entity.HttpTransaction;
import com.chuckerteam.chucker.internal.support.LiveDataUtilsKt;
import com.chuckerteam.chucker.internal.ui.transaction.TransactionOverviewFragment;
import com.chuckerteam.chucker.internal.ui.transaction.TransactionViewModel;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J&\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0012\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u001a\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u00152\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u001a\u0010\u001b\u001a\u00020\f2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\b\u00a8\u0006 "}, d2={"Lcom/chuckerteam/chucker/internal/ui/transaction/TransactionOverviewFragment;", "Landroidx/fragment/app/Fragment;", "()V", "overviewBinding", "Lcom/chuckerteam/chucker/databinding/ChuckerFragmentTransactionOverviewBinding;", "viewModel", "Lcom/chuckerteam/chucker/internal/ui/transaction/TransactionViewModel;", "getViewModel", "()Lcom/chuckerteam/chucker/internal/ui/transaction/TransactionViewModel;", "viewModel$delegate", "Lkotlin/Lazy;", "onCreate", "", "savedInstanceState", "Landroid/os/Bundle;", "onCreateOptionsMenu", "menu", "Landroid/view/Menu;", "inflater", "Landroid/view/MenuInflater;", "onCreateView", "Landroid/view/View;", "Landroid/view/LayoutInflater;", "container", "Landroid/view/ViewGroup;", "onViewCreated", "view", "populateUI", "transaction", "Lcom/chuckerteam/chucker/internal/data/entity/HttpTransaction;", "encodeUrl", "", "com.github.ChuckerTeam.Chucker.library"})
@SourceDebugExtension(value={"SMAP\nTransactionOverviewFragment.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TransactionOverviewFragment.kt\ncom/chuckerteam/chucker/internal/ui/transaction/TransactionOverviewFragment\n+ 2 FragmentViewModelLazy.kt\nandroidx/fragment/app/FragmentViewModelLazyKt\n*L\n1#1,93:1\n172#2,9:94\n*S KotlinDebug\n*F\n+ 1 TransactionOverviewFragment.kt\ncom/chuckerteam/chucker/internal/ui/transaction/TransactionOverviewFragment\n*L\n19#1:94,9\n*E\n"})
public final class TransactionOverviewFragment
extends Fragment {
    @NotNull
    private final Lazy viewModel$delegate;
    private ChuckerFragmentTransactionOverviewBinding overviewBinding;

    /*
     * WARNING - void declaration
     */
    public TransactionOverviewFragment() {
        void $this$activityViewModels_u24default$iv;
        Fragment fragment = this;
        Function0 factoryProducer$iv = viewModel.2.INSTANCE;
        Function0 extrasProducer$iv = null;
        boolean $i$f$activityViewModels = false;
        KClass kClass = Reflection.getOrCreateKotlinClass(TransactionViewModel.class);
        Function0 function0 = (Function0)new Function0<ViewModelStore>((Fragment)$this$activityViewModels_u24default$iv){
            final /* synthetic */ Fragment $this_activityViewModels;
            {
                this.$this_activityViewModels = $receiver;
                super(0);
            }

            @NotNull
            public final ViewModelStore invoke() {
                ViewModelStore viewModelStore = this.$this_activityViewModels.requireActivity().getViewModelStore();
                Intrinsics.checkNotNullExpressionValue((Object)viewModelStore, (String)"requireActivity().viewModelStore");
                return viewModelStore;
            }
        };
        Function0 function02 = (Function0)new Function0<CreationExtras>(extrasProducer$iv, (Fragment)$this$activityViewModels_u24default$iv){
            final /* synthetic */ Function0 $extrasProducer;
            final /* synthetic */ Fragment $this_activityViewModels;
            {
                this.$extrasProducer = $extrasProducer;
                this.$this_activityViewModels = $receiver;
                super(0);
            }

            @NotNull
            public final CreationExtras invoke() {
                Function0 function0 = this.$extrasProducer;
                if (function0 == null || (function0 = (CreationExtras)function0.invoke()) == null) {
                    CreationExtras creationExtras = this.$this_activityViewModels.requireActivity().getDefaultViewModelCreationExtras();
                    function0 = creationExtras;
                    Intrinsics.checkNotNullExpressionValue((Object)creationExtras, (String)"requireActivity().defaultViewModelCreationExtras");
                }
                return function0;
            }
        };
        Function0 function03 = factoryProducer$iv;
        if (function03 == null) {
            function03 = (Function0)new Function0<ViewModelProvider.Factory>((Fragment)$this$activityViewModels_u24default$iv){
                final /* synthetic */ Fragment $this_activityViewModels;
                {
                    this.$this_activityViewModels = $receiver;
                    super(0);
                }

                @NotNull
                public final ViewModelProvider.Factory invoke() {
                    ViewModelProvider.Factory factory = this.$this_activityViewModels.requireActivity().getDefaultViewModelProviderFactory();
                    Intrinsics.checkNotNullExpressionValue((Object)factory, (String)"requireActivity().defaultViewModelProviderFactory");
                    return factory;
                }
            };
        }
        this.viewModel$delegate = FragmentViewModelLazyKt.createViewModelLazy((Fragment)$this$activityViewModels_u24default$iv, (KClass)kClass, (Function0)function0, (Function0)function02, (Function0)function03);
    }

    private final TransactionViewModel getViewModel() {
        Lazy lazy = this.viewModel$delegate;
        return (TransactionViewModel)((Object)lazy.getValue());
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setHasOptionsMenu(true);
    }

    @Nullable
    public View onCreateView(@NotNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        Intrinsics.checkNotNullParameter((Object)inflater, (String)"inflater");
        ChuckerFragmentTransactionOverviewBinding chuckerFragmentTransactionOverviewBinding = ChuckerFragmentTransactionOverviewBinding.inflate(inflater, container, false);
        Intrinsics.checkNotNullExpressionValue((Object)chuckerFragmentTransactionOverviewBinding, (String)"inflate(inflater, container, false)");
        this.overviewBinding = chuckerFragmentTransactionOverviewBinding;
        ChuckerFragmentTransactionOverviewBinding chuckerFragmentTransactionOverviewBinding2 = this.overviewBinding;
        if (chuckerFragmentTransactionOverviewBinding2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"overviewBinding");
            chuckerFragmentTransactionOverviewBinding2 = null;
        }
        return (View)chuckerFragmentTransactionOverviewBinding2.getRoot();
    }

    public void onCreateOptionsMenu(@NotNull Menu menu2, @NotNull MenuInflater inflater) {
        Intrinsics.checkNotNullParameter((Object)menu2, (String)"menu");
        Intrinsics.checkNotNullParameter((Object)inflater, (String)"inflater");
        menu2.findItem(R.id.save_body).setVisible(false);
        this.getViewModel().getDoesUrlRequireEncoding().observe(this.getViewLifecycleOwner(), arg_0 -> TransactionOverviewFragment.onCreateOptionsMenu$lambda$0(menu2, arg_0));
        super.onCreateOptionsMenu(menu2, inflater);
    }

    public void onViewCreated(@NotNull View view, @Nullable Bundle savedInstanceState) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        super.onViewCreated(view, savedInstanceState);
        LiveDataUtilsKt.combineLatest(this.getViewModel().getTransaction(), this.getViewModel().getEncodeUrl()).observe(this.getViewLifecycleOwner(), arg_0 -> TransactionOverviewFragment.onViewCreated$lambda$1(this, arg_0));
    }

    private final void populateUI(HttpTransaction transaction, boolean encodeUrl) {
        Boolean bl;
        ChuckerFragmentTransactionOverviewBinding chuckerFragmentTransactionOverviewBinding = this.overviewBinding;
        if (chuckerFragmentTransactionOverviewBinding == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"overviewBinding");
            chuckerFragmentTransactionOverviewBinding = null;
        }
        ChuckerFragmentTransactionOverviewBinding $this$populateUI_u24lambda_u242 = chuckerFragmentTransactionOverviewBinding;
        boolean bl2 = false;
        HttpTransaction httpTransaction = transaction;
        $this$populateUI_u24lambda_u242.url.setText((CharSequence)(httpTransaction != null ? httpTransaction.getFormattedUrl(encodeUrl) : null));
        HttpTransaction httpTransaction2 = transaction;
        $this$populateUI_u24lambda_u242.method.setText((CharSequence)(httpTransaction2 != null ? httpTransaction2.getMethod() : null));
        HttpTransaction httpTransaction3 = transaction;
        $this$populateUI_u24lambda_u242.protocol.setText((CharSequence)(httpTransaction3 != null ? httpTransaction3.getProtocol() : null));
        HttpTransaction httpTransaction4 = transaction;
        $this$populateUI_u24lambda_u242.status.setText((CharSequence)String.valueOf((Object)(httpTransaction4 != null ? httpTransaction4.getStatus() : null)));
        HttpTransaction httpTransaction5 = transaction;
        $this$populateUI_u24lambda_u242.response.setText((CharSequence)(httpTransaction5 != null ? httpTransaction5.getResponseSummaryText() : null));
        HttpTransaction httpTransaction6 = transaction;
        Boolean bl3 = bl = httpTransaction6 != null ? Boolean.valueOf(httpTransaction6.isSsl()) : null;
        if (bl == null) {
            $this$populateUI_u24lambda_u242.sslGroup.setVisibility(8);
        } else if (Intrinsics.areEqual((Object)bl, (Object)true)) {
            $this$populateUI_u24lambda_u242.sslGroup.setVisibility(0);
            $this$populateUI_u24lambda_u242.sslValue.setText(R.string.chucker_yes);
        } else {
            $this$populateUI_u24lambda_u242.sslGroup.setVisibility(0);
            $this$populateUI_u24lambda_u242.sslValue.setText(R.string.chucker_no);
        }
        HttpTransaction httpTransaction7 = transaction;
        if ((httpTransaction7 != null ? httpTransaction7.getResponseTlsVersion() : null) != null) {
            $this$populateUI_u24lambda_u242.tlsVersionValue.setText((CharSequence)transaction.getResponseTlsVersion());
            $this$populateUI_u24lambda_u242.tlsGroup.setVisibility(0);
        }
        HttpTransaction httpTransaction8 = transaction;
        if ((httpTransaction8 != null ? httpTransaction8.getResponseCipherSuite() : null) != null) {
            $this$populateUI_u24lambda_u242.cipherSuiteValue.setText((CharSequence)transaction.getResponseCipherSuite());
            $this$populateUI_u24lambda_u242.cipherSuiteGroup.setVisibility(0);
        }
        HttpTransaction httpTransaction9 = transaction;
        $this$populateUI_u24lambda_u242.requestTime.setText((CharSequence)(httpTransaction9 != null ? httpTransaction9.getRequestDateString() : null));
        HttpTransaction httpTransaction10 = transaction;
        $this$populateUI_u24lambda_u242.responseTime.setText((CharSequence)(httpTransaction10 != null ? httpTransaction10.getResponseDateString() : null));
        HttpTransaction httpTransaction11 = transaction;
        $this$populateUI_u24lambda_u242.duration.setText((CharSequence)(httpTransaction11 != null ? httpTransaction11.getDurationString() : null));
        HttpTransaction httpTransaction12 = transaction;
        $this$populateUI_u24lambda_u242.requestSize.setText((CharSequence)(httpTransaction12 != null ? httpTransaction12.getRequestSizeString() : null));
        HttpTransaction httpTransaction13 = transaction;
        $this$populateUI_u24lambda_u242.responseSize.setText((CharSequence)(httpTransaction13 != null ? httpTransaction13.getResponseSizeString() : null));
        HttpTransaction httpTransaction14 = transaction;
        $this$populateUI_u24lambda_u242.totalSize.setText((CharSequence)(httpTransaction14 != null ? httpTransaction14.getTotalSizeString() : null));
    }

    private static final void onCreateOptionsMenu$lambda$0(Menu $menu, Boolean it) {
        Intrinsics.checkNotNullParameter((Object)$menu, (String)"$menu");
        MenuItem menuItem = $menu.findItem(R.id.encode_url);
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        menuItem.setVisible(it.booleanValue());
    }

    private static final void onViewCreated$lambda$1(TransactionOverviewFragment this$0, Pair pair) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        HttpTransaction transaction = (HttpTransaction)pair.component1();
        boolean encodeUrl = (Boolean)pair.component2();
        this$0.populateUI(transaction, encodeUrl);
    }
}

