/*
 * Decompiled with CFR 0.152.
 */
package com.chuckerteam.chucker.internal.support;

import com.chuckerteam.chucker.internal.support.Logger;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u0006J\u0018\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/chuckerteam/chucker/internal/support/FileFactory;", "", "()V", "uniqueIdGenerator", "Ljava/util/concurrent/atomic/AtomicLong;", "create", "Ljava/io/File;", "directory", "fileName", "", "com.github.ChuckerTeam.Chucker.library"})
public final class FileFactory {
    @NotNull
    public static final FileFactory INSTANCE = new FileFactory();
    @NotNull
    private static final AtomicLong uniqueIdGenerator = new AtomicLong();

    private FileFactory() {
    }

    @Nullable
    public final File create(@NotNull File directory) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        return this.create(directory, "chucker-" + uniqueIdGenerator.getAndIncrement());
    }

    @Nullable
    public final File create(@NotNull File directory, @NotNull String fileName) {
        File file;
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        try {
            File $this$create_u24lambda_u240 = file = new File(directory, fileName);
            boolean bl = false;
            if ($this$create_u24lambda_u240.exists() && !$this$create_u24lambda_u240.delete()) {
                throw new IOException("Failed to delete file " + $this$create_u24lambda_u240);
            }
            File file2 = $this$create_u24lambda_u240.getParentFile();
            if (file2 != null) {
                file2.mkdirs();
            }
            if (!$this$create_u24lambda_u240.createNewFile()) {
                throw new IOException("File " + $this$create_u24lambda_u240 + " already exists");
            }
        }
        catch (IOException e) {
            Logger.Companion.error("An error occurred while creating a file", e);
            file = null;
        }
        return file;
    }
}

