/*
 * Decompiled with CFR 0.152.
 */
package com.github.chuanzh.util;

import com.github.chuanzh.enums.RequestMode;
import com.github.chuanzh.po.ControllerInfo;
import com.github.chuanzh.po.MethodInfo;
import com.github.chuanzh.po.Request;
import com.github.chuanzh.util.ClassHelperUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.File;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;

public class ControllerInfoBuilder {
    private static Logger logger = LoggerFactory.getLogger(ControllerInfoBuilder.class);

    public List<ControllerInfo> handle(String packageName, List<String> includes) {
        ArrayList<ControllerInfo> resultList = new ArrayList<ControllerInfo>();
        try {
            List<String> classNames = this.getClassName(packageName);
            for (String className : classNames) {
                if (includes.size() > 0 && !includes.contains(className.substring(className.lastIndexOf(".") + 1))) continue;
                ControllerInfo controllerInfo = new ControllerInfo();
                Class<?> clazz = Class.forName(className);
                if (clazz.getAnnotation(Api.class) != null) {
                    controllerInfo.setDesc(clazz.getAnnotation(Api.class).tags()[0]);
                } else {
                    controllerInfo.setDesc(clazz.getSimpleName());
                }
                controllerInfo.setMethodInfoList(this.getMethodInfoByClass(clazz));
                resultList.add(controllerInfo);
            }
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6control\u7c7b\u5931\u8d25", (Throwable)e);
        }
        return resultList;
    }

    private List<String> getClassName(String packageName) {
        List<String> classNames = null;
        String filePath = ClassLoader.getSystemResource("").getPath() + packageName.replace(".", "/");
        classNames = this.getClassName(filePath, null);
        return classNames;
    }

    private List<String> getClassName(String filePath, List<String> classNameList) {
        File[] childFiles;
        filePath = filePath.replace("\\", "/");
        ArrayList<String> myClassName = new ArrayList<String>();
        File file = new File(filePath);
        for (File childFile : childFiles = file.listFiles()) {
            if (childFile.isDirectory()) {
                myClassName.addAll(this.getClassName(childFile.getPath(), myClassName));
                continue;
            }
            String childFilePath = childFile.getPath();
            childFilePath = !childFilePath.startsWith("/") ? childFilePath.substring(childFilePath.indexOf("\\classes") + 9, childFilePath.lastIndexOf(".")) : childFilePath.substring(childFilePath.indexOf("/classes") + 9, childFilePath.lastIndexOf("."));
            childFilePath = childFilePath.replace("\\", ".").replace("/", ".");
            String lastString = childFilePath.substring(childFilePath.length() - 1, childFilePath.length());
            if (childFilePath.indexOf(".svn") >= 0 || ".".equals(lastString)) continue;
            myClassName.add(childFilePath);
        }
        return myClassName;
    }

    private List<MethodInfo> getMethodInfoByClass(Class clazz) {
        Method[] methods;
        String classRequestMapping = "";
        if (clazz.getAnnotation(RequestMapping.class) != null) {
            classRequestMapping = clazz.getAnnotation(RequestMapping.class).value()[0];
        }
        ArrayList<MethodInfo> methodInfoList = new ArrayList<MethodInfo>();
        for (Method method : methods = clazz.getDeclaredMethods()) {
            MethodInfo methodInfo = new MethodInfo();
            methodInfo.setRequestUrl(classRequestMapping + this.getRequestUrl(method));
            methodInfo.setRequestType(this.getRequestType(method));
            if (method.getAnnotation(ApiOperation.class) != null) {
                methodInfo.setDesc(method.getAnnotation(ApiOperation.class).value());
            }
            Parameter[] parameters = method.getParameters();
            ArrayList<Request> requests = new ArrayList<Request>();
            Request request = null;
            for (Parameter parameter : parameters) {
                if (ClassHelperUtils.isBaseType(parameter.getParameterizedType()) || ClassHelperUtils.isListBaseType(parameter.getParameterizedType())) {
                    request = new Request();
                    request.setName(parameter.getName());
                    request.setType(parameter.getType().getSimpleName());
                    request.setIsNotNull(1);
                    if (parameter.getAnnotation(ApiParam.class) != null) {
                        ApiParam apiParam = parameter.getAnnotation(ApiParam.class);
                        request.setDesc(apiParam.value());
                    }
                    requests.add(request);
                    continue;
                }
                methodInfo.setRequestBeanName(parameter.getParameterizedType().getTypeName());
            }
            if (requests.size() > 0) {
                methodInfo.setRequests(requests);
            }
            methodInfo.setResponseBeanName(method.getGenericReturnType().getTypeName());
            methodInfoList.add(methodInfo);
        }
        return methodInfoList;
    }

    private String getRequestUrl(Method method) {
        if (method.getAnnotation(PostMapping.class) != null) {
            return method.getAnnotation(PostMapping.class).value()[0];
        }
        if (method.getAnnotation(GetMapping.class) != null) {
            return method.getAnnotation(GetMapping.class).value()[0];
        }
        if (method.getAnnotation(RequestMapping.class) != null) {
            return method.getAnnotation(RequestMapping.class).value()[0];
        }
        return "";
    }

    private String getRequestType(Method method) {
        if (method.getAnnotation(PostMapping.class) != null) {
            return RequestMode.POST.name();
        }
        if (method.getAnnotation(GetMapping.class) != null) {
            return RequestMode.GET.name();
        }
        if (method.getAnnotation(RequestMapping.class) != null) {
            return RequestMode.GET_OR_POST.name();
        }
        return "";
    }
}

