/*
 * Decompiled with CFR 0.152.
 */
package com.github.chuanzh.engine;

import com.github.chuanzh.config.GlobalConfig;
import com.github.chuanzh.engine.AbstractTemplateEngine;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FreemarkerTemplateEngine
extends AbstractTemplateEngine {
    private static final Logger logger = LoggerFactory.getLogger(FreemarkerTemplateEngine.class);
    private static Configuration cfg = new Configuration();
    private Template temp = null;
    private static String encode = "UTF-8";
    private GlobalConfig globalConfig;

    public FreemarkerTemplateEngine() {
        this.init();
    }

    @Override
    public AbstractTemplateEngine init() {
        cfg.setClassForTemplateLoading(FreemarkerTemplateEngine.class, "/");
        cfg.setDefaultEncoding(encode);
        try {
            this.temp = cfg.getTemplate("/templates/markdown.ftl");
        }
        catch (IOException e) {
            logger.error("\u521d\u59cb\u5316\u6a21\u677f\u5931\u8d25", (Throwable)e);
        }
        return this;
    }

    @Override
    public AbstractTemplateEngine process(Map<String, Object> param) {
        StringWriter sw = new StringWriter();
        try {
            this.temp.process(param, (Writer)sw);
        }
        catch (Exception e) {
            logger.error("\u5904\u7406\u6a21\u677f\u4fe1\u606f\u5931\u8d25", (Throwable)e);
        }
        this.writeToFile(sw, param.get("path").toString());
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToFile(StringWriter sw, String filePath) {
        OutputStreamWriter fw = null;
        try {
            File file = new File(filePath);
            if (!file.exists()) {
                file.createNewFile();
            }
            fw = new FileWriter(file);
            fw.write(sw.toString());
        }
        catch (IOException e) {
            logger.error("\u5199\u5165\u6587\u4ef6\u5931\u8d25", (Throwable)e);
        }
        finally {
            try {
                fw.close();
            }
            catch (IOException e) {
                logger.error("\u5173\u95ed\u6587\u4ef6\u6d41\u5931\u8d25", (Throwable)e);
            }
        }
    }
}

