/*
 * Decompiled with CFR 0.152.
 */
package com.github.chuanzh;

import com.github.chuanzh.config.GlobalConfig;
import com.github.chuanzh.engine.AbstractTemplateEngine;
import com.github.chuanzh.engine.FreemarkerTemplateEngine;
import com.github.chuanzh.po.ControllerInfo;
import com.github.chuanzh.po.MethodInfo;
import com.github.chuanzh.po.Request;
import com.github.chuanzh.po.Response;
import com.github.chuanzh.util.ClassHelperUtils;
import com.github.chuanzh.util.ControllerInfoBuilder;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocAutoGenerator {
    private Logger logger = LoggerFactory.getLogger(DocAutoGenerator.class);
    private ControllerInfoBuilder controllerInfoBuilder = new ControllerInfoBuilder();
    private GlobalConfig globalConfig;
    private AbstractTemplateEngine abstractTemplateEngine;

    public void execute() {
        if (!this.checkConfig()) {
            return;
        }
        List<Map<String, Object>> params = null;
        try {
            params = this.buildTemplateParam(this.globalConfig.getOutputDir(), this.globalConfig.getPackagePath(), Arrays.asList(this.globalConfig.getInclude()));
        }
        catch (IOException e) {
            this.logger.info("\u6784\u5efa\u6a21\u677f\u53c2\u6570\u5931\u8d25", (Throwable)e);
            return;
        }
        if (null == this.abstractTemplateEngine) {
            this.abstractTemplateEngine = new FreemarkerTemplateEngine();
        }
        ClassHelperUtils.mkdirs(this.globalConfig.getOutputDir());
        for (Map<String, Object> param : params) {
            this.abstractTemplateEngine.process(param);
            this.logger.info("\u751f\u6210\u63a5\u53e3\u6587\u6863\u5b8c\u6210\uff1a" + param.get("path"));
        }
        if (this.globalConfig.isOpen()) {
            ClassHelperUtils.open(this.globalConfig.getOutputDir());
        }
    }

    private boolean checkConfig() {
        if (null == this.globalConfig) {
            this.logger.info("\u8bf7\u914d\u7f6eglobalConfig\u53c2\u6570");
            return false;
        }
        if (this.globalConfig.getOutputDir() == null) {
            this.logger.info("\u8bf7\u914d\u7f6e\u8f93\u51fa\u76ee\u5f55");
            return false;
        }
        if (this.globalConfig.getPackagePath() == null) {
            this.logger.info("\u8bf7\u914d\u7f6eController\u5305\u76ee\u5f55");
            return false;
        }
        return true;
    }

    private List<Map<String, Object>> buildTemplateParam(String docPath, String packageName, List<String> includes) throws IOException {
        ArrayList<Map<String, Object>> params = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> param = null;
        List<ControllerInfo> controllerInfoList = this.controllerInfoBuilder.handle(packageName, includes);
        for (ControllerInfo controllerInfo : controllerInfoList) {
            ArrayList<String> interfaceTitles = new ArrayList<String>();
            ArrayList interfaceDetails = new ArrayList();
            HashMap<String, Object> interfaceDetail = null;
            for (MethodInfo methodInfo : controllerInfo.getMethodInfoList()) {
                interfaceTitles.add(methodInfo.getDesc());
                interfaceDetail = new HashMap<String, Object>();
                interfaceDetail.put("title", methodInfo.getDesc());
                interfaceDetail.put("requestType", String.format("(%s)%s", methodInfo.getRequestType(), methodInfo.getRequestUrl()));
                interfaceDetail.put("request", this.buildRequestInfo(methodInfo));
                interfaceDetail.put("response", this.buildResponseInfo(methodInfo));
                interfaceDetails.add(interfaceDetail);
            }
            param = new HashMap<String, Object>();
            param.put("path", docPath + controllerInfo.getDesc() + ".md");
            param.put("title", controllerInfo.getDesc());
            param.put("interfaceTitles", interfaceTitles);
            param.put("interfaceDetails", interfaceDetails);
            params.add(param);
        }
        return params;
    }

    private LinkedHashMap<String, List<Request>> buildRequestInfo(MethodInfo methodInfo) {
        LinkedHashMap<String, List<Request>> requestList = new LinkedHashMap<String, List<Request>>();
        Object request = null;
        try {
            if (methodInfo.getRequests() != null) {
                requestList.put("", methodInfo.getRequests());
            }
            if (methodInfo.getRequestBeanName() != null) {
                String requestBeanName = methodInfo.getRequestBeanName();
                String subRequestBeanName = null;
                if (requestBeanName.indexOf("<") != -1) {
                    requestBeanName = requestBeanName.substring(0, requestBeanName.indexOf("<"));
                    subRequestBeanName = methodInfo.getRequestBeanName().substring(methodInfo.getRequestBeanName().lastIndexOf("<") + 1, methodInfo.getRequestBeanName().indexOf(">"));
                }
                if (!ClassHelperUtils.isListTypeName(requestBeanName)) {
                    this.doRequestInfo(requestBeanName, requestList);
                }
                if (subRequestBeanName != null && !ClassHelperUtils.isBaseTypeName(subRequestBeanName.substring(subRequestBeanName.lastIndexOf(".") + 1))) {
                    this.doRequestInfo(subRequestBeanName, requestList);
                }
            }
        }
        catch (Exception e) {
            this.logger.error("\u6784\u5efa\u8bf7\u6c42\u53c2\u6570\u5931\u8d25", (Throwable)e);
        }
        return requestList;
    }

    private void doRequestInfo(String beanName, LinkedHashMap<String, List<Request>> requestList) {
        Class<?> requestClass = null;
        try {
            requestClass = Class.forName(beanName);
        }
        catch (ClassNotFoundException e) {
            return;
        }
        ArrayList<Field> requestFields = ClassHelperUtils.findClassAllField(requestClass);
        ArrayList<Request> requests = new ArrayList<Request>();
        if (requestList.size() == 0) {
            requestList.put("first", requests);
        } else {
            requestList.put(requestClass.getSimpleName(), requests);
        }
        for (Field field : requestFields) {
            String subClass;
            if (ClassHelperUtils.isFilterField(field.getName())) continue;
            Request request = new Request();
            request.setName(field.getName());
            request.setType(ClassHelperUtils.getGenericTypeName(field));
            if (field.getAnnotation(ApiModelProperty.class) != null) {
                ApiModelProperty apiModelProperty = field.getAnnotation(ApiModelProperty.class);
                request.setDesc(apiModelProperty.value());
                request.setIsNotNull(apiModelProperty.required() ? 1 : 0);
            }
            requests.add(request);
            if (ClassHelperUtils.isBaseType(field.getGenericType()) || (subClass = ClassHelperUtils.subClass(field.getGenericType())) == null || subClass.equals(beanName)) continue;
            this.doRequestInfo(subClass, requestList);
        }
    }

    private void doResponseInfo(String beanName, LinkedHashMap<String, List<Response>> responseList) {
        Class<?> responseClass = null;
        try {
            responseClass = Class.forName(beanName);
        }
        catch (ClassNotFoundException e) {
            return;
        }
        ArrayList<Field> responseFields = ClassHelperUtils.findClassAllField(responseClass);
        ArrayList<Response> responses = new ArrayList<Response>();
        if (responseList.size() == 0) {
            responseList.put("first", responses);
        } else {
            responseList.put(responseClass.getSimpleName(), responses);
        }
        for (Field field : responseFields) {
            String subClass;
            if (ClassHelperUtils.isFilterField(field.getName())) continue;
            Response response = new Response();
            response.setName(field.getName());
            response.setType(ClassHelperUtils.getGenericTypeName(field));
            if (field.getAnnotation(ApiModelProperty.class) != null) {
                ApiModelProperty apiModelProperty = field.getAnnotation(ApiModelProperty.class);
                response.setDesc(apiModelProperty.value());
            }
            responses.add(response);
            if (ClassHelperUtils.isBaseType(field.getGenericType()) || (subClass = ClassHelperUtils.subClass(field.getGenericType())) == null || subClass.equals(beanName)) continue;
            this.doResponseInfo(subClass, responseList);
        }
    }

    private LinkedHashMap<String, List<Response>> buildResponseInfo(MethodInfo methodInfo) {
        LinkedHashMap<String, List<Response>> responseList = new LinkedHashMap<String, List<Response>>();
        try {
            String responseBeanName = methodInfo.getResponseBeanName();
            String subResponseBeanName = null;
            if (responseBeanName.indexOf("<") != -1) {
                responseBeanName = responseBeanName.substring(0, responseBeanName.indexOf("<"));
                subResponseBeanName = methodInfo.getResponseBeanName().substring(methodInfo.getResponseBeanName().lastIndexOf("<") + 1, methodInfo.getResponseBeanName().indexOf(">"));
            }
            if (!ClassHelperUtils.isListTypeName(responseBeanName)) {
                this.doResponseInfo(responseBeanName, responseList);
            }
            if (subResponseBeanName != null && !ClassHelperUtils.isBaseTypeName(subResponseBeanName.substring(subResponseBeanName.lastIndexOf(".") + 1))) {
                this.doResponseInfo(subResponseBeanName, responseList);
            }
        }
        catch (Exception e) {
            this.logger.error("\u6784\u5efa\u8bf7\u6c42\u53c2\u6570\u5931\u8d25", (Throwable)e);
        }
        return responseList;
    }

    public GlobalConfig getGlobalConfig() {
        return this.globalConfig;
    }

    public void setGlobalConfig(GlobalConfig globalConfig) {
        this.globalConfig = globalConfig;
    }
}

