/*
 * Decompiled with CFR 0.152.
 */
package com.chivorn.smartmaterialspinner;

import android.app.AlertDialog;
import android.app.Dialog;
import android.app.SearchManager;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.style.ForegroundColorSpan;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.appcompat.R;
import androidx.appcompat.widget.AppCompatTextView;
import androidx.appcompat.widget.SearchView;
import androidx.fragment.app.DialogFragment;
import com.chivorn.smartmaterialspinner.R;
import com.chivorn.smartmaterialspinner.SmartMaterialSpinner;
import com.chivorn.smartmaterialspinner.adapter.SearchAdapter;
import java.io.Serializable;
import java.util.List;

public class SearchableSpinnerDialog<T>
extends DialogFragment
implements SearchView.OnQueryTextListener,
SearchView.OnCloseListener {
    private static final String TAG = SearchableSpinnerDialog.class.getSimpleName();
    private static final String INSTANCE_LIST_ITEMS = "ListItems";
    private static final String INSTANCE_LISTENER_KEY = "OnSearchDialogEventListener";
    private static final String INSTANCE_SPINNER_KEY = "SmartMaterialSpinner";
    private ArrayAdapter<T> searchArrayAdapter;
    private ViewGroup searchHeaderView;
    private AppCompatTextView tvSearchHeader;
    private SearchView searchView;
    private TextView tvSearch;
    private ListView searchListView;
    private TextView tvListItem;
    private LinearLayout itemListContainer;
    public Button btnDismiss;
    private boolean isShowKeyboardOnStart;
    private boolean isEnableSearchHeader = true;
    private int headerBackgroundColor;
    private Drawable headerBackgroundDrawable;
    private int searchDropdownView;
    private int searchBackgroundColor;
    private Drawable searchBackgroundDrawable;
    private int searchHintColor;
    private int searchTextColor;
    private int searchFilterColor;
    private int searchListItemBackgroundColor;
    private Drawable searchListItemBackgroundDrawable;
    private int searchListItemColor;
    private int selectedSearchItemColor;
    private int selectedPosition = -1;
    private T selectedItem;
    private String searchHeaderText;
    private int searchHeaderTextColor;
    private String searchHint;
    private int searchDialogGravity = 48;
    private Typeface typeface;
    private boolean enableDismissSearch = false;
    private String dismissSearchText;
    private int dismissSearchColor;
    private OnSearchDialogEventListener onSearchDialogEventListener;
    private OnSearchTextChanged onSearchTextChanged;
    private DialogInterface.OnClickListener dialogListener;
    private SmartMaterialSpinner<T> smartMaterialSpinner;
    private boolean isDismissOnSelected = true;

    public static SearchableSpinnerDialog newInstance(SmartMaterialSpinner smartMaterialSpinner, List items) {
        SearchableSpinnerDialog searchableSpinnerDialog = new SearchableSpinnerDialog();
        Bundle args = new Bundle();
        args.putSerializable(INSTANCE_LIST_ITEMS, (Serializable)((Object)items));
        args.putSerializable(INSTANCE_SPINNER_KEY, (Serializable)smartMaterialSpinner);
        searchableSpinnerDialog.setArguments(args);
        return searchableSpinnerDialog;
    }

    public void onSaveInstanceState(@NonNull Bundle outState) {
        outState = this.setSavedInstanceState(outState);
        outState.putSerializable(INSTANCE_LISTENER_KEY, outState.getSerializable(INSTANCE_LISTENER_KEY));
        outState.putSerializable(INSTANCE_SPINNER_KEY, outState.getSerializable(INSTANCE_SPINNER_KEY));
        outState.putSerializable(INSTANCE_LIST_ITEMS, outState.getSerializable(INSTANCE_LIST_ITEMS));
        super.onSaveInstanceState(outState);
    }

    private Bundle setSavedInstanceState(Bundle savedInstanceState) {
        Bundle dialogInstanceState = this.getArguments();
        if (savedInstanceState == null || savedInstanceState.isEmpty() && dialogInstanceState != null) {
            savedInstanceState = dialogInstanceState;
        }
        return savedInstanceState;
    }

    public void onCreate(Bundle savedInstanceState) {
        savedInstanceState = this.setSavedInstanceState(savedInstanceState);
        this.smartMaterialSpinner = (SmartMaterialSpinner)savedInstanceState.get(INSTANCE_SPINNER_KEY);
        this.onSearchDialogEventListener = this.smartMaterialSpinner;
        savedInstanceState.putSerializable(INSTANCE_LISTENER_KEY, (Serializable)this.onSearchDialogEventListener);
        super.onCreate(savedInstanceState);
    }

    @NonNull
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        savedInstanceState = this.setSavedInstanceState(savedInstanceState);
        LayoutInflater inflater = LayoutInflater.from((Context)this.getActivity());
        if (savedInstanceState != null) {
            this.onSearchDialogEventListener = (OnSearchDialogEventListener)savedInstanceState.getSerializable(INSTANCE_LISTENER_KEY);
        }
        View searchLayout = inflater.inflate(R.layout.smart_material_spinner_searchable_dialog_layout, null);
        this.initSearchDialog(searchLayout, savedInstanceState);
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this.getActivity());
        builder.setView(searchLayout);
        AlertDialog dialog = builder.create();
        this.setGravity((Dialog)dialog);
        return dialog;
    }

    public View onCreateView(@NonNull LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        savedInstanceState = this.setSavedInstanceState(savedInstanceState);
        Window window = this.getDialog().getWindow();
        if (window != null) {
            window.setSoftInputMode(2);
        }
        return super.onCreateView(inflater, container, savedInstanceState);
    }

    private void initSearchDialog(View rootView, Bundle savedInstanceState) {
        List items;
        SearchManager searchManager;
        this.searchHeaderView = (ViewGroup)rootView.findViewById(R.id.search_header_layout);
        this.tvSearchHeader = (AppCompatTextView)rootView.findViewById(R.id.tv_search_header);
        this.searchView = (SearchView)rootView.findViewById(R.id.search_view);
        this.tvSearch = (TextView)this.searchView.findViewById(R.id.search_src_text);
        this.searchListView = (ListView)rootView.findViewById(R.id.search_list_item);
        this.itemListContainer = (LinearLayout)rootView.findViewById(R.id.item_search_list_container);
        this.btnDismiss = (Button)rootView.findViewById(R.id.btn_dismiss);
        if (this.getActivity() != null && (searchManager = (SearchManager)this.getActivity().getSystemService("search")) != null) {
            this.searchView.setSearchableInfo(searchManager.getSearchableInfo(this.getActivity().getComponentName()));
        }
        this.searchView.setIconifiedByDefault(false);
        this.searchView.setOnQueryTextListener((SearchView.OnQueryTextListener)this);
        this.searchView.setOnCloseListener((SearchView.OnCloseListener)this);
        this.searchView.setFocusable(true);
        this.searchView.setIconified(false);
        this.searchView.requestFocusFromTouch();
        if (this.isShowKeyboardOnStart) {
            this.searchView.requestFocus();
        } else {
            this.searchView.clearFocus();
        }
        List list = items = savedInstanceState != null ? (List)((Object)savedInstanceState.getSerializable(INSTANCE_LIST_ITEMS)) : null;
        if (items != null) {
            this.searchArrayAdapter = new SearchAdapter<T>((Context)this.getActivity(), this.searchDropdownView, items){

                @NonNull
                public View getView(int position, View convertView, @NonNull ViewGroup parent) {
                    View listView = super.getView(position, convertView, parent);
                    SearchableSpinnerDialog.this.tvListItem = (TextView)listView;
                    SearchableSpinnerDialog.this.tvListItem.setTypeface(SearchableSpinnerDialog.this.typeface);
                    SpannableString spannableString = new SpannableString(SearchableSpinnerDialog.this.tvListItem.getText());
                    if (SearchableSpinnerDialog.this.searchListItemBackgroundColor != 0) {
                        SearchableSpinnerDialog.this.itemListContainer.setBackgroundColor(SearchableSpinnerDialog.this.searchListItemBackgroundColor);
                    } else if (SearchableSpinnerDialog.this.searchListItemBackgroundDrawable != null && Build.VERSION.SDK_INT >= 16) {
                        SearchableSpinnerDialog.this.itemListContainer.setBackground(SearchableSpinnerDialog.this.searchListItemBackgroundDrawable);
                    }
                    if (SearchableSpinnerDialog.this.searchListItemColor != 0) {
                        SearchableSpinnerDialog.this.tvListItem.setTextColor(SearchableSpinnerDialog.this.searchListItemColor);
                        if (SearchableSpinnerDialog.this.searchFilterColor != 0 && SearchableSpinnerDialog.this.searchView.getQuery() != null && !SearchableSpinnerDialog.this.searchView.getQuery().toString().isEmpty()) {
                            String query = SearchableSpinnerDialog.this.searchView.getQuery().toString().toLowerCase();
                            String fullText = SearchableSpinnerDialog.this.tvListItem.getText().toString().toLowerCase();
                            int start = fullText.indexOf(query);
                            int end = start + query.length();
                            spannableString.setSpan((Object)new ForegroundColorSpan(SearchableSpinnerDialog.this.searchFilterColor), start, end, 0);
                            SearchableSpinnerDialog.this.tvListItem.setText((CharSequence)spannableString, TextView.BufferType.SPANNABLE);
                        }
                    }
                    Object item = SearchableSpinnerDialog.this.searchArrayAdapter.getItem(position);
                    if (SearchableSpinnerDialog.this.selectedSearchItemColor != 0 && position >= 0 && item != null && item.equals(SearchableSpinnerDialog.this.selectedItem)) {
                        SearchableSpinnerDialog.this.tvListItem.setTextColor(SearchableSpinnerDialog.this.selectedSearchItemColor);
                    }
                    return listView;
                }
            };
        }
        this.searchListView.setAdapter(this.searchArrayAdapter);
        this.searchListView.setTextFilterEnabled(true);
        this.searchListView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                if (SearchableSpinnerDialog.this.onSearchDialogEventListener != null) {
                    SearchableSpinnerDialog.this.onSearchDialogEventListener.onSearchItemSelected(SearchableSpinnerDialog.this.searchArrayAdapter.getItem(position), position);
                    SearchableSpinnerDialog.this.selectedItem = SearchableSpinnerDialog.this.searchArrayAdapter.getItem(position);
                }
                SearchableSpinnerDialog.this.getDialog().dismiss();
            }
        });
        this.searchListView.addOnLayoutChangeListener(new View.OnLayoutChangeListener(){

            public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                if (bottom < oldBottom) {
                    SearchableSpinnerDialog.this.scrollToSelectedItem();
                } else if (bottom > oldBottom) {
                    SearchableSpinnerDialog.this.scrollToSelectedItem();
                }
            }
        });
        this.btnDismiss.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SearchableSpinnerDialog.this.dismiss();
            }
        });
        this.initSearchHeader();
        this.initSearchBody();
        this.initSearchFooter();
    }

    private void initSearchHeader() {
        if (this.isEnableSearchHeader) {
            this.searchHeaderView.setVisibility(0);
        } else {
            this.searchHeaderView.setVisibility(8);
        }
        if (this.searchHeaderText != null) {
            this.tvSearchHeader.setText((CharSequence)this.searchHeaderText);
            this.tvSearchHeader.setTypeface(this.typeface);
        }
        if (this.searchHeaderTextColor != 0) {
            this.tvSearchHeader.setTextColor(this.searchHeaderTextColor);
        }
        if (this.headerBackgroundColor != 0) {
            this.searchHeaderView.setBackgroundColor(this.headerBackgroundColor);
        } else if (this.headerBackgroundDrawable != null && Build.VERSION.SDK_INT >= 16) {
            this.searchHeaderView.setBackground(this.headerBackgroundDrawable);
        }
    }

    private void initSearchBody() {
        if (this.searchHint != null) {
            this.searchView.setQueryHint((CharSequence)this.searchHint);
        }
        if (this.searchBackgroundColor != 0) {
            this.searchView.setBackgroundColor(this.searchBackgroundColor);
        } else if (this.searchBackgroundDrawable != null && Build.VERSION.SDK_INT >= 16) {
            this.searchView.setBackground(this.searchBackgroundDrawable);
        }
        if (this.tvSearch != null) {
            this.tvSearch.setTypeface(this.typeface);
            if (this.searchTextColor != 0) {
                this.tvSearch.setTextColor(this.searchTextColor);
            }
            if (this.searchHintColor != 0) {
                this.tvSearch.setHintTextColor(this.searchHintColor);
            }
        }
    }

    private void initSearchFooter() {
        if (this.enableDismissSearch) {
            this.btnDismiss.setVisibility(0);
        }
        if (this.dismissSearchText != null) {
            this.btnDismiss.setText((CharSequence)this.dismissSearchText);
        }
        if (this.dismissSearchColor != 0) {
            this.btnDismiss.setTextColor(this.dismissSearchColor);
        }
    }

    public void onPause() {
        super.onPause();
        this.dismiss();
    }

    public void onDismiss(DialogInterface dialog) {
        if (this.onSearchDialogEventListener != null) {
            this.onSearchDialogEventListener.onSearchableSpinnerDismiss();
        }
        super.onDismiss(dialog);
    }

    public boolean onQueryTextSubmit(String s) {
        this.searchView.clearFocus();
        return true;
    }

    public boolean onQueryTextChange(String s) {
        if (TextUtils.isEmpty((CharSequence)s)) {
            ((ArrayAdapter)this.searchListView.getAdapter()).getFilter().filter(null);
        } else {
            ((ArrayAdapter)this.searchListView.getAdapter()).getFilter().filter((CharSequence)s);
        }
        if (this.onSearchTextChanged != null) {
            this.onSearchTextChanged.onSearchTextChanged(s);
        }
        return true;
    }

    public boolean onClose() {
        return false;
    }

    public void setOnSearchDialogEventListener(OnSearchDialogEventListener onSearchDialogEventListener) {
        this.onSearchDialogEventListener = onSearchDialogEventListener;
    }

    public void setOnSearchTextChangedListener(OnSearchTextChanged onSearchTextChanged) {
        this.onSearchTextChanged = onSearchTextChanged;
    }

    public void setEnableSearchHeader(boolean enableSearchHeader) {
        this.isEnableSearchHeader = enableSearchHeader;
    }

    public void setShowKeyboardOnStart(boolean showKeyboardOnStart) {
        this.isShowKeyboardOnStart = showKeyboardOnStart;
    }

    public void setSearchHeaderText(String header) {
        this.searchHeaderText = header;
    }

    public void setSearchHeaderTextColor(int color2) {
        this.searchHeaderTextColor = color2;
    }

    public void setSearchHeaderBackgroundColor(int color2) {
        this.headerBackgroundColor = color2;
        this.headerBackgroundDrawable = null;
    }

    @RequiresApi(api=16)
    public void setSearchHeaderBackgroundColor(Drawable drawable2) {
        this.headerBackgroundDrawable = drawable2;
        this.headerBackgroundColor = 0;
    }

    public int getSearchDropdownView() {
        return this.searchDropdownView;
    }

    public void setSearchDropdownView(int searchDropdownView) {
        this.searchDropdownView = searchDropdownView;
    }

    public void setSearchBackgroundColor(int color2) {
        this.searchBackgroundColor = color2;
        this.searchBackgroundDrawable = null;
    }

    @RequiresApi(api=16)
    public void setSearchBackgroundColor(Drawable drawable2) {
        this.searchBackgroundDrawable = drawable2;
        this.searchBackgroundColor = 0;
    }

    public void setSearchListItemBackgroundColor(int color2) {
        this.searchListItemBackgroundColor = color2;
        this.searchListItemBackgroundDrawable = null;
    }

    @RequiresApi(api=16)
    public void setSearchListItemBackgroundDrawable(Drawable drawable2) {
        this.searchListItemBackgroundDrawable = drawable2;
        this.searchListItemBackgroundColor = 0;
    }

    public void setSearchHint(String searchHint) {
        this.searchHint = searchHint;
    }

    public void setSearchTextColor(int color2) {
        this.searchTextColor = color2;
    }

    public void setSearchFilterColor(int searchFilterColor) {
        this.searchFilterColor = searchFilterColor;
    }

    public void setSearchHintColor(int color2) {
        this.searchHintColor = color2;
    }

    public void setSearchListItemColor(int searchListItemColor) {
        this.searchListItemColor = searchListItemColor;
    }

    public void setSelectedSearchItemColor(int selectedSearchItemColor) {
        this.selectedSearchItemColor = selectedSearchItemColor;
    }

    public void setSelectedPosition(int position) {
        this.selectedPosition = position;
    }

    public void setGravity(int gravity) {
        this.searchDialogGravity = gravity;
    }

    private void setGravity(Dialog dialog) {
        if (dialog != null && dialog.getWindow() != null) {
            dialog.getWindow().setGravity(this.searchDialogGravity);
        }
    }

    private void scrollToSelectedItem() {
        if (this.selectedPosition >= 0 && this.searchListView.isSmoothScrollbarEnabled()) {
            this.searchListView.smoothScrollToPositionFromTop(this.selectedPosition, 0, 10);
        }
    }

    public Typeface getTypeface() {
        return this.typeface;
    }

    public void setTypeface(Typeface typeface) {
        this.typeface = typeface;
    }

    public boolean isEnableDismissSearch() {
        return this.enableDismissSearch;
    }

    public void setEnableDismissSearch(boolean enableDismissSearch) {
        this.enableDismissSearch = enableDismissSearch;
    }

    public String getDismissSearchText() {
        return this.dismissSearchText;
    }

    public void setDismissSearchText(String dismissSearchText) {
        this.dismissSearchText = dismissSearchText;
    }

    public int getDismissSearchColor() {
        return this.dismissSearchColor;
    }

    public void setDismissSearchColor(int dismissSearchColor) {
        this.dismissSearchColor = dismissSearchColor;
    }

    public static interface OnSearchTextChanged {
        public void onSearchTextChanged(String var1);
    }

    public static interface OnSearchDialogEventListener<T>
    extends Serializable {
        public void onSearchItemSelected(T var1, int var2);

        public void onSearchableSpinnerDismiss();
    }
}

