/*
 * Decompiled with CFR 0.152.
 */
package org.modelmapper.module.jsr310;

import java.time.ZoneId;
import java.time.format.DateTimeFormatter;

public class Jsr310ModuleConfig {
    private static final String DEFAULT_DATE_PATTERN = "yyyy-MM-dd";
    private static final String DEFAULT_DATE_TIME_PATTERN = "yyyy-MM-dd HH:mm:ss";
    private static final String DEFAULT_DATE_TIME_OFFSET_PATTERN = "yyyy-MM-dd HH:mm:ssX";
    private static final String DEFAULT_TIME_PATTERN = "HH:mm:ss";
    private DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private DateTimeFormatter dateTimeOffsetFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ssX");
    private DateTimeFormatter timeFormatter = DateTimeFormatter.ofPattern("HH:mm:ss");
    private ZoneId zoneId = ZoneId.systemDefault();

    public void setDatePattern(String datePattern) {
        this.setDateFormatter(DateTimeFormatter.ofPattern(datePattern));
    }

    public void setDateTimePattern(String dateTimePattern) {
        this.setDateTimeFormatter(DateTimeFormatter.ofPattern(dateTimePattern));
    }

    public void setDateTimeOffsetPattern(String dateTimeOffsetPattern) {
        this.setDateTimeOffsetFormatter(DateTimeFormatter.ofPattern(dateTimeOffsetPattern));
    }

    public void setTimePattern(String timePattern) {
        this.setTimeFormatter(DateTimeFormatter.ofPattern(timePattern));
    }

    public static Jsr310ModuleConfigBuilder builder() {
        return new Jsr310ModuleConfigBuilder();
    }

    public DateTimeFormatter getDateFormatter() {
        return this.dateFormatter;
    }

    public DateTimeFormatter getDateTimeFormatter() {
        return this.dateTimeFormatter;
    }

    public DateTimeFormatter getDateTimeOffsetFormatter() {
        return this.dateTimeOffsetFormatter;
    }

    public DateTimeFormatter getTimeFormatter() {
        return this.timeFormatter;
    }

    public ZoneId getZoneId() {
        return this.zoneId;
    }

    public void setDateFormatter(DateTimeFormatter dateFormatter) {
        this.dateFormatter = dateFormatter;
    }

    public void setDateTimeFormatter(DateTimeFormatter dateTimeFormatter) {
        this.dateTimeFormatter = dateTimeFormatter;
    }

    public void setDateTimeOffsetFormatter(DateTimeFormatter dateTimeOffsetFormatter) {
        this.dateTimeOffsetFormatter = dateTimeOffsetFormatter;
    }

    public void setTimeFormatter(DateTimeFormatter timeFormatter) {
        this.timeFormatter = timeFormatter;
    }

    public void setZoneId(ZoneId zoneId) {
        this.zoneId = zoneId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Jsr310ModuleConfig)) {
            return false;
        }
        Jsr310ModuleConfig other = (Jsr310ModuleConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        DateTimeFormatter this$dateFormatter = this.getDateFormatter();
        DateTimeFormatter other$dateFormatter = other.getDateFormatter();
        if (this$dateFormatter == null ? other$dateFormatter != null : !this$dateFormatter.equals(other$dateFormatter)) {
            return false;
        }
        DateTimeFormatter this$dateTimeFormatter = this.getDateTimeFormatter();
        DateTimeFormatter other$dateTimeFormatter = other.getDateTimeFormatter();
        if (this$dateTimeFormatter == null ? other$dateTimeFormatter != null : !this$dateTimeFormatter.equals(other$dateTimeFormatter)) {
            return false;
        }
        DateTimeFormatter this$dateTimeOffsetFormatter = this.getDateTimeOffsetFormatter();
        DateTimeFormatter other$dateTimeOffsetFormatter = other.getDateTimeOffsetFormatter();
        if (this$dateTimeOffsetFormatter == null ? other$dateTimeOffsetFormatter != null : !this$dateTimeOffsetFormatter.equals(other$dateTimeOffsetFormatter)) {
            return false;
        }
        DateTimeFormatter this$timeFormatter = this.getTimeFormatter();
        DateTimeFormatter other$timeFormatter = other.getTimeFormatter();
        if (this$timeFormatter == null ? other$timeFormatter != null : !this$timeFormatter.equals(other$timeFormatter)) {
            return false;
        }
        ZoneId this$zoneId = this.getZoneId();
        ZoneId other$zoneId = other.getZoneId();
        return !(this$zoneId == null ? other$zoneId != null : !((Object)this$zoneId).equals(other$zoneId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Jsr310ModuleConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DateTimeFormatter $dateFormatter = this.getDateFormatter();
        result = result * 59 + ($dateFormatter == null ? 43 : $dateFormatter.hashCode());
        DateTimeFormatter $dateTimeFormatter = this.getDateTimeFormatter();
        result = result * 59 + ($dateTimeFormatter == null ? 43 : $dateTimeFormatter.hashCode());
        DateTimeFormatter $dateTimeOffsetFormatter = this.getDateTimeOffsetFormatter();
        result = result * 59 + ($dateTimeOffsetFormatter == null ? 43 : $dateTimeOffsetFormatter.hashCode());
        DateTimeFormatter $timeFormatter = this.getTimeFormatter();
        result = result * 59 + ($timeFormatter == null ? 43 : $timeFormatter.hashCode());
        ZoneId $zoneId = this.getZoneId();
        result = result * 59 + ($zoneId == null ? 43 : ((Object)$zoneId).hashCode());
        return result;
    }

    public String toString() {
        return "Jsr310ModuleConfig(dateFormatter=" + this.getDateFormatter() + ", dateTimeFormatter=" + this.getDateTimeFormatter() + ", dateTimeOffsetFormatter=" + this.getDateTimeOffsetFormatter() + ", timeFormatter=" + this.getTimeFormatter() + ", zoneId=" + this.getZoneId() + ")";
    }

    public Jsr310ModuleConfig() {
    }

    public Jsr310ModuleConfig(DateTimeFormatter dateFormatter, DateTimeFormatter dateTimeFormatter, DateTimeFormatter dateTimeOffsetFormatter, DateTimeFormatter timeFormatter, ZoneId zoneId) {
        this.dateFormatter = dateFormatter;
        this.dateTimeFormatter = dateTimeFormatter;
        this.dateTimeOffsetFormatter = dateTimeOffsetFormatter;
        this.timeFormatter = timeFormatter;
        this.zoneId = zoneId;
    }

    public static class Jsr310ModuleConfigBuilder {
        private DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        private DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        private DateTimeFormatter dateTimeOffsetFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ssX");
        private DateTimeFormatter timeFormatter = DateTimeFormatter.ofPattern("HH:mm:ss");
        private ZoneId zoneId = ZoneId.systemDefault();

        public Jsr310ModuleConfigBuilder datePattern(String datePattern) {
            return this.dateFormatter(DateTimeFormatter.ofPattern(datePattern));
        }

        public Jsr310ModuleConfigBuilder dateFormatter(DateTimeFormatter dateFormatter) {
            this.dateFormatter = dateFormatter;
            return this;
        }

        public Jsr310ModuleConfigBuilder dateTimePattern(String dateTimePattern) {
            return this.dateTimeFormatter(DateTimeFormatter.ofPattern(dateTimePattern));
        }

        public Jsr310ModuleConfigBuilder dateTimeFormatter(DateTimeFormatter dateTimeFormatter) {
            this.dateTimeFormatter = dateTimeFormatter;
            return this;
        }

        public Jsr310ModuleConfigBuilder dateTimeOffsetPattern(String dateTimeOffsetPattern) {
            return this.dateTimeOffsetFormatter(DateTimeFormatter.ofPattern(dateTimeOffsetPattern));
        }

        public Jsr310ModuleConfigBuilder dateTimeOffsetFormatter(DateTimeFormatter dateTimeOffsetFormatter) {
            this.dateTimeOffsetFormatter = dateTimeOffsetFormatter;
            return this;
        }

        public Jsr310ModuleConfigBuilder timePattern(String timePattern) {
            return this.timeFormatter(DateTimeFormatter.ofPattern(timePattern));
        }

        public Jsr310ModuleConfigBuilder timeFormatter(DateTimeFormatter timeFormatter) {
            this.timeFormatter = timeFormatter;
            return this;
        }

        public Jsr310ModuleConfigBuilder zoneId(ZoneId zoneId) {
            this.zoneId = zoneId;
            return this;
        }

        public Jsr310ModuleConfig build() {
            return new Jsr310ModuleConfig(this.dateFormatter, this.dateTimeFormatter, this.dateTimeOffsetFormatter, this.timeFormatter, this.zoneId);
        }
    }
}

