/*
 * Decompiled with CFR 0.152.
 */
package org.jaxws.wsdl2html.ui;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.math.RandomUtils;
import org.jaxws.stub2html.view.freemarker.ClasspathFreemarkerWebServiceDisplayEngine;
import org.jaxws.stub2html.view.freemarker.FreemarkerWebServiceDisplayEngine;
import org.jaxws.wsdl2bytecodes.service.WsdlImportException;
import org.jaxws.wsdl2html.service.Wsdl2Html;

public class Wsdl2HtmlMain {
    public static void main(String[] args) throws IOException, WsdlImportException {
        if (args == null || args.length == 0) {
            System.out.println("Params:  wsdlUrl [targetDir] [--debug]");
            return;
        }
        ArrayList<String> argList = new ArrayList<String>(Arrays.asList(args));
        boolean isDebug = argList.remove("--debug");
        String wsdlUrl = (String)argList.get(0);
        File outputRootDir = new File("output/" + Wsdl2HtmlMain.getUniqueNumber());
        if (argList.size() > 1) {
            outputRootDir = new File((String)argList.get(1));
            outputRootDir.mkdirs();
        }
        if (isDebug) {
            argList.add("--debug");
        }
        File byteCodeDir = Wsdl2HtmlMain.getByteCodeDir(outputRootDir);
        File htmlDir = Wsdl2HtmlMain.getHtmlDir(outputRootDir);
        System.out.println("Generating from " + wsdlUrl);
        FreemarkerWebServiceDisplayEngine displayEngine = Wsdl2HtmlMain.createDisplayEngine(argList);
        String html = Wsdl2Html.generateHtml(byteCodeDir.getAbsolutePath(), wsdlUrl, displayEngine, isDebug);
        FileUtils.writeStringToFile((File)new File(htmlDir, "report-" + Wsdl2HtmlMain.getUniqueNumber() + ".html"), (String)html);
        System.out.println("Please find the HTML files at " + htmlDir.getAbsolutePath());
    }

    private static String getUniqueNumber() {
        return System.currentTimeMillis() + "" + RandomUtils.nextLong();
    }

    private static FreemarkerWebServiceDisplayEngine createDisplayEngine(List<String> argList) {
        FreemarkerWebServiceDisplayEngine displayEngine = ClasspathFreemarkerWebServiceDisplayEngine.createEngine();
        return displayEngine;
    }

    private static File getHtmlDir(File outputRootDir) {
        File htmlDir = new File(outputRootDir, "html");
        htmlDir.mkdirs();
        return htmlDir;
    }

    private static File getByteCodeDir(File outputRootDir) {
        File byteCodeDir = new File(outputRootDir, "stubs-" + Wsdl2HtmlMain.getUniqueNumber());
        byteCodeDir.mkdirs();
        return byteCodeDir;
    }
}

