/*
 * Decompiled with CFR 0.152.
 */
package org.jaxws.stub2html.service;

import java.lang.reflect.Method;
import java.util.List;
import org.jaxws.stub2html.model.JavaLanguageVariable;
import org.jaxws.stub2html.model.Stub;
import org.jaxws.stub2html.model.WebMethodStubSet;
import org.jaxws.stub2html.service.JavaLanguageVariableFactory;
import org.jaxws.stub2html.service.Variable2Stub;

public class WebMethodStubSetFactory {
    public static WebMethodStubSet createWebMethodStubSet(Method method) {
        WebMethodStubSet stubSet = new WebMethodStubSet();
        stubSet.setMethodName(method.getName());
        WebMethodStubSetFactory.addRequestStubs(method, stubSet);
        if (!Void.TYPE.equals(method.getReturnType())) {
            WebMethodStubSetFactory.addResponseStub(method, stubSet);
        }
        return stubSet;
    }

    private static void addResponseStub(Method method, WebMethodStubSet stubSet) {
        JavaLanguageVariable variable = JavaLanguageVariableFactory.createVariableFromMethodReturn(method);
        Stub stub = Variable2Stub.convertToStub(variable, null, stubSet.getStubTypeTreeRepository());
        stubSet.setResponseStub(stub);
    }

    private static void addRequestStubs(Method method, WebMethodStubSet stubSet) {
        List<JavaLanguageVariable> requestVariables = JavaLanguageVariableFactory.createVariablesFromMethodParamaters(method);
        for (JavaLanguageVariable variable : requestVariables) {
            Stub stub = Variable2Stub.convertToStub(variable, null, stubSet.getStubTypeTreeRepository());
            stubSet.addRequetStub(stub);
        }
    }
}

