/*
 * Decompiled with CFR 0.152.
 */
package org.jaxws.bytecodes2stub.service;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.jaxws.bytecodes2stub.service.ByteCodePackageClassLoader;
import org.jaxws.util.lang.ClassNameUtils;
import org.jaxws.wsdl2bytecodes.model.ByteCodePackage;

public class ByteCodePackageLoadingService {
    public static List<Class<?>> loadAll(ByteCodePackage byteCodePackage) {
        ArrayList allClasses = new ArrayList();
        ByteCodePackageClassLoader classLoader = new ByteCodePackageClassLoader(Thread.currentThread().getContextClassLoader(), byteCodePackage);
        List<String> classNames = ByteCodePackageLoadingService.getAllClassNames(byteCodePackage);
        for (String className : classNames) {
            Class<?> clazz = ByteCodePackageLoadingService.loadClass(classLoader, className);
            allClasses.add(clazz);
        }
        return allClasses;
    }

    private static Class<?> loadClass(ClassLoader classLoader, String className) {
        try {
            return classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private static List<String> getAllClassNames(ByteCodePackage byteCodePackage) {
        ArrayList<String> classNames = new ArrayList<String>();
        List files = (List)FileUtils.listFiles((File)byteCodePackage.getDir(), (String[])new String[]{"class"}, (boolean)true);
        File rootDir = byteCodePackage.getDir();
        for (File classFile : files) {
            String relativeDir = ByteCodePackageLoadingService.getRelativeDir(rootDir, classFile);
            String packageName = ClassNameUtils.toPackageName(relativeDir);
            String className = packageName + "." + FilenameUtils.getBaseName((String)classFile.getName());
            classNames.add(className);
        }
        return classNames;
    }

    static String getRelativeDir(File rootDir, File file) {
        String filePath = file.getAbsolutePath();
        String rootPath = rootDir.getAbsolutePath();
        String relative = StringUtils.substringBetween((String)filePath, (String)rootPath, (String)file.getName());
        relative = FilenameUtils.separatorsToUnix((String)relative);
        return StringUtils.stripEnd((String)StringUtils.stripStart((String)relative, (String)"/"), (String)"/");
    }
}

