/*
 * Decompiled with CFR 0.152.
 */
package com.cx.restclient;

import com.checkmarx.sdk.config.ScaConfig;
import com.checkmarx.sdk.config.ScaProperties;
import com.checkmarx.sdk.dto.Filter;
import com.checkmarx.sdk.dto.ast.ASTResultsWrapper;
import com.checkmarx.sdk.dto.ast.SCAResults;
import com.checkmarx.sdk.dto.ast.ScanParams;
import com.checkmarx.sdk.dto.filtering.EngineFilterConfiguration;
import com.checkmarx.sdk.dto.filtering.FilterConfiguration;
import com.checkmarx.sdk.dto.filtering.FilterInput;
import com.checkmarx.sdk.exception.ASTRuntimeException;
import com.checkmarx.sdk.service.FilterInputFactory;
import com.checkmarx.sdk.service.FilterValidator;
import com.cx.restclient.AbstractAstClient;
import com.cx.restclient.CxClientDelegator;
import com.cx.restclient.ast.dto.common.ASTConfig;
import com.cx.restclient.ast.dto.common.SummaryResults;
import com.cx.restclient.ast.dto.sca.AstScaConfig;
import com.cx.restclient.ast.dto.sca.AstScaResults;
import com.cx.restclient.ast.dto.sca.report.AstScaSummaryResults;
import com.cx.restclient.ast.dto.sca.report.Finding;
import com.cx.restclient.configuration.CxScanConfig;
import com.cx.restclient.dto.ScanResults;
import com.cx.restclient.dto.ScannerType;
import java.io.File;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.modelmapper.ModelMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ScaClientImpl
extends AbstractAstClient {
    private static final Logger log = LoggerFactory.getLogger(ScaClientImpl.class);
    private final ScaProperties scaProperties;
    private final FilterInputFactory filterInputFactory;
    private final FilterValidator filterValidator;

    @Override
    protected void applyFilterToResults(ASTResultsWrapper combinedResults, ScanParams scanParams) {
        EngineFilterConfiguration filterConfig = ScaClientImpl.extractFilterConfigFrom(scanParams);
        combinedResults.getScaResults().getFindings().removeIf(finding -> !this.passesFilter((Finding)finding, filterConfig));
    }

    private static EngineFilterConfiguration extractFilterConfigFrom(ScanParams scanParams) {
        EngineFilterConfiguration result = Optional.ofNullable(scanParams).map(ScanParams::getFilterConfiguration).map(FilterConfiguration::getScaFilters).orElse(null);
        String message = result == null ? "No SCA filter configuration was found in {}" : "Found SCA filter configuration in {}";
        log.debug(message, (Object)ScanParams.class.getSimpleName());
        return result;
    }

    private boolean passesFilter(Finding finding, EngineFilterConfiguration filterConfig) {
        FilterInput filterInput = this.filterInputFactory.createFilterInputForSca(finding);
        return this.filterValidator.passesFilter(filterInput, filterConfig);
    }

    @Override
    protected ASTResultsWrapper toResults(ScanResults scaResultsFromCommonClient) {
        this.validateNotNull(scaResultsFromCommonClient.getScaResults());
        AstScaSummaryResults summary = scaResultsFromCommonClient.getScaResults().getSummary();
        Map<Filter.Severity, Integer> findingCountsPerSeverity = this.getFindingCountMap((SummaryResults)summary);
        ModelMapper mapper = new ModelMapper();
        SCAResults result = (SCAResults)mapper.map((Object)scaResultsFromCommonClient.getScaResults(), SCAResults.class);
        result.getSummary().setFindingCounts(findingCountsPerSeverity);
        ASTResultsWrapper results = new ASTResultsWrapper();
        results.setScaResults(result);
        return results;
    }

    @Override
    public ASTResultsWrapper getLatestScanResults(ScanParams scanParams) {
        CxScanConfig commonClientScanConfig = this.getScanConfig(scanParams);
        try {
            ASTResultsWrapper result;
            CxClientDelegator client = new CxClientDelegator(commonClientScanConfig, log);
            client.init();
            ScanResults commonClientResults = client.getLatestScanResults();
            if (commonClientResults.getScaResults() != null) {
                result = this.toResults(commonClientResults);
                this.applyFilterToResults(result, scanParams);
            } else {
                result = new ASTResultsWrapper();
            }
            return result;
        }
        catch (Exception e) {
            throw new ASTRuntimeException("Error getting latest scan results.", e);
        }
    }

    @Override
    protected CxScanConfig getScanConfig(ScanParams scanParams) {
        CxScanConfig cxScanConfig = new CxScanConfig();
        cxScanConfig.addScannerType(ScannerType.AST_SCA);
        cxScanConfig.setSastEnabled(false);
        cxScanConfig.setProjectName(scanParams.getProjectName());
        AstScaConfig scaConfig = this.getScaSpecificConfig(scanParams);
        ScaClientImpl.setSourceLocation(scanParams, cxScanConfig, (ASTConfig)scaConfig);
        cxScanConfig.setAstScaConfig(scaConfig);
        return cxScanConfig;
    }

    private AstScaConfig getScaSpecificConfig(ScanParams scanParams) {
        AstScaConfig commonClientScaConfig = new AstScaConfig();
        ScaConfig sdkScaConfig = scanParams.getScaConfig();
        if (sdkScaConfig != null) {
            commonClientScaConfig.setWebAppUrl(sdkScaConfig.getAppUrl());
            commonClientScaConfig.setApiUrl(sdkScaConfig.getApiUrl());
            commonClientScaConfig.setAccessControlUrl(sdkScaConfig.getAccessControlUrl());
            commonClientScaConfig.setTenant(sdkScaConfig.getTenant());
            commonClientScaConfig.setUsername(this.scaProperties.getUsername());
            commonClientScaConfig.setPassword(this.scaProperties.getPassword());
        } else {
            log.warn("Unable to map SCA configuration to an internal object.");
        }
        return commonClientScaConfig;
    }

    @Override
    protected void validate(ScanParams scanParams) {
        ScaClientImpl.validateNotNull(scanParams);
        ScaConfig scaConfig = scanParams.getScaConfig();
        if (Optional.ofNullable(scaConfig).isPresent()) {
            this.validateNotEmpty(scaConfig.getAppUrl(), "SCA application URL");
            this.validateNotEmpty(scaConfig.getApiUrl(), "SCA API URL");
            this.validateNotEmpty(scaConfig.getAccessControlUrl(), "SCA Access Control URL");
            this.validateNotEmpty(scaConfig.getTenant(), "SCA tenant");
            this.validateNotEmpty(this.scaProperties.getUsername(), "Username");
            this.validateNotEmpty(this.scaProperties.getPassword(), "Password");
        }
    }

    private static void validateNotNull(ScanParams scanParams) {
        if (scanParams == null) {
            throw new ASTRuntimeException(String.format("%s SCA parameters weren't provided.", "Scan cannot be initiated."));
        }
        if (scanParams.getRemoteRepoUrl() == null && !ScaClientImpl.localSourcesAreSpecified(scanParams)) {
            String message = String.format("%s Source location is not specified. Please specify either repository URL, zip file path or source directory path.", "Scan cannot be initiated.");
            throw new ASTRuntimeException(message);
        }
        ScaClientImpl.validateSpecifiedPathExists(scanParams.getZipPath());
        ScaClientImpl.validateSpecifiedPathExists(scanParams.getSourceDir());
    }

    private static void validateSpecifiedPathExists(String path) {
        if (StringUtils.isNotEmpty((CharSequence)path) && !new File(path).exists()) {
            throw new ASTRuntimeException(String.format("%s Source location (%s) does not exist.", "Scan cannot be initiated.", path));
        }
    }

    private void validateNotNull(AstScaResults scaResults) {
        if (scaResults == null) {
            throw new ASTRuntimeException("SCA results are missing.");
        }
        AstScaSummaryResults summary = scaResults.getSummary();
        if (summary == null) {
            throw new ASTRuntimeException("SCA results don't contain a summary.");
        }
    }

    public ScaClientImpl(ScaProperties scaProperties, FilterInputFactory filterInputFactory, FilterValidator filterValidator) {
        this.scaProperties = scaProperties;
        this.filterInputFactory = filterInputFactory;
        this.filterValidator = filterValidator;
    }
}

