/*
 * Decompiled with CFR 0.152.
 */
package com.checkmarx.sdk.service;

import com.checkmarx.sdk.dto.Filter;
import com.checkmarx.sdk.dto.filtering.EngineFilterConfiguration;
import com.checkmarx.sdk.dto.filtering.FilterInput;
import com.checkmarx.sdk.exception.CheckmarxRuntimeException;
import groovy.lang.Binding;
import groovy.lang.GroovyRuntimeException;
import groovy.lang.Script;
import java.lang.reflect.Field;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class FilterValidator {
    private static final Logger log = LoggerFactory.getLogger(FilterValidator.class);
    public static final Locale NUMERIC_CONVERSION_LOCALE = Locale.ROOT;
    private static final String INPUT_VARIABLE_NAME = "finding";
    private final NumberFormat numberFormat = NumberFormat.getInstance(NUMERIC_CONVERSION_LOCALE);

    public boolean passesFilter(@NotNull FilterInput finding, EngineFilterConfiguration filterConfiguration) {
        boolean hasSimpleFilters = FilterValidator.hasSimpleFilters(filterConfiguration);
        boolean hasScriptedFilter = FilterValidator.hasScriptedFilter(filterConfiguration);
        if (hasScriptedFilter && hasSimpleFilters) {
            throw new CheckmarxRuntimeException("Simple filters and scripted filter cannot be used together. Please either specify one of them or don't use filters.");
        }
        boolean result = !hasSimpleFilters && !hasScriptedFilter ? true : (hasScriptedFilter ? FilterValidator.passesScriptedFilter(finding, filterConfiguration) : this.passesSimpleFilter(finding, filterConfiguration));
        FilterValidator.logFilteringResult(finding, result);
        return result;
    }

    private static boolean passesScriptedFilter(FilterInput finding, EngineFilterConfiguration filterConfiguration) {
        Script script = filterConfiguration.getScriptedFilter().getScript();
        Binding binding = new Binding();
        binding.setVariable(INPUT_VARIABLE_NAME, (Object)finding);
        script.setBinding(binding);
        Object rawResult = null;
        try {
            rawResult = script.run();
        }
        catch (GroovyRuntimeException e) {
            FilterValidator.rethrowWithDetailedMessage(e);
        }
        catch (Exception e) {
            throw new CheckmarxRuntimeException("An unexpected error has occurred while executing the filter script.", e);
        }
        if (rawResult instanceof Boolean) {
            return (Boolean)rawResult;
        }
        throw new CheckmarxRuntimeException("Filtering script must return a boolean value.");
    }

    private boolean passesSimpleFilter(FilterInput finding, EngineFilterConfiguration filterConfiguration) {
        List<Filter> filters = filterConfiguration.getSimpleFilters();
        return CollectionUtils.isEmpty(filters) || this.findingPassesFilter(finding, filters);
    }

    private static boolean hasScriptedFilter(EngineFilterConfiguration filterConfiguration) {
        return filterConfiguration != null && filterConfiguration.getScriptedFilter() != null && filterConfiguration.getScriptedFilter().getScript() != null;
    }

    private static boolean hasSimpleFilters(EngineFilterConfiguration filterConfiguration) {
        return filterConfiguration != null && CollectionUtils.isNotEmpty(filterConfiguration.getSimpleFilters());
    }

    private boolean findingPassesFilter(FilterInput finding, List<Filter> filters) {
        Map<Filter.Type, List<String>> valuesByType = FilterValidator.groupFilterValuesByFilterType(filters);
        return FilterValidator.fieldMatches(finding.getStatus(), valuesByType.get((Object)Filter.Type.STATUS)) && FilterValidator.fieldMatches(finding.getState(), valuesByType.get((Object)Filter.Type.STATE)) && FilterValidator.fieldMatches(finding.getSeverity(), valuesByType.get((Object)Filter.Type.SEVERITY)) && FilterValidator.fieldMatches(finding.getCwe(), valuesByType.get((Object)Filter.Type.CWE)) && FilterValidator.fieldMatches(finding.getCategory(), valuesByType.get((Object)Filter.Type.TYPE)) && this.scoreIsAtLeast(finding.getScore(), valuesByType.get((Object)Filter.Type.SCORE));
    }

    private boolean scoreIsAtLeast(Double scoreToCheck, List<String> filterValues) {
        Double minAllowedScore;
        boolean passes = true;
        if (scoreToCheck != null && (minAllowedScore = this.getNumericScore(filterValues)) != null) {
            passes = scoreToCheck >= minAllowedScore;
        }
        return passes;
    }

    private Double getNumericScore(List<String> filterValues) {
        Double result = null;
        if (!CollectionUtils.isEmpty(filterValues)) {
            if (filterValues.size() == 1) {
                String scoreString = filterValues.get(0);
                if (!StringUtils.isEmpty((CharSequence)scoreString)) {
                    try {
                        result = this.numberFormat.parse(scoreString).doubleValue();
                    }
                    catch (ParseException e) {
                        log.warn("Invalid {} filter value: '{}', ignoring.", (Object)Filter.Type.SCORE, (Object)scoreString);
                    }
                } else {
                    log.debug("{} is empty. ignoring", (Object)Filter.Type.SCORE);
                }
            } else {
                log.warn("More than 1 {} filter is specified, ignoring.", (Object)Filter.Type.SCORE);
            }
        }
        return result;
    }

    private static Map<Filter.Type, List<String>> groupFilterValuesByFilterType(List<Filter> filters) {
        Map<Filter.Type, List<String>> valuesByType = Arrays.stream(Filter.Type.values()).collect(Collectors.toMap(Function.identity(), filterType -> new ArrayList()));
        for (Filter filter : filters) {
            List<String> targetList = valuesByType.get((Object)filter.getType());
            String safeValue = StringUtils.defaultString((String)filter.getValue());
            targetList.add(safeValue.toUpperCase(Locale.ROOT));
        }
        return valuesByType;
    }

    private static void rethrowWithDetailedMessage(GroovyRuntimeException cause) {
        List existingFields = Arrays.stream(FilterInput.class.getDeclaredFields()).map(Field::getName).collect(Collectors.toList());
        String message = String.format("A runtime error has occurred while executing the filter script. Please use %s.<property> in your expressions, where <property> is one of %s.", INPUT_VARIABLE_NAME, existingFields);
        throw new CheckmarxRuntimeException(message, cause);
    }

    private static boolean fieldMatches(String fieldValue, List<String> allowedValues) {
        return allowedValues.isEmpty() || allowedValues.contains(fieldValue.toUpperCase(Locale.ROOT));
    }

    private static void logFilteringResult(FilterInput finding, boolean passes) {
        if (log.isDebugEnabled()) {
            String idForLog = StringUtils.isNotEmpty((CharSequence)finding.getId()) ? finding.getId() : "n/a";
            String message = passes ? "passes" : "does not pass";
            log.debug("Finding (ID: {}) {} the filter.", (Object)idForLog, (Object)message);
        }
    }
}

