/*
 * Decompiled with CFR 0.152.
 */
package com.checkmarx.sdk.service;

import com.checkmarx.sdk.config.CxProperties;
import com.checkmarx.sdk.config.CxPropertiesBase;
import com.checkmarx.sdk.dto.Filter;
import com.checkmarx.sdk.dto.ScanResults;
import com.checkmarx.sdk.dto.cx.CxCreateProject;
import com.checkmarx.sdk.dto.cx.CxOsa;
import com.checkmarx.sdk.dto.cx.CxOsaLib;
import com.checkmarx.sdk.dto.cx.CxProject;
import com.checkmarx.sdk.dto.cx.CxProjectSource;
import com.checkmarx.sdk.dto.cx.CxRole;
import com.checkmarx.sdk.dto.cx.CxRoleLdap;
import com.checkmarx.sdk.dto.cx.CxScan;
import com.checkmarx.sdk.dto.cx.CxScanParams;
import com.checkmarx.sdk.dto.cx.CxScanSettings;
import com.checkmarx.sdk.dto.cx.CxScanSummary;
import com.checkmarx.sdk.dto.cx.CxTeam;
import com.checkmarx.sdk.dto.cx.CxTeamLdap;
import com.checkmarx.sdk.dto.cx.xml.CxXMLResultsType;
import com.checkmarx.sdk.dto.cx.xml.PathNodeType;
import com.checkmarx.sdk.dto.cx.xml.PathType;
import com.checkmarx.sdk.dto.cx.xml.QueryType;
import com.checkmarx.sdk.dto.cx.xml.ResultType;
import com.checkmarx.sdk.dto.filtering.EngineFilterConfiguration;
import com.checkmarx.sdk.dto.filtering.FilterConfiguration;
import com.checkmarx.sdk.dto.filtering.FilterInput;
import com.checkmarx.sdk.exception.CheckmarxException;
import com.checkmarx.sdk.exception.InvalidCredentialsException;
import com.checkmarx.sdk.service.CxAuthService;
import com.checkmarx.sdk.service.CxClient;
import com.checkmarx.sdk.service.CxLegacyService;
import com.checkmarx.sdk.service.FilterInputFactory;
import com.checkmarx.sdk.service.FilterValidator;
import com.checkmarx.sdk.service.ScanSettingsClient;
import com.checkmarx.sdk.utils.ScanUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestTemplate;

@Service
public class CxService
implements CxClient {
    private static final String UNKNOWN = "-1";
    private static final Integer UNKNOWN_INT = -1;
    private static final Integer SCAN_STATUS_NEW = 1;
    private static final Integer SCAN_STATUS_PRESCAN = 2;
    private static final Integer SCAN_STATUS_QUEUED = 3;
    private static final Integer SCAN_STATUS_SCANNING = 4;
    private static final Integer SCAN_STATUS_POST_SCAN = 6;
    private static final Integer SCAN_STATUS_FINISHED = 7;
    private static final Integer SCAN_STATUS_CANCELED = 8;
    private static final Integer SCAN_STATUS_FAILED = 9;
    private static final Integer SCAN_STATUS_SOURCE_PULLING = 10;
    private static final Integer SCAN_STATUS_NONE = 1001;
    public static final Integer REPORT_STATUS_CREATED = 2;
    private static final Map<String, Integer> STATE_MAP = ImmutableMap.of((Object)"TO VERIFY", (Object)0, (Object)"CONFIRMED", (Object)2, (Object)"URGENT", (Object)3, (Object)"PROPOSED NOT EXPLOITABLE", (Object)4);
    private static final Logger log = LoggerFactory.getLogger(CxService.class);
    private static final String TEAMS = "/auth/teams";
    private static final String TEAM = "/auth/teams/{id}";
    private static final String TEAM_LDAP_MAPPINGS_UPDATE = "/auth/LDAPServers/{id}/TeamMappings";
    private static final String TEAM_LDAP_MAPPINGS = "/auth/LDAPTeamMappings?ldapServerId={id}";
    private static final String TEAM_LDAP_MAPPINGS_DELETE = "/auth/LDAPTeamMappings/{id}";
    private static final String ROLE = "/auth/Roles";
    private static final String ROLE_LDAP_MAPPING = "/auth/LDAPServers/{id}/RoleMappings";
    private static final String ROLE_LDAP_MAPPINGS = "/auth/LDAPRoleMappings?ldapServerId={id}";
    private static final String ROLE_LDAP_MAPPINGS_DELETE = "/auth/LDAPRoleMappings/{id}";
    private static final String LDAP_SERVER = "/auth/LDAPServers";
    private static final String PROJECTS = "/projects";
    private static final String PROJECT = "/projects/{id}";
    private static final String PROJECT_BRANCH = "/projects/{id}/branch";
    private static final String PROJECT_SOURCE = "/projects/{id}/sourceCode/remoteSettings/git";
    private static final String PROJECT_SOURCE_FILE = "/projects/{id}/sourceCode/attachments";
    private static final String PROJECT_EXCLUDE = "/projects/{id}/sourceCode/excludeSettings";
    private static final String SCAN = "/sast/scans";
    private static final String SCAN_SUMMARY = "/sast/scans/{id}/resultsStatistics";
    private static final String PROJECT_SCANS = "/sast/scans?projectId={pid}";
    private static final String SCAN_STATUS = "/sast/scans/{id}";
    private static final String REPORT = "/reports/sastScan";
    private static final String REPORT_DOWNLOAD = "/reports/sastScan/{id}";
    private static final String REPORT_STATUS = "/reports/sastScan/{id}/status";
    private static final String SCAN_QUEUE_STATUS = "/sast/scansQueue/{id}";
    private static final String SCAN_QUEUE = "/sast/scansQueue";
    private static final String OSA_VULN = "Vulnerable_Library";
    private static final ObjectMapper objectMapper = new ObjectMapper();
    public static final String REPORT_LENGTH_MESSAGE = "Report length: {}";
    public static final String ERROR_PROCESSING_RESULTS = "Error while processing scan results for report Id ";
    public static final String ERROR_WITH_XML_REPORT = "Error with XML report";
    public static final String ERROR_PROCESSING_SCAN_RESULTS = "Error while processing scan results";
    public static final String ERROR_GETTING_PROJECT = "Error occurred while retrieving project with id {}, http error {}";
    public static final String FOUND_TEAM = "Found team {} with ID {}";
    public static final String ONLY_SUPPORTED_IN_90_PLUS = "Operation only supported in 9.0+";
    public static final String ERROR_GETTING_TEAMS = "Error occurred while retrieving Teams";
    public static final String SCAN_CREATION_ERROR = "Error occurred while creating Scan for project {}, http error {}";
    public static final String INTERRUPTED_EXCEPTION_MESSAGE = "Interrupted Exception Occurred";
    private final CxProperties cxProperties;
    private final CxLegacyService cxLegacyService;
    private final CxAuthService authClient;
    private final RestTemplate restTemplate;
    private final ScanSettingsClient scanSettingsClient;
    private final FilterInputFactory filterInputFactory;
    private final FilterValidator filterValidator;

    public CxService(CxAuthService authClient, CxProperties cxProperties, CxLegacyService cxLegacyService, @Qualifier(value="cxRestTemplate") RestTemplate restTemplate, ScanSettingsClient scanSettingsClient, FilterInputFactory filterInputFactory, FilterValidator filterValidator) {
        this.authClient = authClient;
        this.cxProperties = cxProperties;
        this.cxLegacyService = cxLegacyService;
        this.restTemplate = restTemplate;
        this.scanSettingsClient = scanSettingsClient;
        this.filterValidator = filterValidator;
        this.filterInputFactory = filterInputFactory;
    }

    public Integer createScan(Integer projectId, boolean incremental, boolean isPublic, boolean forceScan, String comment) {
        CxScan scan = CxScan.builder().projectId(projectId).isIncremental(incremental).forceScan(forceScan).isPublic(isPublic).comment(comment).build();
        HttpEntity requestEntity = new HttpEntity((Object)scan, (MultiValueMap)this.authClient.createAuthHeaders());
        log.info("Creating Scan for project Id {}", (Object)projectId);
        try {
            String response = (String)this.restTemplate.postForObject(this.cxProperties.getUrl().concat(SCAN), (Object)requestEntity, String.class, new Object[0]);
            JSONObject obj = new JSONObject(response);
            String id = obj.get("id").toString();
            log.info("Scan created with Id {} for project Id {}", (Object)id, (Object)projectId);
            return Integer.parseInt(id);
        }
        catch (HttpStatusCodeException e) {
            log.error(SCAN_CREATION_ERROR, (Object)projectId, (Object)e.getStatusCode());
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            return UNKNOWN_INT;
        }
    }

    @Override
    public Integer getLastScanId(Integer projectId) {
        HttpEntity requestEntity = new HttpEntity((MultiValueMap)this.authClient.createAuthHeaders());
        log.info("Finding last Scan Id for project Id {}", (Object)projectId);
        try {
            ResponseEntity response = this.restTemplate.exchange(this.cxProperties.getUrl().concat(SCAN).concat("?projectId=").concat(projectId.toString().concat("&scanStatus=").concat(SCAN_STATUS_FINISHED.toString()).concat("&last=1")), HttpMethod.GET, requestEntity, String.class, new Object[0]);
            JSONArray arr = new JSONArray((String)response.getBody());
            if (arr.length() < 1) {
                return UNKNOWN_INT;
            }
            JSONObject obj = arr.getJSONObject(0);
            String id = obj.get("id").toString();
            log.info("Scan found with Id {} for project Id {}", (Object)id, (Object)projectId);
            return Integer.parseInt(id);
        }
        catch (HttpStatusCodeException e) {
            log.error(SCAN_CREATION_ERROR, (Object)projectId, (Object)e.getStatusCode());
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            return UNKNOWN_INT;
        }
    }

    @Override
    public JSONObject getScanData(String scanId) {
        HttpEntity requestEntity = new HttpEntity((MultiValueMap)this.authClient.createAuthHeaders());
        JSONObject scanData = new JSONObject();
        log.info("Fetching Scan data for Id {}", (Object)scanId);
        try {
            ResponseEntity response = this.restTemplate.exchange(this.cxProperties.getUrl().concat(SCAN).concat("/").concat(scanId), HttpMethod.GET, requestEntity, String.class, new Object[0]);
            scanData = new JSONObject((String)response.getBody());
        }
        catch (HttpStatusCodeException e) {
            log.error("Error occurred while fetching Scan data for scan Id {}, http error {}", (Object)scanId, (Object)e.getStatusCode());
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        return scanData;
    }

    @Override
    public LocalDateTime getLastScanDate(Integer projectId) {
        HttpEntity requestEntity = new HttpEntity((MultiValueMap)this.authClient.createAuthHeaders());
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss");
        log.info("Finding last Scan Id for project Id {}", (Object)projectId);
        try {
            ResponseEntity response = this.restTemplate.exchange(this.cxProperties.getUrl().concat(SCAN).concat("?projectId=").concat(projectId.toString().concat("&scanStatus=").concat(SCAN_STATUS_FINISHED.toString()).concat("&last=").concat(this.cxProperties.getIncrementalNumScans().toString())), HttpMethod.GET, requestEntity, String.class, new Object[0]);
            JSONArray arr = new JSONArray((String)response.getBody());
            for (int i = 0; i < arr.length(); ++i) {
                JSONObject scan = arr.getJSONObject(i);
                if (scan.getBoolean("isIncremental")) continue;
                JSONObject dateAndTime = scan.getJSONObject("dateAndTime");
                log.debug("Last full scan was {}", (Object)dateAndTime);
                try {
                    String finishedOn = dateAndTime.getString("finishedOn");
                    finishedOn = finishedOn.substring(0, 19);
                    log.debug("finishedOn: {}", (Object)finishedOn);
                    LocalDateTime d = LocalDateTime.parse(finishedOn, formatter);
                    return d;
                }
                catch (DateTimeParseException e) {
                    log.warn("Error Parsing last finished scan time {}", (Object)e.getParsedString());
                    log.error(ExceptionUtils.getStackTrace((Throwable)e));
                    return null;
                }
            }
        }
        catch (HttpStatusCodeException e) {
            log.error(SCAN_CREATION_ERROR, (Object)projectId, (Object)e.getStatusCode());
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        catch (NullPointerException e) {
            log.error("Error parsing JSON response for dateAndTime status. {}", (Object)ExceptionUtils.getMessage((Throwable)e));
        }
        return null;
    }

    @Override
    public Integer getScanStatus(Integer scanId) {
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)this.authClient.createAuthHeaders());
        log.debug("Retrieving xml status of xml Id {}", (Object)scanId);
        try {
            ResponseEntity projects = this.restTemplate.exchange(this.cxProperties.getUrl().concat(SCAN_STATUS), HttpMethod.GET, httpEntity, String.class, new Object[]{scanId});
            JSONObject obj = new JSONObject((String)projects.getBody());
            JSONObject status = obj.getJSONObject("status");
            log.debug("status id {}, status name {}", (Object)status.getInt("id"), (Object)status.getString("name"));
            return status.getInt("id");
        }
        catch (HttpStatusCodeException e) {
            log.error("HTTP Status Code of {} while getting xml status for xml Id {}", (Object)e.getStatusCode(), (Object)scanId);
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        catch (JSONException e) {
            log.error("Error processing JSON Response");
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        return UNKNOWN_INT;
    }

    @Override
    public Integer createScanReport(Integer scanId) {
        String strJSON = "{'reportType':'XML', 'scanId':%d}";
        strJSON = String.format(strJSON, scanId);
        HttpEntity requestEntity = new HttpEntity((Object)strJSON, (MultiValueMap)this.authClient.createAuthHeaders());
        try {
            log.info("Creating report for xml Id {}", (Object)scanId);
            ResponseEntity response = this.restTemplate.exchange(this.cxProperties.getUrl().concat(REPORT), HttpMethod.POST, requestEntity, String.class, new Object[0]);
            JSONObject obj = new JSONObject((String)response.getBody());
            Integer id = obj.getInt("reportId");
            log.info("Report with Id {} created", (Object)id);
            return id;
        }
        catch (HttpStatusCodeException e) {
            log.error("HTTP Status Code of {} while creating xml report for xml Id {}", (Object)e.getStatusCode(), (Object)scanId);
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        catch (JSONException e) {
            log.error("Error processing JSON Response");
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        return UNKNOWN_INT;
    }

    @Override
    public Integer getReportStatus(Integer reportId) throws CheckmarxException {
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)this.authClient.createAuthHeaders());
        log.info("Retrieving report status of report Id {}", (Object)reportId);
        try {
            ResponseEntity projects = this.restTemplate.exchange(this.cxProperties.getUrl().concat(REPORT_STATUS), HttpMethod.GET, httpEntity, String.class, new Object[]{reportId});
            JSONObject obj = new JSONObject((String)projects.getBody());
            JSONObject status = obj.getJSONObject("status");
            log.debug("Report status is {} - {} for report Id {}", new Object[]{status.getInt("id"), status.getString("value"), reportId});
            return status.getInt("id");
        }
        catch (HttpStatusCodeException e) {
            log.error("HTTP Status Code of {} while getting report status for report Id {}", (Object)e.getStatusCode(), (Object)reportId);
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new CheckmarxException("HTTP Error ".concat(ExceptionUtils.getRootCauseMessage((Throwable)e)));
        }
        catch (JSONException e) {
            log.error("Error processing JSON Response");
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new CheckmarxException("JSON Parse Error ".concat(ExceptionUtils.getRootCauseMessage((Throwable)e)));
        }
    }

    private void waitForReportCreateOrFail(Integer reportId) throws CheckmarxException, InterruptedException {
        Thread.sleep(this.cxProperties.getReportPolling().intValue());
        int timer = 0;
        while (!this.getReportStatus(reportId).equals(REPORT_STATUS_CREATED)) {
            Thread.sleep(this.cxProperties.getReportPolling().intValue());
            if ((timer += this.cxProperties.getReportPolling().intValue()) < this.cxProperties.getReportTimeout()) continue;
            log.error("Report Generation timeout.  {}", (Object)this.cxProperties.getReportTimeout());
            throw new CheckmarxException("Timeout exceeded during report generation");
        }
    }

    @Override
    public ScanResults getReportContentByScanId(Integer scanId, FilterConfiguration filter) throws CheckmarxException {
        Integer reportId = this.createScanReport(scanId);
        try {
            this.waitForReportCreateOrFail(reportId);
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            Thread.currentThread().interrupt();
            throw new CheckmarxException(INTERRUPTED_EXCEPTION_MESSAGE);
        }
        return this.getReportContent(reportId, filter);
    }

    @Override
    public ScanResults getReportContent(Integer reportId, FilterConfiguration filter) throws CheckmarxException {
        HttpHeaders headers = this.authClient.createAuthHeaders();
        headers.setContentType(MediaType.APPLICATION_XML);
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        String session = null;
        try {
            session = this.authClient.getLegacySession();
        }
        catch (InvalidCredentialsException e) {
            log.error("Error occurring while logging into Legacy SOAP based WebService - issue description will remain blank");
        }
        log.info("Retrieving report contents of report Id {} in XML format", (Object)reportId);
        try {
            CxXMLResultsType cxResults;
            ResponseEntity resultsXML = this.restTemplate.exchange(this.cxProperties.getUrl().concat(REPORT_DOWNLOAD), HttpMethod.GET, httpEntity, String.class, new Object[]{reportId});
            String xml = (String)resultsXML.getBody();
            log.debug(REPORT_LENGTH_MESSAGE, (Object)xml.length());
            log.debug("Headers: {}", (Object)resultsXML.getHeaders().toSingleValueMap());
            log.info("Report downloaded for report Id {}", (Object)reportId);
            log.trace("XML String Output: {}", (Object)xml);
            log.trace("Base64: {}", (Object)Base64.getEncoder().encodeToString(resultsXML.toString().getBytes()));
            xml = xml.trim().replaceFirst("^([\\W]+)<", "<");
            log.debug(REPORT_LENGTH_MESSAGE, (Object)xml.length());
            String xml2 = ScanUtils.cleanStringUTF8_2(xml);
            log.trace("XML2: {}", (Object)xml2);
            ByteArrayInputStream xmlStream = new ByteArrayInputStream(Objects.requireNonNull(xml2.getBytes()));
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{CxXMLResultsType.class});
            XMLInputFactory xif = XMLInputFactory.newInstance();
            xif.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
            xif.setProperty("javax.xml.stream.supportDTD", false);
            xif.setProperty("javax.xml.stream.isNamespaceAware", false);
            ArrayList<ScanResults.XIssue> xIssueList = new ArrayList<ScanResults.XIssue>();
            try {
                XMLStreamReader xsr = xif.createXMLStreamReader(xmlStream);
                Unmarshaller unmarshaller = jc.createUnmarshaller();
                cxResults = (CxXMLResultsType)unmarshaller.unmarshal(xsr);
            }
            catch (UnmarshalException e) {
                log.warn("Issue occurred performing unmashall step - trying again {}", (Object)ExceptionUtils.getMessage((Throwable)e));
                if (resultsXML.getBody() != null) {
                    log.error("Writing raw response from CX to {}", (Object)"CX_".concat(String.valueOf(reportId)));
                    ScanUtils.writeByte("CX_".concat(String.valueOf(reportId)), ((String)resultsXML.getBody()).getBytes());
                    xml2 = ScanUtils.cleanStringUTF8(xml);
                    xmlStream = new ByteArrayInputStream(Objects.requireNonNull(xml2.getBytes()));
                    XMLStreamReader xsr = xif.createXMLStreamReader(xmlStream);
                    Unmarshaller unmarshaller = jc.createUnmarshaller();
                    cxResults = (CxXMLResultsType)unmarshaller.unmarshal(xsr);
                }
                log.error("CX Response for report {} was null", (Object)reportId);
                throw new CheckmarxException("CX report was empty (null)");
            }
            ScanResults.ScanResultsBuilder cxScanBuilder = ScanResults.builder();
            cxScanBuilder.projectId(cxResults.getProjectId());
            cxScanBuilder.team(cxResults.getTeam());
            cxScanBuilder.project(cxResults.getProjectName());
            cxScanBuilder.link(cxResults.getDeepLink());
            cxScanBuilder.files(cxResults.getFilesScanned());
            cxScanBuilder.loc(cxResults.getLinesOfCodeScanned());
            cxScanBuilder.scanType(cxResults.getScanType());
            Map<String, Integer> summary = this.getIssues(filter, session, xIssueList, cxResults);
            cxScanBuilder.xIssues(xIssueList);
            cxScanBuilder.additionalDetails(this.getAdditionalScanDetails(cxResults));
            CxScanSummary scanSummary = this.getScanSummaryByScanId(Integer.valueOf(cxResults.getScanId()));
            cxScanBuilder.scanSummary(scanSummary);
            ScanResults results = cxScanBuilder.build();
            results.getAdditionalDetails().put("flow-summary", summary);
            if (this.cxProperties.getPreserveXml().booleanValue()) {
                results.setOutput(xml);
            }
            return results;
        }
        catch (HttpStatusCodeException e) {
            log.error("HTTP Status Code of {} while getting downloading report contents of report Id {}", (Object)e.getStatusCode(), (Object)reportId);
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new CheckmarxException("Error while processing scan results for report Id {}".concat(reportId.toString()));
        }
        catch (JAXBException | XMLStreamException e) {
            log.error(ERROR_WITH_XML_REPORT);
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new CheckmarxException(ERROR_PROCESSING_RESULTS.concat(reportId.toString()));
        }
        catch (NullPointerException e) {
            log.info("Null Error");
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new CheckmarxException(ERROR_PROCESSING_RESULTS.concat(reportId.toString()));
        }
    }

    @Override
    public CxXMLResultsType getXmlReportContent(Integer reportId) throws CheckmarxException {
        HttpHeaders headers = this.authClient.createAuthHeaders();
        headers.setContentType(MediaType.APPLICATION_XML);
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        log.info("Retrieving report contents of report Id {} in XML format", (Object)reportId);
        try {
            ResponseEntity resultsXML = this.restTemplate.exchange(this.cxProperties.getUrl().concat(REPORT_DOWNLOAD), HttpMethod.GET, httpEntity, String.class, new Object[]{reportId});
            String xml = (String)resultsXML.getBody();
            log.debug(REPORT_LENGTH_MESSAGE, (Object)xml.length());
            log.debug("Headers: {}", (Object)resultsXML.getHeaders().toSingleValueMap());
            log.info("Report downloaded for report Id {}", (Object)reportId);
            log.debug("XML String Output: {}", (Object)xml);
            log.debug("Base64: {}", (Object)Base64.getEncoder().encodeToString(resultsXML.toString().getBytes()));
            xml = xml.trim().replaceFirst("^([\\W]+)<", "<");
            log.debug(REPORT_LENGTH_MESSAGE, (Object)xml.length());
            String xml2 = ScanUtils.cleanStringUTF8_2(xml);
            log.trace("XML2: {}", (Object)xml2);
            ByteArrayInputStream xmlStream = new ByteArrayInputStream(Objects.requireNonNull(xml2.getBytes()));
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{CxXMLResultsType.class});
            XMLInputFactory xif = XMLInputFactory.newInstance();
            xif.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
            xif.setProperty("javax.xml.stream.supportDTD", false);
            xif.setProperty("javax.xml.stream.isNamespaceAware", false);
            try {
                XMLStreamReader xsr = xif.createXMLStreamReader(xmlStream);
                Unmarshaller unmarshaller = jc.createUnmarshaller();
                return (CxXMLResultsType)unmarshaller.unmarshal(xsr);
            }
            catch (UnmarshalException e) {
                log.warn("Issue occurred performing unmashall step - trying again {}", (Object)ExceptionUtils.getMessage((Throwable)e));
                if (resultsXML.getBody() != null) {
                    log.error("Writing raw response from CX to {}", (Object)"CX_".concat(String.valueOf(reportId)));
                    ScanUtils.writeByte("CX_".concat(String.valueOf(reportId)), ((String)resultsXML.getBody()).getBytes());
                    xml2 = ScanUtils.cleanStringUTF8(xml);
                    xmlStream = new ByteArrayInputStream(Objects.requireNonNull(xml2.getBytes()));
                    XMLStreamReader xsr = xif.createXMLStreamReader(xmlStream);
                    Unmarshaller unmarshaller = jc.createUnmarshaller();
                    return (CxXMLResultsType)unmarshaller.unmarshal(xsr);
                }
                log.error("CX Response for report {} was null", (Object)reportId);
                throw new CheckmarxException("CX report was empty (null)");
            }
        }
        catch (HttpStatusCodeException e) {
            log.error("HTTP Status Code of {} while getting downloading report contents of report Id {}", (Object)e.getStatusCode(), (Object)reportId);
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new CheckmarxException(ERROR_PROCESSING_RESULTS.concat(reportId.toString()));
        }
        catch (JAXBException | XMLStreamException e) {
            log.error(ERROR_WITH_XML_REPORT);
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new CheckmarxException(ERROR_PROCESSING_RESULTS.concat(reportId.toString()));
        }
        catch (NullPointerException e) {
            log.info("Null Error");
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new CheckmarxException(ERROR_PROCESSING_RESULTS.concat(reportId.toString()));
        }
    }

    protected Map<String, Object> getAdditionalScanDetails(CxXMLResultsType cxResults) {
        HashMap<String, Object> additionalDetails = new HashMap<String, Object>();
        additionalDetails.put("scanId", cxResults.getScanId());
        additionalDetails.put("scanStartDate", cxResults.getScanStart());
        if (!this.cxProperties.getOffline().booleanValue()) {
            JSONObject jsonObject = this.getScanData(cxResults.getScanId());
            if (jsonObject != null) {
                additionalDetails.put("scanRisk", String.valueOf(jsonObject.getInt("scanRisk")));
                additionalDetails.put("scanRiskSeverity", String.valueOf(jsonObject.getInt("scanRiskSeverity")));
                JSONObject scanState = jsonObject.getJSONObject("scanState");
                if (scanState != null) {
                    additionalDetails.put("numFailedLoc", String.valueOf(scanState.getInt("failedLinesOfCode")));
                }
            }
            Map<String, String> customFields = this.getCustomFields(Integer.valueOf(cxResults.getProjectId()));
            additionalDetails.put("customFields", customFields);
        }
        return additionalDetails;
    }

    @Override
    public Map<String, String> getCustomFields(Integer projectId) {
        HashMap<String, String> customFields = new HashMap<String, String>();
        log.info("Fetching custom fields from project ID ".concat(projectId.toString()));
        CxProject cxProject = this.getProject(projectId);
        if (cxProject != null) {
            for (CxProject.CustomField customField : cxProject.getCustomFields()) {
                customFields.put(customField.getName(), customField.getValue());
            }
        } else {
            log.error("Could not find project with ID ".concat(projectId.toString()));
        }
        return customFields;
    }

    @Override
    public ScanResults getReportContent(File file, FilterConfiguration filter) throws CheckmarxException {
        if (file == null) {
            throw new CheckmarxException("File not provided for processing of results");
        }
        String session = null;
        try {
            if (!this.cxProperties.getOffline().booleanValue()) {
                session = this.authClient.getLegacySession();
            }
        }
        catch (InvalidCredentialsException e) {
            log.error("Error occurring while logging into Legacy SOAP based WebService - issue description will remain blank");
        }
        try {
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{CxXMLResultsType.class});
            XMLInputFactory xif = XMLInputFactory.newInstance();
            xif.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
            xif.setProperty("javax.xml.stream.supportDTD", false);
            xif.setProperty("javax.xml.stream.isNamespaceAware", false);
            Unmarshaller unmarshaller = jc.createUnmarshaller();
            ArrayList<ScanResults.XIssue> issueList = new ArrayList<ScanResults.XIssue>();
            CxXMLResultsType cxResults = (CxXMLResultsType)unmarshaller.unmarshal(file);
            ScanResults.ScanResultsBuilder cxScanBuilder = ScanResults.builder();
            cxScanBuilder.projectId(cxResults.getProjectId());
            cxScanBuilder.team(cxResults.getTeam());
            cxScanBuilder.project(cxResults.getProjectName());
            cxScanBuilder.link(cxResults.getDeepLink());
            cxScanBuilder.files(cxResults.getFilesScanned());
            cxScanBuilder.loc(cxResults.getLinesOfCodeScanned());
            cxScanBuilder.scanType(cxResults.getScanType());
            Map<String, Integer> summary = this.getIssues(filter, session, issueList, cxResults);
            cxScanBuilder.xIssues(issueList);
            cxScanBuilder.additionalDetails(this.getAdditionalScanDetails(cxResults));
            ScanResults results = cxScanBuilder.build();
            if (!this.cxProperties.getOffline().booleanValue() && !ScanUtils.empty(cxResults.getScanId())) {
                CxScanSummary scanSummary = this.getScanSummaryByScanId(Integer.valueOf(cxResults.getScanId()));
                results.setScanSummary(scanSummary);
            }
            results.getAdditionalDetails().put("flow-summary", summary);
            return results;
        }
        catch (JAXBException e) {
            log.error(ERROR_WITH_XML_REPORT);
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new CheckmarxException(ERROR_PROCESSING_SCAN_RESULTS);
        }
        catch (NullPointerException e) {
            log.info("Null error");
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new CheckmarxException(ERROR_PROCESSING_SCAN_RESULTS);
        }
    }

    @Override
    public ScanResults getOsaReportContent(File vulnsFile, File libsFile, List<Filter> filter) throws CheckmarxException {
        if (vulnsFile == null || libsFile == null) {
            throw new CheckmarxException("Files not provided for processing of OSA results");
        }
        try {
            ArrayList<ScanResults.XIssue> issueList = new ArrayList<ScanResults.XIssue>();
            List osaVulns = (List)objectMapper.readValue(vulnsFile, (TypeReference)new TypeReference<List<CxOsa>>(){});
            List osaLibs = (List)objectMapper.readValue(libsFile, (TypeReference)new TypeReference<List<CxOsaLib>>(){});
            Map<String, CxOsaLib> libsMap = this.getOsaLibsMap(osaLibs);
            ImmutableMap severityMap = ImmutableMap.of((Object)"LOW", (Object)1, (Object)"MEDIUM", (Object)2, (Object)"HIGH", (Object)3);
            for (CxOsa o : osaVulns) {
                if (!this.filterOsa(filter, o) || !libsMap.containsKey(o.getLibraryId())) continue;
                CxOsaLib lib = libsMap.get(o.getLibraryId());
                String filename = lib.getName();
                ScanResults.XIssue issue = ScanResults.XIssue.builder().file(filename).vulnerability(OSA_VULN).severity(o.getSeverity().getName()).cve(o.getCveName()).build();
                ScanResults.OsaDetails details = ScanResults.OsaDetails.builder().severity(o.getSeverity().getName()).cve(o.getCveName()).description(o.getDescription()).recommendation(o.getRecommendations()).url(o.getUrl()).version(lib.getVersion()).build();
                if (issueList.contains(issue)) {
                    if ((Integer)severityMap.get((issue = (ScanResults.XIssue)issueList.get(issueList.indexOf(issue))).getSeverity().toUpperCase(Locale.ROOT)) < (Integer)severityMap.get(o.getSeverity().getName().toUpperCase(Locale.ROOT))) {
                        issue.setSeverity(o.getSeverity().getName());
                    }
                    issue.setCve(issue.getCve().concat(",").concat(o.getCveName()));
                    issue.getOsaDetails().add(details);
                    continue;
                }
                ArrayList<ScanResults.OsaDetails> dList = new ArrayList<ScanResults.OsaDetails>();
                dList.add(details);
                issue.setOsaDetails(dList);
                issueList.add(issue);
            }
            return ScanResults.builder().osa(true).xIssues(issueList).build();
        }
        catch (IOException e) {
            log.error("Error parsing JSON OSA report");
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new CheckmarxException(ERROR_PROCESSING_SCAN_RESULTS);
        }
        catch (NullPointerException e) {
            log.info("Null error");
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new CheckmarxException(ERROR_PROCESSING_SCAN_RESULTS);
        }
    }

    @Override
    public String getIssueDescription(Long scanId, Long pathId) {
        return null;
    }

    private boolean filterOsa(List<Filter> filters, CxOsa osa) {
        boolean all = true;
        for (Filter f : filters) {
            if (!f.getType().equals((Object)Filter.Type.SEVERITY)) continue;
            all = false;
            if (!f.getValue().equalsIgnoreCase(osa.getSeverity().getName())) continue;
            return true;
        }
        return all;
    }

    private Map<String, CxOsaLib> getOsaLibsMap(List<CxOsaLib> libs) {
        HashMap<String, CxOsaLib> libMap = new HashMap<String, CxOsaLib>();
        for (CxOsaLib o : libs) {
            libMap.put(o.getId(), o);
        }
        return libMap;
    }

    private Map<String, Integer> getIssues(FilterConfiguration filter, String session, List<ScanResults.XIssue> cxIssueList, CxXMLResultsType cxResults) {
        HashMap<String, Integer> summary = new HashMap<String, Integer>();
        EngineFilterConfiguration sastFilters = Optional.ofNullable(filter).map(FilterConfiguration::getSastFilters).orElse(null);
        for (QueryType result : cxResults.getQuery()) {
            ScanResults.XIssue.XIssueBuilder xIssueBuilder = ScanResults.XIssue.builder();
            for (ResultType resultType : result.getResult()) {
                ScanResults.IssueDetails issueDetails;
                FilterInput filterInput = this.filterInputFactory.createFilterInputForCxSast(result, resultType);
                if (!this.filterValidator.passesFilter(filterInput, sastFilters)) continue;
                boolean falsePositive = false;
                if (!resultType.getFalsePositive().equalsIgnoreCase("FALSE")) {
                    falsePositive = true;
                }
                xIssueBuilder.cwe(result.getCweId());
                xIssueBuilder.language(result.getLanguage());
                xIssueBuilder.severity(result.getSeverity());
                xIssueBuilder.vulnerability(result.getName());
                xIssueBuilder.file(resultType.getFileName());
                xIssueBuilder.severity(resultType.getSeverity());
                xIssueBuilder.link(resultType.getDeepLink());
                xIssueBuilder.vulnerabilityStatus(this.getStateFullName(resultType.getState()));
                xIssueBuilder.queryId(result.getId());
                Map<String, Object> additionalDetails = this.getAdditionalIssueDetails(result, resultType);
                xIssueBuilder.additionalDetails(additionalDetails);
                HashMap<Integer, ScanResults.IssueDetails> details = new HashMap<Integer, ScanResults.IssueDetails>();
                try {
                    if (session != null) {
                        try {
                            xIssueBuilder.description(this.getIssueDescription(session, Long.parseLong(cxResults.getScanId()), Long.parseLong(resultType.getPath().getPathId())));
                        }
                        catch (HttpStatusCodeException e) {
                            xIssueBuilder.description("");
                        }
                    } else {
                        xIssueBuilder.description("");
                    }
                    String snippet = resultType.getPath().getPathNode().get(0).getSnippet().getLine().getCode();
                    snippet = StringUtils.truncate((String)snippet, (int)this.cxProperties.getCodeSnippetLength());
                    issueDetails = new ScanResults.IssueDetails().codeSnippet(snippet).comment(resultType.getRemark()).falsePositive(falsePositive);
                    details.put(Integer.parseInt(resultType.getPath().getPathNode().get(0).getLine()), issueDetails);
                    xIssueBuilder.similarityId(resultType.getPath().getSimilarityId());
                }
                catch (NullPointerException e) {
                    log.warn("Problem grabbing snippet.  Snippet may not exist for finding for Node ID");
                    issueDetails = new ScanResults.IssueDetails().codeSnippet(null).comment(resultType.getRemark()).falsePositive(falsePositive);
                    details.put(Integer.parseInt(resultType.getLine()), issueDetails);
                }
                xIssueBuilder.details(details);
                ScanResults.XIssue issue = xIssueBuilder.build();
                this.prepareIssuesRemoveDuplicates(cxIssueList, resultType, details, falsePositive, issue, summary);
            }
        }
        return summary;
    }

    public String getStateFullName(String key) {
        return (String)MapUtils.invertMap(STATE_MAP).get(Integer.parseInt(key));
    }

    private Map<String, Object> getAdditionalIssueDetails(QueryType q, ResultType r) {
        HashMap<String, Object> additionalDetails = new HashMap<String, Object>();
        additionalDetails.put("categories", q.getCategories());
        String descUrl = ScanUtils.getHostWithProtocol(r.getDeepLink()) + "/CxWebClient/ScanQueryDescription.aspx?queryID=" + q.getId() + "&queryVersionCode=" + q.getQueryVersionCode() + "&queryTitle=" + q.getName();
        additionalDetails.put("recommendedFix", descUrl);
        ArrayList results = new ArrayList();
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("state", r.getState());
        PathType path = r.getPath();
        if (path != null) {
            List<PathNodeType> nodes = path.getPathNode();
            if (!nodes.isEmpty()) {
                result.put("source", this.getNodeData(nodes, 0));
                result.put("sink", this.getNodeData(nodes, nodes.size() - 1));
            } else {
                log.debug(String.format("Result %s%s did not have node paths to process.", q.getName(), r.getNodeId()));
            }
        }
        results.add(result);
        additionalDetails.put("results", results);
        return additionalDetails;
    }

    private Map<String, String> getNodeData(List<PathNodeType> nodes, int nodeIndex) {
        HashMap<String, String> nodeData = new HashMap<String, String>();
        PathNodeType node = nodes.get(nodeIndex);
        nodeData.put("file", node.getFileName());
        nodeData.put("line", node.getLine());
        nodeData.put("column", node.getColumn());
        nodeData.put("object", node.getName());
        return nodeData;
    }

    private void prepareIssuesRemoveDuplicates(List<ScanResults.XIssue> cxIssueList, ResultType resultType, Map<Integer, ScanResults.IssueDetails> details, boolean falsePositive, ScanResults.XIssue issue, Map<String, Integer> summary) {
        if (cxIssueList.contains(issue)) {
            ScanResults.XIssue existingIssue = cxIssueList.get(cxIssueList.indexOf(issue));
            if (!existingIssue.getDetails().containsKey(Integer.parseInt(resultType.getLine()))) {
                if (falsePositive) {
                    existingIssue.setFalsePositiveCount(existingIssue.getFalsePositiveCount() + 1);
                } else {
                    if (!summary.containsKey(resultType.getSeverity())) {
                        summary.put(resultType.getSeverity(), 0);
                    }
                    int severityCount = summary.get(resultType.getSeverity());
                    summary.put(resultType.getSeverity(), ++severityCount);
                }
                existingIssue.getDetails().putAll(details);
            } else {
                ScanResults.IssueDetails existingDetails = existingIssue.getDetails().get(Integer.parseInt(resultType.getLine()));
                ScanResults.IssueDetails newDetails = details.get(Integer.parseInt(resultType.getLine()));
                if (newDetails.isFalsePositive() && !existingDetails.isFalsePositive()) {
                    existingDetails.setFalsePositive(true);
                    existingIssue.setFalsePositiveCount(existingIssue.getFalsePositiveCount() + 1);
                    int severityCount = summary.get(resultType.getSeverity());
                    summary.put(resultType.getSeverity(), --severityCount);
                }
            }
            List results = (List)existingIssue.getAdditionalDetails().get("results");
            results.addAll((List)issue.getAdditionalDetails().get("results"));
        } else {
            if (falsePositive) {
                issue.setFalsePositiveCount(issue.getFalsePositiveCount() + 1);
            } else {
                if (!summary.containsKey(resultType.getSeverity())) {
                    summary.put(resultType.getSeverity(), 0);
                }
                int severityCount = summary.get(resultType.getSeverity());
                summary.put(resultType.getSeverity(), ++severityCount);
            }
            cxIssueList.add(issue);
        }
    }

    private String getIssueDescription(String session, Long scanId, Long pathId) {
        return this.cxLegacyService.getDescription(session, scanId, pathId);
    }

    @Override
    public Integer createProject(String ownerId, String name) {
        CxCreateProject project = CxCreateProject.builder().name(name).owningTeam(ownerId).isPublic(true).build();
        HttpEntity requestEntity = new HttpEntity((Object)project, (MultiValueMap)this.authClient.createAuthHeaders());
        log.info("Creating Project {} for ownerId {}", (Object)name, (Object)ownerId);
        try {
            String response = (String)this.restTemplate.postForObject(this.cxProperties.getUrl().concat(PROJECTS), (Object)requestEntity, String.class, new Object[0]);
            JSONObject obj = new JSONObject(response);
            String id = obj.get("id").toString();
            return Integer.parseInt(id);
        }
        catch (HttpStatusCodeException e) {
            log.error("HTTP error code {} while creating project with name {} under owner id {}", new Object[]{e.getStatusCode(), name, ownerId});
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        catch (JSONException e) {
            log.error("Error processing JSON Response");
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        return UNKNOWN_INT;
    }

    @Override
    public void deleteProject(Integer projectId) {
        this.deleteProject(projectId, false);
    }

    @Override
    public void deleteProject(Integer projectId, boolean deleteRunningScans) {
        String request = new JSONObject().put("deleteRunningScans", deleteRunningScans).toString();
        HttpEntity requestEntity = new HttpEntity((Object)request, (MultiValueMap)this.authClient.createAuthHeaders());
        log.info("Deleting Project id {} with deleteRunningScans={}", (Object)projectId, (Object)deleteRunningScans);
        try {
            this.restTemplate.exchange(this.cxProperties.getUrl().concat(PROJECT), HttpMethod.DELETE, requestEntity, String.class, new Object[]{projectId});
        }
        catch (HttpStatusCodeException e) {
            log.error("HTTP error code {} while deleting project with id {} and deleteRunningScans={}", new Object[]{e.getStatusCode(), projectId, deleteRunningScans});
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    @Override
    public Integer branchProject(Integer projectId, String name) {
        String request = new JSONObject().put("name", (Object)name).toString();
        HttpEntity requestEntity = new HttpEntity((Object)request, (MultiValueMap)this.authClient.createAuthHeaders());
        log.info("Creating branched project with name '{}' from existing project with ID {}", (Object)name, (Object)projectId);
        try {
            String response = (String)this.restTemplate.postForObject(this.cxProperties.getUrl().concat(PROJECT_BRANCH), (Object)requestEntity, String.class, new Object[]{projectId});
            if (response != null) {
                JSONObject obj = new JSONObject(response);
                String id = obj.get("id").toString();
                return Integer.parseInt(id);
            }
            log.error("CX Response for branch project request with name '{}' from existing project with ID {} was null", (Object)name, (Object)projectId);
        }
        catch (HttpStatusCodeException e) {
            log.error("HTTP error code {} while creating branched project with name '{}' from existing project with ID {}", new Object[]{e.getStatusCode(), name, projectId});
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        catch (JSONException e) {
            log.error("Error processing JSON Response while creating branched project with name '{}' from existing project with ID {}", (Object)name, (Object)projectId);
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        return UNKNOWN_INT;
    }

    @Override
    public List<CxProject> getProjects() throws CheckmarxException {
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)this.authClient.createAuthHeaders());
        try {
            ResponseEntity projects = this.restTemplate.exchange(this.cxProperties.getUrl().concat(PROJECTS), HttpMethod.GET, httpEntity, CxProject[].class, new Object[0]);
            if (projects.getBody() != null) {
                return Arrays.asList((Object[])projects.getBody());
            }
            return Collections.emptyList();
        }
        catch (HttpStatusCodeException e) {
            log.warn("Error occurred while retrieving projects, http error {}", (Object)e.getStatusCode());
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new CheckmarxException("Error retrieving Projects");
        }
    }

    @Override
    public List<CxProject> getProjects(String teamId) throws CheckmarxException {
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)this.authClient.createAuthHeaders());
        ArrayList<CxProject> teamProjects = new ArrayList<CxProject>();
        try {
            ResponseEntity projects = this.restTemplate.exchange(this.cxProperties.getUrl().concat(PROJECTS), HttpMethod.GET, httpEntity, CxProject[].class, new Object[0]);
            if (projects.getBody() != null) {
                for (CxProject p : (CxProject[])projects.getBody()) {
                    if (!p.getTeamId().equals(teamId)) continue;
                    teamProjects.add(p);
                }
            }
            return teamProjects;
        }
        catch (HttpStatusCodeException e) {
            log.warn("Error occurred while retrieving projects, http error {}", (Object)e.getStatusCode());
            log.debug(ExceptionUtils.getStackTrace((Throwable)e));
            throw new CheckmarxException("Error retrieving Projects");
        }
    }

    @Override
    public Integer getProjectId(String ownerId, String name) {
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)this.authClient.createAuthHeaders());
        try {
            ResponseEntity projects = this.restTemplate.exchange(this.cxProperties.getUrl().concat(PROJECTS).concat("?projectName=").concat(name).concat("&teamId=").concat(ownerId), HttpMethod.GET, httpEntity, String.class, new Object[0]);
            JSONArray arr = new JSONArray((String)projects.getBody());
            if (arr.length() > 1) {
                return UNKNOWN_INT;
            }
            JSONObject obj = arr.getJSONObject(0);
            return obj.getInt("id");
        }
        catch (HttpStatusCodeException e) {
            if (!e.getStatusCode().equals((Object)HttpStatus.NOT_FOUND)) {
                log.warn("Error occurred while retrieving project with name {}, http error {}", (Object)name, (Object)e.getStatusCode());
                log.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        catch (JSONException e) {
            log.error("Error processing JSON Response");
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        return UNKNOWN_INT;
    }

    @Override
    public CxProject getProject(Integer projectId) {
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)this.authClient.createAuthHeaders());
        try {
            ResponseEntity project = this.restTemplate.exchange(this.cxProperties.getUrl().concat(PROJECT), HttpMethod.GET, httpEntity, CxProject.class, new Object[]{projectId});
            return (CxProject)project.getBody();
        }
        catch (HttpStatusCodeException e) {
            log.error(ERROR_GETTING_PROJECT, (Object)projectId, (Object)e.getStatusCode());
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        catch (JSONException e) {
            log.error("Error processing JSON Response");
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        return null;
    }

    @Override
    public boolean scanExists(Integer projectId) {
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)this.authClient.createAuthHeaders());
        try {
            ResponseEntity scans = this.restTemplate.exchange(this.cxProperties.getUrl().concat(PROJECT_SCANS), HttpMethod.GET, httpEntity, String.class, new Object[]{projectId});
            JSONArray jsonArray = new JSONArray((String)scans.getBody());
            for (int i = 0; i < jsonArray.length(); ++i) {
                JSONObject scan = jsonArray.getJSONObject(i);
                JSONObject status = scan.getJSONObject("status");
                int statusId = status.getInt("id");
                if (!SCAN_STATUS_QUEUED.equals(statusId) && !SCAN_STATUS_NEW.equals(statusId) && !SCAN_STATUS_SCANNING.equals(statusId) && !SCAN_STATUS_PRESCAN.equals(statusId) && !SCAN_STATUS_SOURCE_PULLING.equals(statusId)) continue;
                log.debug("Scan status is {}", (Object)statusId);
                return true;
            }
            log.debug("No scans in the queue that are in progress");
            return false;
        }
        catch (HttpStatusCodeException e) {
            log.error(ERROR_GETTING_PROJECT, (Object)projectId, (Object)e.getStatusCode());
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        catch (JSONException e) {
            log.error("Error processing JSON Response");
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        return false;
    }

    @Override
    public Integer getScanIdOfExistingScanIfExists(Integer projectId) {
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)this.authClient.createAuthHeaders());
        try {
            ResponseEntity scans = this.restTemplate.exchange(this.cxProperties.getUrl().concat(SCAN_QUEUE).concat("?ProjectId=").concat(projectId.toString()), HttpMethod.GET, httpEntity, String.class, new Object[0]);
            JSONArray jsonArray = new JSONArray((String)scans.getBody());
            for (int i = 0; i < jsonArray.length(); ++i) {
                JSONObject scan = jsonArray.getJSONObject(i);
                JSONObject stage = scan.getJSONObject("stage");
                int statusId = stage.getInt("id");
                if (!SCAN_STATUS_QUEUED.equals(statusId) && !SCAN_STATUS_NEW.equals(statusId) && !SCAN_STATUS_SCANNING.equals(statusId) && !SCAN_STATUS_PRESCAN.equals(statusId) && !SCAN_STATUS_SOURCE_PULLING.equals(statusId)) continue;
                log.info("Scan status is {} for Project: {}", (Object)statusId, (Object)projectId);
                Integer scanId = scan.getInt("id");
                return scanId;
            }
            log.info("No scans in the queue that are in progress");
            return UNKNOWN_INT;
        }
        catch (HttpStatusCodeException e) {
            log.error(ERROR_GETTING_PROJECT, (Object)projectId, (Object)e.getStatusCode());
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        catch (JSONException e) {
            log.error("Error processing JSON Response");
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        return UNKNOWN_INT;
    }

    @Override
    public Integer createScanSetting(Integer projectId, Integer presetId, Integer engineConfigId, Integer postActionId) {
        return this.scanSettingsClient.createScanSettings(projectId, presetId, engineConfigId, postActionId);
    }

    @Override
    public String getScanSetting(Integer projectId) {
        return this.scanSettingsClient.getScanSettings(projectId);
    }

    @Override
    public CxScanSettings getScanSettingsDto(int projectId) {
        return this.scanSettingsClient.getScanSettingsDto(projectId);
    }

    @Override
    public Integer getProjectPresetId(Integer projectId) {
        return this.scanSettingsClient.getProjectPresetId(projectId);
    }

    @Override
    public String getPresetName(Integer presetId) {
        return this.scanSettingsClient.getPresetName(presetId);
    }

    @Override
    public void setProjectRepositoryDetails(Integer projectId, String gitUrl, String branch) throws CheckmarxException {
        CxProjectSource projectSource = CxProjectSource.builder().url(gitUrl).branch(branch).build();
        log.debug("branch {}", (Object)branch);
        log.debug("project {}", (Object)projectId);
        HttpEntity requestEntity = new HttpEntity((Object)projectSource, (MultiValueMap)this.authClient.createAuthHeaders());
        try {
            log.info("Updating Source details for project Id {}", (Object)projectId);
            this.restTemplate.exchange(this.cxProperties.getUrl().concat(PROJECT_SOURCE), HttpMethod.POST, requestEntity, String.class, new Object[]{projectId});
        }
        catch (HttpStatusCodeException e) {
            log.error("Error occurred while updating Project source info for project {}.", (Object)projectId);
            throw new CheckmarxException("Error occurred while adding source details to project.  Please ensure GIT is defined within Checkmarx");
        }
    }

    @Override
    public void updateProjectDetails(CxProject cxProject) throws CheckmarxException {
        String strJSON = "{'name':'%s','owningTeam':'%s'}";
        strJSON = String.format(strJSON, cxProject.getName(), cxProject.getTeamId());
        HttpEntity requestEntity = new HttpEntity((Object)strJSON, (MultiValueMap)this.authClient.createAuthHeaders());
        try {
            log.info("Updating details for project {} with id {}", (Object)cxProject.getName(), (Object)cxProject.getId());
            this.restTemplate.exchange(this.cxProperties.getUrl().concat(PROJECT), HttpMethod.PATCH, requestEntity, String.class, new Object[]{cxProject.getId()});
        }
        catch (HttpStatusCodeException e) {
            log.debug(ExceptionUtils.getStackTrace((Throwable)e));
            log.error("Error occurred while updating details for project {}.", (Object)cxProject.getName());
            throw new CheckmarxException("Error occurred while updating project details: " + e.getLocalizedMessage());
        }
    }

    @Override
    public void uploadProjectSource(Integer projectId, File file) throws CheckmarxException {
        HttpHeaders headers = this.authClient.createAuthHeaders();
        headers.setContentType(MediaType.MULTIPART_FORM_DATA);
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        FileSystemResource value = new FileSystemResource(file);
        map.add((Object)"zippedSource", (Object)value);
        HttpEntity requestEntity = new HttpEntity((Object)map, (MultiValueMap)headers);
        try {
            log.info("Updating Source details for project Id {}", (Object)projectId);
            this.restTemplate.exchange(this.cxProperties.getUrl().concat(PROJECT_SOURCE_FILE), HttpMethod.POST, requestEntity, String.class, new Object[]{projectId});
        }
        catch (HttpStatusCodeException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            log.error("Error occurred while uploading Project source for project id {}.", (Object)projectId);
            throw new CheckmarxException("Error occurred while uploading source");
        }
    }

    @Override
    public void setProjectExcludeDetails(Integer projectId, List<String> excludeFolders, List<String> excludeFiles) {
        String excludeFilesStr = "";
        String excludeFolderStr = "";
        if (excludeFiles != null && !excludeFiles.isEmpty()) {
            excludeFilesStr = String.join((CharSequence)",", excludeFiles);
        }
        if (excludeFolders != null && !excludeFolders.isEmpty()) {
            excludeFolderStr = String.join((CharSequence)",", excludeFolders);
        }
        String strJSON = "{'excludeFoldersPattern':'%s', 'excludeFilesPattern':'%s'}";
        strJSON = String.format(strJSON, excludeFolderStr, excludeFilesStr);
        HttpEntity requestEntity = new HttpEntity((Object)strJSON, (MultiValueMap)this.authClient.createAuthHeaders());
        try {
            log.info("Updating Project folder and file exclusion details for project Id {}", (Object)projectId);
            this.restTemplate.exchange(this.cxProperties.getUrl().concat(PROJECT_EXCLUDE), HttpMethod.PUT, requestEntity, String.class, new Object[]{projectId});
        }
        catch (HttpStatusCodeException e) {
            log.error("Error occurred while updating Project source info for project {}.", (Object)projectId);
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    @Override
    public String getTeamId(String teamPath) throws CheckmarxException {
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)this.authClient.createAuthHeaders());
        try {
            List<CxTeam> teams = this.getTeams();
            if (teams == null) {
                throw new CheckmarxException("Error obtaining Team Id");
            }
            for (CxTeam team : teams) {
                if (!team.getFullName().equals(teamPath)) continue;
                log.info(FOUND_TEAM, (Object)teamPath, (Object)team.getId());
                return team.getId();
            }
        }
        catch (HttpStatusCodeException e) {
            log.error(ERROR_GETTING_TEAMS);
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        log.info("No team was found for {}", (Object)teamPath);
        return UNKNOWN;
    }

    @Override
    public String getTeamIdByClientSecret(String teamPath, String clientSecret) {
        return null;
    }

    public String getTeamName(String teamId) throws CheckmarxException {
        try {
            List<CxTeam> teams = this.getTeams();
            if (teams == null) {
                throw new CheckmarxException("Error retrieving Cx teams from the server");
            }
            for (CxTeam team : teams) {
                if (!team.getId().equals(teamId)) continue;
                log.info(FOUND_TEAM, (Object)team.getFullName(), (Object)teamId);
                return team.getFullName();
            }
        }
        catch (HttpStatusCodeException e) {
            log.error(ERROR_GETTING_TEAMS);
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        log.info("No team was found for {}", (Object)teamId);
        return UNKNOWN;
    }

    @Override
    public String getTeamId(String parentTeamId, String teamName) throws CheckmarxException {
        try {
            if (this.cxProperties.getVersion() < 9.0) {
                String parentTeamName = this.getTeamName(parentTeamId);
                return this.getTeamId(parentTeamName.concat(this.cxProperties.getTeamPathSeparator()).concat(teamName));
            }
            List<CxTeam> teams = this.getTeams();
            if (teams == null) {
                throw new CheckmarxException("Error obtaining Team Id");
            }
            for (CxTeam team : teams) {
                if (!team.getName().equals(teamName) || !team.getParentId().equals(parentTeamId)) continue;
                log.info(FOUND_TEAM, (Object)teamName, (Object)team.getId());
                return team.getId();
            }
        }
        catch (HttpStatusCodeException e) {
            log.error(ERROR_GETTING_TEAMS);
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        log.info("No team was found for {} with parentId {}", (Object)teamName, (Object)parentTeamId);
        return UNKNOWN;
    }

    @Override
    public String createTeam(String parentTeamId, String teamName) throws CheckmarxException {
        if (this.cxProperties.getVersion() < 9.0) {
            return this.createTeamWS(parentTeamId, teamName);
        }
        JSONObject json = new JSONObject();
        json.put("name", (Object)teamName);
        json.put("parentId", Long.parseLong(parentTeamId));
        log.info("Creating team with name {} under parent Id {}", (Object)teamName, (Object)parentTeamId);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)json.toString(), (MultiValueMap)this.authClient.createAuthHeaders());
            this.restTemplate.postForObject(this.cxProperties.getUrl().concat(TEAMS), (Object)requestEntity, String.class, new Object[0]);
            return this.getTeamId(parentTeamId, teamName);
        }
        catch (HttpStatusCodeException e) {
            log.error("Error occurred while creating team and retrieving new Id");
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            return UNKNOWN;
        }
    }

    @Override
    public void deleteTeam(String teamId) throws CheckmarxException {
        if (this.cxProperties.getVersion() < 9.0) {
            this.deleteTeamWS(teamId);
        } else {
            HttpEntity httpEntity = new HttpEntity((MultiValueMap)this.authClient.createAuthHeaders());
            log.debug("Deleting team with id {}", (Object)teamId);
            try {
                ResponseEntity responseEntity = this.restTemplate.exchange(this.cxProperties.getUrl().concat(TEAM), HttpMethod.DELETE, httpEntity, String.class, new Object[]{teamId});
            }
            catch (HttpStatusCodeException e) {
                log.error("HTTP Status Code of {} while deleting team Id {}", (Object)e.getStatusCode(), (Object)teamId);
                log.error(ExceptionUtils.getStackTrace((Throwable)e));
                throw new CheckmarxException("Error occurred deleting team with id ".concat(teamId));
            }
        }
    }

    @Override
    public void moveTeam(String teamId, String newParentTeamId) throws CheckmarxException {
        if (teamId.equals(newParentTeamId) || teamId.equals(UNKNOWN) || newParentTeamId.equals(UNKNOWN)) {
            log.info("Invalid parameters: teamId {}, newParentTeamId {}", (Object)teamId, (Object)newParentTeamId);
            return;
        }
        if (this.cxProperties.getVersion() < 9.0) {
            this.moveTeamWS(teamId, newParentTeamId);
        } else {
            log.error("Not implemented in v9.0 yet");
        }
    }

    @Override
    public void renameTeam(String teamId, String newTeamName) throws CheckmarxException {
        if (this.cxProperties.getVersion() < 9.0) {
            this.renameTeamWS(teamId, newTeamName);
        } else {
            log.error("Not implemented in v9.0 yet");
        }
    }

    @Override
    public String createTeamWS(String parentTeamId, String teamName) throws CheckmarxException {
        String session = this.authClient.getLegacySession();
        this.cxLegacyService.createTeam(session, parentTeamId, teamName);
        return this.getTeamId(parentTeamId, teamName);
    }

    @Override
    public void deleteTeamWS(String teamId) throws CheckmarxException {
        String session = this.authClient.getLegacySession();
        this.cxLegacyService.deleteTeam(session, teamId);
    }

    public void moveTeamWS(String teamId, String newParentTeamId) throws CheckmarxException {
        String session = this.authClient.getLegacySession();
        if (this.authClient.getLegacySession() == null) {
            session = this.authClient.legacyLogin(this.cxProperties.getUsername(), this.cxProperties.getPassword());
        }
        this.cxLegacyService.moveTeam(session, teamId, newParentTeamId);
        ArrayList<CxTeam> subteams = new ArrayList<CxTeam>();
        List<CxTeam> teams = this.getTeams();
        String teamName = "";
        if (teams == null) {
            throw new CheckmarxException("Error retrieving Cx teams from the server");
        }
        for (CxTeam team : teams) {
            if (!team.getId().equals(teamId)) continue;
            teamName = team.getFullName();
            log.debug(FOUND_TEAM, (Object)teamName, (Object)teamId);
            break;
        }
        if (!teamName.isEmpty()) {
            for (CxTeam team : teams) {
                String subteamName = team.getFullName();
                log.debug("Checking subteam {}", (Object)subteamName);
                if (subteamName.equals(teamName) || !subteamName.contains(teamName)) continue;
                log.debug("Found subteam {}", (Object)team.getFullName());
                subteams.add(team);
            }
        }
        if (!subteams.isEmpty()) {
            log.info("Moving {} subteams", (Object)subteams.size());
            for (CxTeam subteam : subteams) {
                log.debug("Moving subteam {}", (Object)subteam.getFullName());
                this.cxLegacyService.moveTeam(session, subteam.getId(), teamId);
            }
        }
    }

    public void renameTeamWS(String teamId, String newTeamName) throws CheckmarxException {
        String session = this.authClient.getLegacySession();
        if (this.authClient.getLegacySession() == null) {
            session = this.authClient.legacyLogin(this.cxProperties.getUsername(), this.cxProperties.getPassword());
        }
        log.info("Renaming team {} to {}", (Object)teamId, (Object)newTeamName);
        this.cxLegacyService.updateTeam(session, teamId, newTeamName, null);
    }

    @Override
    public Integer getScanConfiguration(String configuration) throws CheckmarxException {
        return this.scanSettingsClient.getEngineConfigurationId(configuration);
    }

    @Override
    public String getScanConfigurationName(int configurationId) {
        return this.scanSettingsClient.getEngineConfigurationName(configurationId);
    }

    @Override
    public Integer getPresetId(String preset) throws CheckmarxException {
        return this.scanSettingsClient.getPresetId(preset);
    }

    @Override
    public CxScanSummary getScanSummaryByScanId(Integer scanId) throws CheckmarxException {
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)this.authClient.createAuthHeaders());
        try {
            log.debug("Retrieving scan summary for scan id: {}", (Object)scanId);
            ResponseEntity response = this.restTemplate.exchange(this.cxProperties.getUrl().concat(SCAN_SUMMARY), HttpMethod.GET, httpEntity, CxScanSummary.class, new Object[]{scanId});
            CxScanSummary scanSummary = (CxScanSummary)response.getBody();
            if (scanSummary == null) {
                log.warn("No scan summary was available for scan id: {}", (Object)scanId);
            }
            return scanSummary;
        }
        catch (HttpStatusCodeException e) {
            log.error("Error occurred while retrieving scan summary for scan id: {}", (Object)scanId);
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            log.warn("No scan summary was available for scan id: {}", (Object)scanId);
            return null;
        }
    }

    @Override
    public CxScanSummary getScanSummary(Integer projectId) throws CheckmarxException {
        Integer scanId = this.getLastScanId(projectId);
        return this.getScanSummaryByScanId(scanId);
    }

    @Override
    public CxScanSummary getScanSummary(String teamName, String projectName) throws CheckmarxException {
        String teamId = this.getTeamId(teamName);
        Integer projectId = this.getProjectId(teamId, projectName);
        Integer scanId = this.getLastScanId(projectId);
        return this.getScanSummaryByScanId(scanId);
    }

    @Override
    public Integer createScan(CxScanParams params, String comment) throws CheckmarxException {
        boolean projectExistedBeforeScan;
        log.info("Creating scan...");
        this.validateScanParams(params);
        String teamId = this.determineTeamId(params);
        Integer projectId = this.determineProjectId(params, teamId);
        boolean bl = projectExistedBeforeScan = !projectId.equals(UNKNOWN_INT);
        if (!projectExistedBeforeScan && (projectId = this.createProject(teamId, params.getProjectName())).equals(UNKNOWN_INT)) {
            throw new CheckmarxException("Project was not created successfully: ".concat(params.getProjectName()));
        }
        if (!projectExistedBeforeScan || this.cxProperties.getSettingsOverride().booleanValue()) {
            Integer presetId = this.getPresetId(params.getScanPreset());
            Integer engineConfigurationId = this.getScanConfiguration(params.getScanConfiguration());
            this.createScanSetting(projectId, presetId, engineConfigurationId, this.cxProperties.getPostActionPostbackId());
            this.setProjectExcludeDetails(projectId, params.getFolderExclude(), params.getFileExclude());
        }
        switch (params.getSourceType()) {
            case GIT: {
                this.setProjectRepositoryDetails(projectId, params.getGitUrl(), params.getBranch());
                break;
            }
            case FILE: {
                this.uploadProjectSource(projectId, new File(params.getFilePath()));
            }
        }
        if (params.isIncremental() && projectExistedBeforeScan) {
            LocalDateTime scanDate = this.getLastScanDate(projectId);
            if (scanDate == null || LocalDateTime.now().isAfter(scanDate.plusDays(this.cxProperties.getIncrementalThreshold().intValue()))) {
                log.debug("Last scanDate: {}", (Object)scanDate);
                log.info("Last scanDate does not meet the threshold for an incremental scan.");
                params.setIncremental(false);
            } else {
                log.info("Scan will be incremental");
            }
        } else {
            log.info("Scan will be Full Scan");
            params.setIncremental(false);
        }
        CxScan scan = CxScan.builder().projectId(projectId).isIncremental(params.isIncremental()).forceScan(params.isForceScan()).isPublic(params.isPublic()).comment(comment).build();
        HttpHeaders headers = this.authClient.createAuthHeaders();
        headers.add("cxOrigin", "CxFlow");
        HttpEntity requestEntity = new HttpEntity((Object)scan, (MultiValueMap)headers);
        log.info("Creating Scan for project Id {}", (Object)projectId);
        try {
            String response = (String)this.restTemplate.postForObject(this.cxProperties.getUrl().concat(SCAN), (Object)requestEntity, String.class, new Object[0]);
            JSONObject obj = new JSONObject(response);
            String id = obj.get("id").toString();
            log.info("Scan created with Id {} for project Id {}", (Object)id, (Object)projectId);
            return Integer.parseInt(id);
        }
        catch (HttpStatusCodeException e) {
            log.error(SCAN_CREATION_ERROR, (Object)projectId, (Object)e.getStatusCode());
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            log.info("...Finished creating scan");
            return UNKNOWN_INT;
        }
    }

    private Integer determineProjectId(CxScanParams params, String teamId) {
        Integer projectId = params.getProjectId();
        if (projectId == null || projectId.equals(UNKNOWN_INT)) {
            projectId = this.getProjectId(teamId, params.getProjectName());
        }
        return projectId;
    }

    private String determineTeamId(CxScanParams params) throws CheckmarxException {
        String teamId = params.getTeamId();
        if ((ScanUtils.empty(teamId) || teamId.equals(UNKNOWN)) && (teamId = this.getTeamId(params.getTeamName())).equals(UNKNOWN)) {
            throw new CheckmarxException("Team does not exist: ".concat(params.getTeamName()));
        }
        return teamId;
    }

    @Override
    public CxXMLResultsType createScanAndReport(CxScanParams params, String comment) throws CheckmarxException {
        Integer scanId = this.createScan(params, comment);
        this.waitForScanCompletion(scanId);
        try {
            Integer reportId = this.createScanReport(scanId);
            this.waitForReportCreateOrFail(reportId);
            Thread.sleep(1000L);
            return this.getXmlReportContent(reportId);
        }
        catch (InterruptedException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            Thread.currentThread().interrupt();
            throw new CheckmarxException(INTERRUPTED_EXCEPTION_MESSAGE);
        }
    }

    @Override
    public ScanResults createScanAndReport(CxScanParams params, String comment, FilterConfiguration filters) throws CheckmarxException {
        Integer scanId = this.createScan(params, comment);
        this.waitForScanCompletion(scanId);
        try {
            Integer reportId = this.createScanReport(scanId);
            this.waitForReportCreateOrFail(reportId);
            Thread.sleep(this.cxProperties.getScanPolling().intValue());
            return this.getReportContent(reportId, filters);
        }
        catch (InterruptedException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            Thread.currentThread().interrupt();
            throw new CheckmarxException(INTERRUPTED_EXCEPTION_MESSAGE);
        }
    }

    @Override
    public void deleteScan(Integer scanId) throws CheckmarxException {
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)this.authClient.createAuthHeaders());
        log.debug("Deleting scan with id {}", (Object)scanId);
        try {
            ResponseEntity responseEntity = this.restTemplate.exchange(this.cxProperties.getUrl().concat(SCAN_STATUS), HttpMethod.DELETE, httpEntity, String.class, new Object[]{scanId});
        }
        catch (HttpStatusCodeException e) {
            log.error("HTTP Status Code of {} while deleting scan Id {}", (Object)e.getStatusCode(), (Object)scanId);
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    @Override
    public void cancelScan(Integer scanId) throws CheckmarxException {
        log.info("Canceling scan with id {}", (Object)scanId);
        try {
            JSONObject scanRequest = new JSONObject();
            scanRequest.put("status", (Object)"Canceled");
            HttpEntity httpEntity = new HttpEntity((Object)scanRequest.toString(), (MultiValueMap)this.authClient.createAuthHeaders());
            ResponseEntity responseEntity = this.restTemplate.exchange(this.cxProperties.getUrl().concat(SCAN_QUEUE_STATUS), HttpMethod.PATCH, httpEntity, String.class, new Object[]{scanId});
        }
        catch (HttpStatusCodeException e) {
            log.error("HTTP Status Code of {} while canceling scan Id {}", (Object)e.getStatusCode(), (Object)scanId);
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    @Override
    public CxXMLResultsType getLatestScanReport(String teamName, String projectName) throws CheckmarxException {
        String teamId = this.getTeamId(teamName);
        Integer projectId = this.getProjectId(teamId, projectName);
        Integer scanId = this.getLastScanId(projectId);
        try {
            Integer reportId = this.createScanReport(scanId);
            this.waitForReportCreateOrFail(reportId);
            Thread.sleep(this.cxProperties.getScanPolling().intValue());
            return this.getXmlReportContent(reportId);
        }
        catch (InterruptedException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            Thread.currentThread().interrupt();
            throw new CheckmarxException(INTERRUPTED_EXCEPTION_MESSAGE);
        }
    }

    @Override
    public ScanResults getLatestScanResults(String teamName, String projectName, FilterConfiguration filters) throws CheckmarxException {
        String teamId = this.getTeamId(teamName);
        Integer projectId = this.getProjectId(teamId, projectName);
        Integer scanId = this.getLastScanId(projectId);
        try {
            Integer reportId = this.createScanReport(scanId);
            this.waitForReportCreateOrFail(reportId);
            Thread.sleep(this.cxProperties.getScanPolling().intValue());
            return this.getReportContent(reportId, filters);
        }
        catch (InterruptedException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            Thread.currentThread().interrupt();
            throw new CheckmarxException(INTERRUPTED_EXCEPTION_MESSAGE);
        }
    }

    @Override
    public List<CxTeam> getTeams() throws CheckmarxException {
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)this.authClient.createAuthHeaders());
        try {
            log.info("Retrieving Cx teams");
            ResponseEntity response = this.restTemplate.exchange(this.cxProperties.getUrl().concat(TEAMS), HttpMethod.GET, httpEntity, CxTeam[].class, new Object[0]);
            CxTeam[] teams = (CxTeam[])response.getBody();
            if (teams == null) {
                throw new CheckmarxException("Error retrieving teams");
            }
            return Arrays.asList(teams);
        }
        catch (HttpStatusCodeException e) {
            log.error(ERROR_GETTING_TEAMS);
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new CheckmarxException("Error occurred while retrieving teams");
        }
    }

    @Override
    public void mapTeamLdap(Integer ldapServerId, String teamId, String teamName, String ldapGroupDn) throws CheckmarxException {
        if (this.cxProperties.getVersion() < 9.0) {
            log.debug("Calling legacy mapTeamLdapWS");
            this.mapTeamLdapWS(ldapServerId, teamId, teamName, ldapGroupDn);
        } else {
            log.debug("Calling Access Control REST method for Team LDAP Mapping");
            try {
                List<CxTeamLdap> teamLdaps = this.getTeamLdap(ldapServerId);
                ArrayList<CxTeamLdap> teamLdapsTmp = new ArrayList<CxTeamLdap>(teamLdaps);
                String name = CxService.getNameFromLDAP(ldapGroupDn);
                CxTeamLdap ldap = new CxTeamLdap();
                ldap.setLdapGroupDisplayName(name);
                ldap.setLdapGroupDn(ldapGroupDn);
                ldap.setLdapServerId(ldapServerId);
                ldap.setTeamId(teamId);
                if (teamLdapsTmp.contains(ldap)) {
                    log.info("team ldap mapping already exists for team id {} - {}", (Object)teamId, (Object)ldapGroupDn);
                    return;
                }
                teamLdapsTmp.add(ldap);
                HttpEntity requestEntity = new HttpEntity(teamLdapsTmp, (MultiValueMap)this.authClient.createAuthHeaders());
                this.restTemplate.exchange(this.cxProperties.getUrl().concat(TEAM_LDAP_MAPPINGS_UPDATE), HttpMethod.PUT, requestEntity, String.class, new Object[]{ldapServerId});
            }
            catch (HttpStatusCodeException e) {
                log.error("Error occurred while mapping ldap to a team");
                log.error(ExceptionUtils.getStackTrace((Throwable)e));
                throw new CheckmarxException("Error occurred while mapping ldap to a team");
            }
        }
    }

    @Override
    public List<CxTeamLdap> getTeamLdap(Integer ldapServerId) throws CheckmarxException {
        if (this.cxProperties.getVersion() < 9.0) {
            throw new CheckmarxException(ONLY_SUPPORTED_IN_90_PLUS);
        }
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)this.authClient.createAuthHeaders());
        try {
            ResponseEntity projects = this.restTemplate.exchange(this.cxProperties.getUrl().concat(TEAM_LDAP_MAPPINGS), HttpMethod.GET, httpEntity, CxTeamLdap[].class, new Object[]{ldapServerId});
            if (projects.getBody() != null) {
                return Arrays.asList((Object[])projects.getBody());
            }
            return Collections.emptyList();
        }
        catch (HttpStatusCodeException e) {
            log.warn("Error occurred while retrieving Team LDAP Mappings, http error {}", (Object)e.getStatusCode());
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new CheckmarxException("Error retrieving Team LDAP Mappings");
        }
    }

    static String getNameFromLDAP(String ldapGroupDn) {
        try {
            LdapName ldapName = new LdapName(ldapGroupDn);
            List<Rdn> rdns = ldapName.getRdns();
            Rdn r = rdns.get(rdns.size() - 1);
            String cn = r.getValue().toString();
            cn = cn.replace("CN=", "");
            cn = cn.replace("cn=", "");
            return cn;
        }
        catch (InvalidNameException e) {
            log.warn("Could not determine name from CN, defaulting to full CN {}", (Object)ldapGroupDn);
            return ldapGroupDn;
        }
    }

    @Override
    public void removeTeamLdap(Integer ldapServerId, String teamId, String teamName, String ldapGroupDn) throws CheckmarxException {
        if (this.cxProperties.getVersion() < 9.0) {
            log.debug("Calling legacy removeTeamLdapWS");
            this.removeTeamLdapWS(ldapServerId, teamId, teamName, ldapGroupDn);
        } else {
            Integer mapId = this.getLdapTeamMapId(ldapServerId, teamId, ldapGroupDn);
            if (mapId.equals(UNKNOWN_INT)) {
                log.warn("Team mapping not found");
                return;
            }
            HttpEntity requestEntity = new HttpEntity((MultiValueMap)this.authClient.createAuthHeaders());
            log.info("Deleting ldap team mapping id {}", (Object)mapId);
            try {
                this.restTemplate.exchange(this.cxProperties.getUrl().concat(TEAM_LDAP_MAPPINGS_DELETE), HttpMethod.DELETE, requestEntity, String.class, new Object[]{mapId});
            }
            catch (HttpStatusCodeException e) {
                log.error("HTTP error code {} while deleting project with id {}", (Object)e.getStatusCode(), (Object)mapId);
                log.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
    }

    @Override
    public Integer getLdapTeamMapId(Integer ldapServerId, String teamId, String ldapGroupDn) throws CheckmarxException {
        if (this.cxProperties.getVersion() < 9.0) {
            throw new CheckmarxException(ONLY_SUPPORTED_IN_90_PLUS);
        }
        try {
            HttpEntity requestEntity = new HttpEntity((MultiValueMap)this.authClient.createAuthHeaders());
            ResponseEntity response = this.restTemplate.exchange(this.cxProperties.getUrl().concat(TEAM_LDAP_MAPPINGS), HttpMethod.GET, requestEntity, String.class, new Object[]{ldapServerId});
            JSONArray objs = new JSONArray((String)response.getBody());
            for (int i = 0; i < objs.length(); ++i) {
                JSONObject obj = objs.getJSONObject(i);
                String cn = obj.getString("ldapGroupDn");
                if (!teamId.equals(obj.getString("teamId")) || !cn.equals(ldapGroupDn)) continue;
                return obj.getInt("id");
            }
            log.info("No mapping found for {} with Server id {}", (Object)ldapGroupDn, (Object)ldapServerId);
        }
        catch (HttpStatusCodeException e) {
            log.error("Error occurred while retrieving ldap server mappings, http error {}", (Object)e.getStatusCode());
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        return UNKNOWN_INT;
    }

    @Override
    public void mapTeamLdapWS(Integer ldapServerId, String teamId, String teamName, String ldapGroupDn) throws CheckmarxException {
        String session = this.authClient.getLegacySession();
        this.cxLegacyService.createLdapTeamMapping(session, ldapServerId, teamId, teamName, ldapGroupDn);
    }

    @Override
    public void removeTeamLdapWS(Integer ldapServerId, String teamId, String teamName, String ldapGroupDn) throws CheckmarxException {
        String session = this.authClient.getLegacySession();
        if (session == null) {
            session = this.authClient.legacyLogin(this.cxProperties.getUsername(), this.cxProperties.getPassword());
        }
        this.cxLegacyService.removeLdapTeamMapping(session, ldapServerId, teamId, teamName, ldapGroupDn);
    }

    @Override
    public List<CxRole> getRoles() throws CheckmarxException {
        if (this.cxProperties.getVersion() < 9.0) {
            throw new CheckmarxException(ONLY_SUPPORTED_IN_90_PLUS);
        }
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)this.authClient.createAuthHeaders());
        try {
            log.info("Retrieving Cx Roles");
            ResponseEntity response = this.restTemplate.exchange(this.cxProperties.getUrl().concat(ROLE), HttpMethod.GET, httpEntity, CxRole[].class, new Object[0]);
            CxRole[] roles = (CxRole[])response.getBody();
            if (roles == null) {
                throw new CheckmarxException("Error retrieving roles");
            }
            return Arrays.asList(roles);
        }
        catch (HttpStatusCodeException e) {
            log.error("Error occurred while retrieving Roles");
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new CheckmarxException("Error occurred while retrieving teams");
        }
    }

    @Override
    public List<CxRoleLdap> getRoleLdap(Integer ldapServerId) throws CheckmarxException {
        if (this.cxProperties.getVersion() < 9.0) {
            throw new CheckmarxException(ONLY_SUPPORTED_IN_90_PLUS);
        }
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)this.authClient.createAuthHeaders());
        try {
            ResponseEntity projects = this.restTemplate.exchange(this.cxProperties.getUrl().concat(ROLE_LDAP_MAPPINGS), HttpMethod.GET, httpEntity, CxRoleLdap[].class, new Object[]{ldapServerId});
            if (projects.getBody() != null) {
                return Arrays.asList((Object[])projects.getBody());
            }
            return Collections.emptyList();
        }
        catch (HttpStatusCodeException e) {
            log.warn("Error occurred while retrieving Role LDAP Mappings, http error {}", (Object)e.getStatusCode());
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new CheckmarxException("Error retrieving Role LDAP Mappings");
        }
    }

    @Override
    public Integer getRoleId(String roleName) throws CheckmarxException {
        if (this.cxProperties.getVersion() < 9.0) {
            throw new CheckmarxException(ONLY_SUPPORTED_IN_90_PLUS);
        }
        List<CxRole> roles = this.getRoles();
        for (CxRole role : roles) {
            if (!role.getName().equalsIgnoreCase(roleName)) continue;
            log.debug("role found with id {}", (Object)role.getId());
            return role.getId();
        }
        return UNKNOWN_INT;
    }

    @Override
    public void mapRoleLdap(Integer ldapServerId, Integer roleId, String ldapGroupDn) throws CheckmarxException {
        if (this.cxProperties.getVersion() < 9.0) {
            throw new CheckmarxException(ONLY_SUPPORTED_IN_90_PLUS);
        }
        try {
            List<CxRoleLdap> roleLdaps = this.getRoleLdap(ldapServerId);
            ArrayList<CxRoleLdap> roleLapsTmp = new ArrayList<CxRoleLdap>(roleLdaps);
            String name = CxService.getNameFromLDAP(ldapGroupDn);
            CxRoleLdap ldap = new CxRoleLdap();
            ldap.setLdapGroupDisplayName(name);
            ldap.setLdapGroupDn(ldapGroupDn);
            ldap.setLdapServerId(ldapServerId);
            ldap.setRoleId(roleId);
            if (roleLapsTmp.contains(ldap)) {
                log.info("team ldap mapping already exists for team id {} - {}", (Object)roleId, (Object)ldapGroupDn);
                return;
            }
            roleLapsTmp.add(ldap);
            HttpEntity requestEntity = new HttpEntity(roleLapsTmp, (MultiValueMap)this.authClient.createAuthHeaders());
            this.restTemplate.exchange(this.cxProperties.getUrl().concat(ROLE_LDAP_MAPPING), HttpMethod.PUT, requestEntity, String.class, new Object[]{ldapServerId});
        }
        catch (HttpStatusCodeException e) {
            log.error("Error occurred while creating Team Ldap mapping: {}", (Object)ExceptionUtils.getMessage((Throwable)e));
        }
    }

    @Override
    public void removeRoleLdap(Integer ldapServerId, Integer roleId, String ldapGroupDn) throws CheckmarxException {
        if (this.cxProperties.getVersion() < 9.0) {
            throw new CheckmarxException(ONLY_SUPPORTED_IN_90_PLUS);
        }
        Integer mapId = this.getLdapRoleMapId(ldapServerId, roleId, ldapGroupDn);
        if (mapId.equals(UNKNOWN_INT)) {
            log.warn("Team mapping not found");
            return;
        }
        this.removeRoleLdap(mapId);
    }

    @Override
    public void removeRoleLdap(Integer roleMapId) throws CheckmarxException {
        if (this.cxProperties.getVersion() < 9.0) {
            throw new CheckmarxException(ONLY_SUPPORTED_IN_90_PLUS);
        }
        HttpEntity requestEntity = new HttpEntity((MultiValueMap)this.authClient.createAuthHeaders());
        log.info("Deleting ldap role mapping id {}", (Object)roleMapId);
        try {
            this.restTemplate.exchange(this.cxProperties.getUrl().concat(ROLE_LDAP_MAPPINGS_DELETE), HttpMethod.DELETE, requestEntity, String.class, new Object[]{roleMapId});
        }
        catch (HttpStatusCodeException e) {
            log.error("HTTP error code {} while deleting role mapping with id {}", (Object)e.getStatusCode(), (Object)roleMapId);
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    @Override
    public Integer getLdapRoleMapId(Integer ldapServerId, Integer roleId, String ldapGroupDn) throws CheckmarxException {
        if (this.cxProperties.getVersion() < 9.0) {
            throw new CheckmarxException(ONLY_SUPPORTED_IN_90_PLUS);
        }
        try {
            HttpEntity requestEntity = new HttpEntity((MultiValueMap)this.authClient.createAuthHeaders());
            ResponseEntity response = this.restTemplate.exchange(this.cxProperties.getUrl().concat(ROLE_LDAP_MAPPINGS), HttpMethod.GET, requestEntity, String.class, new Object[]{ldapServerId});
            JSONArray objs = new JSONArray((String)response.getBody());
            for (int i = 0; i < objs.length(); ++i) {
                JSONObject obj = objs.getJSONObject(i);
                String cn = obj.getString("ldapGroupDn");
                if (!roleId.equals(obj.getInt("roleId")) || !cn.equals(ldapGroupDn)) continue;
                return obj.getInt("id");
            }
            log.info("No mapping found for {} with Server id {}", (Object)ldapGroupDn, (Object)ldapServerId);
        }
        catch (HttpStatusCodeException e) {
            log.error("Error occurred while retrieving ldap server mappings, http error {}", (Object)e.getStatusCode());
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        return UNKNOWN_INT;
    }

    @Override
    public Integer getLdapServerId(String serverName) throws CheckmarxException {
        if (this.cxProperties.getVersion() < 9.0) {
            String session = this.authClient.getLegacySession();
            if (session == null) {
                session = this.authClient.legacyLogin(this.cxProperties.getUsername(), this.cxProperties.getPassword());
            }
            return this.cxLegacyService.getLdapServerId(session, serverName);
        }
        try {
            HttpEntity requestEntity = new HttpEntity((MultiValueMap)this.authClient.createAuthHeaders());
            ResponseEntity response = this.restTemplate.exchange(this.cxProperties.getUrl().concat(LDAP_SERVER), HttpMethod.GET, requestEntity, String.class, new Object[0]);
            JSONArray objs = new JSONArray((String)response.getBody());
            for (int i = 0; i < objs.length(); ++i) {
                JSONObject obj = objs.getJSONObject(i);
                String name = obj.getString("name");
                if (!name.equals(serverName)) continue;
                return obj.getInt("id");
            }
            log.info("No LDAP Server found for name {}", (Object)serverName);
        }
        catch (HttpStatusCodeException e) {
            log.error("Error occurred while retrieving ldap servers, http error {}", (Object)e.getStatusCode());
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        return UNKNOWN_INT;
    }

    private void validateScanParams(CxScanParams params) throws CheckmarxException {
        log.debug(params.toString());
        if (ScanUtils.empty(params.getProjectName())) {
            throw new CheckmarxException("No project name was provided for the scan");
        }
        if (ScanUtils.empty(params.getTeamName())) {
            if (ScanUtils.empty(this.cxProperties.getTeam())) {
                throw new CheckmarxException("No team was provided for the scan");
            }
            params.setTeamName(this.cxProperties.getTeam());
        }
        if (ScanUtils.empty(params.getFileExclude()) && !ScanUtils.empty(this.cxProperties.getExcludeFiles())) {
            params.setFileExclude(Arrays.asList(this.cxProperties.getExcludeFiles().split(",")));
        }
        if (ScanUtils.empty(params.getFolderExclude()) && !ScanUtils.empty(this.cxProperties.getExcludeFolders())) {
            params.setFolderExclude(Arrays.asList(this.cxProperties.getExcludeFolders().split(",")));
        }
        if (ScanUtils.empty(params.getScanPreset())) {
            if (ScanUtils.empty(this.cxProperties.getScanPreset())) {
                throw new CheckmarxException("No scan preset was provided for the scan");
            }
            params.setScanPreset(this.cxProperties.getScanPreset());
        }
        if (ScanUtils.empty(params.getScanConfiguration())) {
            if (ScanUtils.empty(this.cxProperties.getConfiguration())) {
                throw new CheckmarxException("No scan preset was provided for the scan");
            }
            params.setScanConfiguration(this.cxProperties.getConfiguration());
        }
        if (params.getSourceType().equals((Object)CxScanParams.Type.GIT)) {
            if (ScanUtils.empty(params.getGitUrl()) || ScanUtils.empty(params.getBranch())) {
                throw new CheckmarxException("No git url or branch was was missing for the scan");
            }
        } else if (params.getSourceType().equals((Object)CxScanParams.Type.FILE)) {
            if (ScanUtils.empty(params.getFilePath())) {
                throw new CheckmarxException("No file path was provided for the scan");
            }
        } else {
            throw new CheckmarxException("No source type was provided for the scan");
        }
    }

    @Override
    public void waitForScanCompletion(Integer scanId) throws CheckmarxException {
        Integer status = this.getScanStatus(scanId);
        long timer = 0L;
        try {
            while (!(status.equals(SCAN_STATUS_FINISHED) || status.equals(SCAN_STATUS_CANCELED) || status.equals(SCAN_STATUS_FAILED))) {
                Thread.sleep(this.cxProperties.getScanPolling().intValue());
                status = this.getScanStatus(scanId);
                if ((timer += (long)this.cxProperties.getScanPolling().intValue()) < (long)(this.cxProperties.getScanTimeout() * 60000)) continue;
                log.error("Scan timeout exceeded.  {} minutes", (Object)this.cxProperties.getScanTimeout());
                throw new CheckmarxException("Timeout exceeded during scan");
            }
            if (status.equals(SCAN_STATUS_FAILED) || status.equals(SCAN_STATUS_CANCELED)) {
                throw new CheckmarxException("Scan was cancelled or failed");
            }
        }
        catch (InterruptedException e) {
            throw new CheckmarxException("Thread interrupted");
        }
        catch (HttpStatusCodeException e) {
            throw new CheckmarxException("HTTP Error".concat(ExceptionUtils.getRootCauseMessage((Throwable)e)));
        }
    }

    @Override
    public CxPropertiesBase getCxPropertiesBase() {
        return this.cxProperties;
    }
}

