/*
 * Decompiled with CFR 0.152.
 */
package com.checkmarx.sdk.service;

import com.checkmarx.sdk.config.CxGoProperties;
import com.checkmarx.sdk.dto.cx.CxGoAuthResponse;
import java.time.LocalDateTime;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.CacheControl;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class CxGoAuthService {
    private static final Logger log = LoggerFactory.getLogger(CxGoAuthService.class);
    private final CxGoProperties cxGoProperties;
    private final RestTemplate restTemplate;
    private CxGoAuthResponse token = null;
    private LocalDateTime tokenExpires = null;
    private static final String GET_SESSION_TOKEN = "/v1/auth/login";
    private static final String GRANT_TYPE = "client_credentials";

    public CxGoAuthService(CxGoProperties cxGoProperties, @Qualifier(value="cxRestTemplate") RestTemplate restTemplate) {
        this.cxGoProperties = cxGoProperties;
        this.restTemplate = restTemplate;
    }

    private void getAuthToken(String clientSecretOverride) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setCacheControl(CacheControl.noCache());
        String request = this.getJSONTokenReq(clientSecretOverride);
        HttpEntity req = new HttpEntity((Object)request, (MultiValueMap)headers);
        this.token = (CxGoAuthResponse)this.restTemplate.postForObject(this.cxGoProperties.getUrl().concat(GET_SESSION_TOKEN), (Object)req, CxGoAuthResponse.class, new Object[0]);
        long SAFETY_INTERVAL_SECONDS = 500L;
        LocalDateTime now = LocalDateTime.now();
        this.tokenExpires = Optional.ofNullable(this.token).map(t -> now.plusSeconds(t.getExpiresIn() - 500L)).orElse(now);
    }

    public HttpHeaders createAuthHeaders() {
        return this.createAuthHeaders(null);
    }

    public HttpHeaders createAuthHeaders(String clientSecretOverride) {
        if (this.token == null || this.isTokenExpired()) {
            this.getAuthToken(clientSecretOverride);
        }
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setContentType(MediaType.APPLICATION_JSON);
        httpHeaders.setCacheControl(CacheControl.noCache());
        httpHeaders.set("Authorization", "Bearer ".concat(this.token.getIdToken()));
        return httpHeaders;
    }

    private boolean isTokenExpired() {
        if (this.tokenExpires == null) {
            return true;
        }
        return LocalDateTime.now().isAfter(this.tokenExpires);
    }

    private String getJSONTokenReq(String clientSecretOverride) {
        JSONObject requestBody = new JSONObject();
        try {
            requestBody.put("grant_type", (Object)GRANT_TYPE);
            requestBody.put("token", (Object)this.getEffectiveClientSecret(clientSecretOverride));
        }
        catch (JSONException e) {
            log.error("Error creating JSON Token Request object - JSON object will be empty");
        }
        return requestBody.toString();
    }

    private String getEffectiveClientSecret(String clientSecretOverride) {
        String result;
        if (StringUtils.isNotEmpty((CharSequence)clientSecretOverride)) {
            log.info("Using client secret override.");
            result = clientSecretOverride;
        } else {
            result = this.cxGoProperties.getClientSecret();
        }
        return result;
    }
}

