/*
 * Decompiled with CFR 0.152.
 */
package com.checkmarx.sdk.service;

import com.checkmarx.sdk.ShardManager.ShardSession;
import com.checkmarx.sdk.ShardManager.ShardSessionTracker;
import com.checkmarx.sdk.config.CxProperties;
import com.checkmarx.sdk.dto.cx.CxAuthResponse;
import com.checkmarx.sdk.exception.CheckmarxLegacyException;
import com.checkmarx.sdk.exception.InvalidCredentialsException;
import com.checkmarx.sdk.service.CxAuthClient;
import com.checkmarx.sdk.service.CxLegacyService;
import com.checkmarx.sdk.utils.ScanUtils;
import java.time.LocalDateTime;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestTemplate;

@Service
public class CxAuthService
implements CxAuthClient {
    private static final Logger log = LoggerFactory.getLogger(CxAuthService.class);
    private static final String LOGIN = "/auth/identity/connect/token";
    private static final String DEFAULT_TOKEN = "DEFAULT";
    private static final Integer LEGACY_SESSION_TIME = 5;
    private final CxProperties cxProperties;
    private final CxLegacyService cxLegacyService;
    private final RestTemplate restTemplate;
    private final ShardSessionTracker sessionTracker;
    private String token = null;
    private String soapToken = null;
    private String session = null;
    private LocalDateTime tokenExpires = null;
    private LocalDateTime soapTokenExpires = null;
    private LocalDateTime sessionTokenExpires = null;

    public CxAuthService(CxProperties cxProperties, CxLegacyService cxLegacyService, @Qualifier(value="cxRestTemplate") RestTemplate restTemplate, ShardSessionTracker sessionTracker) {
        this.cxProperties = cxProperties;
        this.cxLegacyService = cxLegacyService;
        this.restTemplate = restTemplate;
        this.sessionTracker = sessionTracker;
    }

    private void getAuthToken() {
        this.getAuthToken(this.cxProperties.getUsername(), this.cxProperties.getPassword(), this.cxProperties.getClientId(), this.cxProperties.getClientSecret(), this.cxProperties.getScope());
    }

    private void getSoapAuthToken() {
        this.getSoapAuthToken(this.cxProperties.getUsername(), this.cxProperties.getPassword());
    }

    @Override
    public String getAuthToken(String username, String password, String clientId, String clientSecret, String scope) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        map.add((Object)"username", (Object)username);
        map.add((Object)"password", (Object)password);
        map.add((Object)"grant_type", (Object)"password");
        map.add((Object)"scope", (Object)this.cxProperties.getScope());
        map.add((Object)"client_id", (Object)clientId);
        if (!ScanUtils.empty(this.cxProperties.getClientSecret())) {
            map.add((Object)"client_secret", (Object)clientSecret);
        }
        HttpEntity requestEntity = new HttpEntity((Object)map, (MultiValueMap)headers);
        try {
            log.info("Logging into Checkmarx {}", (Object)this.cxProperties.getUrl().concat(LOGIN));
            CxAuthResponse response = (CxAuthResponse)this.restTemplate.postForObject(this.cxProperties.getUrl().concat(LOGIN), (Object)requestEntity, CxAuthResponse.class, new Object[0]);
            if (response == null) {
                throw new InvalidCredentialsException();
            }
            this.token = response.getAccessToken();
            this.tokenExpires = LocalDateTime.now().plusSeconds(response.getExpiresIn() - 500L);
            if (this.cxProperties.getEnableShardManager()) {
                ShardSession shard = this.sessionTracker.getShardSession();
                shard.setAccessToken(this.token);
                shard.setTokenExpires(this.tokenExpires);
            }
        }
        catch (NullPointerException | HttpStatusCodeException e) {
            log.error("Error occurred white obtaining Access Token.  Possibly incorrect credentials");
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new InvalidCredentialsException();
        }
        return this.token;
    }

    @Override
    public String getSoapAuthToken(String username, String password) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        if (this.cxProperties.getEnableShardManager()) {
            ShardSession shard = this.sessionTracker.getShardSession();
            username = shard.getUsername();
            password = shard.getPassword();
        }
        map.add((Object)"username", (Object)username);
        map.add((Object)"password", (Object)password);
        map.add((Object)"grant_type", (Object)"password");
        map.add((Object)"scope", (Object)this.cxProperties.getSoapScope());
        map.add((Object)"client_id", (Object)this.cxProperties.getSoapClientId());
        if (!ScanUtils.empty(this.cxProperties.getSoapClientSecret())) {
            map.add((Object)"client_secret", (Object)this.cxProperties.getSoapClientSecret());
        }
        HttpEntity requestEntity = new HttpEntity((Object)map, (MultiValueMap)headers);
        try {
            log.info("Logging into Checkmarx for SOAP token {}", (Object)this.cxProperties.getUrl().concat(LOGIN));
            CxAuthResponse response = (CxAuthResponse)this.restTemplate.postForObject(this.cxProperties.getUrl().concat(LOGIN), (Object)requestEntity, CxAuthResponse.class, new Object[0]);
            if (response == null) {
                throw new InvalidCredentialsException();
            }
            this.soapToken = response.getAccessToken();
            this.soapTokenExpires = LocalDateTime.now().plusSeconds(response.getExpiresIn() - 500L);
            if (this.cxProperties.getEnableShardManager()) {
                ShardSession shard = this.sessionTracker.getShardSession();
                shard.setSoapToken(this.soapToken);
                shard.setSoapTokenExpires(this.soapTokenExpires);
            }
        }
        catch (NullPointerException | HttpStatusCodeException e) {
            log.error("Error occurred white obtaining Access Token.  Possibly incorrect credentials");
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new InvalidCredentialsException();
        }
        return this.soapToken;
    }

    @Override
    public String getCurrentToken() {
        return this.token;
    }

    @Override
    public String getCurrentSoapToken() {
        if (this.soapToken == null || this.isSoapTokenExpired()) {
            this.getSoapAuthToken();
        }
        return this.soapToken;
    }

    @Override
    public String legacyLogin(String username, String password) throws InvalidCredentialsException {
        try {
            this.session = this.cxLegacyService.login(username, password);
        }
        catch (CheckmarxLegacyException e) {
            throw new InvalidCredentialsException();
        }
        return this.session;
    }

    private boolean isTokenExpired() {
        LocalDateTime curTokenExpires = this.tokenExpires;
        if (this.cxProperties.getEnableShardManager()) {
            ShardSession shard = this.sessionTracker.getShardSession();
            curTokenExpires = shard.getTokenExpires();
        }
        if (curTokenExpires == null) {
            return true;
        }
        return LocalDateTime.now().isAfter(curTokenExpires);
    }

    private boolean isSoapTokenExpired() {
        LocalDateTime curTokenExpires = this.soapTokenExpires;
        if (this.cxProperties.getEnableShardManager()) {
            ShardSession shard = this.sessionTracker.getShardSession();
            curTokenExpires = shard.getSoapTokenExpires();
        }
        if (curTokenExpires == null) {
            return true;
        }
        return LocalDateTime.now().isAfter(curTokenExpires);
    }

    private boolean isSessionTokenExpired() {
        if (this.sessionTokenExpires == null) {
            return true;
        }
        return LocalDateTime.now().isAfter(this.sessionTokenExpires);
    }

    @Override
    public HttpHeaders createAuthHeaders() {
        String authToken = this.token;
        if (this.cxProperties.getEnableShardManager()) {
            ShardSession shard = this.sessionTracker.getShardSession();
            authToken = shard.getAccessToken();
        }
        if (authToken == null || this.isTokenExpired()) {
            this.getAuthToken();
            authToken = this.token;
        }
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.set("Authorization", "Bearer ".concat(authToken));
        httpHeaders.setContentType(MediaType.APPLICATION_JSON);
        return httpHeaders;
    }

    @Override
    public String getLegacySession() {
        if (this.cxProperties.getVersion() >= 9.0) {
            return this.getCurrentSoapToken();
        }
        if (this.session == null || this.isSessionTokenExpired()) {
            this.session = this.legacyLogin(this.cxProperties.getUsername(), this.cxProperties.getPassword());
            this.sessionTokenExpires = LocalDateTime.now().plusHours(LEGACY_SESSION_TIME.intValue());
        }
        return this.session;
    }
}

