/*
 * Decompiled with CFR 0.152.
 */
package com.checkmarx.sdk.ShardManager;

import com.checkmarx.sdk.ShardManager.ShardManagerHTTPInterceptor;
import com.checkmarx.sdk.ShardManager.ShardSession;
import com.checkmarx.sdk.config.ShardProperties;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.ws.client.core.WebServiceTemplate;

@Component
public class ShardSessionTracker {
    private static final Logger log = LoggerFactory.getLogger(ShardManagerHTTPInterceptor.class);
    private WebServiceTemplate ws;
    private ShardProperties shardProperties;
    private HashMap<String, ShardSession> shardTracker;

    public ShardSessionTracker(ShardProperties shardProperties, WebServiceTemplate ws) {
        this.ws = ws;
        this.shardTracker = new HashMap();
        this.shardProperties = shardProperties;
    }

    public ShardSession getShardSession() {
        String scanID = this.getScanRequestID();
        if (!this.shardTracker.containsKey(scanID)) {
            ShardSession session = new ShardSession(this.ws);
            this.shardTracker.put(scanID, session);
        }
        return this.shardTracker.get(scanID);
    }

    public String getScanRequestID() {
        return this.captureScanRequestID(() -> log.info("Find Scan ID."));
    }

    private String captureScanRequestID(Runnable r) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream out = System.out;
        try {
            System.setOut(new PrintStream((OutputStream)baos, true, StandardCharsets.UTF_8.name()));
            r.run();
            String tokenStr = new String(baos.toByteArray());
            int tokenPos = tokenStr.indexOf("ScanID") + 13;
            String string = tokenStr.substring(tokenPos, tokenPos + 8);
            return string;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("End of the world, Java doesn't recognise UTF-8");
        }
        finally {
            System.setOut(out);
        }
    }
}

