/*
 * Decompiled with CFR 0.152.
 */
package cfml.parsing.cfscript.script;

import cfml.parsing.cfscript.CFExpression;
import cfml.parsing.cfscript.script.CFParsedStatement;
import cfml.parsing.cfscript.script.CFScriptStatement;
import cfml.parsing.util.ArrayBuilder;
import java.io.Serializable;
import java.util.List;
import org.antlr.v4.runtime.Token;

public class CFForStatement
extends CFParsedStatement
implements Serializable {
    private static final long serialVersionUID = 1L;
    private CFExpression init;
    private CFExpression cond;
    private CFExpression next;
    private CFScriptStatement body;

    public CFForStatement(Token _t, CFExpression _init, CFExpression _cond, CFExpression _next, CFScriptStatement _body) {
        super(_t);
        this.init = _init;
        this.cond = _cond;
        this.next = _next;
        this.body = _body;
    }

    @Override
    public void checkIndirectAssignments(String[] scriptSource) {
        this.body.checkIndirectAssignments(scriptSource);
    }

    @Override
    public String Decompile(int indent) {
        String s = this.Indent(indent) + "for(";
        if (this.init != null) {
            s = s + this.init.Decompile(indent);
        }
        s = s + ";";
        if (this.cond != null) {
            s = s + this.cond.Decompile(indent);
        }
        s = s + ";";
        if (this.next != null) {
            s = s + this.next.Decompile(indent);
        }
        s = s + ")";
        s = s + this.body.Decompile(indent + 2);
        return s;
    }

    public CFExpression getInit() {
        return this.init;
    }

    public CFExpression getCond() {
        return this.cond;
    }

    public CFExpression getNext() {
        return this.next;
    }

    public CFScriptStatement getBody() {
        return this.body;
    }

    @Override
    public List<CFExpression> decomposeExpression() {
        return ArrayBuilder.createCFExpression((CFExpression[])new CFExpression[]{this.init, this.cond, this.next});
    }

    @Override
    public List<CFScriptStatement> decomposeScript() {
        return ArrayBuilder.createCFScriptStatement((CFScriptStatement[])new CFScriptStatement[]{this.body});
    }
}

