/*
 * Decompiled with CFR 0.152.
 */
package cfml.parsing.cfscript.script;

import cfml.parsing.cfscript.CFContext;
import cfml.parsing.cfscript.CFExpression;
import cfml.parsing.cfscript.script.CFParsedStatement;
import cfml.parsing.cfscript.script.CFScriptStatement;
import cfml.parsing.cfscript.script.CFStatementResult;
import cfml.parsing.util.ArrayBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.Token;

public class CFCompDeclStatement
extends CFParsedStatement {
    private static final long serialVersionUID = 1L;
    private Map<CFExpression, CFExpression> attributes;
    private CFScriptStatement body;
    private byte access;
    private String returnType;

    public byte getAccess() {
        return this.access;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public CFCompDeclStatement(Token _t, Map<CFExpression, CFExpression> _attr, CFScriptStatement _body) {
        super(_t);
        this.body = _body;
        this.attributes = _attr;
    }

    public CFScriptStatement getBody() {
        return this.body;
    }

    @Override
    public void checkIndirectAssignments(String[] scriptSource) {
        this.body.checkIndirectAssignments(scriptSource);
    }

    public CFStatementResult Exec(CFContext context) {
        return null;
    }

    @Override
    public String Decompile(int indent) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.Indent(indent));
        sb.append("component ");
        for (Map.Entry<CFExpression, CFExpression> entry : this.attributes.entrySet()) {
            sb.append(entry.getKey().Decompile(0));
            sb.append(entry.getValue() == null ? "" : "=" + entry.getValue().Decompile(0));
            sb.append(" ");
        }
        sb.append("{\n");
        if (this.body != null) {
            sb.append(this.body.Decompile(indent + 2));
            sb.append("\n");
        }
        sb.append("}");
        return sb.toString();
    }

    public Map<CFExpression, CFExpression> getAttributes() {
        return this.attributes;
    }

    @Override
    public List<CFExpression> decomposeExpression() {
        ArrayList<CFExpression> retval = new ArrayList<CFExpression>();
        for (Map.Entry<CFExpression, CFExpression> key : this.attributes.entrySet()) {
            retval.add(key.getKey());
            retval.add(key.getValue());
        }
        return retval;
    }

    @Override
    public List<CFScriptStatement> decomposeScript() {
        return ArrayBuilder.createCFScriptStatement((CFScriptStatement[])new CFScriptStatement[]{this.body});
    }
}

