/*
 * Decompiled with CFR 0.152.
 */
package cfml.parsing.cfscript;

import cfml.parsing.cfscript.CFExpression;
import cfml.parsing.cfscript.CFFunctionExpression;
import cfml.parsing.cfscript.CFIdentifier;
import cfml.parsing.cfscript.script.CFScriptStatement;
import cfml.parsing.util.ArrayBuilder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.Token;

public class CFFullVarExpression
extends CFIdentifier
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<CFExpression> expressions = new ArrayList<CFExpression>();

    public CFFullVarExpression(Token _t, CFExpression _main) {
        super(_t);
        if (_main != null) {
            this.expressions.add(_main);
        }
    }

    public CFIdentifier getIdentifier() {
        return (CFIdentifier)this.expressions.get(0);
    }

    @Override
    public String getScope() {
        return this.getIdentifier().getScope();
    }

    @Override
    public byte getType() {
        return this.expressions.get(this.expressions.size() - 1).getType();
    }

    @Override
    public boolean isEscapeSingleQuotes() {
        return this.expressions.get(this.expressions.size() - 1).isEscapeSingleQuotes();
    }

    public void addMember(CFExpression _right) {
        this.expressions.add(_right);
    }

    @Override
    public String Decompile(int indent) {
        StringBuilder sb = new StringBuilder();
        for (CFExpression expression : this.expressions) {
            if (sb.length() > 0 && (expression.getType() != CFExpression.IDENTIFIER || expression.getToken().getType() != 72)) {
                if (expression.getType() == CFExpression.IDENTIFIER || expression.getType() == CFExpression.LITERAL) {
                    sb.append(".");
                } else if (expression instanceof CFFunctionExpression && ((CFFunctionExpression)expression).getIdentifier() != null) {
                    sb.append(".");
                }
            }
            sb.append(expression.Decompile(0));
        }
        return sb.toString();
    }

    public List<CFExpression> getExpressions() {
        return this.expressions;
    }

    public CFIdentifier getLastIdentifier() {
        for (int i = this.expressions.size() - 1; i >= 0; --i) {
            if (!(this.expressions.get(i) instanceof CFIdentifier)) continue;
            return (CFIdentifier)this.expressions.get(i);
        }
        return null;
    }

    @Override
    public List<CFExpression> decomposeExpression() {
        return this.expressions;
    }

    @Override
    public List<CFScriptStatement> decomposeScript() {
        return ArrayBuilder.createCFScriptStatement((CFScriptStatement[])new CFScriptStatement[0]);
    }
}

